/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels.spi;

import java.io.IOException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.Channel;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.InterruptibleChannel;

public abstract class AbstractInterruptibleChannel
implements Channel,
InterruptibleChannel {
    private volatile boolean closed = false;
    volatile boolean interrupted = false;
    private final Runnable interruptAndCloseRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                AbstractInterruptibleChannel.this.interrupted = true;
                AbstractInterruptibleChannel.this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    };

    protected AbstractInterruptibleChannel() {
    }

    @Override
    public final synchronized boolean isOpen() {
        return !this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        if (!this.closed) {
            AbstractInterruptibleChannel abstractInterruptibleChannel = this;
            synchronized (abstractInterruptibleChannel) {
                if (!this.closed) {
                    this.closed = true;
                    this.implCloseChannel();
                }
            }
        }
    }

    protected final void begin() {
        Thread.currentThread().pushInterruptAction$(this.interruptAndCloseRunnable);
    }

    protected final void end(boolean success) throws AsynchronousCloseException {
        Thread.currentThread().popInterruptAction$(this.interruptAndCloseRunnable);
        if (this.interrupted) {
            this.interrupted = false;
            throw new ClosedByInterruptException();
        }
        if (!success && this.closed) {
            throw new AsynchronousCloseException();
        }
    }

    protected abstract void implCloseChannel() throws IOException;
}

