/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.apache.harmony.security.fortress.Engine;

public abstract class Signature
extends SignatureSpi {
    private static final String SERVICE = "Signature";
    private static final Engine ENGINE = new Engine("Signature");
    Provider provider;
    final String algorithm;
    protected static final int UNINITIALIZED = 0;
    protected static final int SIGN = 2;
    protected static final int VERIFY = 3;
    protected int state = 0;

    protected Signature(String algorithm) {
        this.algorithm = algorithm;
    }

    public static Signature getInstance(String algorithm) throws NoSuchAlgorithmException {
        if (algorithm == null) {
            throw new NullPointerException("algorithm == null");
        }
        return Signature.getSignature(algorithm, null);
    }

    public static Signature getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (algorithm == null) {
            throw new NullPointerException("algorithm == null");
        }
        if (provider == null || provider.isEmpty()) {
            throw new IllegalArgumentException();
        }
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return Signature.getSignature(algorithm, p);
    }

    public static Signature getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (algorithm == null) {
            throw new NullPointerException("algorithm == null");
        }
        if (provider == null) {
            throw new IllegalArgumentException("provider == null");
        }
        return Signature.getSignature(algorithm, provider);
    }

    private static Signature getSignature(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        Engine.SpiAndProvider spiAndProvider;
        if (algorithm == null || algorithm.isEmpty()) {
            throw new NoSuchAlgorithmException("Unknown algorithm: " + algorithm);
        }
        try {
            spiAndProvider = Signature.tryAlgorithm(null, provider, algorithm);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException("InvalidKeyException thrown when key == null", e);
        }
        if (spiAndProvider == null) {
            if (provider == null) {
                throw new NoSuchAlgorithmException("No provider found for " + algorithm);
            }
            throw new NoSuchAlgorithmException("Provider " + provider.getName() + " does not provide " + algorithm);
        }
        if (spiAndProvider.spi instanceof Signature) {
            return (Signature)spiAndProvider.spi;
        }
        return new SignatureImpl(algorithm, provider);
    }

    private static Engine.SpiAndProvider tryAlgorithm(Key key, Provider provider, String algorithm) throws InvalidKeyException {
        if (provider != null) {
            Provider.Service service = provider.getService(SERVICE, algorithm);
            if (service == null) {
                return null;
            }
            return Signature.tryAlgorithmWithProvider(null, service);
        }
        ArrayList<Provider.Service> services = ENGINE.getServices(algorithm);
        if (services == null || services.isEmpty()) {
            return null;
        }
        boolean keySupported = false;
        for (Provider.Service service : services) {
            if (key != null && !service.supportsParameter(key)) continue;
            keySupported = true;
            Engine.SpiAndProvider sap = Signature.tryAlgorithmWithProvider(key, service);
            if (sap == null) continue;
            return sap;
        }
        if (!keySupported) {
            throw new InvalidKeyException("No provider supports the provided key");
        }
        return null;
    }

    private static Engine.SpiAndProvider tryAlgorithmWithProvider(Key key, Provider.Service service) {
        try {
            if (key != null && !service.supportsParameter(key)) {
                return null;
            }
            Engine.SpiAndProvider sap = ENGINE.getInstance(service, null);
            if (sap.spi == null || sap.provider == null) {
                return null;
            }
            if (!(sap.spi instanceof SignatureSpi)) {
                return null;
            }
            return sap;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public final Provider getProvider() {
        this.ensureProviderChosen();
        return this.provider;
    }

    void ensureProviderChosen() {
    }

    public SignatureSpi getCurrentSpi() {
        return null;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final void initVerify(PublicKey publicKey) throws InvalidKeyException {
        this.engineInitVerify(publicKey);
        this.state = 3;
    }

    public final void initVerify(Certificate certificate) throws InvalidKeyException {
        if (certificate instanceof X509Certificate) {
            Set<String> ce = ((X509Certificate)certificate).getCriticalExtensionOIDs();
            boolean critical = false;
            if (ce != null && !ce.isEmpty()) {
                boolean[] keyUsage;
                Iterator<String> i = ce.iterator();
                while (i.hasNext()) {
                    if (!"2.5.29.15".equals(i.next())) continue;
                    critical = true;
                    break;
                }
                if (critical && (keyUsage = ((X509Certificate)certificate).getKeyUsage()) != null && !keyUsage[0]) {
                    throw new InvalidKeyException("The public key in the certificate cannot be used for digital signature purposes");
                }
            }
        }
        this.engineInitVerify(certificate.getPublicKey());
        this.state = 3;
    }

    public final void initSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey);
        this.state = 2;
    }

    public final void initSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.engineInitSign(privateKey, random);
        this.state = 2;
    }

    public final byte[] sign() throws SignatureException {
        if (this.state != 2) {
            throw new SignatureException("Signature object is not initialized properly");
        }
        return this.engineSign();
    }

    public final int sign(byte[] outbuf, int offset, int len) throws SignatureException {
        if (outbuf == null || offset < 0 || len < 0 || offset + len > outbuf.length) {
            throw new IllegalArgumentException();
        }
        if (this.state != 2) {
            throw new SignatureException("Signature object is not initialized properly");
        }
        return this.engineSign(outbuf, offset, len);
    }

    public final boolean verify(byte[] signature) throws SignatureException {
        if (this.state != 3) {
            throw new SignatureException("Signature object is not initialized properly");
        }
        return this.engineVerify(signature);
    }

    public final boolean verify(byte[] signature, int offset, int length) throws SignatureException {
        if (this.state != 3) {
            throw new SignatureException("Signature object is not initialized properly");
        }
        if (signature == null || offset < 0 || length < 0 || offset + length > signature.length) {
            throw new IllegalArgumentException();
        }
        return this.engineVerify(signature, offset, length);
    }

    public final void update(byte b) throws SignatureException {
        if (this.state == 0) {
            throw new SignatureException("Signature object is not initialized properly");
        }
        this.engineUpdate(b);
    }

    public final void update(byte[] data) throws SignatureException {
        if (this.state == 0) {
            throw new SignatureException("Signature object is not initialized properly");
        }
        this.engineUpdate(data, 0, data.length);
    }

    public final void update(byte[] data, int off, int len) throws SignatureException {
        if (this.state == 0) {
            throw new SignatureException("Signature object is not initialized properly");
        }
        if (data == null || off < 0 || len < 0 || off + len > data.length) {
            throw new IllegalArgumentException();
        }
        this.engineUpdate(data, off, len);
    }

    public final void update(ByteBuffer data) throws SignatureException {
        if (this.state == 0) {
            throw new SignatureException("Signature object is not initialized properly");
        }
        this.engineUpdate(data);
    }

    public String toString() {
        return "SIGNATURE " + this.algorithm + " state: " + this.stateToString(this.state);
    }

    private String stateToString(int state) {
        switch (state) {
            case 0: {
                return "UNINITIALIZED";
            }
            case 2: {
                return "SIGN";
            }
            case 3: {
                return "VERIFY";
            }
        }
        return "";
    }

    @Deprecated
    public final void setParameter(String param, Object value) throws InvalidParameterException {
        this.engineSetParameter(param, value);
    }

    public final void setParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        this.engineSetParameter(params);
    }

    public final AlgorithmParameters getParameters() {
        return this.engineGetParameters();
    }

    @Deprecated
    public final Object getParameter(String param) throws InvalidParameterException {
        return this.engineGetParameter(param);
    }

    private static class SignatureImpl
    extends Signature {
        private final Object initLock = new Object();
        private final Provider specifiedProvider;
        private SignatureSpi spiImpl;

        public SignatureImpl(String algorithm, Provider provider) {
            super(algorithm);
            this.specifiedProvider = provider;
        }

        private SignatureImpl(String algorithm, Provider provider, SignatureSpi spi) {
            this(algorithm, provider);
            this.spiImpl = spi;
        }

        @Override
        void ensureProviderChosen() {
            this.getSpi();
        }

        @Override
        protected byte[] engineSign() throws SignatureException {
            return this.getSpi().engineSign();
        }

        @Override
        protected void engineUpdate(byte arg0) throws SignatureException {
            this.getSpi().engineUpdate(arg0);
        }

        @Override
        protected boolean engineVerify(byte[] arg0) throws SignatureException {
            return this.getSpi().engineVerify(arg0);
        }

        @Override
        protected void engineUpdate(byte[] arg0, int arg1, int arg2) throws SignatureException {
            this.getSpi().engineUpdate(arg0, arg1, arg2);
        }

        @Override
        protected void engineInitSign(PrivateKey arg0) throws InvalidKeyException {
            this.getSpi(arg0).engineInitSign(arg0);
        }

        @Override
        protected void engineInitVerify(PublicKey arg0) throws InvalidKeyException {
            this.getSpi(arg0).engineInitVerify(arg0);
        }

        @Override
        protected Object engineGetParameter(String arg0) throws InvalidParameterException {
            return this.getSpi().engineGetParameter(arg0);
        }

        @Override
        protected void engineSetParameter(String arg0, Object arg1) throws InvalidParameterException {
            this.getSpi().engineSetParameter(arg0, arg1);
        }

        @Override
        protected void engineSetParameter(AlgorithmParameterSpec arg0) throws InvalidAlgorithmParameterException {
            this.getSpi().engineSetParameter(arg0);
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            SignatureSpi spi = this.spiImpl != null ? (SignatureSpi)this.spiImpl.clone() : null;
            return new SignatureImpl(this.getAlgorithm(), this.getProvider(), spi);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SignatureSpi getSpi(Key key) throws InvalidKeyException {
            Object object = this.initLock;
            synchronized (object) {
                if (this.spiImpl != null && key == null) {
                    return this.spiImpl;
                }
                Engine.SpiAndProvider sap = Signature.tryAlgorithm(key, this.specifiedProvider, this.algorithm);
                if (sap == null) {
                    throw new ProviderException("No provider for " + this.getAlgorithm());
                }
                this.spiImpl = (SignatureSpi)sap.spi;
                this.provider = sap.provider;
                return this.spiImpl;
            }
        }

        private SignatureSpi getSpi() {
            try {
                return this.getSpi(null);
            }
            catch (InvalidKeyException e) {
                throw new IllegalStateException("InvalidKeyException thrown when key == null", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SignatureSpi getCurrentSpi() {
            Object object = this.initLock;
            synchronized (object) {
                return this.spiImpl;
            }
        }
    }
}

