/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import libcore.util.EmptyArray;

public class ChoiceFormat
extends NumberFormat {
    private static final long serialVersionUID = 1795184449645032964L;
    private double[] choiceLimits;
    private String[] choiceFormats;

    public ChoiceFormat(double[] limits, String[] formats) {
        this.setChoices(limits, formats);
    }

    public ChoiceFormat(String template) {
        this.applyPattern(template);
    }

    public void applyPattern(String template) {
        double[] limits = new double[5];
        ArrayList<String> formats = new ArrayList<String>();
        int length = template.length();
        int limitCount = 0;
        int index = 0;
        StringBuffer buffer = new StringBuffer();
        NumberFormat format = NumberFormat.getInstance(Locale.US);
        ParsePosition position = new ParsePosition(0);
        while (true) {
            double next;
            if ((index = this.skipWhitespace(template, index)) >= length) {
                if (limitCount == limits.length) {
                    this.choiceLimits = limits;
                } else {
                    this.choiceLimits = new double[limitCount];
                    System.arraycopy((double[])limits, (int)0, (double[])this.choiceLimits, (int)0, (int)limitCount);
                }
                this.choiceFormats = new String[formats.size()];
                for (int i = 0; i < formats.size(); ++i) {
                    this.choiceFormats[i] = (String)formats.get(i);
                }
                return;
            }
            position.setIndex(index);
            Number value = format.parse(template, position);
            index = this.skipWhitespace(template, position.getIndex());
            if (position.getErrorIndex() != -1 || index >= length) {
                this.choiceLimits = EmptyArray.DOUBLE;
                this.choiceFormats = EmptyArray.STRING;
                return;
            }
            char ch = template.charAt(index++);
            if (limitCount == limits.length) {
                double[] newLimits = new double[limitCount * 2];
                System.arraycopy((double[])limits, (int)0, (double[])newLimits, (int)0, (int)limitCount);
                limits = newLimits;
            }
            switch (ch) {
                case '#': 
                case '\u2264': {
                    next = value.doubleValue();
                    break;
                }
                case '<': {
                    next = ChoiceFormat.nextDouble(value.doubleValue());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad character '" + ch + "' in template: " + template);
                }
            }
            if (limitCount > 0 && next <= limits[limitCount - 1]) {
                throw new IllegalArgumentException("Bad template: " + template);
            }
            buffer.setLength(0);
            position.setIndex(index);
            ChoiceFormat.upTo(template, position, buffer, '|');
            index = position.getIndex();
            limits[limitCount++] = next;
            formats.add(buffer.toString());
        }
    }

    @Override
    public Object clone() {
        ChoiceFormat clone = (ChoiceFormat)super.clone();
        clone.choiceLimits = (double[])this.choiceLimits.clone();
        clone.choiceFormats = (String[])this.choiceFormats.clone();
        return clone;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ChoiceFormat)) {
            return false;
        }
        ChoiceFormat choice = (ChoiceFormat)object;
        return Arrays.equals(this.choiceLimits, choice.choiceLimits) && Arrays.equals(this.choiceFormats, choice.choiceFormats);
    }

    @Override
    public StringBuffer format(double value, StringBuffer buffer, FieldPosition field) {
        for (int i = this.choiceLimits.length - 1; i >= 0; --i) {
            if (!(this.choiceLimits[i] <= value)) continue;
            return buffer.append(this.choiceFormats[i]);
        }
        return this.choiceFormats.length == 0 ? buffer : buffer.append(this.choiceFormats[0]);
    }

    @Override
    public StringBuffer format(long value, StringBuffer buffer, FieldPosition field) {
        return this.format((double)value, buffer, field);
    }

    public Object[] getFormats() {
        return this.choiceFormats;
    }

    public double[] getLimits() {
        return this.choiceLimits;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        for (int i = 0; i < this.choiceLimits.length; ++i) {
            long v = Double.doubleToLongBits(this.choiceLimits[i]);
            hashCode += (int)(v ^ v >>> 32) + this.choiceFormats[i].hashCode();
        }
        return hashCode;
    }

    public static final double nextDouble(double value) {
        return Math.nextUp(value);
    }

    public static double nextDouble(double value, boolean increment) {
        return increment ? ChoiceFormat.nextDouble(value) : ChoiceFormat.previousDouble(value);
    }

    @Override
    public Number parse(String string2, ParsePosition position) {
        int offset = position.getIndex();
        for (int i = 0; i < this.choiceFormats.length; ++i) {
            if (!string2.startsWith(this.choiceFormats[i], offset)) continue;
            position.setIndex(offset + this.choiceFormats[i].length());
            return new Double(this.choiceLimits[i]);
        }
        position.setErrorIndex(offset);
        return new Double(Double.NaN);
    }

    public static final double previousDouble(double value) {
        return Math.nextAfter(value, Double.NEGATIVE_INFINITY);
    }

    public void setChoices(double[] limits, String[] formats) {
        if (limits.length != formats.length) {
            throw new IllegalArgumentException("limits.length != formats.length: " + limits.length + " != " + formats.length);
        }
        this.choiceLimits = limits;
        this.choiceFormats = formats;
    }

    private int skipWhitespace(String string2, int index) {
        int length = string2.length();
        while (index < length && Character.isWhitespace(string2.charAt(index))) {
            ++index;
        }
        return index;
    }

    public String toPattern() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.choiceLimits.length; ++i) {
            boolean quote;
            if (i != 0) {
                buffer.append('|');
            }
            String previous = String.valueOf(ChoiceFormat.previousDouble(this.choiceLimits[i]));
            String limit = String.valueOf(this.choiceLimits[i]);
            if (Double.isInfinite(this.choiceLimits[i]) || Double.isInfinite(ChoiceFormat.previousDouble(this.choiceLimits[i]))) {
                if (this.choiceLimits[i] < 0.0) {
                    buffer.append("-\u221e");
                    buffer.append('<');
                } else {
                    buffer.append('\u221e');
                    buffer.append('<');
                }
            } else if (previous.length() < limit.length()) {
                buffer.append(previous);
                buffer.append('<');
            } else {
                buffer.append(limit);
                buffer.append('#');
            }
            boolean bl = quote = this.choiceFormats[i].indexOf(124) != -1;
            if (quote) {
                buffer.append('\'');
            }
            buffer.append(this.choiceFormats[i]);
            if (!quote) continue;
            buffer.append('\'');
        }
        return buffer.toString();
    }
}

