/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.BreakIterator;
import java.text.CharacterIterator;

class IcuIteratorWrapper
extends BreakIterator {
    private android.icu.text.BreakIterator wrapped;

    IcuIteratorWrapper(android.icu.text.BreakIterator iterator) {
        this.wrapped = iterator;
    }

    @Override
    public int current() {
        return this.wrapped.current();
    }

    @Override
    public int first() {
        return this.wrapped.first();
    }

    @Override
    public int following(int offset) {
        this.checkOffset(offset);
        return this.wrapped.following(offset);
    }

    @Override
    public CharacterIterator getText() {
        return this.wrapped.getText();
    }

    @Override
    public int last() {
        return this.wrapped.last();
    }

    @Override
    public int next() {
        return this.wrapped.next();
    }

    @Override
    public int next(int n) {
        return this.wrapped.next(n);
    }

    @Override
    public int previous() {
        return this.wrapped.previous();
    }

    @Override
    public void setText(String newText) {
        this.wrapped.setText(newText);
    }

    @Override
    public void setText(CharacterIterator newText) {
        newText.current();
        this.wrapped.setText(newText);
    }

    @Override
    public boolean isBoundary(int offset) {
        this.checkOffset(offset);
        return this.wrapped.isBoundary(offset);
    }

    @Override
    public int preceding(int offset) {
        this.checkOffset(offset);
        return this.wrapped.preceding(offset);
    }

    public boolean equals(Object o) {
        if (!(o instanceof IcuIteratorWrapper)) {
            return false;
        }
        return this.wrapped.equals(((IcuIteratorWrapper)o).wrapped);
    }

    public String toString() {
        return this.wrapped.toString();
    }

    public int hashCode() {
        return this.wrapped.hashCode();
    }

    private void checkOffset(int offset) {
        CharacterIterator it = this.wrapped.getText();
        if (it == null) {
            throw new IllegalArgumentException("BreakIterator has no text");
        }
        if (offset < it.getBeginIndex() || offset > it.getEndIndex()) {
            String message = "Valid range is [" + it.getBeginIndex() + " " + it.getEndIndex() + "]";
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public Object clone() {
        IcuIteratorWrapper cloned = (IcuIteratorWrapper)super.clone();
        cloned.wrapped = (android.icu.text.BreakIterator)this.wrapped.clone();
        return cloned;
    }
}

