/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IllformedLocaleException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import libcore.icu.ICU;

public final class Locale
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 9149081749638150636L;
    public static final Locale CANADA = new Locale(true, "en", "CA");
    public static final Locale CANADA_FRENCH = new Locale(true, "fr", "CA");
    public static final Locale CHINA = new Locale(true, "zh", "CN");
    public static final Locale CHINESE = new Locale(true, "zh", "");
    public static final Locale ENGLISH = new Locale(true, "en", "");
    public static final Locale FRANCE = new Locale(true, "fr", "FR");
    public static final Locale FRENCH = new Locale(true, "fr", "");
    public static final Locale GERMAN = new Locale(true, "de", "");
    public static final Locale GERMANY = new Locale(true, "de", "DE");
    public static final Locale ITALIAN = new Locale(true, "it", "");
    public static final Locale ITALY = new Locale(true, "it", "IT");
    public static final Locale JAPAN = new Locale(true, "ja", "JP");
    public static final Locale JAPANESE = new Locale(true, "ja", "");
    public static final Locale KOREA = new Locale(true, "ko", "KR");
    public static final Locale KOREAN = new Locale(true, "ko", "");
    public static final Locale PRC = new Locale(true, "zh", "CN");
    public static final Locale ROOT = new Locale(true, "", "");
    public static final Locale SIMPLIFIED_CHINESE = new Locale(true, "zh", "CN");
    public static final Locale TAIWAN = new Locale(true, "zh", "TW");
    public static final Locale TRADITIONAL_CHINESE = new Locale(true, "zh", "TW");
    public static final Locale UK = new Locale(true, "en", "GB");
    public static final Locale US = new Locale(true, "en", "US");
    public static final char PRIVATE_USE_EXTENSION = 'x';
    public static final char UNICODE_LOCALE_EXTENSION = 'u';
    private static final String UNDETERMINED_LANGUAGE = "und";
    private static final TreeMap<String, String> GRANDFATHERED_LOCALES = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private transient String countryCode;
    private transient String languageCode;
    private transient String variantCode;
    private transient String scriptCode;
    private transient Set<String> unicodeAttributes;
    private transient Map<String, String> unicodeKeywords;
    private transient Map<Character, String> extensions;
    private final transient boolean hasValidatedFields;
    private transient String cachedToStringResult;
    private transient String cachedLanguageTag;
    private transient String cachedIcuLocaleId;
    private static final ObjectStreamField[] serialPersistentFields;

    public static Locale getDefaultLocaleFromSystemProperties() {
        Locale defaultLocale;
        String languageTag = System.getProperty("user.locale", "");
        if (!languageTag.isEmpty()) {
            defaultLocale = Locale.forLanguageTag(languageTag);
        } else {
            String language = System.getProperty("user.language", "en");
            String region = System.getProperty("user.region", "US");
            String variant = System.getProperty("user.variant", "");
            defaultLocale = new Locale(language, region, variant);
        }
        return defaultLocale;
    }

    public static Locale forLanguageTag(String languageTag) {
        if (languageTag == null) {
            throw new NullPointerException("languageTag == null");
        }
        return Locale.forLanguageTag(languageTag, false);
    }

    private Locale(boolean hasValidatedFields, String lowerCaseLanguageCode, String upperCaseCountryCode) {
        this.languageCode = lowerCaseLanguageCode;
        this.countryCode = upperCaseCountryCode;
        this.variantCode = "";
        this.scriptCode = "";
        this.unicodeAttributes = Collections.EMPTY_SET;
        this.unicodeKeywords = Collections.EMPTY_MAP;
        this.extensions = Collections.EMPTY_MAP;
        this.hasValidatedFields = hasValidatedFields;
    }

    public Locale(String language) {
        this(language, "", "", "", Collections.EMPTY_SET, Collections.EMPTY_MAP, Collections.EMPTY_MAP, false);
    }

    public Locale(String language, String country) {
        this(language, country, "", "", Collections.EMPTY_SET, Collections.EMPTY_MAP, Collections.EMPTY_MAP, false);
    }

    public Locale(String language, String country, String variant, String scriptCode, Set<String> unicodeAttributes, Map<String, String> unicodeKeywords, Map<Character, String> extensions, boolean hasValidatedFields) {
        if (language == null || country == null || variant == null) {
            throw new NullPointerException("language=" + language + ",country=" + country + ",variant=" + variant);
        }
        if (hasValidatedFields) {
            this.languageCode = Locale.adjustLanguageCode(language);
            this.countryCode = country;
            this.variantCode = variant;
        } else if (language.isEmpty() && country.isEmpty()) {
            this.languageCode = "";
            this.countryCode = "";
            this.variantCode = variant;
        } else {
            this.languageCode = Locale.adjustLanguageCode(language);
            this.countryCode = country.toUpperCase(US);
            this.variantCode = variant;
        }
        this.scriptCode = scriptCode;
        if (hasValidatedFields) {
            TreeSet<String> attribsCopy = new TreeSet<String>(unicodeAttributes);
            TreeMap<String, String> keywordsCopy = new TreeMap<String, String>(unicodeKeywords);
            TreeMap<Character, String> extensionsCopy = new TreeMap<Character, String>(extensions);
            Locale.addUnicodeExtensionToExtensionsMap(attribsCopy, keywordsCopy, extensionsCopy);
            this.unicodeAttributes = Collections.unmodifiableSet(attribsCopy);
            this.unicodeKeywords = Collections.unmodifiableMap(keywordsCopy);
            this.extensions = Collections.unmodifiableMap(extensionsCopy);
        } else {
            TreeMap<String, String> keywordsCopy;
            if ("ja".equals(language) && "JP".equals(country) && "JP".equals(variant)) {
                keywordsCopy = new TreeMap<String, String>(unicodeKeywords);
                keywordsCopy.put("ca", "japanese");
                unicodeKeywords = keywordsCopy;
            } else if ("th".equals(language) && "TH".equals(country) && "TH".equals(variant)) {
                keywordsCopy = new TreeMap<String, String>(unicodeKeywords);
                keywordsCopy.put("nu", "thai");
                unicodeKeywords = keywordsCopy;
            }
            if (!unicodeKeywords.isEmpty() || !unicodeAttributes.isEmpty()) {
                TreeMap<Character, String> extensionsCopy = new TreeMap<Character, String>(extensions);
                Locale.addUnicodeExtensionToExtensionsMap(unicodeAttributes, unicodeKeywords, extensionsCopy);
                extensions = extensionsCopy;
            }
            this.unicodeAttributes = unicodeAttributes;
            this.unicodeKeywords = unicodeKeywords;
            this.extensions = extensions;
        }
        this.hasValidatedFields = hasValidatedFields;
    }

    public Locale(String language, String country, String variant) {
        this(language, country, variant, "", Collections.EMPTY_SET, Collections.EMPTY_MAP, Collections.EMPTY_MAP, false);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Locale) {
            Locale o = (Locale)object;
            return this.languageCode.equals(o.languageCode) && this.countryCode.equals(o.countryCode) && this.variantCode.equals(o.variantCode) && this.scriptCode.equals(o.scriptCode) && this.extensions.equals(o.extensions);
        }
        return false;
    }

    public static Locale[] getAvailableLocales() {
        return ICU.getAvailableLocales();
    }

    public String getCountry() {
        return this.countryCode;
    }

    public static Locale getDefault() {
        return NoImagePreloadHolder.defaultLocale;
    }

    public final String getDisplayCountry() {
        return this.getDisplayCountry(Locale.getDefault());
    }

    public String getDisplayCountry(Locale locale) {
        if (this.countryCode.isEmpty()) {
            return "";
        }
        String normalizedRegion = Builder.normalizeAndValidateRegion(this.countryCode, false);
        if (normalizedRegion.isEmpty()) {
            return this.countryCode;
        }
        String result = ICU.getDisplayCountry(this, locale);
        if (result == null) {
            result = ICU.getDisplayCountry(this, Locale.getDefault());
        }
        return result;
    }

    public final String getDisplayLanguage() {
        return this.getDisplayLanguage(Locale.getDefault());
    }

    public String getDisplayLanguage(Locale locale) {
        if (this.languageCode.isEmpty()) {
            return "";
        }
        String normalizedLanguage = Builder.normalizeAndValidateLanguage(this.languageCode, false);
        if (UNDETERMINED_LANGUAGE.equals(normalizedLanguage)) {
            return this.languageCode;
        }
        String result = ICU.getDisplayLanguage(this, locale);
        if (result == null) {
            result = ICU.getDisplayLanguage(this, Locale.getDefault());
        }
        return result;
    }

    public final String getDisplayName() {
        return this.getDisplayName(Locale.getDefault());
    }

    public String getDisplayName(Locale locale) {
        int count = 0;
        StringBuilder buffer = new StringBuilder();
        if (!this.languageCode.isEmpty()) {
            String displayLanguage = this.getDisplayLanguage(locale);
            buffer.append(displayLanguage.isEmpty() ? this.languageCode : displayLanguage);
            ++count;
        }
        if (!this.scriptCode.isEmpty()) {
            String displayScript;
            if (count == 1) {
                buffer.append(" (");
            }
            buffer.append((displayScript = this.getDisplayScript(locale)).isEmpty() ? this.scriptCode : displayScript);
            ++count;
        }
        if (!this.countryCode.isEmpty()) {
            if (count == 1) {
                buffer.append(" (");
            } else if (count == 2) {
                buffer.append(",");
            }
            String displayCountry = this.getDisplayCountry(locale);
            buffer.append(displayCountry.isEmpty() ? this.countryCode : displayCountry);
            ++count;
        }
        if (!this.variantCode.isEmpty()) {
            if (count == 1) {
                buffer.append(" (");
            } else if (count == 2 || count == 3) {
                buffer.append(",");
            }
            String displayVariant = this.getDisplayVariant(locale);
            buffer.append(displayVariant.isEmpty() ? this.variantCode : displayVariant);
            ++count;
        }
        if (count > 1) {
            buffer.append(")");
        }
        return buffer.toString();
    }

    public final String getDisplayVariant() {
        return this.getDisplayVariant(Locale.getDefault());
    }

    public String getDisplayVariant(Locale locale) {
        if (this.variantCode.isEmpty()) {
            return "";
        }
        try {
            Builder.normalizeAndValidateVariant(this.variantCode);
        }
        catch (IllformedLocaleException ilfe) {
            return this.variantCode;
        }
        String result = ICU.getDisplayVariant(this, locale);
        if (result == null) {
            result = ICU.getDisplayVariant(this, Locale.getDefault());
        }
        if (result.isEmpty()) {
            return this.variantCode;
        }
        return result;
    }

    public String getISO3Country() {
        String code = ICU.getISO3Country("en-" + this.countryCode);
        if (!this.countryCode.isEmpty() && code.isEmpty()) {
            throw new MissingResourceException("No 3-letter country code for locale: " + this, "FormatData_" + this, "ShortCountry");
        }
        return code;
    }

    public String getISO3Language() {
        if (this.languageCode.isEmpty()) {
            return "";
        }
        String code = ICU.getISO3Language(this.languageCode);
        if (!this.languageCode.isEmpty() && code.isEmpty()) {
            throw new MissingResourceException("No 3-letter language code for locale: " + this, "FormatData_" + this, "ShortLanguage");
        }
        return code;
    }

    public static String[] getISOCountries() {
        return ICU.getISOCountries();
    }

    public static String[] getISOLanguages() {
        return ICU.getISOLanguages();
    }

    public String getLanguage() {
        return this.languageCode;
    }

    public String getVariant() {
        return this.variantCode;
    }

    public String getScript() {
        return this.scriptCode;
    }

    public String getDisplayScript() {
        return this.getDisplayScript(Locale.getDefault());
    }

    public String getDisplayScript(Locale locale) {
        if (this.scriptCode.isEmpty()) {
            return "";
        }
        String result = ICU.getDisplayScript(this, locale);
        if (result == null) {
            result = ICU.getDisplayScript(this, Locale.getDefault());
        }
        return result;
    }

    public String toLanguageTag() {
        if (this.cachedLanguageTag == null) {
            this.cachedLanguageTag = this.makeLanguageTag();
        }
        return this.cachedLanguageTag;
    }

    private String makeLanguageTag() {
        String language = "";
        String region = "";
        String variant = "";
        String illFormedVariantSubtags = "";
        if (this.hasValidatedFields) {
            language = this.languageCode;
            region = this.countryCode;
            variant = this.variantCode.replace('_', '-');
        } else {
            language = Builder.normalizeAndValidateLanguage(this.languageCode, false);
            region = Builder.normalizeAndValidateRegion(this.countryCode, false);
            try {
                variant = Builder.normalizeAndValidateVariant(this.variantCode);
            }
            catch (IllformedLocaleException ilfe) {
                String[] split = Locale.splitIllformedVariant(this.variantCode);
                variant = split[0];
                illFormedVariantSubtags = split[1];
            }
        }
        if (language.isEmpty()) {
            language = UNDETERMINED_LANGUAGE;
        }
        if ("no".equals(language) && "NO".equals(region) && "NY".equals(variant)) {
            language = "nn";
            region = "NO";
            variant = "";
        }
        StringBuilder sb = new StringBuilder(16);
        sb.append(language);
        if (!this.scriptCode.isEmpty()) {
            sb.append('-');
            sb.append(this.scriptCode);
        }
        if (!region.isEmpty()) {
            sb.append('-');
            sb.append(region);
        }
        if (!variant.isEmpty()) {
            sb.append('-');
            sb.append(variant);
        }
        for (Map.Entry<Character, String> extension : this.extensions.entrySet()) {
            if (extension.getKey().equals(Character.valueOf('x'))) continue;
            sb.append('-').append(extension.getKey());
            sb.append('-').append(extension.getValue());
        }
        String privateUse = this.extensions.get(Character.valueOf('x'));
        if (privateUse != null) {
            sb.append("-x-");
            sb.append(privateUse);
        }
        if (!illFormedVariantSubtags.isEmpty()) {
            if (privateUse == null) {
                sb.append("-x-lvariant-");
            } else {
                sb.append('-');
            }
            sb.append(illFormedVariantSubtags);
        }
        return sb.toString();
    }

    private static String[] splitIllformedVariant(String variant) {
        String normalizedVariant = variant.replace('_', '-');
        String[] subTags = normalizedVariant.split("-");
        String[] split = new String[]{"", ""};
        int firstInvalidSubtag = subTags.length;
        for (int i = 0; i < subTags.length; ++i) {
            if (Locale.isValidBcp47Alphanum(subTags[i], 1, 8)) continue;
            firstInvalidSubtag = i;
            break;
        }
        if (firstInvalidSubtag == 0) {
            return split;
        }
        int firstIllformedSubtag = firstInvalidSubtag;
        for (int i = 0; i < firstInvalidSubtag; ++i) {
            String subTag = subTags[i];
            if (subTag.length() >= 5 && subTag.length() <= 8) {
                if (Locale.isAsciiAlphaNum(subTag)) continue;
                firstIllformedSubtag = i;
                continue;
            }
            if (subTag.length() == 4) {
                char firstChar = subTag.charAt(0);
                if (firstChar >= '0' && firstChar <= '9' && Locale.isAsciiAlphaNum(subTag)) continue;
                firstIllformedSubtag = i;
                continue;
            }
            firstIllformedSubtag = i;
        }
        split[0] = Locale.concatenateRange(subTags, 0, firstIllformedSubtag);
        split[1] = Locale.concatenateRange(subTags, firstIllformedSubtag, firstInvalidSubtag);
        return split;
    }

    private static String concatenateRange(String[] array2, int start, int end) {
        StringBuilder builder = new StringBuilder(32);
        for (int i = start; i < end; ++i) {
            if (i != start) {
                builder.append('-');
            }
            builder.append(array2[i]);
        }
        return builder.toString();
    }

    public Set<Character> getExtensionKeys() {
        return this.extensions.keySet();
    }

    public String getExtension(char extensionKey) {
        return this.extensions.get(Character.valueOf(extensionKey));
    }

    public String getUnicodeLocaleType(String keyWord) {
        return this.unicodeKeywords.get(keyWord);
    }

    public Set<String> getUnicodeLocaleAttributes() {
        return this.unicodeAttributes;
    }

    public Set<String> getUnicodeLocaleKeys() {
        return this.unicodeKeywords.keySet();
    }

    public synchronized int hashCode() {
        return this.countryCode.hashCode() + this.languageCode.hashCode() + this.variantCode.hashCode() + this.scriptCode.hashCode() + this.extensions.hashCode();
    }

    public static synchronized void setDefault(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("locale == null");
        }
        String languageTag = locale.toLanguageTag();
        NoImagePreloadHolder.defaultLocale = locale;
        ICU.setDefaultLocale(languageTag);
    }

    public final String toString() {
        String result = this.cachedToStringResult;
        if (result == null) {
            result = this.cachedToStringResult = Locale.toNewString(this.languageCode, this.countryCode, this.variantCode, this.scriptCode, this.extensions);
        }
        return result;
    }

    private static String toNewString(String languageCode, String countryCode, String variantCode, String scriptCode, Map<Character, String> extensions) {
        boolean hasScriptOrExtensions;
        if (languageCode.length() == 0 && countryCode.length() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder(11);
        result.append(languageCode);
        boolean bl = hasScriptOrExtensions = !scriptCode.isEmpty() || !extensions.isEmpty();
        if (!countryCode.isEmpty() || !variantCode.isEmpty() || hasScriptOrExtensions) {
            result.append('_');
        }
        result.append(countryCode);
        if (!variantCode.isEmpty() || hasScriptOrExtensions) {
            result.append('_');
        }
        result.append(variantCode);
        if (hasScriptOrExtensions) {
            if (!variantCode.isEmpty()) {
                result.append('_');
            }
            result.append("#");
            if (!scriptCode.isEmpty()) {
                result.append(scriptCode);
            }
            if (!extensions.isEmpty()) {
                if (!scriptCode.isEmpty()) {
                    result.append('-');
                }
                result.append(Locale.serializeExtensions(extensions));
            }
        }
        return result.toString();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        ObjectOutputStream.PutField fields = stream.putFields();
        fields.put("country", this.countryCode);
        fields.put("hashcode", -1);
        fields.put("language", this.languageCode);
        fields.put("variant", this.variantCode);
        fields.put("script", this.scriptCode);
        if (!this.extensions.isEmpty()) {
            fields.put("extensions", Locale.serializeExtensions(this.extensions));
        }
        stream.writeFields();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = stream.readFields();
        this.countryCode = (String)fields.get("country", "");
        this.languageCode = (String)fields.get("language", "");
        this.variantCode = (String)fields.get("variant", "");
        this.scriptCode = (String)fields.get("script", "");
        this.unicodeKeywords = Collections.EMPTY_MAP;
        this.unicodeAttributes = Collections.EMPTY_SET;
        this.extensions = Collections.EMPTY_MAP;
        String extensions = (String)fields.get("extensions", null);
        if (extensions != null) {
            this.readExtensions(extensions);
        }
    }

    private void readExtensions(String extensions) {
        TreeMap<Character, String> extensionsMap = new TreeMap<Character, String>();
        Locale.parseSerializedExtensions(extensions, extensionsMap);
        this.extensions = Collections.unmodifiableMap(extensionsMap);
        if (extensionsMap.containsKey(Character.valueOf('u'))) {
            String unicodeExtension = (String)extensionsMap.get(Character.valueOf('u'));
            String[] subTags = unicodeExtension.split("-");
            TreeMap<String, String> unicodeKeywords = new TreeMap<String, String>();
            TreeSet<String> unicodeAttributes = new TreeSet<String>();
            Locale.parseUnicodeExtension(subTags, unicodeKeywords, unicodeAttributes);
            this.unicodeKeywords = Collections.unmodifiableMap(unicodeKeywords);
            this.unicodeAttributes = Collections.unmodifiableSet(unicodeAttributes);
        }
    }

    public static String serializeExtensions(Map<Character, String> extensionsMap) {
        Iterator<Map.Entry<Character, String>> entryIterator = extensionsMap.entrySet().iterator();
        StringBuilder sb = new StringBuilder(64);
        while (true) {
            Map.Entry<Character, String> entry = entryIterator.next();
            sb.append(entry.getKey());
            sb.append('-');
            sb.append(entry.getValue());
            if (!entryIterator.hasNext()) break;
            sb.append('-');
        }
        return sb.toString();
    }

    public static void parseSerializedExtensions(String extString, Map<Character, String> outputMap) {
        String[] subTags = extString.split("-");
        int[] typeStartIndices = new int[subTags.length / 2];
        int length = 0;
        int count = 0;
        for (String subTag : subTags) {
            if (subTag.length() > 0) {
                length += subTag.length() + 1;
            }
            if (subTag.length() != 1) continue;
            typeStartIndices[count++] = length;
        }
        for (int i = 0; i < count; ++i) {
            int valueStart = typeStartIndices[i];
            int valueEnd = i == count - 1 ? extString.length() : typeStartIndices[i + 1] - 3;
            outputMap.put(Character.valueOf(extString.charAt(typeStartIndices[i] - 2)), extString.substring(valueStart, valueEnd));
        }
    }

    private static boolean isUnM49AreaCode(String code) {
        if (code.length() != 3) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            char character = code.charAt(i);
            if (character >= '0' && character <= '9') continue;
            return false;
        }
        return true;
    }

    private static boolean isAsciiAlphaNum(String string2) {
        for (int i = 0; i < string2.length(); ++i) {
            char character = string2.charAt(i);
            if (character >= 'a' && character <= 'z' || character >= 'A' && character <= 'Z' || character >= '0' && character <= '9') continue;
            return false;
        }
        return true;
    }

    private static boolean isValidBcp47Alpha(String string2, int lowerBound, int upperBound) {
        int length = string2.length();
        if (length < lowerBound || length > upperBound) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            char character = string2.charAt(i);
            if (character >= 'a' && character <= 'z' || character >= 'A' && character <= 'Z') continue;
            return false;
        }
        return true;
    }

    private static boolean isValidBcp47Alphanum(String attributeOrType, int lowerBound, int upperBound) {
        if (attributeOrType.length() < lowerBound || attributeOrType.length() > upperBound) {
            return false;
        }
        return Locale.isAsciiAlphaNum(attributeOrType);
    }

    private static String titleCaseAsciiWord(String word) {
        try {
            byte[] chars = word.toLowerCase(ROOT).getBytes(StandardCharsets.US_ASCII);
            chars[0] = (byte)(chars[0] + 65 - 97);
            return new String(chars, StandardCharsets.US_ASCII);
        }
        catch (UnsupportedOperationException uoe) {
            throw new AssertionError((Object)uoe);
        }
    }

    private static boolean isValidTypeList(String lowerCaseTypeList) {
        String[] splitList;
        for (String type : splitList = lowerCaseTypeList.split("-")) {
            if (Locale.isValidBcp47Alphanum(type, 3, 8)) continue;
            return false;
        }
        return true;
    }

    private static void addUnicodeExtensionToExtensionsMap(Set<String> attributes, Map<String, String> keywords, Map<Character, String> extensions) {
        if (attributes.isEmpty() && keywords.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder(32);
        if (!attributes.isEmpty()) {
            Iterator<String> attributesIterator = attributes.iterator();
            while (true) {
                sb.append(attributesIterator.next());
                if (!attributesIterator.hasNext()) break;
                sb.append('-');
            }
        }
        if (!keywords.isEmpty()) {
            if (!attributes.isEmpty()) {
                sb.append('-');
            }
            Iterator<Map.Entry<String, String>> keywordsIterator = keywords.entrySet().iterator();
            while (true) {
                Map.Entry<String, String> keyWord = keywordsIterator.next();
                sb.append(keyWord.getKey());
                if (!keyWord.getValue().isEmpty()) {
                    sb.append('-');
                    sb.append(keyWord.getValue());
                }
                if (!keywordsIterator.hasNext()) break;
                sb.append('-');
            }
        }
        extensions.put(Character.valueOf('u'), sb.toString());
    }

    public static void parseUnicodeExtension(String[] subtags, Map<String, String> keywords, Set<String> attributes) {
        String lastKeyword = null;
        ArrayList<String> subtagsForKeyword = new ArrayList<String>();
        for (String subtag : subtags) {
            if (subtag.length() == 2) {
                if (subtagsForKeyword.size() > 0) {
                    keywords.put(lastKeyword, Locale.joinBcp47Subtags(subtagsForKeyword));
                    subtagsForKeyword.clear();
                }
                lastKeyword = subtag;
                continue;
            }
            if (subtag.length() <= 2) continue;
            if (lastKeyword == null) {
                attributes.add(subtag);
                continue;
            }
            subtagsForKeyword.add(subtag);
        }
        if (subtagsForKeyword.size() > 0) {
            keywords.put(lastKeyword, Locale.joinBcp47Subtags(subtagsForKeyword));
        } else if (lastKeyword != null) {
            keywords.put(lastKeyword, "");
        }
    }

    private static String joinBcp47Subtags(List<String> strings) {
        int size = strings.size();
        StringBuilder sb = new StringBuilder(strings.get(0).length());
        for (int i = 0; i < size; ++i) {
            sb.append(strings.get(i));
            if (i == size - 1) continue;
            sb.append('-');
        }
        return sb.toString();
    }

    public static String adjustLanguageCode(String languageCode) {
        String adjusted = languageCode.toLowerCase(US);
        if (languageCode.equals("he")) {
            adjusted = "iw";
        } else if (languageCode.equals("id")) {
            adjusted = "in";
        } else if (languageCode.equals("yi")) {
            adjusted = "ji";
        }
        return adjusted;
    }

    private static String convertGrandfatheredTag(String original) {
        String converted = GRANDFATHERED_LOCALES.get(original);
        return converted != null ? converted : original;
    }

    private static void extractVariantSubtags(String[] subtags, int startIndex, int endIndex, List<String> normalizedVariants) {
        String subtag;
        for (int i = startIndex; i < endIndex && Builder.isValidVariantSubtag(subtag = subtags[i]); ++i) {
            normalizedVariants.add(subtag);
        }
    }

    private static int extractExtensions(String[] subtags, int startIndex, int endIndex, Map<Character, String> extensions) {
        int i;
        int privateUseExtensionIndex = -1;
        int extensionKeyIndex = -1;
        for (i = startIndex; i < endIndex; ++i) {
            boolean parsingPrivateUse;
            String subtag = subtags[i];
            boolean bl = parsingPrivateUse = privateUseExtensionIndex != -1 && extensionKeyIndex == privateUseExtensionIndex;
            if (subtag.length() == 1 && !parsingPrivateUse) {
                if (extensionKeyIndex != -1) {
                    if (i - 1 == extensionKeyIndex) {
                        return extensionKeyIndex;
                    }
                    String key = subtags[extensionKeyIndex].toLowerCase(ROOT);
                    if (extensions.containsKey(Character.valueOf(key.charAt(0)))) {
                        return extensionKeyIndex;
                    }
                    String value = Locale.concatenateRange(subtags, extensionKeyIndex + 1, i);
                    extensions.put(Character.valueOf(key.charAt(0)), value.toLowerCase(ROOT));
                }
                extensionKeyIndex = i;
                if ("x".equals(subtag.toLowerCase(ROOT))) {
                    privateUseExtensionIndex = i;
                    continue;
                }
                if (privateUseExtensionIndex == -1) continue;
                return privateUseExtensionIndex;
            }
            if (extensionKeyIndex != -1) {
                if (Locale.isValidBcp47Alphanum(subtag, parsingPrivateUse ? 1 : 2, 8)) continue;
                return i;
            }
            return i;
        }
        if (extensionKeyIndex != -1) {
            if (i - 1 == extensionKeyIndex) {
                return extensionKeyIndex;
            }
            String key = subtags[extensionKeyIndex].toLowerCase(ROOT);
            if (extensions.containsKey(Character.valueOf(key.charAt(0)))) {
                return extensionKeyIndex;
            }
            String value = Locale.concatenateRange(subtags, extensionKeyIndex + 1, i);
            extensions.put(Character.valueOf(key.charAt(0)), value.toLowerCase(ROOT));
        }
        return i;
    }

    private static Locale forLanguageTag(String tag, boolean strict) {
        String converted = Locale.convertGrandfatheredTag(tag);
        String[] subtags = converted.split("-");
        int lastSubtag = subtags.length;
        for (int i = 0; i < subtags.length; ++i) {
            String subtag = subtags[i];
            if (!subtag.isEmpty() && subtag.length() <= 8) continue;
            if (strict) {
                throw new IllformedLocaleException("Invalid subtag at index: " + i + " in tag: " + tag);
            }
            lastSubtag = i - 1;
            break;
        }
        String languageCode = Builder.normalizeAndValidateLanguage(subtags[0], strict);
        String scriptCode = "";
        int nextSubtag = 1;
        if (lastSubtag > nextSubtag && !(scriptCode = Builder.normalizeAndValidateScript(subtags[nextSubtag], false)).isEmpty()) {
            ++nextSubtag;
        }
        String regionCode = "";
        if (lastSubtag > nextSubtag && !(regionCode = Builder.normalizeAndValidateRegion(subtags[nextSubtag], false)).isEmpty()) {
            ++nextSubtag;
        }
        ArrayList<String> variants = null;
        if (lastSubtag > nextSubtag) {
            variants = new ArrayList<String>();
            Locale.extractVariantSubtags(subtags, nextSubtag, lastSubtag, variants);
            nextSubtag += variants.size();
        }
        TreeMap<Character, String> extensions = Collections.EMPTY_MAP;
        if (lastSubtag > nextSubtag) {
            extensions = new TreeMap<Character, String>();
            nextSubtag = Locale.extractExtensions(subtags, nextSubtag, lastSubtag, extensions);
        }
        if (nextSubtag != lastSubtag && strict) {
            throw new IllformedLocaleException("Unparseable subtag: " + subtags[nextSubtag] + " from language tag: " + tag);
        }
        TreeSet<String> unicodeKeywords = Collections.EMPTY_SET;
        TreeMap<String, String> unicodeAttributes = Collections.EMPTY_MAP;
        if (extensions.containsKey(Character.valueOf('u'))) {
            unicodeKeywords = new TreeSet<String>();
            unicodeAttributes = new TreeMap<String, String>();
            Locale.parseUnicodeExtension(((String)extensions.get(Character.valueOf('u'))).split("-"), unicodeAttributes, unicodeKeywords);
        }
        String variantCode = "";
        if (variants != null && !variants.isEmpty()) {
            StringBuilder variantsBuilder = new StringBuilder(variants.size() * 8);
            for (int i = 0; i < variants.size(); ++i) {
                if (i != 0) {
                    variantsBuilder.append('_');
                }
                variantsBuilder.append((String)variants.get(i));
            }
            variantCode = variantsBuilder.toString();
        }
        return new Locale(languageCode, regionCode, variantCode, scriptCode, unicodeKeywords, unicodeAttributes, extensions, true);
    }

    static {
        GRANDFATHERED_LOCALES.put("en-GB-oed", "en-GB-x-oed");
        GRANDFATHERED_LOCALES.put("i-ami", "ami");
        GRANDFATHERED_LOCALES.put("i-bnn", "bnn");
        GRANDFATHERED_LOCALES.put("i-default", "en-x-i-default");
        GRANDFATHERED_LOCALES.put("i-enochian", "und-x-i-enochian");
        GRANDFATHERED_LOCALES.put("i-hak", "hak");
        GRANDFATHERED_LOCALES.put("i-klingon", "tlh");
        GRANDFATHERED_LOCALES.put("i-lux", "lb");
        GRANDFATHERED_LOCALES.put("i-mingo", "see-x-i-mingo");
        GRANDFATHERED_LOCALES.put("i-navajo", "nv");
        GRANDFATHERED_LOCALES.put("i-pwn", "pwn");
        GRANDFATHERED_LOCALES.put("i-tao", "tao");
        GRANDFATHERED_LOCALES.put("i-tay", "tay");
        GRANDFATHERED_LOCALES.put("i-tsu", "tsu");
        GRANDFATHERED_LOCALES.put("sgn-BE-FR", "sfb");
        GRANDFATHERED_LOCALES.put("sgn-BE-NL", "vgt");
        GRANDFATHERED_LOCALES.put("sgn-CH-DE", "sgg");
        GRANDFATHERED_LOCALES.put("art-lojban", "jbo");
        GRANDFATHERED_LOCALES.put("cel-gaulish", "xtg-x-cel-gaulish");
        GRANDFATHERED_LOCALES.put("no-bok", "nb");
        GRANDFATHERED_LOCALES.put("no-nyn", "nn");
        GRANDFATHERED_LOCALES.put("zh-guoyu", "cmn");
        GRANDFATHERED_LOCALES.put("zh-hakka", "hak");
        GRANDFATHERED_LOCALES.put("zh-min", "nan-x-zh-min");
        GRANDFATHERED_LOCALES.put("zh-min-nan", "nan");
        GRANDFATHERED_LOCALES.put("zh-xiang", "hsn");
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("country", String.class), new ObjectStreamField("hashcode", Integer.TYPE), new ObjectStreamField("language", String.class), new ObjectStreamField("variant", String.class), new ObjectStreamField("script", String.class), new ObjectStreamField("extensions", String.class)};
    }

    public static final class Builder {
        private String language = "";
        private String region = "";
        private String variant = "";
        private String script = "";
        private final Set<String> attributes = new TreeSet<String>();
        private final Map<String, String> keywords = new TreeMap<String, String>();
        private final Map<Character, String> extensions = new TreeMap<Character, String>();

        public Builder setLanguage(String language) {
            this.language = Builder.normalizeAndValidateLanguage(language, true);
            return this;
        }

        private static String normalizeAndValidateLanguage(String language, boolean strict) {
            if (language == null || language.isEmpty()) {
                return "";
            }
            String lowercaseLanguage = language.toLowerCase(ROOT);
            if (!Locale.isValidBcp47Alpha(lowercaseLanguage, 2, 3)) {
                if (strict) {
                    throw new IllformedLocaleException("Invalid language: " + language);
                }
                return Locale.UNDETERMINED_LANGUAGE;
            }
            return lowercaseLanguage;
        }

        public Builder setLanguageTag(String languageTag) {
            if (languageTag == null || languageTag.isEmpty()) {
                this.clear();
                return this;
            }
            Locale fromIcu = Locale.forLanguageTag(languageTag, true);
            if (fromIcu == null) {
                throw new IllformedLocaleException("Invalid languageTag: " + languageTag);
            }
            this.setLocale(fromIcu);
            return this;
        }

        public Builder setRegion(String region) {
            this.region = Builder.normalizeAndValidateRegion(region, true);
            return this;
        }

        private static String normalizeAndValidateRegion(String region, boolean strict) {
            if (region == null || region.isEmpty()) {
                return "";
            }
            String uppercaseRegion = region.toUpperCase(ROOT);
            if (!Locale.isValidBcp47Alpha(uppercaseRegion, 2, 2) && !Locale.isUnM49AreaCode(uppercaseRegion)) {
                if (strict) {
                    throw new IllformedLocaleException("Invalid region: " + region);
                }
                return "";
            }
            return uppercaseRegion;
        }

        public Builder setVariant(String variant) {
            this.variant = Builder.normalizeAndValidateVariant(variant);
            return this;
        }

        private static String normalizeAndValidateVariant(String variant) {
            String[] subTags;
            if (variant == null || variant.isEmpty()) {
                return "";
            }
            String normalizedVariant = variant.replace('-', '_');
            for (String subTag : subTags = normalizedVariant.split("_")) {
                if (Builder.isValidVariantSubtag(subTag)) continue;
                throw new IllformedLocaleException("Invalid variant: " + variant);
            }
            return normalizedVariant;
        }

        private static boolean isValidVariantSubtag(String subTag) {
            char firstChar;
            return subTag.length() >= 5 && subTag.length() <= 8 ? Locale.isAsciiAlphaNum(subTag) : subTag.length() == 4 && (firstChar = subTag.charAt(0)) >= '0' && firstChar <= '9' && Locale.isAsciiAlphaNum(subTag);
        }

        public Builder setScript(String script) {
            this.script = Builder.normalizeAndValidateScript(script, true);
            return this;
        }

        private static String normalizeAndValidateScript(String script, boolean strict) {
            if (script == null || script.isEmpty()) {
                return "";
            }
            if (!Locale.isValidBcp47Alpha(script, 4, 4)) {
                if (strict) {
                    throw new IllformedLocaleException("Invalid script: " + script);
                }
                return "";
            }
            return Locale.titleCaseAsciiWord(script);
        }

        public Builder setLocale(Locale locale) {
            if (locale == null) {
                throw new NullPointerException("locale == null");
            }
            String backupLanguage = this.language;
            String backupRegion = this.region;
            String backupVariant = this.variant;
            try {
                this.setLanguage(locale.getLanguage());
                this.setRegion(locale.getCountry());
                this.setVariant(locale.getVariant());
            }
            catch (IllformedLocaleException ifle) {
                this.language = backupLanguage;
                this.region = backupRegion;
                this.variant = backupVariant;
                throw ifle;
            }
            this.script = locale.getScript();
            this.extensions.clear();
            this.extensions.putAll(locale.extensions);
            this.keywords.clear();
            this.keywords.putAll(locale.unicodeKeywords);
            this.attributes.clear();
            this.attributes.addAll(locale.unicodeAttributes);
            return this;
        }

        public Builder addUnicodeLocaleAttribute(String attribute) {
            if (attribute == null) {
                throw new NullPointerException("attribute == null");
            }
            String lowercaseAttribute = attribute.toLowerCase(ROOT);
            if (!Locale.isValidBcp47Alphanum(lowercaseAttribute, 3, 8)) {
                throw new IllformedLocaleException("Invalid locale attribute: " + attribute);
            }
            this.attributes.add(lowercaseAttribute);
            return this;
        }

        public Builder removeUnicodeLocaleAttribute(String attribute) {
            if (attribute == null) {
                throw new NullPointerException("attribute == null");
            }
            String lowercaseAttribute = attribute.toLowerCase(ROOT);
            if (!Locale.isValidBcp47Alphanum(lowercaseAttribute, 3, 8)) {
                throw new IllformedLocaleException("Invalid locale attribute: " + attribute);
            }
            this.attributes.remove(attribute);
            return this;
        }

        public Builder setExtension(char key, String value) {
            if (value == null || value.isEmpty()) {
                this.extensions.remove(Character.valueOf(key));
                return this;
            }
            String normalizedValue = value.toLowerCase(ROOT).replace('_', '-');
            String[] subtags = normalizedValue.split("-");
            char normalizedKey = Character.toLowerCase(key);
            int minimumLength = normalizedKey == 'x' ? 1 : 2;
            for (String subtag : subtags) {
                if (Locale.isValidBcp47Alphanum(subtag, minimumLength, 8)) continue;
                throw new IllformedLocaleException("Invalid private use extension : " + value);
            }
            if (normalizedKey == 'u') {
                this.extensions.clear();
                this.attributes.clear();
                Locale.parseUnicodeExtension(subtags, this.keywords, this.attributes);
            } else {
                this.extensions.put(Character.valueOf(normalizedKey), normalizedValue);
            }
            return this;
        }

        public Builder clearExtensions() {
            this.extensions.clear();
            this.attributes.clear();
            this.keywords.clear();
            return this;
        }

        public Builder setUnicodeLocaleKeyword(String key, String type) {
            if (key == null) {
                throw new NullPointerException("key == null");
            }
            if (type == null && this.keywords != null) {
                this.keywords.remove(key);
                return this;
            }
            String lowerCaseKey = key.toLowerCase(ROOT);
            if (lowerCaseKey.length() != 2 || !Locale.isAsciiAlphaNum(lowerCaseKey)) {
                throw new IllformedLocaleException("Invalid unicode locale keyword: " + key);
            }
            String lowerCaseType = type.toLowerCase(ROOT).replace("_", "-");
            if (!Locale.isValidTypeList(lowerCaseType)) {
                throw new IllformedLocaleException("Invalid unicode locale type: " + type);
            }
            this.keywords.put(lowerCaseKey, lowerCaseType);
            return this;
        }

        public Builder clear() {
            this.clearExtensions();
            this.script = "";
            this.variant = "";
            this.region = "";
            this.language = "";
            return this;
        }

        public Locale build() {
            return new Locale(this.language, this.region, this.variant, this.script, this.attributes, this.keywords, this.extensions, true);
        }
    }

    private static class NoImagePreloadHolder {
        private static Locale defaultLocale = Locale.getDefaultLocaleFromSystemProperties();

        private NoImagePreloadHolder() {
        }
    }
}

