/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class XMLFormatter
extends Formatter {
    private static final String indent = "    ";

    @Override
    public String format(LogRecord r) {
        long time = r.getMillis();
        String date = MessageFormat.format("{0, date} {0, time}", new Date(time));
        String nl = System.lineSeparator();
        StringBuilder sb = new StringBuilder();
        sb.append("<record>").append(nl);
        XMLFormatter.append(sb, 1, "date", date);
        XMLFormatter.append(sb, 1, "millis", time);
        XMLFormatter.append(sb, 1, "sequence", r.getSequenceNumber());
        if (r.getLoggerName() != null) {
            XMLFormatter.escapeAndAppend(sb, 1, "logger", r.getLoggerName());
        }
        XMLFormatter.append(sb, 1, "level", r.getLevel().getName());
        if (r.getSourceClassName() != null) {
            XMLFormatter.append(sb, 1, "class", r.getSourceClassName());
        }
        if (r.getSourceMethodName() != null) {
            XMLFormatter.escapeAndAppend(sb, 1, "method", r.getSourceMethodName());
        }
        XMLFormatter.append(sb, 1, "thread", r.getThreadID());
        this.formatMessages(r, sb);
        Object[] params = r.getParameters();
        if (params != null) {
            for (Object element : params) {
                XMLFormatter.escapeAndAppend(sb, 1, "param", element);
            }
        }
        this.formatThrowable(r, sb);
        sb.append("</record>").append(nl);
        return sb.toString();
    }

    private void formatMessages(LogRecord r, StringBuilder sb) {
        ResourceBundle rb = r.getResourceBundle();
        String pattern = r.getMessage();
        if (rb != null && pattern != null) {
            String message;
            try {
                message = rb.getString(pattern);
            }
            catch (Exception e) {
                message = null;
            }
            if (message == null) {
                message = pattern;
                XMLFormatter.escapeAndAppend(sb, 1, "message", message);
            } else {
                XMLFormatter.escapeAndAppend(sb, 1, "message", message);
                XMLFormatter.escapeAndAppend(sb, 1, "key", pattern);
                XMLFormatter.escapeAndAppend(sb, 1, "catalog", r.getResourceBundleName());
            }
        } else if (pattern != null) {
            XMLFormatter.escapeAndAppend(sb, 1, "message", pattern);
        } else {
            sb.append(indent).append("<message/>");
        }
    }

    private void formatThrowable(LogRecord r, StringBuilder sb) {
        Throwable t = r.getThrown();
        if (t != null) {
            StackTraceElement[] elements;
            String nl = System.lineSeparator();
            sb.append(indent).append("<exception>").append(nl);
            XMLFormatter.escapeAndAppend(sb, 2, "message", t.toString());
            for (StackTraceElement e : elements = t.getStackTrace()) {
                sb.append(indent).append(indent).append("<frame>").append(nl);
                XMLFormatter.append(sb, 3, "class", e.getClassName());
                XMLFormatter.escapeAndAppend(sb, 3, "method", e.getMethodName());
                XMLFormatter.append(sb, 3, "line", e.getLineNumber());
                sb.append(indent).append(indent).append("</frame>").append(nl);
            }
            sb.append(indent).append("</exception>").append(nl);
        }
    }

    private static void append(StringBuilder sb, int indentCount, String tag, Object value) {
        for (int i = 0; i < indentCount; ++i) {
            sb.append(indent);
        }
        sb.append("<").append(tag).append(">");
        sb.append(value);
        sb.append("</").append(tag).append(">");
        sb.append(System.lineSeparator());
    }

    private static void escapeAndAppend(StringBuilder sb, int indentCount, String tag, Object value) {
        if (value == null) {
            XMLFormatter.append(sb, indentCount, tag, value);
        } else {
            for (int i = 0; i < indentCount; ++i) {
                sb.append(indent);
            }
            sb.append("<").append(tag).append(">");
            try {
                XMLFormatter.escapeXml(sb, value.toString());
            }
            catch (IOException e) {
                throw new AssertionError();
            }
            sb.append("</").append(tag).append(">");
            sb.append(System.lineSeparator());
        }
    }

    private static void escapeXml(Appendable valueBuilder, String value) throws IOException {
        block7: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\"': {
                    valueBuilder.append("&quot;");
                    continue block7;
                }
                case '>': {
                    valueBuilder.append("&gt;");
                    continue block7;
                }
                case '<': {
                    valueBuilder.append("&lt;");
                    continue block7;
                }
                case '&': {
                    valueBuilder.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    valueBuilder.append("&apos;");
                    continue block7;
                }
                default: {
                    valueBuilder.append(c);
                }
            }
        }
    }

    @Override
    public String getHead(Handler h) {
        String encoding = null;
        if (h != null) {
            encoding = h.getEncoding();
        }
        if (encoding == null) {
            encoding = System.getProperty("file.encoding");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"").append(encoding).append("\" standalone=\"no\"?>");
        sb.append(System.lineSeparator());
        sb.append("<!DOCTYPE log SYSTEM \"logger.dtd\">");
        sb.append(System.lineSeparator());
        sb.append("<log>");
        return sb.toString();
    }

    @Override
    public String getTail(Handler h) {
        return "</log>";
    }
}

