/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import libcore.io.Memory;
import libcore.io.Streams;

public class GZIPInputStream
extends InflaterInputStream {
    private static final int FCOMMENT = 16;
    private static final int FEXTRA = 4;
    private static final int FHCRC = 2;
    private static final int FNAME = 8;
    private static final int GZIP_TRAILER_SIZE = 8;
    public static final int GZIP_MAGIC = 35615;
    protected CRC32 crc = new CRC32();
    protected boolean eos = false;

    public GZIPInputStream(InputStream is) throws IOException {
        this(is, 512);
    }

    public GZIPInputStream(InputStream is, int size) throws IOException {
        super(is, new Inflater(true), size);
        try {
            byte[] header = GZIPInputStream.readHeader(is);
            short magic = Memory.peekShort(header, 0, ByteOrder.LITTLE_ENDIAN);
            if (magic != -29921) {
                throw new IOException(String.format("unknown format (magic number %x)", magic));
            }
            GZIPInputStream.parseGzipHeader(is, header, this.crc, this.buf);
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        this.eos = true;
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        int bytesRead;
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        if (this.eos) {
            return -1;
        }
        Arrays.checkOffsetAndCount(buffer.length, byteOffset, byteCount);
        try {
            bytesRead = super.read(buffer, byteOffset, byteCount);
        }
        finally {
            this.eos = this.eof;
        }
        if (bytesRead != -1) {
            this.crc.update(buffer, byteOffset, bytesRead);
        }
        if (this.eos) {
            this.verifyCrc();
            this.eos = this.maybeReadNextMember();
            if (!this.eos) {
                this.crc.reset();
                this.inf.reset();
                this.eof = false;
                this.len = 0;
            }
        }
        return bytesRead;
    }

    private boolean maybeReadNextMember() throws IOException {
        byte[] buffer;
        int remaining = this.inf.getRemaining() - 8;
        if (remaining > 0) {
            if (!(this.in instanceof PushbackInputStream)) {
                this.in = new PushbackInputStream(this.in, this.buf.length);
            }
            ((PushbackInputStream)this.in).unread(this.buf, this.inf.getCurrentOffset() + 8, remaining);
        }
        try {
            buffer = GZIPInputStream.readHeader(this.in);
        }
        catch (EOFException eof) {
            return true;
        }
        short magic = Memory.peekShort(buffer, 0, ByteOrder.LITTLE_ENDIAN);
        if (magic != -29921) {
            return true;
        }
        GZIPInputStream.parseGzipHeader(this.in, buffer, this.crc, this.buf);
        return false;
    }

    private static byte[] readHeader(InputStream in) throws IOException {
        byte[] header = new byte[10];
        Streams.readFully(in, header, 0, header.length);
        return header;
    }

    private static void parseGzipHeader(InputStream in, byte[] header, CRC32 crc, byte[] scratch) throws IOException {
        boolean hcrc;
        byte flags = header[3];
        boolean bl = hcrc = (flags & 2) != 0;
        if (hcrc) {
            crc.update(header, 0, header.length);
        }
        if ((flags & 4) != 0) {
            int result;
            Streams.readFully(in, header, 0, 2);
            if (hcrc) {
                crc.update(header, 0, 2);
            }
            for (int length = Memory.peekShort(header, 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF; length > 0; length -= result) {
                int max = length > scratch.length ? scratch.length : length;
                result = in.read(scratch, 0, max);
                if (result == -1) {
                    throw new EOFException();
                }
                if (!hcrc) continue;
                crc.update(scratch, 0, result);
            }
        }
        if ((flags & 8) != 0) {
            GZIPInputStream.readZeroTerminated(in, crc, hcrc);
        }
        if ((flags & 0x10) != 0) {
            GZIPInputStream.readZeroTerminated(in, crc, hcrc);
        }
        if (hcrc) {
            Streams.readFully(in, header, 0, 2);
            short crc16 = Memory.peekShort(header, 0, ByteOrder.LITTLE_ENDIAN);
            if ((short)crc.getValue() != crc16) {
                throw new IOException("CRC mismatch");
            }
            crc.reset();
        }
    }

    private void verifyCrc() throws IOException {
        int size = this.inf.getRemaining();
        int trailerSize = 8;
        byte[] b = new byte[8];
        int copySize = size > 8 ? 8 : size;
        System.arraycopy((byte[])this.buf, (int)(this.len - size), (byte[])b, (int)0, (int)copySize);
        Streams.readFully(this.in, b, copySize, 8 - copySize);
        if (Memory.peekInt(b, 0, ByteOrder.LITTLE_ENDIAN) != (int)this.crc.getValue()) {
            throw new IOException("CRC mismatch");
        }
        if (Memory.peekInt(b, 4, ByteOrder.LITTLE_ENDIAN) != this.inf.getTotalOut()) {
            throw new IOException("Size mismatch");
        }
    }

    private static void readZeroTerminated(InputStream in, CRC32 crc, boolean hcrc) throws IOException {
        int result;
        while ((result = in.read()) > 0) {
            if (!hcrc) continue;
            crc.update(result);
        }
        if (result == -1) {
            throw new EOFException();
        }
        if (hcrc) {
            crc.update(result);
        }
    }
}

