/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class Zip64 {
    public static final long MAX_ZIP_ENTRY_AND_ARCHIVE_SIZE = 0xFFFFFFFFL;
    private static final short ZIP64_EXTENDED_INFO_HEADER_ID = 1;
    private static final int ZIP64_LOCATOR_SIZE = 20;
    private static final int ZIP64_LOCATOR_SIGNATURE = 117853008;
    private static final int ZIP64_EOCD_RECORD_SIGNATURE = 101075792;
    private static final int ZIP64_EOCD_RECORD_EFFECTIVE_SIZE = 40;

    private Zip64() {
    }

    public static long parseZip64EocdRecordLocator(RandomAccessFile raf, long eocdOffset) throws IOException {
        if (eocdOffset > 20L) {
            raf.seek(eocdOffset - 20L);
            if (Integer.reverseBytes(raf.readInt()) == 117853008) {
                byte[] zip64EocdLocator = new byte[16];
                raf.readFully(zip64EocdLocator);
                ByteBuffer buf = ByteBuffer.wrap(zip64EocdLocator).order(ByteOrder.LITTLE_ENDIAN);
                int diskWithCentralDir = buf.getInt();
                long zip64EocdRecordOffset = buf.getLong();
                int numDisks = buf.getInt();
                if (numDisks != 1 || diskWithCentralDir != 0) {
                    throw new ZipException("Spanned archives not supported");
                }
                return zip64EocdRecordOffset;
            }
        }
        return -1L;
    }

    public static ZipFile.EocdRecord parseZip64EocdRecord(RandomAccessFile raf, long eocdRecordOffset, int commentLength) throws IOException {
        raf.seek(eocdRecordOffset);
        int signature = Integer.reverseBytes(raf.readInt());
        if (signature != 101075792) {
            throw new ZipException("Invalid zip64 eocd record offset, sig=" + Integer.toHexString(signature) + " offset=" + eocdRecordOffset);
        }
        raf.skipBytes(12);
        byte[] zip64Eocd = new byte[40];
        raf.readFully(zip64Eocd);
        ByteBuffer buf = ByteBuffer.wrap(zip64Eocd).order(ByteOrder.LITTLE_ENDIAN);
        try {
            int diskNumber = buf.getInt();
            int diskWithCentralDirStart = buf.getInt();
            long numEntries = buf.getLong();
            long totalNumEntries = buf.getLong();
            buf.getLong();
            long centralDirOffset = buf.getLong();
            if (numEntries != totalNumEntries || diskNumber != 0 || diskWithCentralDirStart != 0) {
                throw new ZipException("Spanned archives not supported : numEntries=" + numEntries + ", totalNumEntries=" + totalNumEntries + ", diskNumber=" + diskNumber + ", diskWithCentralDirStart=" + diskWithCentralDirStart);
            }
            return new ZipFile.EocdRecord(numEntries, centralDirOffset, commentLength);
        }
        catch (BufferUnderflowException bue) {
            ZipException zipException = new ZipException("Error parsing zip64 eocd record.");
            zipException.initCause(bue);
            throw zipException;
        }
    }

    public static boolean parseZip64ExtendedInfo(ZipEntry ze, boolean fromCentralDirectory) throws ZipException {
        ByteBuffer buf;
        int extendedInfoSize = -1;
        int extendedInfoStart = -1;
        if (ze.extra != null && ze.extra.length > 0 && (extendedInfoSize = Zip64.getZip64ExtendedInfoSize(buf = ByteBuffer.wrap(ze.extra).order(ByteOrder.LITTLE_ENDIAN))) != -1) {
            extendedInfoStart = buf.position();
            try {
                if (fromCentralDirectory || ze.getMethod() == 0) {
                    if (ze.size == 0xFFFFFFFFL) {
                        ze.size = buf.getLong();
                    }
                    if (ze.compressedSize == 0xFFFFFFFFL) {
                        ze.compressedSize = buf.getLong();
                    }
                }
                if (fromCentralDirectory && ze.localHeaderRelOffset == 0xFFFFFFFFL) {
                    ze.localHeaderRelOffset = buf.getLong();
                }
            }
            catch (BufferUnderflowException bue) {
                ZipException zipException = new ZipException("Error parsing extended info");
                zipException.initCause(bue);
                throw zipException;
            }
        }
        if (extendedInfoSize == -1) {
            if (ze.compressedSize == 0xFFFFFFFFL || ze.size == 0xFFFFFFFFL || ze.localHeaderRelOffset == 0xFFFFFFFFL) {
                throw new ZipException("File contains no zip64 extended information: name=" + ze.name + "compressedSize=" + ze.compressedSize + ", size=" + ze.size + ", localHeader=" + ze.localHeaderRelOffset);
            }
            return false;
        }
        int extendedInfoHeaderStart = extendedInfoStart - 4;
        int extendedInfoTotalSize = extendedInfoSize + 4;
        int extrasLen = ze.extra.length - extendedInfoTotalSize;
        byte[] extrasWithoutZip64 = new byte[extrasLen];
        System.arraycopy((byte[])ze.extra, (int)0, (byte[])extrasWithoutZip64, (int)0, (int)extendedInfoHeaderStart);
        System.arraycopy((byte[])ze.extra, (int)(extendedInfoHeaderStart + extendedInfoTotalSize), (byte[])extrasWithoutZip64, (int)extendedInfoHeaderStart, (int)(extrasLen - extendedInfoHeaderStart));
        ze.extra = extrasWithoutZip64;
        return true;
    }

    public static void insertZip64ExtendedInfoToExtras(ZipEntry ze) throws ZipException {
        byte[] output;
        int extendedInfoSize = 28;
        if (ze.extra == null) {
            output = new byte[28];
        } else {
            if (ze.extra.length + 28 > 65535) {
                throw new ZipException("No space in extras for zip64 extended entry info");
            }
            output = new byte[ze.extra.length + 28];
            System.arraycopy((byte[])ze.extra, (int)0, (byte[])output, (int)28, (int)ze.extra.length);
        }
        ByteBuffer bb = ByteBuffer.wrap(output).order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort((short)1);
        bb.putShort((short)24);
        if (ze.getMethod() == 0) {
            bb.putLong(ze.size);
            bb.putLong(ze.compressedSize);
        } else {
            bb.putLong(0L);
            bb.putLong(0L);
        }
        bb.putLong(ze.localHeaderRelOffset);
        ze.extra = output;
    }

    private static int getZip64ExtendedInfoSize(ByteBuffer extras) {
        try {
            while (extras.hasRemaining()) {
                int headerId = extras.getShort() & 0xFFFF;
                int length = extras.getShort() & 0xFFFF;
                if (headerId == 1) {
                    if (extras.remaining() >= length) {
                        return length;
                    }
                    return -1;
                }
                extras.position(extras.position() + length);
            }
            return -1;
        }
        catch (BufferUnderflowException bue) {
            return -1;
        }
        catch (IllegalArgumentException iae) {
            return -1;
        }
    }

    public static void refreshZip64ExtendedInfo(ZipEntry ze) {
        if (ze.extra == null) {
            throw new IllegalStateException("Zip64 entry has no available extras: " + ze);
        }
        ByteBuffer buf = ByteBuffer.wrap(ze.extra).order(ByteOrder.LITTLE_ENDIAN);
        int extendedInfoSize = Zip64.getZip64ExtendedInfoSize(buf);
        if (extendedInfoSize == -1) {
            throw new IllegalStateException("Zip64 entry extras has no zip64 extended info record: " + ze);
        }
        try {
            buf.putLong(ze.size);
            buf.putLong(ze.compressedSize);
            buf.putLong(ze.localHeaderRelOffset);
        }
        catch (BufferOverflowException boe) {
            throw new IllegalStateException("Invalid extended info extra", boe);
        }
    }

    public static void writeZip64EocdRecordAndLocator(ByteArrayOutputStream baos, long numEntries, long offset, long cDirSize) throws IOException {
        ZipOutputStream.writeLongAsUint32(baos, 101075792L);
        ZipOutputStream.writeLongAsUint64(baos, 44L);
        ZipOutputStream.writeIntAsUint16(baos, 20);
        ZipOutputStream.writeIntAsUint16(baos, 20);
        ZipOutputStream.writeLongAsUint32(baos, 0L);
        ZipOutputStream.writeLongAsUint32(baos, 0L);
        ZipOutputStream.writeLongAsUint64(baos, numEntries);
        ZipOutputStream.writeLongAsUint64(baos, numEntries);
        ZipOutputStream.writeLongAsUint64(baos, cDirSize);
        ZipOutputStream.writeLongAsUint64(baos, offset);
        ZipOutputStream.writeLongAsUint32(baos, 117853008L);
        ZipOutputStream.writeLongAsUint32(baos, 0L);
        ZipOutputStream.writeLongAsUint64(baos, offset + cDirSize);
        ZipOutputStream.writeLongAsUint32(baos, 1L);
    }
}

