/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Zip64;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import libcore.util.CountingOutputStream;
import libcore.util.EmptyArray;

public class ZipOutputStream
extends DeflaterOutputStream
implements ZipConstants {
    public static final int DEFLATED = 8;
    public static final int STORED = 0;
    private static final int ZIP_VERSION_2_0 = 20;
    private byte[] commentBytes = EmptyArray.BYTE;
    private final HashSet<String> entries = new HashSet();
    private int defaultCompressionMethod = 8;
    private int compressionLevel = -1;
    private ByteArrayOutputStream cDir = new ByteArrayOutputStream();
    private ZipEntry currentEntry;
    private final CRC32 crc = new CRC32();
    private long offset = 0L;
    private byte[] nameBytes;
    private byte[] entryCommentBytes;
    private static final byte[] ZIP64_PLACEHOLDER_BYTES = new byte[]{-1, -1, -1, -1};
    private boolean archiveNeedsZip64EocdRecord;
    private boolean currentEntryNeedsZip64;
    private final boolean forceZip64;

    public ZipOutputStream(OutputStream os) {
        this(os, false);
    }

    public ZipOutputStream(OutputStream os, boolean forceZip64) {
        super((OutputStream)new CountingOutputStream(os), new Deflater(-1, true));
        this.forceZip64 = forceZip64;
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            this.finish();
            this.def.end();
            this.out.close();
            this.out = null;
        }
    }

    public void closeEntry() throws IOException {
        this.checkOpen();
        if (this.currentEntry == null) {
            return;
        }
        if (this.currentEntry.getMethod() == 8) {
            super.finish();
        }
        if (this.currentEntry.getMethod() == 0) {
            if (this.crc.getValue() != this.currentEntry.crc) {
                throw new ZipException("CRC mismatch");
            }
            if (this.currentEntry.size != this.crc.tbytes) {
                throw new ZipException("Size mismatch");
            }
        }
        long curOffset = 30L;
        if (this.currentEntry.getMethod() != 0) {
            curOffset += 16L;
            ZipOutputStream.writeLongAsUint32(this.out, 134695760L);
            this.currentEntry.crc = this.crc.getValue();
            ZipOutputStream.writeLongAsUint32(this.out, this.currentEntry.crc);
            this.currentEntry.compressedSize = this.def.getBytesWritten();
            this.currentEntry.size = this.def.getBytesRead();
            if (this.currentEntryNeedsZip64) {
                curOffset += 8L;
                ZipOutputStream.writeLongAsUint64(this.out, this.currentEntry.compressedSize);
                ZipOutputStream.writeLongAsUint64(this.out, this.currentEntry.size);
            } else {
                ZipOutputStream.writeLongAsUint32(this.out, this.currentEntry.compressedSize);
                ZipOutputStream.writeLongAsUint32(this.out, this.currentEntry.size);
            }
        }
        int flags = this.currentEntry.getMethod() == 0 ? 0 : 8;
        flags |= 0x800;
        ZipOutputStream.writeLongAsUint32(this.cDir, 33639248L);
        ZipOutputStream.writeIntAsUint16(this.cDir, 20);
        ZipOutputStream.writeIntAsUint16(this.cDir, 20);
        ZipOutputStream.writeIntAsUint16(this.cDir, flags);
        ZipOutputStream.writeIntAsUint16(this.cDir, this.currentEntry.getMethod());
        ZipOutputStream.writeIntAsUint16(this.cDir, this.currentEntry.time);
        ZipOutputStream.writeIntAsUint16(this.cDir, this.currentEntry.modDate);
        ZipOutputStream.writeLongAsUint32(this.cDir, this.crc.getValue());
        if (this.currentEntry.getMethod() == 8) {
            this.currentEntry.setCompressedSize(this.def.getBytesWritten());
            this.currentEntry.setSize(this.def.getBytesRead());
            curOffset += this.currentEntry.getCompressedSize();
        } else {
            this.currentEntry.setCompressedSize(this.crc.tbytes);
            this.currentEntry.setSize(this.crc.tbytes);
            curOffset += this.currentEntry.getSize();
        }
        if (this.currentEntryNeedsZip64) {
            Zip64.refreshZip64ExtendedInfo(this.currentEntry);
            ZipOutputStream.writeLongAsUint32(this.cDir, 0xFFFFFFFFL);
            ZipOutputStream.writeLongAsUint32(this.cDir, 0xFFFFFFFFL);
        } else {
            ZipOutputStream.writeLongAsUint32(this.cDir, this.currentEntry.getCompressedSize());
            ZipOutputStream.writeLongAsUint32(this.cDir, this.currentEntry.getSize());
        }
        curOffset += (long)ZipOutputStream.writeIntAsUint16(this.cDir, this.nameBytes.length);
        if (this.currentEntry.extra != null) {
            curOffset += (long)ZipOutputStream.writeIntAsUint16(this.cDir, this.currentEntry.extra.length);
        } else {
            ZipOutputStream.writeIntAsUint16(this.cDir, 0);
        }
        ZipOutputStream.writeIntAsUint16(this.cDir, this.entryCommentBytes.length);
        ZipOutputStream.writeIntAsUint16(this.cDir, 0);
        ZipOutputStream.writeIntAsUint16(this.cDir, 0);
        ZipOutputStream.writeLongAsUint32(this.cDir, 0L);
        if (this.currentEntryNeedsZip64) {
            ZipOutputStream.writeLongAsUint32(this.cDir, 0xFFFFFFFFL);
        } else {
            ZipOutputStream.writeLongAsUint32(this.cDir, this.currentEntry.localHeaderRelOffset);
        }
        this.cDir.write(this.nameBytes);
        this.nameBytes = null;
        if (this.currentEntry.extra != null) {
            this.cDir.write(this.currentEntry.extra);
        }
        this.offset += curOffset;
        if (this.entryCommentBytes.length > 0) {
            this.cDir.write(this.entryCommentBytes);
            this.entryCommentBytes = EmptyArray.BYTE;
        }
        this.currentEntry = null;
        this.crc.reset();
        this.def.reset();
        this.done = false;
    }

    @Override
    public void finish() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream is closed");
        }
        if (this.cDir == null) {
            return;
        }
        if (this.entries.isEmpty()) {
            throw new ZipException("No entries");
        }
        if (this.currentEntry != null) {
            this.closeEntry();
        }
        int cdirEntriesSize = this.cDir.size();
        if (this.archiveNeedsZip64EocdRecord) {
            Zip64.writeZip64EocdRecordAndLocator(this.cDir, this.entries.size(), this.offset, cdirEntriesSize);
        }
        ZipOutputStream.writeLongAsUint32(this.cDir, 101010256L);
        ZipOutputStream.writeIntAsUint16(this.cDir, 0);
        ZipOutputStream.writeIntAsUint16(this.cDir, 0);
        if (this.archiveNeedsZip64EocdRecord) {
            ZipOutputStream.writeIntAsUint16(this.cDir, 65535);
            ZipOutputStream.writeIntAsUint16(this.cDir, 65535);
            ZipOutputStream.writeLongAsUint32(this.cDir, -1L);
            ZipOutputStream.writeLongAsUint32(this.cDir, -1L);
        } else {
            ZipOutputStream.writeIntAsUint16(this.cDir, this.entries.size());
            ZipOutputStream.writeIntAsUint16(this.cDir, this.entries.size());
            ZipOutputStream.writeLongAsUint32(this.cDir, cdirEntriesSize);
            ZipOutputStream.writeLongAsUint32(this.cDir, this.offset);
        }
        ZipOutputStream.writeIntAsUint16(this.cDir, this.commentBytes.length);
        if (this.commentBytes.length > 0) {
            this.cDir.write(this.commentBytes);
        }
        this.cDir.writeTo(this.out);
        this.cDir = null;
    }

    public void putNextEntry(ZipEntry ze) throws IOException {
        int method;
        if (this.currentEntry != null) {
            this.closeEntry();
        }
        if ((method = ze.getMethod()) == -1) {
            method = this.defaultCompressionMethod;
        }
        if (method == 0) {
            if (ze.getCompressedSize() == -1L) {
                ze.setCompressedSize(ze.getSize());
            } else if (ze.getSize() == -1L) {
                ze.setSize(ze.getCompressedSize());
            }
            if (ze.getCrc() == -1L) {
                throw new ZipException("STORED entry missing CRC");
            }
            if (ze.getSize() == -1L) {
                throw new ZipException("STORED entry missing size");
            }
            if (ze.size != ze.compressedSize) {
                throw new ZipException("STORED entry size/compressed size mismatch");
            }
        }
        this.checkOpen();
        this.checkAndSetZip64Requirements(ze);
        this.nameBytes = ze.name.getBytes(StandardCharsets.UTF_8);
        this.checkSizeIsWithinShort("Name", this.nameBytes);
        this.entryCommentBytes = EmptyArray.BYTE;
        if (ze.comment != null) {
            this.entryCommentBytes = ze.comment.getBytes(StandardCharsets.UTF_8);
            this.checkSizeIsWithinShort("Comment", this.entryCommentBytes);
        }
        this.def.setLevel(this.compressionLevel);
        ze.setMethod(method);
        this.currentEntry = ze;
        this.currentEntry.localHeaderRelOffset = this.offset;
        this.entries.add(this.currentEntry.name);
        int flags = method == 0 ? 0 : 8;
        ZipOutputStream.writeLongAsUint32(this.out, 67324752L);
        ZipOutputStream.writeIntAsUint16(this.out, 20);
        ZipOutputStream.writeIntAsUint16(this.out, flags |= 0x800);
        ZipOutputStream.writeIntAsUint16(this.out, method);
        if (this.currentEntry.getTime() == -1L) {
            this.currentEntry.setTime(System.currentTimeMillis());
        }
        ZipOutputStream.writeIntAsUint16(this.out, this.currentEntry.time);
        ZipOutputStream.writeIntAsUint16(this.out, this.currentEntry.modDate);
        if (method == 0) {
            ZipOutputStream.writeLongAsUint32(this.out, this.currentEntry.crc);
            if (this.currentEntryNeedsZip64) {
                this.out.write(ZIP64_PLACEHOLDER_BYTES);
                this.out.write(ZIP64_PLACEHOLDER_BYTES);
            } else {
                ZipOutputStream.writeLongAsUint32(this.out, this.currentEntry.size);
                ZipOutputStream.writeLongAsUint32(this.out, this.currentEntry.size);
            }
        } else {
            ZipOutputStream.writeLongAsUint32(this.out, 0L);
            ZipOutputStream.writeLongAsUint32(this.out, 0L);
            ZipOutputStream.writeLongAsUint32(this.out, 0L);
        }
        ZipOutputStream.writeIntAsUint16(this.out, this.nameBytes.length);
        if (this.currentEntryNeedsZip64) {
            Zip64.insertZip64ExtendedInfoToExtras(this.currentEntry);
        }
        if (this.currentEntry.extra != null) {
            ZipOutputStream.writeIntAsUint16(this.out, this.currentEntry.extra.length);
        } else {
            ZipOutputStream.writeIntAsUint16(this.out, 0);
        }
        this.out.write(this.nameBytes);
        if (this.currentEntry.extra != null) {
            this.out.write(this.currentEntry.extra);
        }
    }

    private void checkAndSetZip64Requirements(ZipEntry entry) {
        long totalBytesWritten = this.getBytesWritten();
        long entriesWritten = this.entries.size();
        this.currentEntryNeedsZip64 = false;
        if (this.forceZip64) {
            this.currentEntryNeedsZip64 = true;
            this.archiveNeedsZip64EocdRecord = true;
            return;
        }
        if (entriesWritten == 65535L) {
            this.archiveNeedsZip64EocdRecord = true;
        }
        if (totalBytesWritten > 0xFFFFFFFFL || entry.getSize() > 0xFFFFFFFFL) {
            this.currentEntryNeedsZip64 = true;
            this.archiveNeedsZip64EocdRecord = true;
        }
    }

    public void setComment(String comment) {
        if (comment == null) {
            this.commentBytes = EmptyArray.BYTE;
            return;
        }
        byte[] newCommentBytes = comment.getBytes(StandardCharsets.UTF_8);
        this.checkSizeIsWithinShort("Comment", newCommentBytes);
        this.commentBytes = newCommentBytes;
    }

    public void setLevel(int level) {
        if (level < -1 || level > 9) {
            throw new IllegalArgumentException("Bad level: " + level);
        }
        this.compressionLevel = level;
    }

    public void setMethod(int method) {
        if (method != 0 && method != 8) {
            throw new IllegalArgumentException("Bad method: " + method);
        }
        this.defaultCompressionMethod = method;
    }

    static long writeLongAsUint32(OutputStream os, long i) throws IOException {
        os.write((int)(i & 0xFFL));
        os.write((int)(i >> 8) & 0xFF);
        os.write((int)(i >> 16) & 0xFF);
        os.write((int)(i >> 24) & 0xFF);
        return i;
    }

    static long writeLongAsUint64(OutputStream os, long i) throws IOException {
        int i1 = (int)i;
        os.write(i1 & 0xFF);
        os.write(i1 >> 8 & 0xFF);
        os.write(i1 >> 16 & 0xFF);
        os.write(i1 >> 24 & 0xFF);
        int i2 = (int)(i >> 32);
        os.write(i2 & 0xFF);
        os.write(i2 >> 8 & 0xFF);
        os.write(i2 >> 16 & 0xFF);
        os.write(i2 >> 24 & 0xFF);
        return i;
    }

    static int writeIntAsUint16(OutputStream os, int i) throws IOException {
        os.write(i & 0xFF);
        os.write(i >> 8 & 0xFF);
        return i;
    }

    @Override
    public void write(byte[] buffer, int offset, int byteCount) throws IOException {
        Arrays.checkOffsetAndCount(buffer.length, offset, byteCount);
        if (this.currentEntry == null) {
            throw new ZipException("No active entry");
        }
        long totalBytes = this.crc.tbytes + (long)byteCount;
        if (totalBytes > 0xFFFFFFFFL && !this.currentEntryNeedsZip64) {
            throw new IOException("Zip entry size (" + totalBytes + " bytes) cannot be represented in the zip format (needs Zip64)." + " Set the entry length using ZipEntry#setLength to use Zip64 where necessary.");
        }
        if (this.currentEntry.getMethod() == 0) {
            this.out.write(buffer, offset, byteCount);
        } else {
            super.write(buffer, offset, byteCount);
        }
        this.crc.update(buffer, offset, byteCount);
    }

    private void checkOpen() throws IOException {
        if (this.cDir == null) {
            throw new IOException("Stream is closed");
        }
    }

    private void checkSizeIsWithinShort(String property, byte[] bytes) {
        if (bytes.length > 65535) {
            throw new IllegalArgumentException(property + " too long in UTF-8:" + bytes.length + " bytes");
        }
    }

    private long getBytesWritten() {
        return ((CountingOutputStream)this.out).getCount();
    }
}

