/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import org.apache.harmony.security.fortress.Engine;

public class KeyAgreement {
    private static final String SERVICE = "KeyAgreement";
    private static final Engine ENGINE = new Engine("KeyAgreement");
    private static final SecureRandom RANDOM = new SecureRandom();
    private Provider provider;
    private final Provider specifiedProvider;
    private KeyAgreementSpi spiImpl;
    private final String algorithm;
    private final Object initLock = new Object();

    protected KeyAgreement(KeyAgreementSpi keyAgreeSpi, Provider provider, String algorithm) {
        this.spiImpl = keyAgreeSpi;
        this.specifiedProvider = provider;
        this.algorithm = algorithm;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final Provider getProvider() {
        this.getSpi();
        return this.provider;
    }

    public static final KeyAgreement getInstance(String algorithm) throws NoSuchAlgorithmException {
        return KeyAgreement.getKeyAgreement(algorithm, null);
    }

    public static final KeyAgreement getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (provider == null || provider.isEmpty()) {
            throw new IllegalArgumentException("Provider is null or empty");
        }
        Provider impProvider = Security.getProvider(provider);
        if (impProvider == null) {
            throw new NoSuchProviderException(provider);
        }
        return KeyAgreement.getKeyAgreement(algorithm, impProvider);
    }

    public static final KeyAgreement getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("provider == null");
        }
        return KeyAgreement.getKeyAgreement(algorithm, provider);
    }

    private static KeyAgreement getKeyAgreement(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        boolean providerSupportsAlgorithm;
        if (algorithm == null) {
            throw new NullPointerException("algorithm == null");
        }
        try {
            providerSupportsAlgorithm = KeyAgreement.tryAlgorithm(null, provider, algorithm) != null;
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException("InvalidKeyException thrown when key == null", e);
        }
        if (!providerSupportsAlgorithm) {
            if (provider == null) {
                throw new NoSuchAlgorithmException("No provider found for " + algorithm);
            }
            throw new NoSuchAlgorithmException("Provider " + provider.getName() + " does not provide " + algorithm);
        }
        return new KeyAgreement(null, provider, algorithm);
    }

    private static Engine.SpiAndProvider tryAlgorithm(Key key, Provider provider, String algorithm) throws InvalidKeyException {
        if (provider != null) {
            Provider.Service service = provider.getService(SERVICE, algorithm);
            if (service == null) {
                return null;
            }
            return KeyAgreement.tryAlgorithmWithProvider(service);
        }
        ArrayList<Provider.Service> services = ENGINE.getServices(algorithm);
        if (services == null || services.isEmpty()) {
            return null;
        }
        boolean keySupported = false;
        for (Provider.Service service : services) {
            if (key != null && !service.supportsParameter(key)) continue;
            keySupported = true;
            Engine.SpiAndProvider sap = KeyAgreement.tryAlgorithmWithProvider(service);
            if (sap == null) continue;
            return sap;
        }
        if (!keySupported) {
            throw new InvalidKeyException("No provider supports the provided key");
        }
        return null;
    }

    private static Engine.SpiAndProvider tryAlgorithmWithProvider(Provider.Service service) {
        try {
            Engine.SpiAndProvider sap = ENGINE.getInstance(service, null);
            if (sap.spi == null || sap.provider == null) {
                return null;
            }
            if (!(sap.spi instanceof KeyAgreementSpi)) {
                return null;
            }
            return sap;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyAgreementSpi getSpi(Key key) throws InvalidKeyException {
        Object object = this.initLock;
        synchronized (object) {
            if (this.spiImpl != null && key == null) {
                return this.spiImpl;
            }
            Engine.SpiAndProvider sap = KeyAgreement.tryAlgorithm(key, this.specifiedProvider, this.algorithm);
            if (sap == null) {
                throw new ProviderException("No provider for " + this.getAlgorithm());
            }
            this.spiImpl = (KeyAgreementSpi)sap.spi;
            this.provider = sap.provider;
            return this.spiImpl;
        }
    }

    private KeyAgreementSpi getSpi() {
        try {
            return this.getSpi(null);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException("InvalidKeyException thrown when key == null", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyAgreementSpi getCurrentSpi() {
        Object object = this.initLock;
        synchronized (object) {
            return this.spiImpl;
        }
    }

    public final void init(Key key) throws InvalidKeyException {
        this.getSpi(key).engineInit(key, RANDOM);
    }

    public final void init(Key key, SecureRandom random) throws InvalidKeyException {
        this.getSpi(key).engineInit(key, random);
    }

    public final void init(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.getSpi(key).engineInit(key, params, RANDOM);
    }

    public final void init(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.getSpi(key).engineInit(key, params, random);
    }

    public final Key doPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        return this.getSpi().engineDoPhase(key, lastPhase);
    }

    public final byte[] generateSecret() throws IllegalStateException {
        return this.getSpi().engineGenerateSecret();
    }

    public final int generateSecret(byte[] sharedSecret, int offset) throws IllegalStateException, ShortBufferException {
        return this.getSpi().engineGenerateSecret(sharedSecret, offset);
    }

    public final SecretKey generateSecret(String algorithm) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        return this.getSpi().engineGenerateSecret(algorithm);
    }
}

