/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.ProviderException;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import javax.crypto.MacSpi;
import javax.crypto.ShortBufferException;
import org.apache.harmony.security.fortress.Engine;

public class Mac
implements Cloneable {
    private static final String SERVICE = "Mac";
    private static final Engine ENGINE = new Engine("Mac");
    private Provider provider;
    private final Provider specifiedProvider;
    private MacSpi spiImpl;
    private final String algorithm;
    private final Object initLock = new Object();
    private boolean isInitMac;

    protected Mac(MacSpi macSpi, Provider provider, String algorithm) {
        this.specifiedProvider = provider;
        this.algorithm = algorithm;
        this.spiImpl = macSpi;
        this.isInitMac = false;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final Provider getProvider() {
        this.getSpi();
        return this.provider;
    }

    public static final Mac getInstance(String algorithm) throws NoSuchAlgorithmException {
        return Mac.getMac(algorithm, null);
    }

    public static final Mac getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (provider == null || provider.isEmpty()) {
            throw new IllegalArgumentException("Provider is null or empty");
        }
        Provider impProvider = Security.getProvider(provider);
        if (impProvider == null) {
            throw new NoSuchProviderException(provider);
        }
        return Mac.getMac(algorithm, impProvider);
    }

    public static final Mac getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("provider == null");
        }
        return Mac.getMac(algorithm, provider);
    }

    private static Mac getMac(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        boolean providerSupportsAlgorithm;
        if (algorithm == null) {
            throw new NullPointerException("algorithm == null");
        }
        try {
            providerSupportsAlgorithm = Mac.tryAlgorithm(null, provider, algorithm) != null;
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException("InvalidKeyException thrown when key == null", e);
        }
        if (!providerSupportsAlgorithm) {
            if (provider == null) {
                throw new NoSuchAlgorithmException("No provider found for " + algorithm);
            }
            throw new NoSuchAlgorithmException("Provider " + provider.getName() + " does not provide " + algorithm);
        }
        return new Mac(null, provider, algorithm);
    }

    private static Engine.SpiAndProvider tryAlgorithm(Key key, Provider provider, String algorithm) throws InvalidKeyException {
        if (provider != null) {
            Provider.Service service = provider.getService(SERVICE, algorithm);
            if (service == null) {
                return null;
            }
            return Mac.tryAlgorithmWithProvider(service);
        }
        ArrayList<Provider.Service> services = ENGINE.getServices(algorithm);
        if (services == null || services.isEmpty()) {
            return null;
        }
        boolean keySupported = false;
        for (Provider.Service service : services) {
            if (key != null && !service.supportsParameter(key)) continue;
            keySupported = true;
            Engine.SpiAndProvider sap = Mac.tryAlgorithmWithProvider(service);
            if (sap == null) continue;
            return sap;
        }
        if (!keySupported) {
            throw new InvalidKeyException("No provider supports the provided key");
        }
        return null;
    }

    private static Engine.SpiAndProvider tryAlgorithmWithProvider(Provider.Service service) {
        try {
            Engine.SpiAndProvider sap = ENGINE.getInstance(service, null);
            if (sap.spi == null || sap.provider == null) {
                return null;
            }
            if (!(sap.spi instanceof MacSpi)) {
                return null;
            }
            return sap;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MacSpi getSpi(Key key) throws InvalidKeyException {
        Object object = this.initLock;
        synchronized (object) {
            if (this.spiImpl != null && this.provider != null && key == null) {
                return this.spiImpl;
            }
            if (this.algorithm == null) {
                return null;
            }
            Engine.SpiAndProvider sap = Mac.tryAlgorithm(key, this.specifiedProvider, this.algorithm);
            if (sap == null) {
                throw new ProviderException("No provider for " + this.getAlgorithm());
            }
            if (this.spiImpl == null || this.provider != null) {
                this.spiImpl = (MacSpi)sap.spi;
            }
            this.provider = sap.provider;
            return this.spiImpl;
        }
    }

    private MacSpi getSpi() {
        try {
            return this.getSpi(null);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException("InvalidKeyException thrown when key == null", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MacSpi getCurrentSpi() {
        Object object = this.initLock;
        synchronized (object) {
            return this.spiImpl;
        }
    }

    public final int getMacLength() {
        return this.getSpi().engineGetMacLength();
    }

    public final void init(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (key == null) {
            throw new InvalidKeyException("key == null");
        }
        this.getSpi(key).engineInit(key, params);
        this.isInitMac = true;
    }

    public final void init(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("key == null");
        }
        try {
            this.getSpi(key).engineInit(key, null);
            this.isInitMac = true;
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException(e);
        }
    }

    public final void update(byte input) throws IllegalStateException {
        if (!this.isInitMac) {
            throw new IllegalStateException();
        }
        this.getSpi().engineUpdate(input);
    }

    public final void update(byte[] input, int offset, int len) throws IllegalStateException {
        if (!this.isInitMac) {
            throw new IllegalStateException();
        }
        if (input == null) {
            return;
        }
        if (offset < 0 || len < 0 || offset + len > input.length) {
            throw new IllegalArgumentException("Incorrect arguments. input.length=" + input.length + " offset=" + offset + ", len=" + len);
        }
        this.getSpi().engineUpdate(input, offset, len);
    }

    public final void update(byte[] input) throws IllegalStateException {
        if (!this.isInitMac) {
            throw new IllegalStateException();
        }
        if (input != null) {
            this.getSpi().engineUpdate(input, 0, input.length);
        }
    }

    public final void update(ByteBuffer input) {
        if (!this.isInitMac) {
            throw new IllegalStateException();
        }
        if (input == null) {
            throw new IllegalArgumentException("input == null");
        }
        this.getSpi().engineUpdate(input);
    }

    public final byte[] doFinal() throws IllegalStateException {
        if (!this.isInitMac) {
            throw new IllegalStateException();
        }
        return this.getSpi().engineDoFinal();
    }

    public final void doFinal(byte[] output, int outOffset) throws ShortBufferException, IllegalStateException {
        if (!this.isInitMac) {
            throw new IllegalStateException();
        }
        if (output == null) {
            throw new ShortBufferException("output == null");
        }
        if (outOffset < 0 || outOffset >= output.length) {
            throw new ShortBufferException("Incorrect outOffset: " + outOffset);
        }
        MacSpi spi = this.getSpi();
        int t = spi.engineGetMacLength();
        if (t > output.length - outOffset) {
            throw new ShortBufferException("Output buffer is short. Needed " + t + " bytes.");
        }
        byte[] result = spi.engineDoFinal();
        System.arraycopy((byte[])result, (int)0, (byte[])output, (int)outOffset, (int)result.length);
    }

    public final byte[] doFinal(byte[] input) throws IllegalStateException {
        if (!this.isInitMac) {
            throw new IllegalStateException();
        }
        MacSpi spi = this.getSpi();
        if (input != null) {
            spi.engineUpdate(input, 0, input.length);
        }
        return spi.engineDoFinal();
    }

    public final void reset() {
        this.getSpi().engineReset();
    }

    public final Object clone() throws CloneNotSupportedException {
        MacSpi newSpiImpl = null;
        MacSpi spi = this.getSpi();
        if (spi != null) {
            newSpiImpl = (MacSpi)spi.clone();
        }
        Mac mac = new Mac(newSpiImpl, this.provider, this.algorithm);
        mac.isInitMac = this.isInitMac;
        return mac;
    }
}

