/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import libcore.io.IoUtils;

public class SealedObject
implements Serializable {
    private static final long serialVersionUID = 4482838265551344752L;
    protected byte[] encodedParams;
    private byte[] encryptedContent;
    private String sealAlg;
    private String paramsAlg;

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = s.readFields();
        this.encodedParams = SealedObject.getSafeCopy(fields, "encodedParams");
        this.encryptedContent = SealedObject.getSafeCopy(fields, "encryptedContent");
        this.paramsAlg = (String)fields.get("paramsAlg", null);
        this.sealAlg = (String)fields.get("sealAlg", null);
    }

    private static byte[] getSafeCopy(ObjectInputStream.GetField fields, String fieldName) throws IOException {
        byte[] fieldValue = (byte[])fields.get(fieldName, null);
        return fieldValue != null ? (byte[])fieldValue.clone() : null;
    }

    public SealedObject(Serializable object, Cipher c) throws IOException, IllegalBlockSizeException {
        if (c == null) {
            throw new NullPointerException("c == null");
        }
        ObjectOutputStream oos = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(object);
            oos.flush();
            AlgorithmParameters ap = c.getParameters();
            this.encodedParams = ap == null ? null : ap.getEncoded();
            this.paramsAlg = ap == null ? null : ap.getAlgorithm();
            this.sealAlg = c.getAlgorithm();
            this.encryptedContent = c.doFinal(bos.toByteArray());
        }
        catch (BadPaddingException e) {
            try {
                throw new IOException(e.toString());
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(oos);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(oos);
    }

    protected SealedObject(SealedObject so) {
        if (so == null) {
            throw new NullPointerException("so == null");
        }
        this.encryptedContent = so.encryptedContent != null ? (byte[])so.encryptedContent.clone() : null;
        this.encodedParams = so.encodedParams != null ? (byte[])so.encodedParams.clone() : null;
        this.sealAlg = so.sealAlg;
        this.paramsAlg = so.paramsAlg;
    }

    public final String getAlgorithm() {
        return this.sealAlg;
    }

    public final Object getObject(Key key) throws IOException, ClassNotFoundException, NoSuchAlgorithmException, InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("key == null");
        }
        try {
            Cipher cipher = Cipher.getInstance(this.sealAlg);
            if (this.paramsAlg != null && this.paramsAlg.length() != 0) {
                AlgorithmParameters params = AlgorithmParameters.getInstance(this.paramsAlg);
                params.init(this.encodedParams);
                cipher.init(2, key, params);
            } else {
                cipher.init(2, key);
            }
            byte[] serialized = cipher.doFinal(this.encryptedContent);
            return SealedObject.readSerialized(serialized);
        }
        catch (NoSuchPaddingException e) {
            throw new NoSuchAlgorithmException(e.toString());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new NoSuchAlgorithmException(e.toString());
        }
        catch (IllegalBlockSizeException e) {
            throw new NoSuchAlgorithmException(e.toString());
        }
        catch (BadPaddingException e) {
            throw new NoSuchAlgorithmException(e.toString());
        }
        catch (IllegalStateException e) {
            throw new NoSuchAlgorithmException(e.toString());
        }
    }

    public final Object getObject(Cipher c) throws IOException, ClassNotFoundException, IllegalBlockSizeException, BadPaddingException {
        if (c == null) {
            throw new NullPointerException("c == null");
        }
        byte[] serialized = c.doFinal(this.encryptedContent);
        return SealedObject.readSerialized(serialized);
    }

    public final Object getObject(Key key, String provider) throws IOException, ClassNotFoundException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        if (provider == null || provider.isEmpty()) {
            throw new IllegalArgumentException("provider name empty or null");
        }
        try {
            Cipher cipher = Cipher.getInstance(this.sealAlg, provider);
            if (this.paramsAlg != null && this.paramsAlg.length() != 0) {
                AlgorithmParameters params = AlgorithmParameters.getInstance(this.paramsAlg);
                params.init(this.encodedParams);
                cipher.init(2, key, params);
            } else {
                cipher.init(2, key);
            }
            byte[] serialized = cipher.doFinal(this.encryptedContent);
            return SealedObject.readSerialized(serialized);
        }
        catch (NoSuchPaddingException e) {
            throw new NoSuchAlgorithmException(e.toString());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new NoSuchAlgorithmException(e.toString());
        }
        catch (IllegalBlockSizeException e) {
            throw new NoSuchAlgorithmException(e.toString());
        }
        catch (BadPaddingException e) {
            throw new NoSuchAlgorithmException(e.toString());
        }
        catch (IllegalStateException e) {
            throw new NoSuchAlgorithmException(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object readSerialized(byte[] serialized) throws IOException, ClassNotFoundException {
        Object object;
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new ByteArrayInputStream(serialized));
            object = ois.readObject();
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(ois);
            throw throwable;
        }
        IoUtils.closeQuietly(ois);
        return object;
    }
}

