/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.io.IOException;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import javax.net.SocketFactory;
import javax.net.ssl.DefaultSSLSocketFactory;
import javax.net.ssl.SSLContext;
import org.apache.harmony.security.fortress.Services;

public abstract class SSLSocketFactory
extends SocketFactory {
    private static SocketFactory defaultSocketFactory;
    private static int lastCacheVersion;

    public static synchronized SocketFactory getDefault() {
        int newCacheVersion = Services.getCacheVersion();
        if (defaultSocketFactory != null && lastCacheVersion == newCacheVersion) {
            return defaultSocketFactory;
        }
        lastCacheVersion = newCacheVersion;
        String newName = Security.getProperty("ssl.SocketFactory.provider");
        if (newName != null) {
            ClassLoader cl;
            if (defaultSocketFactory != null) {
                if (newName.equals(defaultSocketFactory.getClass().getName())) {
                    return defaultSocketFactory;
                }
                defaultSocketFactory = null;
            }
            if ((cl = Thread.currentThread().getContextClassLoader()) == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            try {
                Class<?> sfc = Class.forName(newName, true, cl);
                defaultSocketFactory = (SocketFactory)sfc.newInstance();
            }
            catch (Exception e) {
                System.logW((String)("Could not create " + newName + " with ClassLoader " + cl.toString() + ": " + e.getMessage()));
            }
        } else {
            defaultSocketFactory = null;
        }
        if (defaultSocketFactory == null) {
            SSLContext context;
            try {
                context = SSLContext.getDefault();
            }
            catch (NoSuchAlgorithmException e) {
                context = null;
            }
            if (context != null) {
                defaultSocketFactory = context.getSocketFactory();
            }
        }
        if (defaultSocketFactory == null) {
            defaultSocketFactory = new DefaultSSLSocketFactory("No SSLSocketFactory installed");
        }
        return defaultSocketFactory;
    }

    public abstract String[] getDefaultCipherSuites();

    public abstract String[] getSupportedCipherSuites();

    public abstract Socket createSocket(Socket var1, String var2, int var3, boolean var4) throws IOException;

    static {
        lastCacheVersion = -1;
    }
}

