/*
 * Decompiled with CFR 0.152.
 */
package javax.security.cert;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.Arrays;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.CertificateException;

public abstract class Certificate {
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Certificate)) {
            return false;
        }
        Certificate object = (Certificate)obj;
        try {
            return Arrays.equals(this.getEncoded(), object.getEncoded());
        }
        catch (CertificateEncodingException e) {
            return false;
        }
    }

    public int hashCode() {
        int res = 0;
        try {
            byte[] array2 = this.getEncoded();
            for (int i = 0; i < array2.length; ++i) {
                res += array2[i];
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            // empty catch block
        }
        return res;
    }

    public abstract byte[] getEncoded() throws CertificateEncodingException;

    public abstract void verify(PublicKey var1) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract void verify(PublicKey var1, String var2) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract String toString();

    public abstract PublicKey getPublicKey();
}

