/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import android.system.ErrnoException;
import android.system.GaiException;
import android.system.StructAddrinfo;
import android.system.StructFlock;
import android.system.StructGroupReq;
import android.system.StructGroupSourceReq;
import android.system.StructLinger;
import android.system.StructPasswd;
import android.system.StructPollfd;
import android.system.StructStat;
import android.system.StructStatVfs;
import android.system.StructTimeval;
import android.system.StructUcred;
import android.system.StructUtsname;
import android.util.MutableInt;
import android.util.MutableLong;
import java.io.FileDescriptor;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.NioUtils;
import libcore.io.Os;

public final class Posix
implements Os {
    Posix() {
    }

    @Override
    public native FileDescriptor accept(FileDescriptor var1, InetSocketAddress var2) throws ErrnoException, SocketException;

    @Override
    public native boolean access(String var1, int var2) throws ErrnoException;

    @Override
    public native InetAddress[] android_getaddrinfo(String var1, StructAddrinfo var2, int var3) throws GaiException;

    @Override
    public native void bind(FileDescriptor var1, InetAddress var2, int var3) throws ErrnoException, SocketException;

    @Override
    public native void bind(FileDescriptor var1, SocketAddress var2) throws ErrnoException, SocketException;

    @Override
    public native void chmod(String var1, int var2) throws ErrnoException;

    @Override
    public native void chown(String var1, int var2, int var3) throws ErrnoException;

    @Override
    public native void close(FileDescriptor var1) throws ErrnoException;

    @Override
    public native void connect(FileDescriptor var1, InetAddress var2, int var3) throws ErrnoException, SocketException;

    @Override
    public native void connect(FileDescriptor var1, SocketAddress var2) throws ErrnoException, SocketException;

    @Override
    public native FileDescriptor dup(FileDescriptor var1) throws ErrnoException;

    @Override
    public native FileDescriptor dup2(FileDescriptor var1, int var2) throws ErrnoException;

    @Override
    public native String[] environ();

    @Override
    public native void execv(String var1, String[] var2) throws ErrnoException;

    @Override
    public native void execve(String var1, String[] var2, String[] var3) throws ErrnoException;

    @Override
    public native void fchmod(FileDescriptor var1, int var2) throws ErrnoException;

    @Override
    public native void fchown(FileDescriptor var1, int var2, int var3) throws ErrnoException;

    @Override
    public native int fcntlFlock(FileDescriptor var1, int var2, StructFlock var3) throws ErrnoException, InterruptedIOException;

    @Override
    public native int fcntlInt(FileDescriptor var1, int var2, int var3) throws ErrnoException;

    @Override
    public native int fcntlVoid(FileDescriptor var1, int var2) throws ErrnoException;

    @Override
    public native void fdatasync(FileDescriptor var1) throws ErrnoException;

    @Override
    public native StructStat fstat(FileDescriptor var1) throws ErrnoException;

    @Override
    public native StructStatVfs fstatvfs(FileDescriptor var1) throws ErrnoException;

    @Override
    public native void fsync(FileDescriptor var1) throws ErrnoException;

    @Override
    public native void ftruncate(FileDescriptor var1, long var2) throws ErrnoException;

    @Override
    public native String gai_strerror(int var1);

    @Override
    public native int getegid();

    @Override
    public native int geteuid();

    @Override
    public native int getgid();

    @Override
    public native String getenv(String var1);

    @Override
    public native String getnameinfo(InetAddress var1, int var2) throws GaiException;

    @Override
    public native SocketAddress getpeername(FileDescriptor var1) throws ErrnoException;

    @Override
    public native int getpgid(int var1);

    @Override
    public native int getpid();

    @Override
    public native int getppid();

    @Override
    public native StructPasswd getpwnam(String var1) throws ErrnoException;

    @Override
    public native StructPasswd getpwuid(int var1) throws ErrnoException;

    @Override
    public native SocketAddress getsockname(FileDescriptor var1) throws ErrnoException;

    @Override
    public native int getsockoptByte(FileDescriptor var1, int var2, int var3) throws ErrnoException;

    @Override
    public native InetAddress getsockoptInAddr(FileDescriptor var1, int var2, int var3) throws ErrnoException;

    @Override
    public native int getsockoptInt(FileDescriptor var1, int var2, int var3) throws ErrnoException;

    @Override
    public native StructLinger getsockoptLinger(FileDescriptor var1, int var2, int var3) throws ErrnoException;

    @Override
    public native StructTimeval getsockoptTimeval(FileDescriptor var1, int var2, int var3) throws ErrnoException;

    @Override
    public native StructUcred getsockoptUcred(FileDescriptor var1, int var2, int var3) throws ErrnoException;

    @Override
    public native int gettid();

    @Override
    public native int getuid();

    @Override
    public native int getxattr(String var1, String var2, byte[] var3) throws ErrnoException;

    @Override
    public native String if_indextoname(int var1);

    @Override
    public native InetAddress inet_pton(int var1, String var2);

    @Override
    public native InetAddress ioctlInetAddress(FileDescriptor var1, int var2, String var3) throws ErrnoException;

    @Override
    public native int ioctlInt(FileDescriptor var1, int var2, MutableInt var3) throws ErrnoException;

    @Override
    public native boolean isatty(FileDescriptor var1);

    @Override
    public native void kill(int var1, int var2) throws ErrnoException;

    @Override
    public native void lchown(String var1, int var2, int var3) throws ErrnoException;

    @Override
    public native void link(String var1, String var2) throws ErrnoException;

    @Override
    public native void listen(FileDescriptor var1, int var2) throws ErrnoException;

    @Override
    public native long lseek(FileDescriptor var1, long var2, int var4) throws ErrnoException;

    @Override
    public native StructStat lstat(String var1) throws ErrnoException;

    @Override
    public native void mincore(long var1, long var3, byte[] var5) throws ErrnoException;

    @Override
    public native void mkdir(String var1, int var2) throws ErrnoException;

    @Override
    public native void mkfifo(String var1, int var2) throws ErrnoException;

    @Override
    public native void mlock(long var1, long var3) throws ErrnoException;

    @Override
    public native long mmap(long var1, long var3, int var5, int var6, FileDescriptor var7, long var8) throws ErrnoException;

    @Override
    public native void msync(long var1, long var3, int var5) throws ErrnoException;

    @Override
    public native void munlock(long var1, long var3) throws ErrnoException;

    @Override
    public native void munmap(long var1, long var3) throws ErrnoException;

    @Override
    public native FileDescriptor open(String var1, int var2, int var3) throws ErrnoException;

    @Override
    public native FileDescriptor[] pipe2(int var1) throws ErrnoException;

    @Override
    public native int poll(StructPollfd[] var1, int var2) throws ErrnoException;

    @Override
    public native void posix_fallocate(FileDescriptor var1, long var2, long var4) throws ErrnoException;

    @Override
    public native int prctl(int var1, long var2, long var4, long var6, long var8) throws ErrnoException;

    @Override
    public int pread(FileDescriptor fd, ByteBuffer buffer, long offset) throws ErrnoException, InterruptedIOException {
        int position = buffer.position();
        int bytesRead = buffer.isDirect() ? this.preadBytes(fd, buffer, position, buffer.remaining(), offset) : this.preadBytes(fd, NioUtils.unsafeArray(buffer), NioUtils.unsafeArrayOffset(buffer) + position, buffer.remaining(), offset);
        Posix.maybeUpdateBufferPosition(buffer, position, bytesRead);
        return bytesRead;
    }

    @Override
    public int pread(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, long offset) throws ErrnoException, InterruptedIOException {
        return this.preadBytes(fd, bytes, byteOffset, byteCount, offset);
    }

    private native int preadBytes(FileDescriptor var1, Object var2, int var3, int var4, long var5) throws ErrnoException, InterruptedIOException;

    @Override
    public int pwrite(FileDescriptor fd, ByteBuffer buffer, long offset) throws ErrnoException, InterruptedIOException {
        int position = buffer.position();
        int bytesWritten = buffer.isDirect() ? this.pwriteBytes(fd, buffer, position, buffer.remaining(), offset) : this.pwriteBytes(fd, NioUtils.unsafeArray(buffer), NioUtils.unsafeArrayOffset(buffer) + position, buffer.remaining(), offset);
        Posix.maybeUpdateBufferPosition(buffer, position, bytesWritten);
        return bytesWritten;
    }

    @Override
    public int pwrite(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, long offset) throws ErrnoException, InterruptedIOException {
        return this.pwriteBytes(fd, bytes, byteOffset, byteCount, offset);
    }

    private native int pwriteBytes(FileDescriptor var1, Object var2, int var3, int var4, long var5) throws ErrnoException, InterruptedIOException;

    @Override
    public int read(FileDescriptor fd, ByteBuffer buffer) throws ErrnoException, InterruptedIOException {
        int position = buffer.position();
        int bytesRead = buffer.isDirect() ? this.readBytes(fd, buffer, position, buffer.remaining()) : this.readBytes(fd, NioUtils.unsafeArray(buffer), NioUtils.unsafeArrayOffset(buffer) + position, buffer.remaining());
        Posix.maybeUpdateBufferPosition(buffer, position, bytesRead);
        return bytesRead;
    }

    @Override
    public int read(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount) throws ErrnoException, InterruptedIOException {
        return this.readBytes(fd, bytes, byteOffset, byteCount);
    }

    private native int readBytes(FileDescriptor var1, Object var2, int var3, int var4) throws ErrnoException, InterruptedIOException;

    @Override
    public native String readlink(String var1) throws ErrnoException;

    @Override
    public native int readv(FileDescriptor var1, Object[] var2, int[] var3, int[] var4) throws ErrnoException, InterruptedIOException;

    @Override
    public int recvfrom(FileDescriptor fd, ByteBuffer buffer, int flags, InetSocketAddress srcAddress) throws ErrnoException, SocketException {
        int position = buffer.position();
        int bytesReceived = buffer.isDirect() ? this.recvfromBytes(fd, buffer, position, buffer.remaining(), flags, srcAddress) : this.recvfromBytes(fd, NioUtils.unsafeArray(buffer), NioUtils.unsafeArrayOffset(buffer) + position, buffer.remaining(), flags, srcAddress);
        Posix.maybeUpdateBufferPosition(buffer, position, bytesReceived);
        return bytesReceived;
    }

    @Override
    public int recvfrom(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, int flags, InetSocketAddress srcAddress) throws ErrnoException, SocketException {
        return this.recvfromBytes(fd, bytes, byteOffset, byteCount, flags, srcAddress);
    }

    private native int recvfromBytes(FileDescriptor var1, Object var2, int var3, int var4, int var5, InetSocketAddress var6) throws ErrnoException, SocketException;

    @Override
    public native void remove(String var1) throws ErrnoException;

    @Override
    public native void removexattr(String var1, String var2) throws ErrnoException;

    @Override
    public native void rename(String var1, String var2) throws ErrnoException;

    @Override
    public native long sendfile(FileDescriptor var1, FileDescriptor var2, MutableLong var3, long var4) throws ErrnoException;

    @Override
    public int sendto(FileDescriptor fd, ByteBuffer buffer, int flags, InetAddress inetAddress, int port) throws ErrnoException, SocketException {
        int position = buffer.position();
        int bytesSent = buffer.isDirect() ? this.sendtoBytes(fd, buffer, position, buffer.remaining(), flags, inetAddress, port) : this.sendtoBytes(fd, NioUtils.unsafeArray(buffer), NioUtils.unsafeArrayOffset(buffer) + position, buffer.remaining(), flags, inetAddress, port);
        Posix.maybeUpdateBufferPosition(buffer, position, bytesSent);
        return bytesSent;
    }

    @Override
    public int sendto(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, int flags, InetAddress inetAddress, int port) throws ErrnoException, SocketException {
        return this.sendtoBytes(fd, bytes, byteOffset, byteCount, flags, inetAddress, port);
    }

    @Override
    public int sendto(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, int flags, SocketAddress address) throws ErrnoException, SocketException {
        return this.sendtoBytes(fd, bytes, byteOffset, byteCount, flags, address);
    }

    private native int sendtoBytes(FileDescriptor var1, Object var2, int var3, int var4, int var5, InetAddress var6, int var7) throws ErrnoException, SocketException;

    private native int sendtoBytes(FileDescriptor var1, Object var2, int var3, int var4, int var5, SocketAddress var6) throws ErrnoException, SocketException;

    @Override
    public native void setegid(int var1) throws ErrnoException;

    @Override
    public native void setenv(String var1, String var2, boolean var3) throws ErrnoException;

    @Override
    public native void seteuid(int var1) throws ErrnoException;

    @Override
    public native void setgid(int var1) throws ErrnoException;

    @Override
    public native void setpgid(int var1, int var2) throws ErrnoException;

    @Override
    public native void setregid(int var1, int var2) throws ErrnoException;

    @Override
    public native void setreuid(int var1, int var2) throws ErrnoException;

    @Override
    public native int setsid() throws ErrnoException;

    @Override
    public native void setsockoptByte(FileDescriptor var1, int var2, int var3, int var4) throws ErrnoException;

    @Override
    public native void setsockoptIfreq(FileDescriptor var1, int var2, int var3, String var4) throws ErrnoException;

    @Override
    public native void setsockoptInt(FileDescriptor var1, int var2, int var3, int var4) throws ErrnoException;

    @Override
    public native void setsockoptIpMreqn(FileDescriptor var1, int var2, int var3, int var4) throws ErrnoException;

    @Override
    public native void setsockoptGroupReq(FileDescriptor var1, int var2, int var3, StructGroupReq var4) throws ErrnoException;

    @Override
    public native void setsockoptGroupSourceReq(FileDescriptor var1, int var2, int var3, StructGroupSourceReq var4) throws ErrnoException;

    @Override
    public native void setsockoptLinger(FileDescriptor var1, int var2, int var3, StructLinger var4) throws ErrnoException;

    @Override
    public native void setsockoptTimeval(FileDescriptor var1, int var2, int var3, StructTimeval var4) throws ErrnoException;

    @Override
    public native void setuid(int var1) throws ErrnoException;

    @Override
    public native void setxattr(String var1, String var2, byte[] var3, int var4) throws ErrnoException;

    @Override
    public native void shutdown(FileDescriptor var1, int var2) throws ErrnoException;

    @Override
    public native FileDescriptor socket(int var1, int var2, int var3) throws ErrnoException;

    @Override
    public native void socketpair(int var1, int var2, int var3, FileDescriptor var4, FileDescriptor var5) throws ErrnoException;

    @Override
    public native StructStat stat(String var1) throws ErrnoException;

    @Override
    public native StructStatVfs statvfs(String var1) throws ErrnoException;

    @Override
    public native String strerror(int var1);

    @Override
    public native String strsignal(int var1);

    @Override
    public native void symlink(String var1, String var2) throws ErrnoException;

    @Override
    public native long sysconf(int var1);

    @Override
    public native void tcdrain(FileDescriptor var1) throws ErrnoException;

    @Override
    public native void tcsendbreak(FileDescriptor var1, int var2) throws ErrnoException;

    @Override
    public int umask(int mask) {
        if ((mask & 0x1FF) != mask) {
            throw new IllegalArgumentException("Invalid umask: " + mask);
        }
        return this.umaskImpl(mask);
    }

    private native int umaskImpl(int var1);

    @Override
    public native StructUtsname uname();

    @Override
    public native void unsetenv(String var1) throws ErrnoException;

    @Override
    public native int waitpid(int var1, MutableInt var2, int var3) throws ErrnoException;

    @Override
    public int write(FileDescriptor fd, ByteBuffer buffer) throws ErrnoException, InterruptedIOException {
        int position = buffer.position();
        int bytesWritten = buffer.isDirect() ? this.writeBytes(fd, buffer, position, buffer.remaining()) : this.writeBytes(fd, NioUtils.unsafeArray(buffer), NioUtils.unsafeArrayOffset(buffer) + position, buffer.remaining());
        Posix.maybeUpdateBufferPosition(buffer, position, bytesWritten);
        return bytesWritten;
    }

    @Override
    public int write(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount) throws ErrnoException, InterruptedIOException {
        return this.writeBytes(fd, bytes, byteOffset, byteCount);
    }

    private native int writeBytes(FileDescriptor var1, Object var2, int var3, int var4) throws ErrnoException, InterruptedIOException;

    @Override
    public native int writev(FileDescriptor var1, Object[] var2, int[] var3, int[] var4) throws ErrnoException, InterruptedIOException;

    private static void maybeUpdateBufferPosition(ByteBuffer buffer, int originalPosition, int bytesReadOrWritten) {
        if (bytesReadOrWritten > 0) {
            buffer.position(bytesReadOrWritten + originalPosition);
        }
    }
}

