/*
 * Decompiled with CFR 0.152.
 */
package libcore.tzdata.update;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.CRC32;

public final class FileUtils {
    private FileUtils() {
    }

    public static File createSubFile(File parentDir, String name) throws IOException {
        File subFile = new File(parentDir, name).getCanonicalFile();
        if (!subFile.getPath().startsWith(parentDir.getCanonicalPath())) {
            throw new IOException(name + " must exist beneath " + parentDir + ". Canonicalized subpath: " + subFile);
        }
        return subFile;
    }

    public static void ensureDirectoriesExist(File dir, boolean makeWorldReadable) throws IOException {
        LinkedList<File> dirs = new LinkedList<File>();
        File currentDir = dir;
        do {
            dirs.addFirst(currentDir);
        } while ((currentDir = currentDir.getParentFile()) != null);
        for (File dirToCheck : dirs) {
            if (!dirToCheck.exists()) {
                if (!dirToCheck.mkdir()) {
                    throw new IOException("Unable to create directory: " + dir);
                }
                if (!makeWorldReadable) continue;
                FileUtils.makeDirectoryWorldAccessible(dirToCheck);
                continue;
            }
            if (dirToCheck.isDirectory()) continue;
            throw new IOException(dirToCheck + " exists but is not a directory");
        }
    }

    public static void makeDirectoryWorldAccessible(File directory) throws IOException {
        if (!directory.isDirectory()) {
            throw new IOException(directory + " must be a directory");
        }
        FileUtils.makeWorldReadable(directory);
        if (!directory.setExecutable(true, false)) {
            throw new IOException("Unable to make " + directory + " world-executable");
        }
    }

    public static void makeWorldReadable(File file) throws IOException {
        if (!file.setReadable(true, false)) {
            throw new IOException("Unable to make " + file + " world-readable");
        }
    }

    public static long calculateChecksum(File file) throws IOException {
        int BUFFER_SIZE = 8196;
        CRC32 crc32 = new CRC32();
        try (FileInputStream fis = new FileInputStream(file);){
            int count;
            byte[] buffer = new byte[8196];
            while ((count = fis.read(buffer)) != -1) {
                crc32.update(buffer, 0, count);
            }
        }
        return crc32.getValue();
    }

    public static void rename(File from, File to) throws IOException {
        FileUtils.ensureFileDoesNotExist(to);
        if (!from.renameTo(to)) {
            throw new IOException("Unable to rename " + from + " to " + to);
        }
    }

    public static void ensureFileDoesNotExist(File file) throws IOException {
        if (file.exists()) {
            if (!file.isFile()) {
                throw new IOException(file + " is not a file");
            }
            FileUtils.doDelete(file);
        }
    }

    public static void doDelete(File file) throws IOException {
        if (!file.delete()) {
            throw new IOException("Unable to delete: " + file);
        }
    }

    public static boolean isSymlink(File file) throws IOException {
        String baseName = file.getName();
        String canonicalPathExceptBaseName = new File(file.getParentFile().getCanonicalFile(), baseName).getPath();
        return !file.getCanonicalPath().equals(canonicalPathExceptBaseName);
    }

    public static void deleteRecursive(File toDelete) throws IOException {
        if (toDelete.isDirectory()) {
            for (File file : toDelete.listFiles()) {
                if (file.isDirectory() && !FileUtils.isSymlink(file)) {
                    FileUtils.deleteRecursive(file);
                    continue;
                }
                FileUtils.doDelete(file);
            }
            Object[] remainingFiles = toDelete.list();
            if (remainingFiles.length != 0) {
                throw new IOException("Unable to delete files: " + Arrays.toString(remainingFiles));
            }
        }
        FileUtils.doDelete(toDelete);
    }

    public static boolean filesExist(File rootDir, String ... fileNames) throws IOException {
        for (String fileName : fileNames) {
            File file = new File(rootDir, fileName);
            if (file.exists()) continue;
            return false;
        }
        return true;
    }

    public static List<String> readLines(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try (BufferedReader fileReader = new BufferedReader(new InputStreamReader((InputStream)in, StandardCharsets.UTF_8));){
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = fileReader.readLine()) != null) {
                lines.add(line);
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
    }
}

