/*
 * Decompiled with CFR 0.152.
 */
package libcore.tzdata.update;

import android.util.Slog;
import java.io.File;
import java.io.IOException;
import libcore.tzdata.update.ConfigBundle;
import libcore.tzdata.update.FileUtils;

public final class TzDataBundleInstaller {
    static final String CURRENT_TZ_DATA_DIR_NAME = "current";
    static final String WORKING_DIR_NAME = "working";
    static final String OLD_TZ_DATA_DIR_NAME = "old";
    private final String logTag;
    private final File installDir;

    public TzDataBundleInstaller(String logTag, File installDir) {
        this.logTag = logTag;
        this.installDir = installDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean install(byte[] content) throws IOException {
        File oldTzDataDir = new File(this.installDir, OLD_TZ_DATA_DIR_NAME);
        if (oldTzDataDir.exists()) {
            FileUtils.deleteRecursive(oldTzDataDir);
        }
        File currentTzDataDir = new File(this.installDir, CURRENT_TZ_DATA_DIR_NAME);
        File workingDir = new File(this.installDir, WORKING_DIR_NAME);
        Slog.i(this.logTag, "Applying time zone update");
        File unpackedContentDir = this.unpackBundle(content, workingDir);
        try {
            if (!this.checkBundleFilesExist(unpackedContentDir)) {
                Slog.i(this.logTag, "Update not applied: Bundle is missing files");
                boolean bl = false;
                return bl;
            }
            if (this.verifySystemChecksums(unpackedContentDir)) {
                FileUtils.makeDirectoryWorldAccessible(unpackedContentDir);
                if (currentTzDataDir.exists()) {
                    Slog.i(this.logTag, "Moving " + currentTzDataDir + " to " + oldTzDataDir);
                    FileUtils.rename(currentTzDataDir, oldTzDataDir);
                }
                Slog.i(this.logTag, "Moving " + unpackedContentDir + " to " + currentTzDataDir);
                FileUtils.rename(unpackedContentDir, currentTzDataDir);
                Slog.i(this.logTag, "Update applied: " + currentTzDataDir + " successfully created");
                boolean bl = true;
                return bl;
            }
            Slog.i(this.logTag, "Update not applied: System checksum did not match");
            boolean bl = false;
            return bl;
        }
        finally {
            this.deleteBestEffort(oldTzDataDir);
            this.deleteBestEffort(unpackedContentDir);
        }
    }

    private void deleteBestEffort(File dir) {
        if (dir.exists()) {
            try {
                FileUtils.deleteRecursive(dir);
            }
            catch (IOException e) {
                Slog.w(this.logTag, "Unable to delete " + dir, e);
            }
        }
    }

    private File unpackBundle(byte[] content, File targetDir) throws IOException {
        Slog.i(this.logTag, "Unpacking update content to: " + targetDir);
        ConfigBundle bundle = new ConfigBundle(content);
        bundle.extractTo(targetDir);
        return targetDir;
    }

    private boolean checkBundleFilesExist(File unpackedContentDir) throws IOException {
        Slog.i(this.logTag, "Verifying bundle contents");
        return FileUtils.filesExist(unpackedContentDir, "tzdata_version", "checksums", "tzdata", "icu/icu_tzdata.dat");
    }

    private boolean verifySystemChecksums(File unpackedContentDir) throws IOException {
        Slog.i(this.logTag, "Verifying system file checksums");
        File checksumsFile = new File(unpackedContentDir, "checksums");
        for (String line : FileUtils.readLines(checksumsFile)) {
            long expectedChecksum;
            int delimiterPos = line.indexOf(44);
            if (delimiterPos <= 0 || delimiterPos == line.length() - 1) {
                throw new IOException("Bad checksum entry: " + line);
            }
            try {
                expectedChecksum = Long.parseLong(line.substring(0, delimiterPos));
            }
            catch (NumberFormatException e) {
                throw new IOException("Invalid checksum value: " + line);
            }
            String filePath = line.substring(delimiterPos + 1);
            File file = new File(filePath);
            if (!file.exists()) {
                Slog.i(this.logTag, "Failed checksum test for file: " + file + ": file not found");
                return false;
            }
            long actualChecksum = FileUtils.calculateChecksum(file);
            if (actualChecksum == expectedChecksum) continue;
            Slog.i(this.logTag, "Failed checksum test for file: " + file + ": required=" + expectedChecksum + ", actual=" + actualChecksum);
            return false;
        }
        return true;
    }
}

