/*
 * Decompiled with CFR 0.152.
 */
package libcore.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CountingOutputStream
extends FilterOutputStream {
    private long count = 0L;

    public CountingOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        this.out.write(buffer, offset, length);
        this.count += (long)length;
    }

    @Override
    public void write(int oneByte) throws IOException {
        this.out.write(oneByte);
        ++this.count;
    }

    public long getCount() {
        return this.count;
    }
}

