/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.asn1;

import java.io.IOException;
import org.apache.harmony.security.asn1.ASN1Any;
import org.apache.harmony.security.asn1.ASN1Choice;
import org.apache.harmony.security.asn1.ASN1Exception;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.asn1.BerOutputStream;

public final class ASN1Implicit
extends ASN1Type {
    private static final int TAGGING_PRIMITIVE = 0;
    private static final int TAGGING_CONSTRUCTED = 1;
    private static final int TAGGING_STRING = 2;
    private final ASN1Type type;
    private final int taggingType;

    public ASN1Implicit(int tagNumber, ASN1Type type) {
        super(128, tagNumber);
        if (type instanceof ASN1Choice || type instanceof ASN1Any) {
            throw new IllegalArgumentException("Implicit tagging can not be used for ASN.1 ANY or CHOICE type");
        }
        this.type = type;
        this.taggingType = type.checkTag(type.id) ? (type.checkTag(type.constrId) ? 2 : 0) : 1;
    }

    @Override
    public final boolean checkTag(int identifier) {
        switch (this.taggingType) {
            case 0: {
                return this.id == identifier;
            }
            case 1: {
                return this.constrId == identifier;
            }
        }
        return this.id == identifier || this.constrId == identifier;
    }

    @Override
    public Object decode(BerInputStream in) throws IOException {
        if (!this.checkTag(in.tag)) {
            throw new ASN1Exception("ASN.1 implicitly tagged type expected at [" + in.tagOffset + "]. Expected tag: " + Integer.toHexString(this.id) + ", " + "but got " + Integer.toHexString(in.tag));
        }
        in.tag = this.id == in.tag ? this.type.id : this.type.constrId;
        in.content = this.type.decode(in);
        if (in.isVerify) {
            return null;
        }
        return this.getDecodedObject(in);
    }

    @Override
    public void encodeASN(BerOutputStream out) {
        if (this.taggingType == 1) {
            out.encodeTag(this.constrId);
        } else {
            out.encodeTag(this.id);
        }
        this.encodeContent(out);
    }

    @Override
    public void encodeContent(BerOutputStream out) {
        this.type.encodeContent(out);
    }

    @Override
    public void setEncodingContent(BerOutputStream out) {
        this.type.setEncodingContent(out);
    }
}

