/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.fortress;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.harmony.security.fortress.SecurityAccess;
import org.apache.harmony.security.fortress.Services;

public final class Engine {
    public static SecurityAccess door;
    private final String serviceName;
    private volatile ServiceCacheEntry serviceCache;

    public Engine(String serviceName) {
        this.serviceName = serviceName;
    }

    public SpiAndProvider getInstance(String algorithm, Object param) throws NoSuchAlgorithmException {
        if (algorithm == null) {
            throw new NoSuchAlgorithmException("Null algorithm name");
        }
        ArrayList<Provider.Service> services = this.getServices(algorithm);
        if (services == null) {
            throw this.notFound(this.serviceName, algorithm);
        }
        return new SpiAndProvider(services.get(0).newInstance(param), services.get(0).getProvider());
    }

    public SpiAndProvider getInstance(Provider.Service service, String param) throws NoSuchAlgorithmException {
        return new SpiAndProvider(service.newInstance(param), service.getProvider());
    }

    public ArrayList<Provider.Service> getServices(String algorithm) {
        int newCacheVersion = Services.getCacheVersion();
        ServiceCacheEntry cacheEntry = this.serviceCache;
        String algoUC = algorithm.toUpperCase(Locale.US);
        if (cacheEntry != null && cacheEntry.algorithm.equalsIgnoreCase(algoUC) && newCacheVersion == cacheEntry.cacheVersion) {
            return cacheEntry.services;
        }
        ArrayList<Provider.Service> services = Services.getServices(this.serviceName, algoUC);
        this.serviceCache = new ServiceCacheEntry(algoUC, newCacheVersion, services);
        return services;
    }

    public Object getInstance(String algorithm, Provider provider, Object param) throws NoSuchAlgorithmException {
        if (algorithm == null) {
            throw new NoSuchAlgorithmException("algorithm == null");
        }
        Provider.Service service = provider.getService(this.serviceName, algorithm);
        if (service == null) {
            throw this.notFound(this.serviceName, algorithm);
        }
        return service.newInstance(param);
    }

    private NoSuchAlgorithmException notFound(String serviceName, String algorithm) throws NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException(serviceName + " " + algorithm + " implementation not found");
    }

    public static final class SpiAndProvider {
        public final Object spi;
        public final Provider provider;

        private SpiAndProvider(Object spi, Provider provider) {
            this.spi = spi;
            this.provider = provider;
        }
    }

    private static final class ServiceCacheEntry {
        private final String algorithm;
        private final int cacheVersion;
        private final ArrayList<Provider.Service> services;

        private ServiceCacheEntry(String algorithm, int cacheVersion, ArrayList<Provider.Service> services) {
            this.algorithm = algorithm;
            this.cacheVersion = cacheVersion;
            this.services = services;
        }
    }
}

