/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import dalvik.system.VMStack;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public final class Unsafe {
    private static final Unsafe THE_ONE;
    private static final Unsafe theUnsafe;

    private Unsafe() {
    }

    public static Unsafe getUnsafe() {
        ClassLoader calling = VMStack.getCallingClassLoader();
        if (calling != null && calling != Unsafe.class.getClassLoader()) {
            throw new SecurityException("Unsafe access denied");
        }
        return THE_ONE;
    }

    public long objectFieldOffset(Field field) {
        if (Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException("valid for instance fields only");
        }
        return field.getOffset();
    }

    public int arrayBaseOffset(Class clazz) {
        Class<?> component = clazz.getComponentType();
        if (component == null) {
            throw new IllegalArgumentException("Valid for array classes only: " + clazz);
        }
        return Unsafe.getArrayBaseOffsetForComponentType(component);
    }

    public int arrayIndexScale(Class clazz) {
        Class<?> component = clazz.getComponentType();
        if (component == null) {
            throw new IllegalArgumentException("Valid for array classes only: " + clazz);
        }
        return Unsafe.getArrayIndexScaleForComponentType(component);
    }

    private static native int getArrayBaseOffsetForComponentType(Class var0);

    private static native int getArrayIndexScaleForComponentType(Class var0);

    public native boolean compareAndSwapInt(Object var1, long var2, int var4, int var5);

    public native boolean compareAndSwapLong(Object var1, long var2, long var4, long var6);

    public native boolean compareAndSwapObject(Object var1, long var2, Object var4, Object var5);

    public native int getIntVolatile(Object var1, long var2);

    public native void putIntVolatile(Object var1, long var2, int var4);

    public native long getLongVolatile(Object var1, long var2);

    public native void putLongVolatile(Object var1, long var2, long var4);

    public native Object getObjectVolatile(Object var1, long var2);

    public native void putObjectVolatile(Object var1, long var2, Object var4);

    public native int getInt(Object var1, long var2);

    public native void putInt(Object var1, long var2, int var4);

    public native void putOrderedInt(Object var1, long var2, int var4);

    public native long getLong(Object var1, long var2);

    public native void putLong(Object var1, long var2, long var4);

    public native void putOrderedLong(Object var1, long var2, long var4);

    public native Object getObject(Object var1, long var2);

    public native void putObject(Object var1, long var2, Object var4);

    public native void putOrderedObject(Object var1, long var2, Object var4);

    public void park(boolean absolute, long time) {
        if (absolute) {
            Thread.currentThread().parkUntil$(time);
        } else {
            Thread.currentThread().parkFor$(time);
        }
    }

    public void unpark(Object obj) {
        if (!(obj instanceof Thread)) {
            throw new IllegalArgumentException("valid for Threads only");
        }
        ((Thread)obj).unpark$();
    }

    public native Object allocateInstance(Class<?> var1);

    static {
        theUnsafe = THE_ONE = new Unsafe();
    }
}

