/*
 * Decompiled with CFR 0.152.
 */
package android.accessibilityservice;

import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.MotionEvent;
import java.util.ArrayList;
import java.util.List;

public final class GestureDescription {
    private static final int MAX_STROKE_COUNT = 10;
    private static final long MAX_GESTURE_DURATION_MS = 60000L;
    private final List<StrokeDescription> mStrokes = new ArrayList<StrokeDescription>();
    private final float[] mTempPos = new float[2];

    public static int getMaxStrokeCount() {
        return 10;
    }

    public static long getMaxGestureDuration() {
        return 60000L;
    }

    private GestureDescription() {
    }

    private GestureDescription(List<StrokeDescription> strokes) {
        this.mStrokes.addAll(strokes);
    }

    public int getStrokeCount() {
        return this.mStrokes.size();
    }

    public StrokeDescription getStroke(int index) {
        return this.mStrokes.get(index);
    }

    private long getNextKeyPointAtLeast(long offset) {
        long nextKeyPoint = Long.MAX_VALUE;
        for (int i = 0; i < this.mStrokes.size(); ++i) {
            long thisEndTime;
            long thisStartTime = this.mStrokes.get((int)i).mStartTime;
            if (thisStartTime < nextKeyPoint && thisStartTime >= offset) {
                nextKeyPoint = thisStartTime;
            }
            if ((thisEndTime = this.mStrokes.get((int)i).mEndTime) >= nextKeyPoint || thisEndTime < offset) continue;
            nextKeyPoint = thisEndTime;
        }
        return nextKeyPoint == Long.MAX_VALUE ? -1L : nextKeyPoint;
    }

    private int getPointsForTime(long time, TouchPoint[] touchPoints) {
        int numPointsFound = 0;
        for (int i = 0; i < this.mStrokes.size(); ++i) {
            StrokeDescription strokeDescription = this.mStrokes.get(i);
            if (!strokeDescription.hasPointForTime(time)) continue;
            touchPoints[numPointsFound].mPathIndex = i;
            touchPoints[numPointsFound].mIsStartOfPath = time == strokeDescription.mStartTime;
            touchPoints[numPointsFound].mIsEndOfPath = time == strokeDescription.mEndTime;
            strokeDescription.getPosForTime(time, this.mTempPos);
            touchPoints[numPointsFound].mX = Math.round(this.mTempPos[0]);
            touchPoints[numPointsFound].mY = Math.round(this.mTempPos[1]);
            ++numPointsFound;
        }
        return numPointsFound;
    }

    private static long getTotalDuration(List<StrokeDescription> paths) {
        long latestEnd = Long.MIN_VALUE;
        for (int i = 0; i < paths.size(); ++i) {
            StrokeDescription path = paths.get(i);
            latestEnd = Math.max(latestEnd, path.mEndTime);
        }
        return Math.max(latestEnd, 0L);
    }

    public static class MotionEventGenerator {
        private static final int EVENT_META_STATE = 0;
        private static final int EVENT_BUTTON_STATE = 0;
        private static final int EVENT_DEVICE_ID = 0;
        private static final int EVENT_EDGE_FLAGS = 0;
        private static final int EVENT_SOURCE = 4098;
        private static final int EVENT_FLAGS = 0;
        private static final float EVENT_X_PRECISION = 1.0f;
        private static final float EVENT_Y_PRECISION = 1.0f;
        private static TouchPoint[] sCurrentTouchPoints;
        private static TouchPoint[] sLastTouchPoints;
        private static MotionEvent.PointerCoords[] sPointerCoords;
        private static MotionEvent.PointerProperties[] sPointerProps;

        static List<GestureStep> getGestureStepsFromGestureDescription(GestureDescription description, int sampleTimeMs) {
            ArrayList<GestureStep> gestureSteps = new ArrayList<GestureStep>();
            TouchPoint[] currentTouchPoints = MotionEventGenerator.getCurrentTouchPoints(description.getStrokeCount());
            int currentTouchPointSize = 0;
            long timeSinceGestureStart = 0L;
            long nextKeyPointTime = description.getNextKeyPointAtLeast(timeSinceGestureStart);
            while (nextKeyPointTime >= 0L) {
                timeSinceGestureStart = currentTouchPointSize == 0 ? nextKeyPointTime : Math.min(nextKeyPointTime, timeSinceGestureStart + (long)sampleTimeMs);
                currentTouchPointSize = description.getPointsForTime(timeSinceGestureStart, currentTouchPoints);
                gestureSteps.add(new GestureStep(timeSinceGestureStart, currentTouchPointSize, currentTouchPoints));
                nextKeyPointTime = description.getNextKeyPointAtLeast(timeSinceGestureStart + 1L);
            }
            return gestureSteps;
        }

        public static List<MotionEvent> getMotionEventsFromGestureSteps(List<GestureStep> steps) {
            ArrayList<MotionEvent> motionEvents = new ArrayList<MotionEvent>();
            int lastTouchPointSize = 0;
            for (int i = 0; i < steps.size(); ++i) {
                GestureStep step = steps.get(i);
                int currentTouchPointSize = step.numTouchPoints;
                TouchPoint[] lastTouchPoints = MotionEventGenerator.getLastTouchPoints(Math.max(lastTouchPointSize, currentTouchPointSize));
                MotionEventGenerator.appendMoveEventIfNeeded(motionEvents, lastTouchPoints, lastTouchPointSize, step.touchPoints, currentTouchPointSize, step.timeSinceGestureStart);
                lastTouchPointSize = MotionEventGenerator.appendUpEvents(motionEvents, lastTouchPoints, lastTouchPointSize, step.touchPoints, currentTouchPointSize, step.timeSinceGestureStart);
                lastTouchPointSize = MotionEventGenerator.appendDownEvents(motionEvents, lastTouchPoints, lastTouchPointSize, step.touchPoints, currentTouchPointSize, step.timeSinceGestureStart);
            }
            return motionEvents;
        }

        private static TouchPoint[] getCurrentTouchPoints(int requiredCapacity) {
            if (sCurrentTouchPoints == null || sCurrentTouchPoints.length < requiredCapacity) {
                sCurrentTouchPoints = new TouchPoint[requiredCapacity];
                for (int i = 0; i < requiredCapacity; ++i) {
                    MotionEventGenerator.sCurrentTouchPoints[i] = new TouchPoint();
                }
            }
            return sCurrentTouchPoints;
        }

        private static TouchPoint[] getLastTouchPoints(int requiredCapacity) {
            if (sLastTouchPoints == null || sLastTouchPoints.length < requiredCapacity) {
                sLastTouchPoints = new TouchPoint[requiredCapacity];
                for (int i = 0; i < requiredCapacity; ++i) {
                    MotionEventGenerator.sLastTouchPoints[i] = new TouchPoint();
                }
            }
            return sLastTouchPoints;
        }

        private static MotionEvent.PointerCoords[] getPointerCoords(int requiredCapacity) {
            if (sPointerCoords == null || sPointerCoords.length < requiredCapacity) {
                sPointerCoords = new MotionEvent.PointerCoords[requiredCapacity];
                for (int i = 0; i < requiredCapacity; ++i) {
                    MotionEventGenerator.sPointerCoords[i] = new MotionEvent.PointerCoords();
                }
            }
            return sPointerCoords;
        }

        private static MotionEvent.PointerProperties[] getPointerProps(int requiredCapacity) {
            if (sPointerProps == null || sPointerProps.length < requiredCapacity) {
                sPointerProps = new MotionEvent.PointerProperties[requiredCapacity];
                for (int i = 0; i < requiredCapacity; ++i) {
                    MotionEventGenerator.sPointerProps[i] = new MotionEvent.PointerProperties();
                }
            }
            return sPointerProps;
        }

        private static void appendMoveEventIfNeeded(List<MotionEvent> motionEvents, TouchPoint[] lastTouchPoints, int lastTouchPointsSize, TouchPoint[] currentTouchPoints, int currentTouchPointsSize, long currentTime) {
            boolean moveFound = false;
            for (int i = 0; i < currentTouchPointsSize; ++i) {
                int lastPointsIndex = MotionEventGenerator.findPointByPathIndex(lastTouchPoints, lastTouchPointsSize, currentTouchPoints[i].mPathIndex);
                if (lastPointsIndex < 0) continue;
                moveFound |= lastTouchPoints[lastPointsIndex].mX != currentTouchPoints[i].mX || lastTouchPoints[lastPointsIndex].mY != currentTouchPoints[i].mY;
                lastTouchPoints[lastPointsIndex].copyFrom(currentTouchPoints[i]);
            }
            if (moveFound) {
                long downTime = motionEvents.get(motionEvents.size() - 1).getDownTime();
                motionEvents.add(MotionEventGenerator.obtainMotionEvent(downTime, currentTime, 2, lastTouchPoints, lastTouchPointsSize));
            }
        }

        private static int appendUpEvents(List<MotionEvent> motionEvents, TouchPoint[] lastTouchPoints, int lastTouchPointsSize, TouchPoint[] currentTouchPoints, int currentTouchPointsSize, long currentTime) {
            for (int i = 0; i < currentTouchPointsSize; ++i) {
                int indexOfUpEvent;
                if (!currentTouchPoints[i].mIsEndOfPath || (indexOfUpEvent = MotionEventGenerator.findPointByPathIndex(lastTouchPoints, lastTouchPointsSize, currentTouchPoints[i].mPathIndex)) < 0) continue;
                long downTime = motionEvents.get(motionEvents.size() - 1).getDownTime();
                int action = lastTouchPointsSize == 1 ? 1 : 6;
                motionEvents.add(MotionEventGenerator.obtainMotionEvent(downTime, currentTime, action |= indexOfUpEvent << 8, lastTouchPoints, lastTouchPointsSize));
                for (int j = indexOfUpEvent; j < lastTouchPointsSize - 1; ++j) {
                    lastTouchPoints[j].copyFrom(lastTouchPoints[j + 1]);
                }
                --lastTouchPointsSize;
            }
            return lastTouchPointsSize;
        }

        private static int appendDownEvents(List<MotionEvent> motionEvents, TouchPoint[] lastTouchPoints, int lastTouchPointsSize, TouchPoint[] currentTouchPoints, int currentTouchPointsSize, long currentTime) {
            for (int i = 0; i < currentTouchPointsSize; ++i) {
                if (!currentTouchPoints[i].mIsStartOfPath) continue;
                lastTouchPoints[lastTouchPointsSize++].copyFrom(currentTouchPoints[i]);
                int action = lastTouchPointsSize == 1 ? 0 : 5;
                long downTime = action == 0 ? currentTime : motionEvents.get(motionEvents.size() - 1).getDownTime();
                motionEvents.add(MotionEventGenerator.obtainMotionEvent(downTime, currentTime, action |= i << 8, lastTouchPoints, lastTouchPointsSize));
            }
            return lastTouchPointsSize;
        }

        private static MotionEvent obtainMotionEvent(long downTime, long eventTime, int action, TouchPoint[] touchPoints, int touchPointsSize) {
            MotionEvent.PointerCoords[] pointerCoords = MotionEventGenerator.getPointerCoords(touchPointsSize);
            MotionEvent.PointerProperties[] pointerProperties = MotionEventGenerator.getPointerProps(touchPointsSize);
            for (int i = 0; i < touchPointsSize; ++i) {
                pointerProperties[i].id = touchPoints[i].mPathIndex;
                pointerProperties[i].toolType = 0;
                pointerCoords[i].clear();
                pointerCoords[i].pressure = 1.0f;
                pointerCoords[i].size = 1.0f;
                pointerCoords[i].x = touchPoints[i].mX;
                pointerCoords[i].y = touchPoints[i].mY;
            }
            return MotionEvent.obtain(downTime, eventTime, action, touchPointsSize, pointerProperties, pointerCoords, 0, 0, 1.0f, 1.0f, 0, 0, 4098, 0);
        }

        private static int findPointByPathIndex(TouchPoint[] touchPoints, int touchPointsSize, int pathIndex) {
            for (int i = 0; i < touchPointsSize; ++i) {
                if (touchPoints[i].mPathIndex != pathIndex) continue;
                return i;
            }
            return -1;
        }
    }

    public static class GestureStep
    implements Parcelable {
        public long timeSinceGestureStart;
        public int numTouchPoints;
        public TouchPoint[] touchPoints;
        public static final Parcelable.Creator<GestureStep> CREATOR = new Parcelable.Creator<GestureStep>(){

            @Override
            public GestureStep createFromParcel(Parcel in) {
                return new GestureStep(in);
            }

            public GestureStep[] newArray(int size) {
                return new GestureStep[size];
            }
        };

        public GestureStep(long timeSinceGestureStart, int numTouchPoints, TouchPoint[] touchPointsToCopy) {
            this.timeSinceGestureStart = timeSinceGestureStart;
            this.numTouchPoints = numTouchPoints;
            this.touchPoints = new TouchPoint[numTouchPoints];
            for (int i = 0; i < numTouchPoints; ++i) {
                this.touchPoints[i] = new TouchPoint(touchPointsToCopy[i]);
            }
        }

        public GestureStep(Parcel parcel) {
            this.timeSinceGestureStart = parcel.readLong();
            Parcelable[] parcelables = parcel.readParcelableArray(TouchPoint.class.getClassLoader());
            this.numTouchPoints = parcelables == null ? 0 : parcelables.length;
            this.touchPoints = new TouchPoint[this.numTouchPoints];
            for (int i = 0; i < this.numTouchPoints; ++i) {
                this.touchPoints[i] = (TouchPoint)parcelables[i];
            }
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeLong(this.timeSinceGestureStart);
            dest.writeParcelableArray(this.touchPoints, flags);
        }
    }

    public static class TouchPoint
    implements Parcelable {
        private static final int FLAG_IS_START_OF_PATH = 1;
        private static final int FLAG_IS_END_OF_PATH = 2;
        int mPathIndex;
        boolean mIsStartOfPath;
        boolean mIsEndOfPath;
        float mX;
        float mY;
        public static final Parcelable.Creator<TouchPoint> CREATOR = new Parcelable.Creator<TouchPoint>(){

            @Override
            public TouchPoint createFromParcel(Parcel in) {
                return new TouchPoint(in);
            }

            public TouchPoint[] newArray(int size) {
                return new TouchPoint[size];
            }
        };

        public TouchPoint() {
        }

        public TouchPoint(TouchPoint pointToCopy) {
            this.copyFrom(pointToCopy);
        }

        public TouchPoint(Parcel parcel) {
            this.mPathIndex = parcel.readInt();
            int startEnd = parcel.readInt();
            this.mIsStartOfPath = (startEnd & 1) != 0;
            this.mIsEndOfPath = (startEnd & 2) != 0;
            this.mX = parcel.readFloat();
            this.mY = parcel.readFloat();
        }

        void copyFrom(TouchPoint other) {
            this.mPathIndex = other.mPathIndex;
            this.mIsStartOfPath = other.mIsStartOfPath;
            this.mIsEndOfPath = other.mIsEndOfPath;
            this.mX = other.mX;
            this.mY = other.mY;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mPathIndex);
            int startEnd = this.mIsStartOfPath ? 1 : 0;
            dest.writeInt(startEnd |= this.mIsEndOfPath ? 2 : 0);
            dest.writeFloat(this.mX);
            dest.writeFloat(this.mY);
        }
    }

    public static class StrokeDescription {
        Path mPath;
        long mStartTime;
        long mEndTime;
        private float mTimeToLengthConversion;
        private PathMeasure mPathMeasure;
        float[] mTapLocation;

        public StrokeDescription(Path path, long startTime, long duration) {
            if (duration <= 0L) {
                throw new IllegalArgumentException("Duration must be positive");
            }
            if (startTime < 0L) {
                throw new IllegalArgumentException("Start time must not be negative");
            }
            RectF bounds = new RectF();
            path.computeBounds(bounds, false);
            if (bounds.bottom < 0.0f || bounds.top < 0.0f || bounds.right < 0.0f || bounds.left < 0.0f) {
                throw new IllegalArgumentException("Path bounds must not be negative");
            }
            if (path.isEmpty()) {
                throw new IllegalArgumentException("Path is empty");
            }
            this.mPath = new Path(path);
            this.mPathMeasure = new PathMeasure(path, false);
            if (this.mPathMeasure.getLength() == 0.0f) {
                Path tempPath = new Path(path);
                tempPath.lineTo(-1.0f, -1.0f);
                this.mTapLocation = new float[2];
                PathMeasure pathMeasure = new PathMeasure(tempPath, false);
                pathMeasure.getPosTan(0.0f, this.mTapLocation, null);
            }
            if (this.mPathMeasure.nextContour()) {
                throw new IllegalArgumentException("Path has more than one contour");
            }
            this.mPathMeasure.setPath(this.mPath, false);
            this.mStartTime = startTime;
            this.mEndTime = startTime + duration;
            this.mTimeToLengthConversion = this.getLength() / (float)duration;
        }

        public Path getPath() {
            return new Path(this.mPath);
        }

        public long getStartTime() {
            return this.mStartTime;
        }

        public long getDuration() {
            return this.mEndTime - this.mStartTime;
        }

        float getLength() {
            return this.mPathMeasure.getLength();
        }

        boolean getPosForTime(long time, float[] pos) {
            if (this.mTapLocation != null) {
                pos[0] = this.mTapLocation[0];
                pos[1] = this.mTapLocation[1];
                return true;
            }
            if (time == this.mEndTime) {
                return this.mPathMeasure.getPosTan(this.getLength(), pos, null);
            }
            float length = this.mTimeToLengthConversion * (float)(time - this.mStartTime);
            return this.mPathMeasure.getPosTan(length, pos, null);
        }

        boolean hasPointForTime(long time) {
            return time >= this.mStartTime && time <= this.mEndTime;
        }
    }

    public static class Builder {
        private final List<StrokeDescription> mStrokes = new ArrayList<StrokeDescription>();

        public Builder addStroke(StrokeDescription strokeDescription) {
            if (this.mStrokes.size() >= 10) {
                throw new IllegalStateException("Attempting to add too many strokes to a gesture");
            }
            this.mStrokes.add(strokeDescription);
            if (GestureDescription.getTotalDuration(this.mStrokes) > 60000L) {
                this.mStrokes.remove(strokeDescription);
                throw new IllegalStateException("Gesture would exceed maximum duration with new stroke");
            }
            return this;
        }

        public GestureDescription build() {
            if (this.mStrokes.size() == 0) {
                throw new IllegalStateException("Gestures must have at least one stroke");
            }
            return new GestureDescription(this.mStrokes);
        }
    }
}

