/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.IProcessObserver;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.SparseArray;
import java.util.List;

public class AppImportanceMonitor {
    final Context mContext;
    final SparseArray<AppEntry> mApps = new SparseArray();
    final IProcessObserver mProcessObserver = new IProcessObserver.Stub(){

        @Override
        public void onForegroundActivitiesChanged(int pid, int uid, boolean foregroundActivities) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onProcessStateChanged(int pid, int uid, int procState) {
            SparseArray<AppEntry> sparseArray = AppImportanceMonitor.this.mApps;
            synchronized (sparseArray) {
                AppImportanceMonitor.this.updateImportanceLocked(pid, uid, ActivityManager.RunningAppProcessInfo.procStateToImportance(procState), true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onProcessDied(int pid, int uid) {
            SparseArray<AppEntry> sparseArray = AppImportanceMonitor.this.mApps;
            synchronized (sparseArray) {
                AppImportanceMonitor.this.updateImportanceLocked(pid, uid, 1000, true);
            }
        }
    };
    static final int MSG_UPDATE = 1;
    final Handler mHandler;

    public AppImportanceMonitor(Context context, Looper looper) {
        this.mContext = context;
        this.mHandler = new Handler(looper){

            @Override
            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        AppImportanceMonitor.this.onImportanceChanged(msg.arg1, msg.arg2 & 0xFFFF, msg.arg2 >> 16);
                        break;
                    }
                    default: {
                        super.handleMessage(msg);
                    }
                }
            }
        };
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        try {
            ActivityManagerNative.getDefault().registerProcessObserver(this.mProcessObserver);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        List<ActivityManager.RunningAppProcessInfo> apps = am.getRunningAppProcesses();
        if (apps != null) {
            for (int i = 0; i < apps.size(); ++i) {
                ActivityManager.RunningAppProcessInfo app = apps.get(i);
                this.updateImportanceLocked(app.uid, app.pid, app.importance, false);
            }
        }
    }

    public int getImportance(int uid) {
        AppEntry ent = this.mApps.get(uid);
        if (ent == null) {
            return 1000;
        }
        return ent.importance;
    }

    public void onImportanceChanged(int uid, int importance, int oldImportance) {
    }

    void updateImportanceLocked(int uid, int pid, int importance, boolean repChange) {
        AppEntry ent = this.mApps.get(uid);
        if (ent == null) {
            ent = new AppEntry(uid);
            this.mApps.put(uid, ent);
        }
        if (importance >= 1000) {
            ent.procs.remove(pid);
        } else {
            ent.procs.put(pid, importance);
        }
        this.updateImportanceLocked(ent, repChange);
    }

    void updateImportanceLocked(AppEntry ent, boolean repChange) {
        int appImp = 1000;
        for (int i = 0; i < ent.procs.size(); ++i) {
            int procImp = ent.procs.valueAt(i);
            if (procImp >= appImp) continue;
            appImp = procImp;
        }
        if (appImp != ent.importance) {
            int impCode = appImp | ent.importance << 16;
            ent.importance = appImp;
            if (appImp >= 1000) {
                this.mApps.remove(ent.uid);
            }
            if (repChange) {
                this.mHandler.obtainMessage(1, ent.uid, impCode).sendToTarget();
            }
        }
    }

    static class AppEntry {
        final int uid;
        final SparseArray<Integer> procs = new SparseArray(1);
        int importance = 1000;

        AppEntry(int _uid) {
            this.uid = _uid;
        }
    }
}

