/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentManagerImpl;
import android.app.FragmentTransaction;
import android.app.SharedElementCallback;
import android.graphics.Rect;
import android.transition.Transition;
import android.transition.TransitionManager;
import android.transition.TransitionSet;
import android.util.ArrayMap;
import android.util.Log;
import android.util.LogWriter;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import com.android.internal.util.FastPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

final class BackStackRecord
extends FragmentTransaction
implements FragmentManager.BackStackEntry,
Runnable {
    static final String TAG = "FragmentManager";
    final FragmentManagerImpl mManager;
    static final int OP_NULL = 0;
    static final int OP_ADD = 1;
    static final int OP_REPLACE = 2;
    static final int OP_REMOVE = 3;
    static final int OP_HIDE = 4;
    static final int OP_SHOW = 5;
    static final int OP_DETACH = 6;
    static final int OP_ATTACH = 7;
    Op mHead;
    Op mTail;
    int mNumOp;
    int mEnterAnim;
    int mExitAnim;
    int mPopEnterAnim;
    int mPopExitAnim;
    int mTransition;
    int mTransitionStyle;
    boolean mAddToBackStack;
    boolean mAllowAddToBackStack = true;
    String mName;
    boolean mCommitted;
    int mIndex = -1;
    int mBreadCrumbTitleRes;
    CharSequence mBreadCrumbTitleText;
    int mBreadCrumbShortTitleRes;
    CharSequence mBreadCrumbShortTitleText;
    ArrayList<String> mSharedElementSourceNames;
    ArrayList<String> mSharedElementTargetNames;

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("BackStackEntry{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        if (this.mIndex >= 0) {
            sb.append(" #");
            sb.append(this.mIndex);
        }
        if (this.mName != null) {
            sb.append(" ");
            sb.append(this.mName);
        }
        sb.append("}");
        return sb.toString();
    }

    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        this.dump(prefix, writer, true);
    }

    void dump(String prefix, PrintWriter writer, boolean full) {
        if (full) {
            writer.print(prefix);
            writer.print("mName=");
            writer.print(this.mName);
            writer.print(" mIndex=");
            writer.print(this.mIndex);
            writer.print(" mCommitted=");
            writer.println(this.mCommitted);
            if (this.mTransition != 0) {
                writer.print(prefix);
                writer.print("mTransition=#");
                writer.print(Integer.toHexString(this.mTransition));
                writer.print(" mTransitionStyle=#");
                writer.println(Integer.toHexString(this.mTransitionStyle));
            }
            if (this.mEnterAnim != 0 || this.mExitAnim != 0) {
                writer.print(prefix);
                writer.print("mEnterAnim=#");
                writer.print(Integer.toHexString(this.mEnterAnim));
                writer.print(" mExitAnim=#");
                writer.println(Integer.toHexString(this.mExitAnim));
            }
            if (this.mPopEnterAnim != 0 || this.mPopExitAnim != 0) {
                writer.print(prefix);
                writer.print("mPopEnterAnim=#");
                writer.print(Integer.toHexString(this.mPopEnterAnim));
                writer.print(" mPopExitAnim=#");
                writer.println(Integer.toHexString(this.mPopExitAnim));
            }
            if (this.mBreadCrumbTitleRes != 0 || this.mBreadCrumbTitleText != null) {
                writer.print(prefix);
                writer.print("mBreadCrumbTitleRes=#");
                writer.print(Integer.toHexString(this.mBreadCrumbTitleRes));
                writer.print(" mBreadCrumbTitleText=");
                writer.println(this.mBreadCrumbTitleText);
            }
            if (this.mBreadCrumbShortTitleRes != 0 || this.mBreadCrumbShortTitleText != null) {
                writer.print(prefix);
                writer.print("mBreadCrumbShortTitleRes=#");
                writer.print(Integer.toHexString(this.mBreadCrumbShortTitleRes));
                writer.print(" mBreadCrumbShortTitleText=");
                writer.println(this.mBreadCrumbShortTitleText);
            }
        }
        if (this.mHead != null) {
            writer.print(prefix);
            writer.println("Operations:");
            String innerPrefix = prefix + "    ";
            Op op = this.mHead;
            int num = 0;
            while (op != null) {
                String cmdStr;
                switch (op.cmd) {
                    case 0: {
                        cmdStr = "NULL";
                        break;
                    }
                    case 1: {
                        cmdStr = "ADD";
                        break;
                    }
                    case 2: {
                        cmdStr = "REPLACE";
                        break;
                    }
                    case 3: {
                        cmdStr = "REMOVE";
                        break;
                    }
                    case 4: {
                        cmdStr = "HIDE";
                        break;
                    }
                    case 5: {
                        cmdStr = "SHOW";
                        break;
                    }
                    case 6: {
                        cmdStr = "DETACH";
                        break;
                    }
                    case 7: {
                        cmdStr = "ATTACH";
                        break;
                    }
                    default: {
                        cmdStr = "cmd=" + op.cmd;
                    }
                }
                writer.print(prefix);
                writer.print("  Op #");
                writer.print(num);
                writer.print(": ");
                writer.print(cmdStr);
                writer.print(" ");
                writer.println(op.fragment);
                if (full) {
                    if (op.enterAnim != 0 || op.exitAnim != 0) {
                        writer.print(innerPrefix);
                        writer.print("enterAnim=#");
                        writer.print(Integer.toHexString(op.enterAnim));
                        writer.print(" exitAnim=#");
                        writer.println(Integer.toHexString(op.exitAnim));
                    }
                    if (op.popEnterAnim != 0 || op.popExitAnim != 0) {
                        writer.print(innerPrefix);
                        writer.print("popEnterAnim=#");
                        writer.print(Integer.toHexString(op.popEnterAnim));
                        writer.print(" popExitAnim=#");
                        writer.println(Integer.toHexString(op.popExitAnim));
                    }
                }
                if (op.removed != null && op.removed.size() > 0) {
                    for (int i = 0; i < op.removed.size(); ++i) {
                        writer.print(innerPrefix);
                        if (op.removed.size() == 1) {
                            writer.print("Removed: ");
                        } else {
                            if (i == 0) {
                                writer.println("Removed:");
                            }
                            writer.print(innerPrefix);
                            writer.print("  #");
                            writer.print(i);
                            writer.print(": ");
                        }
                        writer.println(op.removed.get(i));
                    }
                }
                op = op.next;
                ++num;
            }
        }
    }

    public BackStackRecord(FragmentManagerImpl manager) {
        this.mManager = manager;
    }

    @Override
    public int getId() {
        return this.mIndex;
    }

    @Override
    public int getBreadCrumbTitleRes() {
        return this.mBreadCrumbTitleRes;
    }

    @Override
    public int getBreadCrumbShortTitleRes() {
        return this.mBreadCrumbShortTitleRes;
    }

    @Override
    public CharSequence getBreadCrumbTitle() {
        if (this.mBreadCrumbTitleRes != 0) {
            return this.mManager.mHost.getContext().getText(this.mBreadCrumbTitleRes);
        }
        return this.mBreadCrumbTitleText;
    }

    @Override
    public CharSequence getBreadCrumbShortTitle() {
        if (this.mBreadCrumbShortTitleRes != 0) {
            return this.mManager.mHost.getContext().getText(this.mBreadCrumbShortTitleRes);
        }
        return this.mBreadCrumbShortTitleText;
    }

    void addOp(Op op) {
        if (this.mHead == null) {
            this.mHead = this.mTail = op;
        } else {
            op.prev = this.mTail;
            this.mTail.next = op;
            this.mTail = op;
        }
        op.enterAnim = this.mEnterAnim;
        op.exitAnim = this.mExitAnim;
        op.popEnterAnim = this.mPopEnterAnim;
        op.popExitAnim = this.mPopExitAnim;
        ++this.mNumOp;
    }

    @Override
    public FragmentTransaction add(Fragment fragment, String tag) {
        this.doAddOp(0, fragment, tag, 1);
        return this;
    }

    @Override
    public FragmentTransaction add(int containerViewId, Fragment fragment) {
        this.doAddOp(containerViewId, fragment, null, 1);
        return this;
    }

    @Override
    public FragmentTransaction add(int containerViewId, Fragment fragment, String tag) {
        this.doAddOp(containerViewId, fragment, tag, 1);
        return this;
    }

    private void doAddOp(int containerViewId, Fragment fragment, String tag, int opcmd) {
        fragment.mFragmentManager = this.mManager;
        if (tag != null) {
            if (fragment.mTag != null && !tag.equals(fragment.mTag)) {
                throw new IllegalStateException("Can't change tag of fragment " + fragment + ": was " + fragment.mTag + " now " + tag);
            }
            fragment.mTag = tag;
        }
        if (containerViewId != 0) {
            if (containerViewId == -1) {
                throw new IllegalArgumentException("Can't add fragment " + fragment + " with tag " + tag + " to container view with no id");
            }
            if (fragment.mFragmentId != 0 && fragment.mFragmentId != containerViewId) {
                throw new IllegalStateException("Can't change container ID of fragment " + fragment + ": was " + fragment.mFragmentId + " now " + containerViewId);
            }
            fragment.mContainerId = fragment.mFragmentId = containerViewId;
        }
        Op op = new Op();
        op.cmd = opcmd;
        op.fragment = fragment;
        this.addOp(op);
    }

    @Override
    public FragmentTransaction replace(int containerViewId, Fragment fragment) {
        return this.replace(containerViewId, fragment, null);
    }

    @Override
    public FragmentTransaction replace(int containerViewId, Fragment fragment, String tag) {
        if (containerViewId == 0) {
            throw new IllegalArgumentException("Must use non-zero containerViewId");
        }
        this.doAddOp(containerViewId, fragment, tag, 2);
        return this;
    }

    @Override
    public FragmentTransaction remove(Fragment fragment) {
        Op op = new Op();
        op.cmd = 3;
        op.fragment = fragment;
        this.addOp(op);
        return this;
    }

    @Override
    public FragmentTransaction hide(Fragment fragment) {
        Op op = new Op();
        op.cmd = 4;
        op.fragment = fragment;
        this.addOp(op);
        return this;
    }

    @Override
    public FragmentTransaction show(Fragment fragment) {
        Op op = new Op();
        op.cmd = 5;
        op.fragment = fragment;
        this.addOp(op);
        return this;
    }

    @Override
    public FragmentTransaction detach(Fragment fragment) {
        Op op = new Op();
        op.cmd = 6;
        op.fragment = fragment;
        this.addOp(op);
        return this;
    }

    @Override
    public FragmentTransaction attach(Fragment fragment) {
        Op op = new Op();
        op.cmd = 7;
        op.fragment = fragment;
        this.addOp(op);
        return this;
    }

    @Override
    public FragmentTransaction setCustomAnimations(int enter, int exit) {
        return this.setCustomAnimations(enter, exit, 0, 0);
    }

    @Override
    public FragmentTransaction setCustomAnimations(int enter, int exit, int popEnter, int popExit) {
        this.mEnterAnim = enter;
        this.mExitAnim = exit;
        this.mPopEnterAnim = popEnter;
        this.mPopExitAnim = popExit;
        return this;
    }

    @Override
    public FragmentTransaction setTransition(int transition2) {
        this.mTransition = transition2;
        return this;
    }

    @Override
    public FragmentTransaction addSharedElement(View sharedElement, String name) {
        String transitionName = sharedElement.getTransitionName();
        if (transitionName == null) {
            throw new IllegalArgumentException("Unique transitionNames are required for all sharedElements");
        }
        if (this.mSharedElementSourceNames == null) {
            this.mSharedElementSourceNames = new ArrayList();
            this.mSharedElementTargetNames = new ArrayList();
        }
        this.mSharedElementSourceNames.add(transitionName);
        this.mSharedElementTargetNames.add(name);
        return this;
    }

    @Override
    public FragmentTransaction setTransitionStyle(int styleRes) {
        this.mTransitionStyle = styleRes;
        return this;
    }

    @Override
    public FragmentTransaction addToBackStack(String name) {
        if (!this.mAllowAddToBackStack) {
            throw new IllegalStateException("This FragmentTransaction is not allowed to be added to the back stack.");
        }
        this.mAddToBackStack = true;
        this.mName = name;
        return this;
    }

    @Override
    public boolean isAddToBackStackAllowed() {
        return this.mAllowAddToBackStack;
    }

    @Override
    public FragmentTransaction disallowAddToBackStack() {
        if (this.mAddToBackStack) {
            throw new IllegalStateException("This transaction is already being added to the back stack");
        }
        this.mAllowAddToBackStack = false;
        return this;
    }

    @Override
    public FragmentTransaction setBreadCrumbTitle(int res) {
        this.mBreadCrumbTitleRes = res;
        this.mBreadCrumbTitleText = null;
        return this;
    }

    @Override
    public FragmentTransaction setBreadCrumbTitle(CharSequence text) {
        this.mBreadCrumbTitleRes = 0;
        this.mBreadCrumbTitleText = text;
        return this;
    }

    @Override
    public FragmentTransaction setBreadCrumbShortTitle(int res) {
        this.mBreadCrumbShortTitleRes = res;
        this.mBreadCrumbShortTitleText = null;
        return this;
    }

    @Override
    public FragmentTransaction setBreadCrumbShortTitle(CharSequence text) {
        this.mBreadCrumbShortTitleRes = 0;
        this.mBreadCrumbShortTitleText = text;
        return this;
    }

    void bumpBackStackNesting(int amt) {
        if (!this.mAddToBackStack) {
            return;
        }
        if (FragmentManagerImpl.DEBUG) {
            Log.v(TAG, "Bump nesting in " + this + " by " + amt);
        }
        Op op = this.mHead;
        while (op != null) {
            if (op.fragment != null) {
                op.fragment.mBackStackNesting += amt;
                if (FragmentManagerImpl.DEBUG) {
                    Log.v(TAG, "Bump nesting of " + op.fragment + " to " + op.fragment.mBackStackNesting);
                }
            }
            if (op.removed != null) {
                for (int i = op.removed.size() - 1; i >= 0; --i) {
                    Fragment r = op.removed.get(i);
                    r.mBackStackNesting += amt;
                    if (!FragmentManagerImpl.DEBUG) continue;
                    Log.v(TAG, "Bump nesting of " + r + " to " + r.mBackStackNesting);
                }
            }
            op = op.next;
        }
    }

    @Override
    public int commit() {
        return this.commitInternal(false);
    }

    @Override
    public int commitAllowingStateLoss() {
        return this.commitInternal(true);
    }

    @Override
    public void commitNow() {
        this.disallowAddToBackStack();
        this.mManager.execSingleAction(this, false);
    }

    @Override
    public void commitNowAllowingStateLoss() {
        this.disallowAddToBackStack();
        this.mManager.execSingleAction(this, true);
    }

    int commitInternal(boolean allowStateLoss) {
        if (this.mCommitted) {
            throw new IllegalStateException("commit already called");
        }
        if (FragmentManagerImpl.DEBUG) {
            Log.v(TAG, "Commit: " + this);
            LogWriter logw = new LogWriter(2, TAG);
            FastPrintWriter pw = new FastPrintWriter(logw, false, 1024);
            this.dump("  ", null, pw, null);
            ((PrintWriter)pw).flush();
        }
        this.mCommitted = true;
        this.mIndex = this.mAddToBackStack ? this.mManager.allocBackStackIndex(this) : -1;
        this.mManager.enqueueAction(this, allowStateLoss);
        return this.mIndex;
    }

    @Override
    public void run() {
        if (FragmentManagerImpl.DEBUG) {
            Log.v(TAG, "Run: " + this);
        }
        if (this.mAddToBackStack && this.mIndex < 0) {
            throw new IllegalStateException("addToBackStack() called after commit()");
        }
        this.bumpBackStackNesting(1);
        if (this.mManager.mCurState >= 1) {
            SparseArray<Fragment> firstOutFragments = new SparseArray<Fragment>();
            SparseArray<Fragment> lastInFragments = new SparseArray<Fragment>();
            this.calculateFragments(firstOutFragments, lastInFragments);
            this.beginTransition(firstOutFragments, lastInFragments, false);
        }
        Op op = this.mHead;
        while (op != null) {
            switch (op.cmd) {
                case 1: {
                    Fragment f = op.fragment;
                    f.mNextAnim = op.enterAnim;
                    this.mManager.addFragment(f, false);
                    break;
                }
                case 2: {
                    Fragment f = op.fragment;
                    int containerId = f.mContainerId;
                    if (this.mManager.mAdded != null) {
                        for (int i = this.mManager.mAdded.size() - 1; i >= 0; --i) {
                            Fragment old = this.mManager.mAdded.get(i);
                            if (FragmentManagerImpl.DEBUG) {
                                Log.v(TAG, "OP_REPLACE: adding=" + f + " old=" + old);
                            }
                            if (old.mContainerId != containerId) continue;
                            if (old == f) {
                                f = null;
                                op.fragment = null;
                                continue;
                            }
                            if (op.removed == null) {
                                op.removed = new ArrayList();
                            }
                            op.removed.add(old);
                            old.mNextAnim = op.exitAnim;
                            if (this.mAddToBackStack) {
                                ++old.mBackStackNesting;
                                if (FragmentManagerImpl.DEBUG) {
                                    Log.v(TAG, "Bump nesting of " + old + " to " + old.mBackStackNesting);
                                }
                            }
                            this.mManager.removeFragment(old, this.mTransition, this.mTransitionStyle);
                        }
                    }
                    if (f == null) break;
                    f.mNextAnim = op.enterAnim;
                    this.mManager.addFragment(f, false);
                    break;
                }
                case 3: {
                    Fragment f = op.fragment;
                    f.mNextAnim = op.exitAnim;
                    this.mManager.removeFragment(f, this.mTransition, this.mTransitionStyle);
                    break;
                }
                case 4: {
                    Fragment f = op.fragment;
                    f.mNextAnim = op.exitAnim;
                    this.mManager.hideFragment(f, this.mTransition, this.mTransitionStyle);
                    break;
                }
                case 5: {
                    Fragment f = op.fragment;
                    f.mNextAnim = op.enterAnim;
                    this.mManager.showFragment(f, this.mTransition, this.mTransitionStyle);
                    break;
                }
                case 6: {
                    Fragment f = op.fragment;
                    f.mNextAnim = op.exitAnim;
                    this.mManager.detachFragment(f, this.mTransition, this.mTransitionStyle);
                    break;
                }
                case 7: {
                    Fragment f = op.fragment;
                    f.mNextAnim = op.enterAnim;
                    this.mManager.attachFragment(f, this.mTransition, this.mTransitionStyle);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown cmd: " + op.cmd);
                }
            }
            op = op.next;
        }
        this.mManager.moveToState(this.mManager.mCurState, this.mTransition, this.mTransitionStyle, true);
        if (this.mAddToBackStack) {
            this.mManager.addBackStackState(this);
        }
    }

    private static void setFirstOut(SparseArray<Fragment> firstOutFragments, SparseArray<Fragment> lastInFragments, Fragment fragment) {
        int containerId;
        if (fragment != null && (containerId = fragment.mContainerId) != 0 && !fragment.isHidden()) {
            if (fragment.isAdded() && fragment.getView() != null && firstOutFragments.get(containerId) == null) {
                firstOutFragments.put(containerId, fragment);
            }
            if (lastInFragments.get(containerId) == fragment) {
                lastInFragments.remove(containerId);
            }
        }
    }

    private void setLastIn(SparseArray<Fragment> firstOutFragments, SparseArray<Fragment> lastInFragments, Fragment fragment) {
        if (fragment != null) {
            int containerId = fragment.mContainerId;
            if (containerId != 0) {
                if (!fragment.isAdded()) {
                    lastInFragments.put(containerId, fragment);
                }
                if (firstOutFragments.get(containerId) == fragment) {
                    firstOutFragments.remove(containerId);
                }
            }
            if (fragment.mState < 1 && this.mManager.mCurState >= 1 && this.mManager.mHost.getContext().getApplicationInfo().targetSdkVersion >= 24) {
                this.mManager.makeActive(fragment);
                this.mManager.moveToState(fragment, 1, 0, 0, false);
            }
        }
    }

    private void calculateFragments(SparseArray<Fragment> firstOutFragments, SparseArray<Fragment> lastInFragments) {
        if (!this.mManager.mContainer.onHasView()) {
            return;
        }
        Op op = this.mHead;
        while (op != null) {
            switch (op.cmd) {
                case 1: {
                    this.setLastIn(firstOutFragments, lastInFragments, op.fragment);
                    break;
                }
                case 2: {
                    Fragment f = op.fragment;
                    if (this.mManager.mAdded != null) {
                        for (int i = 0; i < this.mManager.mAdded.size(); ++i) {
                            Fragment old = this.mManager.mAdded.get(i);
                            if (f != null && old.mContainerId != f.mContainerId) continue;
                            if (old == f) {
                                f = null;
                                lastInFragments.remove(old.mContainerId);
                                continue;
                            }
                            BackStackRecord.setFirstOut(firstOutFragments, lastInFragments, old);
                        }
                    }
                    this.setLastIn(firstOutFragments, lastInFragments, op.fragment);
                    break;
                }
                case 3: {
                    BackStackRecord.setFirstOut(firstOutFragments, lastInFragments, op.fragment);
                    break;
                }
                case 4: {
                    BackStackRecord.setFirstOut(firstOutFragments, lastInFragments, op.fragment);
                    break;
                }
                case 5: {
                    this.setLastIn(firstOutFragments, lastInFragments, op.fragment);
                    break;
                }
                case 6: {
                    BackStackRecord.setFirstOut(firstOutFragments, lastInFragments, op.fragment);
                    break;
                }
                case 7: {
                    this.setLastIn(firstOutFragments, lastInFragments, op.fragment);
                }
            }
            op = op.next;
        }
    }

    public void calculateBackFragments(SparseArray<Fragment> firstOutFragments, SparseArray<Fragment> lastInFragments) {
        if (!this.mManager.mContainer.onHasView()) {
            return;
        }
        Op op = this.mTail;
        while (op != null) {
            switch (op.cmd) {
                case 1: {
                    BackStackRecord.setFirstOut(firstOutFragments, lastInFragments, op.fragment);
                    break;
                }
                case 2: {
                    if (op.removed != null) {
                        for (int i = op.removed.size() - 1; i >= 0; --i) {
                            this.setLastIn(firstOutFragments, lastInFragments, op.removed.get(i));
                        }
                    }
                    BackStackRecord.setFirstOut(firstOutFragments, lastInFragments, op.fragment);
                    break;
                }
                case 3: {
                    this.setLastIn(firstOutFragments, lastInFragments, op.fragment);
                    break;
                }
                case 4: {
                    this.setLastIn(firstOutFragments, lastInFragments, op.fragment);
                    break;
                }
                case 5: {
                    BackStackRecord.setFirstOut(firstOutFragments, lastInFragments, op.fragment);
                    break;
                }
                case 6: {
                    this.setLastIn(firstOutFragments, lastInFragments, op.fragment);
                    break;
                }
                case 7: {
                    BackStackRecord.setFirstOut(firstOutFragments, lastInFragments, op.fragment);
                }
            }
            op = op.prev;
        }
    }

    private TransitionState beginTransition(SparseArray<Fragment> firstOutFragments, SparseArray<Fragment> lastInFragments, boolean isBack) {
        int containerId;
        int i;
        TransitionState state = new TransitionState();
        state.nonExistentView = new View(this.mManager.mHost.getContext());
        for (i = 0; i < firstOutFragments.size(); ++i) {
            containerId = firstOutFragments.keyAt(i);
            this.configureTransitions(containerId, state, isBack, firstOutFragments, lastInFragments);
        }
        for (i = 0; i < lastInFragments.size(); ++i) {
            containerId = lastInFragments.keyAt(i);
            if (firstOutFragments.get(containerId) != null) continue;
            this.configureTransitions(containerId, state, isBack, firstOutFragments, lastInFragments);
        }
        return state;
    }

    private static Transition cloneTransition(Transition transition2) {
        if (transition2 != null) {
            transition2 = transition2.clone();
        }
        return transition2;
    }

    private static Transition getEnterTransition(Fragment inFragment, boolean isBack) {
        if (inFragment == null) {
            return null;
        }
        return BackStackRecord.cloneTransition(isBack ? inFragment.getReenterTransition() : inFragment.getEnterTransition());
    }

    private static Transition getExitTransition(Fragment outFragment, boolean isBack) {
        if (outFragment == null) {
            return null;
        }
        return BackStackRecord.cloneTransition(isBack ? outFragment.getReturnTransition() : outFragment.getExitTransition());
    }

    private static TransitionSet getSharedElementTransition(Fragment inFragment, Fragment outFragment, boolean isBack) {
        if (inFragment == null || outFragment == null) {
            return null;
        }
        Transition transition2 = BackStackRecord.cloneTransition(isBack ? outFragment.getSharedElementReturnTransition() : inFragment.getSharedElementEnterTransition());
        if (transition2 == null) {
            return null;
        }
        TransitionSet transitionSet = new TransitionSet();
        transitionSet.addTransition(transition2);
        return transitionSet;
    }

    private static ArrayList<View> captureExitingViews(Transition exitTransition, Fragment outFragment, ArrayMap<String, View> namedViews, View nonExistentView) {
        ArrayList<View> viewList = null;
        if (exitTransition != null) {
            viewList = new ArrayList<View>();
            View root = outFragment.getView();
            root.captureTransitioningViews(viewList);
            if (namedViews != null) {
                viewList.removeAll(namedViews.values());
            }
            if (!viewList.isEmpty()) {
                viewList.add(nonExistentView);
                BackStackRecord.addTargets(exitTransition, viewList);
            }
        }
        return viewList;
    }

    private ArrayMap<String, View> remapSharedElements(TransitionState state, Fragment outFragment, boolean isBack) {
        ArrayMap<String, View> namedViews = new ArrayMap<String, View>();
        if (this.mSharedElementSourceNames != null) {
            outFragment.getView().findNamedViews(namedViews);
            if (isBack) {
                namedViews.retainAll(this.mSharedElementTargetNames);
            } else {
                namedViews = BackStackRecord.remapNames(this.mSharedElementSourceNames, this.mSharedElementTargetNames, namedViews);
            }
        }
        if (isBack) {
            outFragment.mEnterTransitionCallback.onMapSharedElements(this.mSharedElementTargetNames, namedViews);
            this.setBackNameOverrides(state, namedViews, false);
        } else {
            outFragment.mExitTransitionCallback.onMapSharedElements(this.mSharedElementTargetNames, namedViews);
            this.setNameOverrides(state, namedViews, false);
        }
        return namedViews;
    }

    private ArrayList<View> addTransitionTargets(final TransitionState state, final Transition enterTransition, final TransitionSet sharedElementTransition, final Transition exitTransition, final Transition overallTransition, final View container, final Fragment inFragment, final Fragment outFragment, final ArrayList<View> hiddenFragmentViews, final boolean isBack, final ArrayList<View> sharedElementTargets) {
        if (enterTransition == null && sharedElementTransition == null && overallTransition == null) {
            return null;
        }
        final ArrayList<View> enteringViews = new ArrayList<View>();
        container.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            @Override
            public boolean onPreDraw() {
                container.getViewTreeObserver().removeOnPreDrawListener(this);
                if (inFragment != null) {
                    BackStackRecord.this.excludeHiddenFragments(hiddenFragmentViews, inFragment.mContainerId, overallTransition);
                }
                ArrayMap namedViews = null;
                if (sharedElementTransition != null) {
                    namedViews = BackStackRecord.this.mapSharedElementsIn(state, isBack, inFragment);
                    BackStackRecord.removeTargets(sharedElementTransition, sharedElementTargets);
                    sharedElementTargets.remove(state.nonExistentView);
                    BackStackRecord.excludeViews(exitTransition, sharedElementTransition, sharedElementTargets, false);
                    BackStackRecord.excludeViews(enterTransition, sharedElementTransition, sharedElementTargets, false);
                    BackStackRecord.setSharedElementTargets(sharedElementTransition, state.nonExistentView, namedViews, sharedElementTargets);
                    BackStackRecord.this.setEpicenterIn(namedViews, state);
                    BackStackRecord.this.callSharedElementEnd(state, inFragment, outFragment, isBack, namedViews);
                }
                if (enterTransition != null) {
                    enterTransition.removeTarget(state.nonExistentView);
                    View view = inFragment.getView();
                    if (view != null) {
                        view.captureTransitioningViews(enteringViews);
                        if (namedViews != null) {
                            enteringViews.removeAll(namedViews.values());
                        }
                        enteringViews.add(state.nonExistentView);
                        BackStackRecord.addTargets(enterTransition, enteringViews);
                    }
                    BackStackRecord.this.setSharedElementEpicenter(enterTransition, state);
                }
                BackStackRecord.excludeViews(exitTransition, enterTransition, enteringViews, true);
                BackStackRecord.excludeViews(exitTransition, sharedElementTransition, sharedElementTargets, true);
                BackStackRecord.excludeViews(enterTransition, sharedElementTransition, sharedElementTargets, true);
                return true;
            }
        });
        return enteringViews;
    }

    private void callSharedElementEnd(TransitionState state, Fragment inFragment, Fragment outFragment, boolean isBack, ArrayMap<String, View> namedViews) {
        SharedElementCallback sharedElementCallback = isBack ? outFragment.mEnterTransitionCallback : inFragment.mEnterTransitionCallback;
        ArrayList<String> names = new ArrayList<String>(namedViews.keySet());
        ArrayList<View> views = new ArrayList<View>(namedViews.values());
        sharedElementCallback.onSharedElementEnd(names, views, null);
    }

    private void setEpicenterIn(ArrayMap<String, View> namedViews, TransitionState state) {
        View epicenter;
        if (this.mSharedElementTargetNames != null && !namedViews.isEmpty() && (epicenter = namedViews.get(this.mSharedElementTargetNames.get(0))) != null) {
            state.enteringEpicenterView = epicenter;
        }
    }

    private ArrayMap<String, View> mapSharedElementsIn(TransitionState state, boolean isBack, Fragment inFragment) {
        ArrayMap<String, View> namedViews = this.mapEnteringSharedElements(state, inFragment, isBack);
        if (isBack) {
            inFragment.mExitTransitionCallback.onMapSharedElements(this.mSharedElementTargetNames, namedViews);
            this.setBackNameOverrides(state, namedViews, true);
        } else {
            inFragment.mEnterTransitionCallback.onMapSharedElements(this.mSharedElementTargetNames, namedViews);
            this.setNameOverrides(state, namedViews, true);
        }
        return namedViews;
    }

    private static Transition mergeTransitions(Transition enterTransition, Transition exitTransition, Transition sharedElementTransition, Fragment inFragment, boolean isBack) {
        Transition transition2;
        boolean overlap = true;
        if (enterTransition != null && exitTransition != null && inFragment != null) {
            boolean bl = overlap = isBack ? inFragment.getAllowReturnTransitionOverlap() : inFragment.getAllowEnterTransitionOverlap();
        }
        if (overlap) {
            TransitionSet transitionSet = new TransitionSet();
            if (enterTransition != null) {
                transitionSet.addTransition(enterTransition);
            }
            if (exitTransition != null) {
                transitionSet.addTransition(exitTransition);
            }
            if (sharedElementTransition != null) {
                transitionSet.addTransition(sharedElementTransition);
            }
            transition2 = transitionSet;
        } else {
            Transition staggered = null;
            if (exitTransition != null && enterTransition != null) {
                staggered = new TransitionSet().addTransition(exitTransition).addTransition(enterTransition).setOrdering(1);
            } else if (exitTransition != null) {
                staggered = exitTransition;
            } else if (enterTransition != null) {
                staggered = enterTransition;
            }
            if (sharedElementTransition != null) {
                TransitionSet together = new TransitionSet();
                if (staggered != null) {
                    together.addTransition(staggered);
                }
                together.addTransition(sharedElementTransition);
                transition2 = together;
            } else {
                transition2 = staggered;
            }
        }
        return transition2;
    }

    private void configureTransitions(int containerId, TransitionState state, boolean isBack, SparseArray<Fragment> firstOutFragments, SparseArray<Fragment> lastInFragments) {
        ViewGroup sceneRoot = (ViewGroup)this.mManager.mContainer.onFindViewById(containerId);
        if (sceneRoot != null) {
            Transition transition2;
            View epicenterView;
            ArrayList<View> exitingViews;
            Fragment inFragment = lastInFragments.get(containerId);
            Fragment outFragment = firstOutFragments.get(containerId);
            Transition enterTransition = BackStackRecord.getEnterTransition(inFragment, isBack);
            TransitionSet sharedElementTransition = BackStackRecord.getSharedElementTransition(inFragment, outFragment, isBack);
            Transition exitTransition = BackStackRecord.getExitTransition(outFragment, isBack);
            if (enterTransition == null && sharedElementTransition == null && exitTransition == null) {
                return;
            }
            if (enterTransition != null) {
                enterTransition.addTarget(state.nonExistentView);
            }
            ArrayMap<String, View> namedViews = null;
            ArrayList<View> sharedElementTargets = new ArrayList<View>();
            if (sharedElementTransition != null) {
                namedViews = this.remapSharedElements(state, outFragment, isBack);
                BackStackRecord.setSharedElementTargets(sharedElementTransition, state.nonExistentView, namedViews, sharedElementTargets);
                SharedElementCallback callback = isBack ? outFragment.mEnterTransitionCallback : inFragment.mEnterTransitionCallback;
                ArrayList<String> names = new ArrayList<String>(namedViews.keySet());
                ArrayList<View> views = new ArrayList<View>(namedViews.values());
                callback.onSharedElementStart(names, views, null);
            }
            if ((exitingViews = BackStackRecord.captureExitingViews(exitTransition, outFragment, namedViews, state.nonExistentView)) == null || exitingViews.isEmpty()) {
                exitTransition = null;
            }
            BackStackRecord.excludeViews(enterTransition, exitTransition, exitingViews, true);
            BackStackRecord.excludeViews(enterTransition, sharedElementTransition, sharedElementTargets, true);
            BackStackRecord.excludeViews(exitTransition, sharedElementTransition, sharedElementTargets, true);
            if (this.mSharedElementTargetNames != null && namedViews != null && (epicenterView = namedViews.get(this.mSharedElementTargetNames.get(0))) != null) {
                if (exitTransition != null) {
                    BackStackRecord.setEpicenter(exitTransition, epicenterView);
                }
                if (sharedElementTransition != null) {
                    BackStackRecord.setEpicenter(sharedElementTransition, epicenterView);
                }
            }
            if ((transition2 = BackStackRecord.mergeTransitions(enterTransition, exitTransition, sharedElementTransition, inFragment, isBack)) != null) {
                ArrayList<View> hiddenFragments = new ArrayList<View>();
                ArrayList<View> enteringViews = this.addTransitionTargets(state, enterTransition, sharedElementTransition, exitTransition, transition2, sceneRoot, inFragment, outFragment, hiddenFragments, isBack, sharedElementTargets);
                transition2.setNameOverrides(state.nameOverrides);
                transition2.excludeTarget(state.nonExistentView, true);
                this.excludeHiddenFragments(hiddenFragments, containerId, transition2);
                TransitionManager.beginDelayedTransition(sceneRoot, transition2);
                this.removeTargetedViewsFromTransitions(sceneRoot, state.nonExistentView, enterTransition, enteringViews, exitTransition, exitingViews, sharedElementTransition, sharedElementTargets, transition2, hiddenFragments);
            }
        }
    }

    private static void setSharedElementTargets(TransitionSet transition2, View nonExistentView, ArrayMap<String, View> namedViews, ArrayList<View> sharedElementTargets) {
        sharedElementTargets.clear();
        sharedElementTargets.addAll(namedViews.values());
        List<View> views = transition2.getTargets();
        views.clear();
        int count = sharedElementTargets.size();
        for (int i = 0; i < count; ++i) {
            View view = sharedElementTargets.get(i);
            BackStackRecord.bfsAddViewChildren(views, view);
        }
        sharedElementTargets.add(nonExistentView);
        BackStackRecord.addTargets(transition2, sharedElementTargets);
    }

    private static void bfsAddViewChildren(List<View> views, View startView) {
        int startIndex = views.size();
        if (BackStackRecord.containedBeforeIndex(views, startView, startIndex)) {
            return;
        }
        views.add(startView);
        for (int index = startIndex; index < views.size(); ++index) {
            View view = views.get(index);
            if (!(view instanceof ViewGroup)) continue;
            ViewGroup viewGroup = (ViewGroup)view;
            int childCount = viewGroup.getChildCount();
            for (int childIndex = 0; childIndex < childCount; ++childIndex) {
                View child = viewGroup.getChildAt(childIndex);
                if (BackStackRecord.containedBeforeIndex(views, child, startIndex)) continue;
                views.add(child);
            }
        }
    }

    private static boolean containedBeforeIndex(List<View> views, View view, int maxIndex) {
        for (int i = 0; i < maxIndex; ++i) {
            if (views.get(i) != view) continue;
            return true;
        }
        return false;
    }

    private static void excludeViews(Transition transition2, Transition fromTransition, ArrayList<View> views, boolean exclude) {
        if (transition2 != null) {
            int viewCount = fromTransition == null ? 0 : views.size();
            for (int i = 0; i < viewCount; ++i) {
                transition2.excludeTarget(views.get(i), exclude);
            }
        }
    }

    private void removeTargetedViewsFromTransitions(final ViewGroup sceneRoot, final View nonExistingView, final Transition enterTransition, final ArrayList<View> enteringViews, final Transition exitTransition, final ArrayList<View> exitingViews, final Transition sharedElementTransition, final ArrayList<View> sharedElementTargets, final Transition overallTransition, final ArrayList<View> hiddenViews) {
        if (overallTransition != null) {
            sceneRoot.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                @Override
                public boolean onPreDraw() {
                    sceneRoot.getViewTreeObserver().removeOnPreDrawListener(this);
                    if (enterTransition != null) {
                        BackStackRecord.removeTargets(enterTransition, enteringViews);
                        BackStackRecord.excludeViews(enterTransition, exitTransition, exitingViews, false);
                        BackStackRecord.excludeViews(enterTransition, sharedElementTransition, sharedElementTargets, false);
                    }
                    if (exitTransition != null) {
                        BackStackRecord.removeTargets(exitTransition, exitingViews);
                        BackStackRecord.excludeViews(exitTransition, enterTransition, enteringViews, false);
                        BackStackRecord.excludeViews(exitTransition, sharedElementTransition, sharedElementTargets, false);
                    }
                    if (sharedElementTransition != null) {
                        BackStackRecord.removeTargets(sharedElementTransition, sharedElementTargets);
                    }
                    int numViews = hiddenViews.size();
                    for (int i = 0; i < numViews; ++i) {
                        overallTransition.excludeTarget((View)hiddenViews.get(i), false);
                    }
                    overallTransition.excludeTarget(nonExistingView, false);
                    return true;
                }
            });
        }
    }

    public static void removeTargets(Transition transition2, ArrayList<View> views) {
        block3: {
            List<View> targets;
            block2: {
                if (!(transition2 instanceof TransitionSet)) break block2;
                TransitionSet set = (TransitionSet)transition2;
                int numTransitions = set.getTransitionCount();
                for (int i = 0; i < numTransitions; ++i) {
                    Transition child = set.getTransitionAt(i);
                    BackStackRecord.removeTargets(child, views);
                }
                break block3;
            }
            if (BackStackRecord.hasSimpleTarget(transition2) || (targets = transition2.getTargets()) == null || targets.size() != views.size() || !targets.containsAll(views)) break block3;
            for (int i = views.size() - 1; i >= 0; --i) {
                transition2.removeTarget(views.get(i));
            }
        }
    }

    public static void addTargets(Transition transition2, ArrayList<View> views) {
        block3: {
            List<View> targets;
            block2: {
                if (!(transition2 instanceof TransitionSet)) break block2;
                TransitionSet set = (TransitionSet)transition2;
                int numTransitions = set.getTransitionCount();
                for (int i = 0; i < numTransitions; ++i) {
                    Transition child = set.getTransitionAt(i);
                    BackStackRecord.addTargets(child, views);
                }
                break block3;
            }
            if (BackStackRecord.hasSimpleTarget(transition2) || !BackStackRecord.isNullOrEmpty(targets = transition2.getTargets())) break block3;
            int numViews = views.size();
            for (int i = 0; i < numViews; ++i) {
                transition2.addTarget(views.get(i));
            }
        }
    }

    private static boolean hasSimpleTarget(Transition transition2) {
        return !BackStackRecord.isNullOrEmpty(transition2.getTargetIds()) || !BackStackRecord.isNullOrEmpty(transition2.getTargetNames()) || !BackStackRecord.isNullOrEmpty(transition2.getTargetTypes());
    }

    private static boolean isNullOrEmpty(List list) {
        return list == null || list.isEmpty();
    }

    private static ArrayMap<String, View> remapNames(ArrayList<String> inMap, ArrayList<String> toGoInMap, ArrayMap<String, View> namedViews) {
        ArrayMap<String, View> remappedViews = new ArrayMap<String, View>();
        if (!namedViews.isEmpty()) {
            int numKeys = inMap.size();
            for (int i = 0; i < numKeys; ++i) {
                View view = namedViews.get(inMap.get(i));
                if (view == null) continue;
                remappedViews.put(toGoInMap.get(i), view);
            }
        }
        return remappedViews;
    }

    private ArrayMap<String, View> mapEnteringSharedElements(TransitionState state, Fragment inFragment, boolean isBack) {
        ArrayMap<String, View> namedViews = new ArrayMap<String, View>();
        View root = inFragment.getView();
        if (root != null && this.mSharedElementSourceNames != null) {
            root.findNamedViews(namedViews);
            if (isBack) {
                namedViews = BackStackRecord.remapNames(this.mSharedElementSourceNames, this.mSharedElementTargetNames, namedViews);
            } else {
                namedViews.retainAll(this.mSharedElementTargetNames);
            }
        }
        return namedViews;
    }

    private void excludeHiddenFragments(ArrayList<View> hiddenFragmentViews, int containerId, Transition transition2) {
        if (this.mManager.mAdded != null) {
            for (int i = 0; i < this.mManager.mAdded.size(); ++i) {
                Fragment fragment = this.mManager.mAdded.get(i);
                if (fragment.mView == null || fragment.mContainer == null || fragment.mContainerId != containerId) continue;
                if (fragment.mHidden) {
                    if (hiddenFragmentViews.contains(fragment.mView)) continue;
                    transition2.excludeTarget(fragment.mView, true);
                    hiddenFragmentViews.add(fragment.mView);
                    continue;
                }
                transition2.excludeTarget(fragment.mView, false);
                hiddenFragmentViews.remove(fragment.mView);
            }
        }
    }

    private static void setEpicenter(Transition transition2, View view) {
        final Rect epicenter = new Rect();
        view.getBoundsOnScreen(epicenter);
        transition2.setEpicenterCallback(new Transition.EpicenterCallback(){

            @Override
            public Rect onGetEpicenter(Transition transition2) {
                return epicenter;
            }
        });
    }

    private void setSharedElementEpicenter(Transition transition2, final TransitionState state) {
        transition2.setEpicenterCallback(new Transition.EpicenterCallback(){
            private Rect mEpicenter;

            @Override
            public Rect onGetEpicenter(Transition transition2) {
                if (this.mEpicenter == null && state.enteringEpicenterView != null) {
                    this.mEpicenter = new Rect();
                    state.enteringEpicenterView.getBoundsOnScreen(this.mEpicenter);
                }
                return this.mEpicenter;
            }
        });
    }

    public TransitionState popFromBackStack(boolean doStateMove, TransitionState state, SparseArray<Fragment> firstOutFragments, SparseArray<Fragment> lastInFragments) {
        if (FragmentManagerImpl.DEBUG) {
            Log.v(TAG, "popFromBackStack: " + this);
            LogWriter logw = new LogWriter(2, TAG);
            FastPrintWriter pw = new FastPrintWriter(logw, false, 1024);
            this.dump("  ", null, pw, null);
            ((PrintWriter)pw).flush();
        }
        if (this.mManager.mCurState >= 1) {
            if (state == null) {
                if (firstOutFragments.size() != 0 || lastInFragments.size() != 0) {
                    state = this.beginTransition(firstOutFragments, lastInFragments, true);
                }
            } else if (!doStateMove) {
                BackStackRecord.setNameOverrides(state, this.mSharedElementTargetNames, this.mSharedElementSourceNames);
            }
        }
        this.bumpBackStackNesting(-1);
        Op op = this.mTail;
        while (op != null) {
            switch (op.cmd) {
                case 1: {
                    Fragment f = op.fragment;
                    f.mNextAnim = op.popExitAnim;
                    this.mManager.removeFragment(f, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle);
                    break;
                }
                case 2: {
                    Fragment f = op.fragment;
                    if (f != null) {
                        f.mNextAnim = op.popExitAnim;
                        this.mManager.removeFragment(f, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle);
                    }
                    if (op.removed == null) break;
                    for (int i = 0; i < op.removed.size(); ++i) {
                        Fragment old = op.removed.get(i);
                        old.mNextAnim = op.popEnterAnim;
                        this.mManager.addFragment(old, false);
                    }
                    break;
                }
                case 3: {
                    Fragment f = op.fragment;
                    f.mNextAnim = op.popEnterAnim;
                    this.mManager.addFragment(f, false);
                    break;
                }
                case 4: {
                    Fragment f = op.fragment;
                    f.mNextAnim = op.popEnterAnim;
                    this.mManager.showFragment(f, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle);
                    break;
                }
                case 5: {
                    Fragment f = op.fragment;
                    f.mNextAnim = op.popExitAnim;
                    this.mManager.hideFragment(f, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle);
                    break;
                }
                case 6: {
                    Fragment f = op.fragment;
                    f.mNextAnim = op.popEnterAnim;
                    this.mManager.attachFragment(f, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle);
                    break;
                }
                case 7: {
                    Fragment f = op.fragment;
                    f.mNextAnim = op.popExitAnim;
                    this.mManager.detachFragment(f, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown cmd: " + op.cmd);
                }
            }
            op = op.prev;
        }
        if (doStateMove) {
            this.mManager.moveToState(this.mManager.mCurState, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle, true);
            state = null;
        }
        if (this.mIndex >= 0) {
            this.mManager.freeBackStackIndex(this.mIndex);
            this.mIndex = -1;
        }
        return state;
    }

    private static void setNameOverride(ArrayMap<String, String> overrides, String source, String target) {
        if (source != null && target != null && !source.equals(target)) {
            for (int index = 0; index < overrides.size(); ++index) {
                if (!source.equals(overrides.valueAt(index))) continue;
                overrides.setValueAt(index, target);
                return;
            }
            overrides.put(source, target);
        }
    }

    private static void setNameOverrides(TransitionState state, ArrayList<String> sourceNames, ArrayList<String> targetNames) {
        if (sourceNames != null && targetNames != null) {
            for (int i = 0; i < sourceNames.size(); ++i) {
                String source = sourceNames.get(i);
                String target = targetNames.get(i);
                BackStackRecord.setNameOverride(state.nameOverrides, source, target);
            }
        }
    }

    private void setBackNameOverrides(TransitionState state, ArrayMap<String, View> namedViews, boolean isEnd) {
        int targetCount = this.mSharedElementTargetNames == null ? 0 : this.mSharedElementTargetNames.size();
        int sourceCount = this.mSharedElementSourceNames == null ? 0 : this.mSharedElementSourceNames.size();
        int count = Math.min(targetCount, sourceCount);
        for (int i = 0; i < count; ++i) {
            String source = this.mSharedElementSourceNames.get(i);
            String originalTarget = this.mSharedElementTargetNames.get(i);
            View view = namedViews.get(originalTarget);
            if (view == null) continue;
            String target = view.getTransitionName();
            if (isEnd) {
                BackStackRecord.setNameOverride(state.nameOverrides, source, target);
                continue;
            }
            BackStackRecord.setNameOverride(state.nameOverrides, target, source);
        }
    }

    private void setNameOverrides(TransitionState state, ArrayMap<String, View> namedViews, boolean isEnd) {
        int count = namedViews == null ? 0 : namedViews.size();
        for (int i = 0; i < count; ++i) {
            String source = namedViews.keyAt(i);
            String target = namedViews.valueAt(i).getTransitionName();
            if (isEnd) {
                BackStackRecord.setNameOverride(state.nameOverrides, source, target);
                continue;
            }
            BackStackRecord.setNameOverride(state.nameOverrides, target, source);
        }
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public int getTransition() {
        return this.mTransition;
    }

    public int getTransitionStyle() {
        return this.mTransitionStyle;
    }

    @Override
    public boolean isEmpty() {
        return this.mNumOp == 0;
    }

    public class TransitionState {
        public ArrayMap<String, String> nameOverrides = new ArrayMap();
        public View enteringEpicenterView;
        public View nonExistentView;
    }

    static final class Op {
        Op next;
        Op prev;
        int cmd;
        Fragment fragment;
        int enterAnim;
        int exitAnim;
        int popEnterAnim;
        int popExitAnim;
        ArrayList<Fragment> removed;

        Op() {
        }
    }
}

