/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.IEphemeralResolver;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.pm.EphemeralResolveInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IRemoteCallback;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import java.util.List;

public abstract class EphemeralResolverService
extends Service {
    public static final String EXTRA_RESOLVE_INFO = "android.app.extra.RESOLVE_INFO";
    public static final String EXTRA_SEQUENCE = "android.app.extra.SEQUENCE";
    private static final String EXTRA_PREFIX = "android.app.PREFIX";
    private Handler mHandler;

    public abstract List<EphemeralResolveInfo> onEphemeralResolveInfoList(int[] var1, int var2);

    @Override
    public final void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        this.mHandler = new ServiceHandler(base.getMainLooper());
    }

    @Override
    public final IBinder onBind(Intent intent) {
        return new IEphemeralResolver.Stub(){

            @Override
            public void getEphemeralResolveInfoList(IRemoteCallback callback, int[] digestPrefix, int prefixMask, int sequence) {
                Message msg = EphemeralResolverService.this.mHandler.obtainMessage(1, prefixMask, sequence, callback);
                Bundle data = new Bundle();
                data.putIntArray(EphemeralResolverService.EXTRA_PREFIX, digestPrefix);
                msg.setData(data);
                msg.sendToTarget();
            }
        };
    }

    private final class ServiceHandler
    extends Handler {
        public static final int MSG_GET_EPHEMERAL_RESOLVE_INFO = 1;

        public ServiceHandler(Looper looper) {
            super(looper, null, true);
        }

        @Override
        public void handleMessage(Message message) {
            int action = message.what;
            switch (action) {
                case 1: {
                    IRemoteCallback callback = (IRemoteCallback)message.obj;
                    int[] digestPrefix = message.getData().getIntArray(EphemeralResolverService.EXTRA_PREFIX);
                    List<EphemeralResolveInfo> resolveInfo = EphemeralResolverService.this.onEphemeralResolveInfoList(digestPrefix, message.arg1);
                    Bundle data = new Bundle();
                    data.putInt(EphemeralResolverService.EXTRA_SEQUENCE, message.arg2);
                    data.putParcelableList(EphemeralResolverService.EXTRA_RESOLVE_INFO, resolveInfo);
                    try {
                        callback.sendResult(data);
                    }
                    catch (RemoteException remoteException) {}
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown message: " + action);
                }
            }
        }
    }
}

