/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Printer;
import android.util.SparseArray;
import android.util.Xml;
import com.android.internal.R;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public final class DeviceAdminInfo
implements Parcelable {
    static final String TAG = "DeviceAdminInfo";
    public static final int USES_POLICY_DEVICE_OWNER = -2;
    public static final int USES_POLICY_PROFILE_OWNER = -1;
    public static final int USES_POLICY_LIMIT_PASSWORD = 0;
    public static final int USES_POLICY_WATCH_LOGIN = 1;
    public static final int USES_POLICY_RESET_PASSWORD = 2;
    public static final int USES_POLICY_FORCE_LOCK = 3;
    public static final int USES_POLICY_WIPE_DATA = 4;
    public static final int USES_POLICY_SETS_GLOBAL_PROXY = 5;
    public static final int USES_POLICY_EXPIRE_PASSWORD = 6;
    public static final int USES_ENCRYPTED_STORAGE = 7;
    public static final int USES_POLICY_DISABLE_CAMERA = 8;
    public static final int USES_POLICY_DISABLE_KEYGUARD_FEATURES = 9;
    static ArrayList<PolicyInfo> sPoliciesDisplayOrder = new ArrayList();
    static HashMap<String, Integer> sKnownPolicies = new HashMap();
    static SparseArray<PolicyInfo> sRevKnownPolicies = new SparseArray();
    final ActivityInfo mActivityInfo;
    boolean mVisible;
    int mUsesPolicies;
    public static final Parcelable.Creator<DeviceAdminInfo> CREATOR;

    public DeviceAdminInfo(Context context, ResolveInfo resolveInfo) throws XmlPullParserException, IOException {
        this(context, resolveInfo.activityInfo);
    }

    public DeviceAdminInfo(Context context, ActivityInfo activityInfo) throws XmlPullParserException, IOException {
        this.mActivityInfo = activityInfo;
        PackageManager pm = context.getPackageManager();
        try (XmlResourceParser parser = null;){
            int type;
            parser = this.mActivityInfo.loadXmlMetaData(pm, "android.app.device_admin");
            if (parser == null) {
                throw new XmlPullParserException("No android.app.device_admin meta-data");
            }
            Resources res = pm.getResourcesForApplication(this.mActivityInfo.applicationInfo);
            AttributeSet attrs = Xml.asAttributeSet(parser);
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String nodeName = parser.getName();
            if (!"device-admin".equals(nodeName)) {
                throw new XmlPullParserException("Meta-data does not start with device-admin tag");
            }
            TypedArray sa = res.obtainAttributes(attrs, R.styleable.DeviceAdmin);
            this.mVisible = sa.getBoolean(0, true);
            sa.recycle();
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                String tagName;
                if (type == 3 || type == 4 || !(tagName = parser.getName()).equals("uses-policies")) continue;
                int innerDepth = parser.getDepth();
                while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > innerDepth)) {
                    if (type == 3 || type == 4) continue;
                    String policyName = parser.getName();
                    Integer val = sKnownPolicies.get(policyName);
                    if (val != null) {
                        this.mUsesPolicies |= 1 << val;
                        continue;
                    }
                    Log.w(TAG, "Unknown tag under uses-policies of " + this.getComponent() + ": " + policyName);
                }
            }
        }
    }

    DeviceAdminInfo(Parcel source) {
        this.mActivityInfo = ActivityInfo.CREATOR.createFromParcel(source);
        this.mUsesPolicies = source.readInt();
    }

    public String getPackageName() {
        return this.mActivityInfo.packageName;
    }

    public String getReceiverName() {
        return this.mActivityInfo.name;
    }

    public ActivityInfo getActivityInfo() {
        return this.mActivityInfo;
    }

    public ComponentName getComponent() {
        return new ComponentName(this.mActivityInfo.packageName, this.mActivityInfo.name);
    }

    public CharSequence loadLabel(PackageManager pm) {
        return this.mActivityInfo.loadLabel(pm);
    }

    public CharSequence loadDescription(PackageManager pm) throws Resources.NotFoundException {
        if (this.mActivityInfo.descriptionRes != 0) {
            return pm.getText(this.mActivityInfo.packageName, this.mActivityInfo.descriptionRes, this.mActivityInfo.applicationInfo);
        }
        throw new Resources.NotFoundException();
    }

    public Drawable loadIcon(PackageManager pm) {
        return this.mActivityInfo.loadIcon(pm);
    }

    public boolean isVisible() {
        return this.mVisible;
    }

    public boolean usesPolicy(int policyIdent) {
        return (this.mUsesPolicies & 1 << policyIdent) != 0;
    }

    public String getTagForPolicy(int policyIdent) {
        return DeviceAdminInfo.sRevKnownPolicies.get((int)policyIdent).tag;
    }

    public ArrayList<PolicyInfo> getUsedPolicies() {
        ArrayList<PolicyInfo> res = new ArrayList<PolicyInfo>();
        for (int i = 0; i < sPoliciesDisplayOrder.size(); ++i) {
            PolicyInfo pi = sPoliciesDisplayOrder.get(i);
            if (!this.usesPolicy(pi.ident)) continue;
            res.add(pi);
        }
        return res;
    }

    public void writePoliciesToXml(XmlSerializer out) throws IllegalArgumentException, IllegalStateException, IOException {
        out.attribute(null, "flags", Integer.toString(this.mUsesPolicies));
    }

    public void readPoliciesFromXml(XmlPullParser parser) throws XmlPullParserException, IOException {
        this.mUsesPolicies = Integer.parseInt(parser.getAttributeValue(null, "flags"));
    }

    public void dump(Printer pw, String prefix) {
        pw.println(prefix + "Receiver:");
        this.mActivityInfo.dump(pw, prefix + "  ");
    }

    public String toString() {
        return "DeviceAdminInfo{" + this.mActivityInfo.name + "}";
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.mActivityInfo.writeToParcel(dest, flags);
        dest.writeInt(this.mUsesPolicies);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    static {
        sPoliciesDisplayOrder.add(new PolicyInfo(4, "wipe-data", 17039918, 17039919, 17039920, 17039921));
        sPoliciesDisplayOrder.add(new PolicyInfo(2, "reset-password", 17039914, 17039915));
        sPoliciesDisplayOrder.add(new PolicyInfo(0, "limit-password", 17039909, 17039910));
        sPoliciesDisplayOrder.add(new PolicyInfo(1, "watch-login", 17039911, 17039912, 17039911, 17039913));
        sPoliciesDisplayOrder.add(new PolicyInfo(3, "force-lock", 17039916, 17039917));
        sPoliciesDisplayOrder.add(new PolicyInfo(5, "set-global-proxy", 17039922, 17039923));
        sPoliciesDisplayOrder.add(new PolicyInfo(6, "expire-password", 17039924, 17039925));
        sPoliciesDisplayOrder.add(new PolicyInfo(7, "encrypted-storage", 17039926, 17039927));
        sPoliciesDisplayOrder.add(new PolicyInfo(8, "disable-camera", 17039928, 17039929));
        sPoliciesDisplayOrder.add(new PolicyInfo(9, "disable-keyguard-features", 17039930, 17039931));
        for (int i = 0; i < sPoliciesDisplayOrder.size(); ++i) {
            PolicyInfo pi = sPoliciesDisplayOrder.get(i);
            sRevKnownPolicies.put(pi.ident, pi);
            sKnownPolicies.put(pi.tag, pi.ident);
        }
        CREATOR = new Parcelable.Creator<DeviceAdminInfo>(){

            @Override
            public DeviceAdminInfo createFromParcel(Parcel source) {
                return new DeviceAdminInfo(source);
            }

            public DeviceAdminInfo[] newArray(int size) {
                return new DeviceAdminInfo[size];
            }
        };
    }

    public static class PolicyInfo {
        public final int ident;
        public final String tag;
        public final int label;
        public final int description;
        public final int labelForSecondaryUsers;
        public final int descriptionForSecondaryUsers;

        public PolicyInfo(int ident, String tag, int label, int description) {
            this(ident, tag, label, description, label, description);
        }

        public PolicyInfo(int ident, String tag, int label, int description, int labelForSecondaryUsers, int descriptionForSecondaryUsers) {
            this.ident = ident;
            this.tag = tag;
            this.label = label;
            this.description = description;
            this.labelForSecondaryUsers = labelForSecondaryUsers;
            this.descriptionForSecondaryUsers = descriptionForSecondaryUsers;
        }
    }
}

