/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.IntentFilter;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class EphemeralResolveInfo
implements Parcelable {
    public static final String SHA_ALGORITHM = "SHA-256";
    private final EphemeralDigest mDigest;
    private final String mPackageName;
    private final List<IntentFilter> mFilters = new ArrayList<IntentFilter>();
    public static final Parcelable.Creator<EphemeralResolveInfo> CREATOR = new Parcelable.Creator<EphemeralResolveInfo>(){

        @Override
        public EphemeralResolveInfo createFromParcel(Parcel in) {
            return new EphemeralResolveInfo(in);
        }

        public EphemeralResolveInfo[] newArray(int size) {
            return new EphemeralResolveInfo[size];
        }
    };

    public EphemeralResolveInfo(Uri uri, String packageName, List<IntentFilter> filters) {
        if (uri == null || packageName == null || filters == null || filters.size() == 0) {
            throw new IllegalArgumentException();
        }
        this.mDigest = new EphemeralDigest(uri, -1, -1);
        this.mFilters.addAll(filters);
        this.mPackageName = packageName;
    }

    EphemeralResolveInfo(Parcel in) {
        this.mDigest = (EphemeralDigest)in.readParcelable(null);
        this.mPackageName = in.readString();
        in.readList(this.mFilters, null);
    }

    public byte[] getDigestBytes() {
        return this.mDigest.getDigestBytes()[0];
    }

    public int getDigestPrefix() {
        return this.mDigest.getDigestPrefix()[0];
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public List<IntentFilter> getFilters() {
        return this.mFilters;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable(this.mDigest, flags);
        out.writeString(this.mPackageName);
        out.writeList(this.mFilters);
    }

    public static final class EphemeralDigest
    implements Parcelable {
        private final byte[][] mDigestBytes;
        private final int[] mDigestPrefix;
        public static final Parcelable.Creator<EphemeralDigest> CREATOR = new Parcelable.Creator<EphemeralDigest>(){

            @Override
            public EphemeralDigest createFromParcel(Parcel in) {
                return new EphemeralDigest(in);
            }

            public EphemeralDigest[] newArray(int size) {
                return new EphemeralDigest[size];
            }
        };

        public EphemeralDigest(Uri uri, int digestMask, int maxDigests) {
            if (uri == null) {
                throw new IllegalArgumentException();
            }
            this.mDigestBytes = EphemeralDigest.generateDigest(uri, maxDigests);
            this.mDigestPrefix = new int[this.mDigestBytes.length];
            for (int i = 0; i < this.mDigestBytes.length; ++i) {
                this.mDigestPrefix[i] = ((this.mDigestBytes[i][0] & 0xFF) << 24 | (this.mDigestBytes[i][1] & 0xFF) << 16 | (this.mDigestBytes[i][2] & 0xFF) << 8 | (this.mDigestBytes[i][3] & 0xFF) << 0) & digestMask;
            }
        }

        private static byte[][] generateDigest(Uri uri, int maxDigests) {
            ArrayList<byte[]> digests = new ArrayList<byte[]>();
            try {
                String host = uri.getHost().toLowerCase(Locale.ENGLISH);
                MessageDigest digest = MessageDigest.getInstance(EphemeralResolveInfo.SHA_ALGORITHM);
                if (maxDigests <= 0) {
                    byte[] hostBytes = host.getBytes();
                    digests.add(digest.digest(hostBytes));
                } else {
                    int prevDot = host.lastIndexOf(46);
                    if ((prevDot = host.lastIndexOf(46, prevDot - 1)) < 0) {
                        digests.add(digest.digest(host.getBytes()));
                    } else {
                        byte[] hostBytes = host.substring(prevDot + 1, host.length()).getBytes();
                        digests.add(digest.digest(hostBytes));
                        for (int digestCount = 1; prevDot >= 0 && digestCount < maxDigests; ++digestCount) {
                            prevDot = host.lastIndexOf(46, prevDot - 1);
                            hostBytes = host.substring(prevDot + 1, host.length()).getBytes();
                            digests.add(digest.digest(hostBytes));
                        }
                    }
                }
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("could not find digest algorithm");
            }
            return (byte[][])digests.toArray((T[])new byte[digests.size()][]);
        }

        EphemeralDigest(Parcel in) {
            int digestCount = in.readInt();
            if (digestCount == -1) {
                this.mDigestBytes = null;
            } else {
                this.mDigestBytes = new byte[digestCount][];
                for (int i = 0; i < digestCount; ++i) {
                    this.mDigestBytes[i] = in.createByteArray();
                }
            }
            this.mDigestPrefix = in.createIntArray();
        }

        public byte[][] getDigestBytes() {
            return this.mDigestBytes;
        }

        public int[] getDigestPrefix() {
            return this.mDigestPrefix;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            if (this.mDigestBytes == null) {
                out.writeInt(-1);
            } else {
                out.writeInt(this.mDigestBytes.length);
                for (int i = 0; i < this.mDigestBytes.length; ++i) {
                    out.writeByteArray(this.mDigestBytes[i]);
                }
            }
            out.writeIntArray(this.mDigestPrefix);
        }
    }

    public static final class EphemeralResolveIntentInfo
    extends IntentFilter {
        private final EphemeralResolveInfo mResolveInfo;

        public EphemeralResolveIntentInfo(IntentFilter orig, EphemeralResolveInfo resolveInfo) {
            super(orig);
            this.mResolveInfo = resolveInfo;
        }

        public EphemeralResolveInfo getEphemeralResolveInfo() {
            return this.mResolveInfo;
        }
    }
}

