/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.permission;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.permission.IRuntimePermissionPresenter;
import android.content.pm.permission.RuntimePermissionPresentationInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.SomeArgs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class RuntimePermissionPresenter {
    private static final String TAG = "RuntimePermPresenter";
    public static final String KEY_RESULT = "android.content.pm.permission.RuntimePermissionPresenter.key.result";
    private static final Object sLock = new Object();
    @GuardedBy(value="sLock")
    private static RuntimePermissionPresenter sInstance;
    private final RemoteService mRemoteService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RuntimePermissionPresenter getInstance(Context context) {
        Object object = sLock;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new RuntimePermissionPresenter(context.getApplicationContext());
            }
            return sInstance;
        }
    }

    private RuntimePermissionPresenter(Context context) {
        this.mRemoteService = new RemoteService(context);
    }

    public void getAppPermissions(String packageName, OnResultCallback callback, Handler handler) {
        SomeArgs args = SomeArgs.obtain();
        args.arg1 = packageName;
        args.arg2 = callback;
        args.arg3 = handler;
        Message message = this.mRemoteService.obtainMessage(1, args);
        this.mRemoteService.processMessage(message);
    }

    public void getAppsUsingPermissions(boolean system, OnResultCallback callback, Handler handler) {
        SomeArgs args = SomeArgs.obtain();
        args.arg1 = callback;
        args.arg2 = handler;
        args.argi1 = system ? 1 : 0;
        Message message = this.mRemoteService.obtainMessage(2, args);
        this.mRemoteService.processMessage(message);
    }

    private static final class RemoteService
    extends Handler
    implements ServiceConnection {
        private static final long UNBIND_TIMEOUT_MILLIS = 10000L;
        public static final int MSG_GET_APP_PERMISSIONS = 1;
        public static final int MSG_GET_APPS_USING_PERMISSIONS = 2;
        public static final int MSG_UNBIND = 3;
        private final Object mLock = new Object();
        private final Context mContext;
        @GuardedBy(value="mLock")
        private final List<Message> mPendingWork = new ArrayList<Message>();
        @GuardedBy(value="mLock")
        private IRuntimePermissionPresenter mRemoteInstance;
        @GuardedBy(value="mLock")
        private boolean mBound;

        public RemoteService(Context context) {
            super(context.getMainLooper(), null, false);
            this.mContext = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processMessage(Message message) {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.mBound) {
                    Intent intent = new Intent("android.permissionpresenterservice.RuntimePermissionPresenterService");
                    intent.setPackage(this.mContext.getPackageManager().getPermissionControllerPackageName());
                    this.mBound = this.mContext.bindService(intent, this, 1);
                }
                this.mPendingWork.add(message);
                this.scheduleNextMessageIfNeededLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            Object object = this.mLock;
            synchronized (object) {
                this.mRemoteInstance = IRuntimePermissionPresenter.Stub.asInterface(service);
                this.scheduleNextMessageIfNeededLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceDisconnected(ComponentName name) {
            Object object = this.mLock;
            synchronized (object) {
                this.mRemoteInstance = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            Object object;
            switch (msg.what) {
                case 1: {
                    IRuntimePermissionPresenter remoteInstance;
                    SomeArgs args = (SomeArgs)msg.obj;
                    String packageName = (String)args.arg1;
                    final OnResultCallback callback = (OnResultCallback)args.arg2;
                    final Handler handler = (Handler)args.arg3;
                    args.recycle();
                    Object object2 = this.mLock;
                    synchronized (object2) {
                        remoteInstance = this.mRemoteInstance;
                    }
                    if (remoteInstance == null) {
                        return;
                    }
                    try {
                        remoteInstance.getAppPermissions(packageName, new RemoteCallback(new RemoteCallback.OnResultListener(){

                            @Override
                            public void onResult(Bundle result) {
                                List<RuntimePermissionPresentationInfo> permissions = null;
                                if (result != null) {
                                    permissions = result.getParcelableArrayList(RuntimePermissionPresenter.KEY_RESULT);
                                }
                                if (permissions == null) {
                                    permissions = Collections.emptyList();
                                }
                                final ArrayList<RuntimePermissionPresentationInfo> reportedPermissions = permissions;
                                if (handler != null) {
                                    handler.post(new Runnable(){

                                        @Override
                                        public void run() {
                                            callback.onGetAppPermissions(reportedPermissions);
                                        }
                                    });
                                } else {
                                    callback.onGetAppPermissions(reportedPermissions);
                                }
                            }
                        }, this));
                    }
                    catch (RemoteException re) {
                        Log.e(RuntimePermissionPresenter.TAG, "Error getting app permissions", re);
                    }
                    this.scheduleUnbind();
                    break;
                }
                case 2: {
                    IRuntimePermissionPresenter remoteInstance;
                    SomeArgs args = (SomeArgs)msg.obj;
                    final OnResultCallback callback = (OnResultCallback)args.arg1;
                    final Handler handler = (Handler)args.arg2;
                    final boolean system = args.argi1 == 1;
                    args.recycle();
                    Object re = this.mLock;
                    synchronized (re) {
                        remoteInstance = this.mRemoteInstance;
                    }
                    if (remoteInstance == null) {
                        return;
                    }
                    try {
                        remoteInstance.getAppsUsingPermissions(system, new RemoteCallback(new RemoteCallback.OnResultListener(){

                            @Override
                            public void onResult(Bundle result) {
                                List<ApplicationInfo> apps = null;
                                if (result != null) {
                                    apps = result.getParcelableArrayList(RuntimePermissionPresenter.KEY_RESULT);
                                }
                                if (apps == null) {
                                    apps = Collections.emptyList();
                                }
                                final ArrayList<ApplicationInfo> reportedApps = apps;
                                if (handler != null) {
                                    handler.post(new Runnable(){

                                        @Override
                                        public void run() {
                                            callback.getAppsUsingPermissions(system, reportedApps);
                                        }
                                    });
                                } else {
                                    callback.getAppsUsingPermissions(system, reportedApps);
                                }
                            }
                        }, this));
                    }
                    catch (RemoteException re2) {
                        Log.e(RuntimePermissionPresenter.TAG, "Error getting apps using permissions", re2);
                    }
                    this.scheduleUnbind();
                    break;
                }
                case 3: {
                    object = this.mLock;
                    synchronized (object) {
                        if (this.mBound) {
                            this.mContext.unbindService(this);
                            this.mBound = false;
                        }
                        this.mRemoteInstance = null;
                        break;
                    }
                }
            }
            object = this.mLock;
            synchronized (object) {
                this.scheduleNextMessageIfNeededLocked();
            }
        }

        private void scheduleNextMessageIfNeededLocked() {
            if (this.mBound && this.mRemoteInstance != null && !this.mPendingWork.isEmpty()) {
                Message nextMessage = this.mPendingWork.remove(0);
                this.sendMessage(nextMessage);
            }
        }

        private void scheduleUnbind() {
            this.removeMessages(3);
            this.sendEmptyMessageDelayed(3, 10000L);
        }
    }

    public static abstract class OnResultCallback {
        public void onGetAppPermissions(List<RuntimePermissionPresentationInfo> permissions) {
        }

        public void getAppsUsingPermissions(boolean system, List<ApplicationInfo> apps) {
        }
    }
}

