/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.util.Log;

public abstract class FilterPort {
    protected Filter mFilter;
    protected String mName;
    protected FrameFormat mPortFormat;
    protected boolean mIsBlocking = true;
    protected boolean mIsOpen = false;
    protected boolean mChecksType = false;
    private boolean mLogVerbose;
    private static final String TAG = "FilterPort";

    public FilterPort(Filter filter, String name) {
        this.mName = name;
        this.mFilter = filter;
        this.mLogVerbose = Log.isLoggable(TAG, 2);
    }

    public boolean isAttached() {
        return this.mFilter != null;
    }

    public FrameFormat getPortFormat() {
        return this.mPortFormat;
    }

    public void setPortFormat(FrameFormat format) {
        this.mPortFormat = format;
    }

    public Filter getFilter() {
        return this.mFilter;
    }

    public String getName() {
        return this.mName;
    }

    public void setBlocking(boolean blocking) {
        this.mIsBlocking = blocking;
    }

    public void setChecksType(boolean checksType) {
        this.mChecksType = checksType;
    }

    public void open() {
        if (!this.mIsOpen && this.mLogVerbose) {
            Log.v(TAG, "Opening " + this);
        }
        this.mIsOpen = true;
    }

    public void close() {
        if (this.mIsOpen && this.mLogVerbose) {
            Log.v(TAG, "Closing " + this);
        }
        this.mIsOpen = false;
    }

    public boolean isOpen() {
        return this.mIsOpen;
    }

    public boolean isBlocking() {
        return this.mIsBlocking;
    }

    public abstract boolean filterMustClose();

    public abstract boolean isReady();

    public abstract void pushFrame(Frame var1);

    public abstract void setFrame(Frame var1);

    public abstract Frame pullFrame();

    public abstract boolean hasFrame();

    public abstract void clear();

    public String toString() {
        return "port '" + this.mName + "' of " + this.mFilter;
    }

    protected void assertPortIsOpen() {
        if (!this.isOpen()) {
            throw new RuntimeException("Illegal operation on closed " + this + "!");
        }
    }

    protected void checkFrameType(Frame frame, boolean forceCheck) {
        if ((this.mChecksType || forceCheck) && this.mPortFormat != null && !frame.getFormat().isCompatibleWith(this.mPortFormat)) {
            throw new RuntimeException("Frame passed to " + this + " is of incorrect type! " + "Expected " + this.mPortFormat + " but got " + frame.getFormat());
        }
    }

    protected void checkFrameManager(Frame frame, FilterContext context) {
        if (frame.getFrameManager() != null && frame.getFrameManager() != context.getFrameManager()) {
            throw new RuntimeException("Frame " + frame + " is managed by foreign FrameManager! ");
        }
    }
}

