/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.videosrc;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.GLFrame;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.GenerateFinalPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.opengl.Matrix;
import android.util.Log;
import android.view.Surface;
import java.io.IOException;

public class MediaSource
extends Filter {
    @GenerateFieldPort(name="sourceUrl", hasDefault=true)
    private String mSourceUrl = "";
    @GenerateFieldPort(name="sourceAsset", hasDefault=true)
    private AssetFileDescriptor mSourceAsset = null;
    @GenerateFieldPort(name="context", hasDefault=true)
    private Context mContext = null;
    @GenerateFieldPort(name="sourceIsUrl", hasDefault=true)
    private boolean mSelectedIsUrl = false;
    @GenerateFinalPort(name="waitForNewFrame", hasDefault=true)
    private boolean mWaitForNewFrame = true;
    @GenerateFieldPort(name="loop", hasDefault=true)
    private boolean mLooping = true;
    @GenerateFieldPort(name="volume", hasDefault=true)
    private float mVolume = 0.0f;
    @GenerateFieldPort(name="orientation", hasDefault=true)
    private int mOrientation = 0;
    private MediaPlayer mMediaPlayer;
    private GLFrame mMediaFrame;
    private SurfaceTexture mSurfaceTexture;
    private ShaderProgram mFrameExtractor;
    private MutableFrameFormat mOutputFormat;
    private int mWidth;
    private int mHeight;
    private static final int PREP_TIMEOUT = 100;
    private static final int PREP_TIMEOUT_REPEAT = 100;
    private static final int NEWFRAME_TIMEOUT = 100;
    private static final int NEWFRAME_TIMEOUT_REPEAT = 10;
    private final String mFrameShader = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES tex_sampler_0;\nvarying vec2 v_texcoord;\nvoid main() {\n  gl_FragColor = texture2D(tex_sampler_0, v_texcoord);\n}\n";
    private static final float[] mSourceCoords_0 = new float[]{1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    private static final float[] mSourceCoords_270 = new float[]{0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f};
    private static final float[] mSourceCoords_180 = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f};
    private static final float[] mSourceCoords_90 = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f};
    private boolean mGotSize;
    private boolean mPrepared;
    private boolean mPlaying;
    private boolean mNewFrameAvailable = false;
    private boolean mOrientationUpdated;
    private boolean mPaused;
    private boolean mCompleted;
    private final boolean mLogVerbose;
    private static final String TAG = "MediaSource";
    private MediaPlayer.OnVideoSizeChangedListener onVideoSizeChangedListener = new MediaPlayer.OnVideoSizeChangedListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
            if (MediaSource.this.mLogVerbose) {
                Log.v(MediaSource.TAG, "MediaPlayer sent dimensions: " + width + " x " + height);
            }
            if (!MediaSource.this.mGotSize) {
                if (MediaSource.this.mOrientation == 0 || MediaSource.this.mOrientation == 180) {
                    MediaSource.this.mOutputFormat.setDimensions(width, height);
                } else {
                    MediaSource.this.mOutputFormat.setDimensions(height, width);
                }
                MediaSource.this.mWidth = width;
                MediaSource.this.mHeight = height;
            } else if (MediaSource.this.mOutputFormat.getWidth() != width || MediaSource.this.mOutputFormat.getHeight() != height) {
                Log.e(MediaSource.TAG, "Multiple video size change events received!");
            }
            MediaSource mediaSource = MediaSource.this;
            synchronized (mediaSource) {
                MediaSource.this.mGotSize = true;
                MediaSource.this.notify();
            }
        }
    };
    private MediaPlayer.OnPreparedListener onPreparedListener = new MediaPlayer.OnPreparedListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPrepared(MediaPlayer mp) {
            if (MediaSource.this.mLogVerbose) {
                Log.v(MediaSource.TAG, "MediaPlayer is prepared");
            }
            MediaSource mediaSource = MediaSource.this;
            synchronized (mediaSource) {
                MediaSource.this.mPrepared = true;
                MediaSource.this.notify();
            }
        }
    };
    private MediaPlayer.OnCompletionListener onCompletionListener = new MediaPlayer.OnCompletionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompletion(MediaPlayer mp) {
            if (MediaSource.this.mLogVerbose) {
                Log.v(MediaSource.TAG, "MediaPlayer has completed playback");
            }
            MediaSource mediaSource = MediaSource.this;
            synchronized (mediaSource) {
                MediaSource.this.mCompleted = true;
            }
        }
    };
    private SurfaceTexture.OnFrameAvailableListener onMediaFrameAvailableListener = new SurfaceTexture.OnFrameAvailableListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFrameAvailable(SurfaceTexture surfaceTexture) {
            if (MediaSource.this.mLogVerbose) {
                Log.v(MediaSource.TAG, "New frame from media player");
            }
            MediaSource mediaSource = MediaSource.this;
            synchronized (mediaSource) {
                if (MediaSource.this.mLogVerbose) {
                    Log.v(MediaSource.TAG, "New frame: notify");
                }
                MediaSource.this.mNewFrameAvailable = true;
                MediaSource.this.notify();
                if (MediaSource.this.mLogVerbose) {
                    Log.v(MediaSource.TAG, "New frame: notify done");
                }
            }
        }
    };

    public MediaSource(String name) {
        super(name);
        this.mLogVerbose = Log.isLoggable(TAG, 2);
    }

    @Override
    public void setupPorts() {
        this.addOutputPort("video", ImageFormat.create(3, 3));
    }

    private void createFormats() {
        this.mOutputFormat = ImageFormat.create(3, 3);
    }

    @Override
    protected void prepare(FilterContext context) {
        if (this.mLogVerbose) {
            Log.v(TAG, "Preparing MediaSource");
        }
        this.mFrameExtractor = new ShaderProgram(context, "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES tex_sampler_0;\nvarying vec2 v_texcoord;\nvoid main() {\n  gl_FragColor = texture2D(tex_sampler_0, v_texcoord);\n}\n");
        this.mFrameExtractor.setSourceRect(0.0f, 1.0f, 1.0f, -1.0f);
        this.createFormats();
    }

    @Override
    public void open(FilterContext context) {
        if (this.mLogVerbose) {
            Log.v(TAG, "Opening MediaSource");
            if (this.mSelectedIsUrl) {
                Log.v(TAG, "Current URL is " + this.mSourceUrl);
            } else {
                Log.v(TAG, "Current source is Asset!");
            }
        }
        this.mMediaFrame = (GLFrame)context.getFrameManager().newBoundFrame(this.mOutputFormat, 104, 0L);
        this.mSurfaceTexture = new SurfaceTexture(this.mMediaFrame.getTextureId());
        if (!this.setupMediaPlayer(this.mSelectedIsUrl)) {
            throw new RuntimeException("Error setting up MediaPlayer!");
        }
    }

    @Override
    public void process(FilterContext context) {
        int waitCount;
        if (this.mLogVerbose) {
            Log.v(TAG, "Processing new frame");
        }
        if (this.mMediaPlayer == null) {
            throw new NullPointerException("Unexpected null media player!");
        }
        if (this.mCompleted) {
            this.closeOutputPort("video");
            return;
        }
        if (!this.mPlaying) {
            waitCount = 0;
            if (this.mLogVerbose) {
                Log.v(TAG, "Waiting for preparation to complete");
            }
            while (!this.mGotSize || !this.mPrepared) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.mCompleted) {
                    this.closeOutputPort("video");
                    return;
                }
                if (++waitCount != 100) continue;
                this.mMediaPlayer.release();
                throw new RuntimeException("MediaPlayer timed out while preparing!");
            }
            if (this.mLogVerbose) {
                Log.v(TAG, "Starting playback");
            }
            this.mMediaPlayer.start();
        }
        if (!this.mPaused || !this.mPlaying) {
            if (this.mWaitForNewFrame) {
                if (this.mLogVerbose) {
                    Log.v(TAG, "Waiting for new frame");
                }
                waitCount = 0;
                while (!this.mNewFrameAvailable) {
                    block27: {
                        if (waitCount == 10) {
                            if (this.mCompleted) {
                                this.closeOutputPort("video");
                                return;
                            }
                            throw new RuntimeException("Timeout waiting for new frame!");
                        }
                        try {
                            this.wait(100L);
                        }
                        catch (InterruptedException e) {
                            if (!this.mLogVerbose) break block27;
                            Log.v(TAG, "interrupted");
                        }
                    }
                    ++waitCount;
                }
                this.mNewFrameAvailable = false;
                if (this.mLogVerbose) {
                    Log.v(TAG, "Got new frame");
                }
            }
            this.mSurfaceTexture.updateTexImage();
            this.mOrientationUpdated = true;
        }
        if (this.mOrientationUpdated) {
            float[] surfaceTransform = new float[16];
            this.mSurfaceTexture.getTransformMatrix(surfaceTransform);
            float[] sourceCoords = new float[16];
            switch (this.mOrientation) {
                default: {
                    Matrix.multiplyMM(sourceCoords, 0, surfaceTransform, 0, mSourceCoords_0, 0);
                    break;
                }
                case 90: {
                    Matrix.multiplyMM(sourceCoords, 0, surfaceTransform, 0, mSourceCoords_90, 0);
                    break;
                }
                case 180: {
                    Matrix.multiplyMM(sourceCoords, 0, surfaceTransform, 0, mSourceCoords_180, 0);
                    break;
                }
                case 270: {
                    Matrix.multiplyMM(sourceCoords, 0, surfaceTransform, 0, mSourceCoords_270, 0);
                }
            }
            if (this.mLogVerbose) {
                Log.v(TAG, "OrientationHint = " + this.mOrientation);
                String temp = String.format("SetSourceRegion: %.2f, %.2f, %.2f, %.2f, %.2f, %.2f, %.2f, %.2f", Float.valueOf(sourceCoords[4]), Float.valueOf(sourceCoords[5]), Float.valueOf(sourceCoords[0]), Float.valueOf(sourceCoords[1]), Float.valueOf(sourceCoords[12]), Float.valueOf(sourceCoords[13]), Float.valueOf(sourceCoords[8]), Float.valueOf(sourceCoords[9]));
                Log.v(TAG, temp);
            }
            this.mFrameExtractor.setSourceRegion(sourceCoords[4], sourceCoords[5], sourceCoords[0], sourceCoords[1], sourceCoords[12], sourceCoords[13], sourceCoords[8], sourceCoords[9]);
            this.mOrientationUpdated = false;
        }
        Frame output = context.getFrameManager().newFrame(this.mOutputFormat);
        this.mFrameExtractor.process(this.mMediaFrame, output);
        long timestamp = this.mSurfaceTexture.getTimestamp();
        if (this.mLogVerbose) {
            Log.v(TAG, "Timestamp: " + (double)timestamp / 1.0E9 + " s");
        }
        output.setTimestamp(timestamp);
        this.pushOutput("video", output);
        output.release();
        this.mPlaying = true;
    }

    @Override
    public void close(FilterContext context) {
        if (this.mMediaPlayer.isPlaying()) {
            this.mMediaPlayer.stop();
        }
        this.mPrepared = false;
        this.mGotSize = false;
        this.mPlaying = false;
        this.mPaused = false;
        this.mCompleted = false;
        this.mNewFrameAvailable = false;
        this.mMediaPlayer.release();
        this.mMediaPlayer = null;
        this.mSurfaceTexture.release();
        this.mSurfaceTexture = null;
        if (this.mLogVerbose) {
            Log.v(TAG, "MediaSource closed");
        }
    }

    @Override
    public void tearDown(FilterContext context) {
        if (this.mMediaFrame != null) {
            this.mMediaFrame.release();
        }
    }

    @Override
    public void fieldPortValueUpdated(String name, FilterContext context) {
        if (this.mLogVerbose) {
            Log.v(TAG, "Parameter update");
        }
        if (name.equals("sourceUrl")) {
            if (this.isOpen()) {
                if (this.mLogVerbose) {
                    Log.v(TAG, "Opening new source URL");
                }
                if (this.mSelectedIsUrl) {
                    this.setupMediaPlayer(this.mSelectedIsUrl);
                }
            }
        } else if (name.equals("sourceAsset")) {
            if (this.isOpen()) {
                if (this.mLogVerbose) {
                    Log.v(TAG, "Opening new source FD");
                }
                if (!this.mSelectedIsUrl) {
                    this.setupMediaPlayer(this.mSelectedIsUrl);
                }
            }
        } else if (name.equals("loop")) {
            if (this.isOpen()) {
                this.mMediaPlayer.setLooping(this.mLooping);
            }
        } else if (name.equals("sourceIsUrl")) {
            if (this.isOpen()) {
                if (this.mSelectedIsUrl) {
                    if (this.mLogVerbose) {
                        Log.v(TAG, "Opening new source URL");
                    }
                } else if (this.mLogVerbose) {
                    Log.v(TAG, "Opening new source Asset");
                }
                this.setupMediaPlayer(this.mSelectedIsUrl);
            }
        } else if (name.equals("volume")) {
            if (this.isOpen()) {
                this.mMediaPlayer.setVolume(this.mVolume, this.mVolume);
            }
        } else if (name.equals("orientation") && this.mGotSize) {
            if (this.mOrientation == 0 || this.mOrientation == 180) {
                this.mOutputFormat.setDimensions(this.mWidth, this.mHeight);
            } else {
                this.mOutputFormat.setDimensions(this.mHeight, this.mWidth);
            }
            this.mOrientationUpdated = true;
        }
    }

    public synchronized void pauseVideo(boolean pauseState) {
        if (this.isOpen()) {
            if (pauseState && !this.mPaused) {
                this.mMediaPlayer.pause();
            } else if (!pauseState && this.mPaused) {
                this.mMediaPlayer.start();
            }
        }
        this.mPaused = pauseState;
    }

    private synchronized boolean setupMediaPlayer(boolean useUrl) {
        this.mPrepared = false;
        this.mGotSize = false;
        this.mPlaying = false;
        this.mPaused = false;
        this.mCompleted = false;
        this.mNewFrameAvailable = false;
        if (this.mLogVerbose) {
            Log.v(TAG, "Setting up playback.");
        }
        if (this.mMediaPlayer != null) {
            if (this.mLogVerbose) {
                Log.v(TAG, "Resetting existing MediaPlayer.");
            }
            this.mMediaPlayer.reset();
        } else {
            if (this.mLogVerbose) {
                Log.v(TAG, "Creating new MediaPlayer.");
            }
            this.mMediaPlayer = new MediaPlayer();
        }
        if (this.mMediaPlayer == null) {
            throw new RuntimeException("Unable to create a MediaPlayer!");
        }
        try {
            if (useUrl) {
                if (this.mLogVerbose) {
                    Log.v(TAG, "Setting MediaPlayer source to URI " + this.mSourceUrl);
                }
                if (this.mContext == null) {
                    this.mMediaPlayer.setDataSource(this.mSourceUrl);
                } else {
                    this.mMediaPlayer.setDataSource(this.mContext, Uri.parse(this.mSourceUrl.toString()));
                }
            } else {
                if (this.mLogVerbose) {
                    Log.v(TAG, "Setting MediaPlayer source to asset " + this.mSourceAsset);
                }
                this.mMediaPlayer.setDataSource(this.mSourceAsset.getFileDescriptor(), this.mSourceAsset.getStartOffset(), this.mSourceAsset.getLength());
            }
        }
        catch (IOException e) {
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
            if (useUrl) {
                throw new RuntimeException(String.format("Unable to set MediaPlayer to URL %s!", this.mSourceUrl), e);
            }
            throw new RuntimeException(String.format("Unable to set MediaPlayer to asset %s!", this.mSourceAsset), e);
        }
        catch (IllegalArgumentException e) {
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
            if (useUrl) {
                throw new RuntimeException(String.format("Unable to set MediaPlayer to URL %s!", this.mSourceUrl), e);
            }
            throw new RuntimeException(String.format("Unable to set MediaPlayer to asset %s!", this.mSourceAsset), e);
        }
        this.mMediaPlayer.setLooping(this.mLooping);
        this.mMediaPlayer.setVolume(this.mVolume, this.mVolume);
        Surface surface = new Surface(this.mSurfaceTexture);
        this.mMediaPlayer.setSurface(surface);
        surface.release();
        this.mMediaPlayer.setOnVideoSizeChangedListener(this.onVideoSizeChangedListener);
        this.mMediaPlayer.setOnPreparedListener(this.onPreparedListener);
        this.mMediaPlayer.setOnCompletionListener(this.onCompletionListener);
        this.mSurfaceTexture.setOnFrameAvailableListener(this.onMediaFrameAvailableListener);
        if (this.mLogVerbose) {
            Log.v(TAG, "Preparing MediaPlayer.");
        }
        this.mMediaPlayer.prepareAsync();
        return true;
    }
}

