/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import com.android.internal.util.XmlUtils;
import java.util.HashMap;
import java.util.Locale;

public class Color {
    public static final int BLACK = -16777216;
    public static final int DKGRAY = -12303292;
    public static final int GRAY = -7829368;
    public static final int LTGRAY = -3355444;
    public static final int WHITE = -1;
    public static final int RED = -65536;
    public static final int GREEN = -16711936;
    public static final int BLUE = -16776961;
    public static final int YELLOW = -256;
    public static final int CYAN = -16711681;
    public static final int MAGENTA = -65281;
    public static final int TRANSPARENT = 0;
    private static final HashMap<String, Integer> sColorNameMap = new HashMap();

    public static int alpha(int color2) {
        return color2 >>> 24;
    }

    public static int red(int color2) {
        return color2 >> 16 & 0xFF;
    }

    public static int green(int color2) {
        return color2 >> 8 & 0xFF;
    }

    public static int blue(int color2) {
        return color2 & 0xFF;
    }

    public static int rgb(int red, int green, int blue) {
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }

    public static int argb(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static float luminance(int color2) {
        double red = (double)Color.red(color2) / 255.0;
        red = red < 0.03928 ? red / 12.92 : Math.pow((red + 0.055) / 1.055, 2.4);
        double green = (double)Color.green(color2) / 255.0;
        green = green < 0.03928 ? green / 12.92 : Math.pow((green + 0.055) / 1.055, 2.4);
        double blue = (double)Color.blue(color2) / 255.0;
        blue = blue < 0.03928 ? blue / 12.92 : Math.pow((blue + 0.055) / 1.055, 2.4);
        return (float)(0.2126 * red + 0.7152 * green + 0.0722 * blue);
    }

    public static int parseColor(String colorString) {
        if (colorString.charAt(0) == '#') {
            long color2 = Long.parseLong(colorString.substring(1), 16);
            if (colorString.length() == 7) {
                color2 |= 0xFFFFFFFFFF000000L;
            } else if (colorString.length() != 9) {
                throw new IllegalArgumentException("Unknown color");
            }
            return (int)color2;
        }
        Integer color3 = sColorNameMap.get(colorString.toLowerCase(Locale.ROOT));
        if (color3 != null) {
            return color3;
        }
        throw new IllegalArgumentException("Unknown color");
    }

    public static void RGBToHSV(int red, int green, int blue, float[] hsv) {
        if (hsv.length < 3) {
            throw new RuntimeException("3 components required for hsv");
        }
        Color.nativeRGBToHSV(red, green, blue, hsv);
    }

    public static void colorToHSV(int color2, float[] hsv) {
        Color.RGBToHSV(color2 >> 16 & 0xFF, color2 >> 8 & 0xFF, color2 & 0xFF, hsv);
    }

    public static int HSVToColor(float[] hsv) {
        return Color.HSVToColor(255, hsv);
    }

    public static int HSVToColor(int alpha, float[] hsv) {
        if (hsv.length < 3) {
            throw new RuntimeException("3 components required for hsv");
        }
        return Color.nativeHSVToColor(alpha, hsv);
    }

    private static native void nativeRGBToHSV(int var0, int var1, int var2, float[] var3);

    private static native int nativeHSVToColor(int var0, float[] var1);

    public static int getHtmlColor(String color2) {
        Integer i = sColorNameMap.get(color2.toLowerCase(Locale.ROOT));
        if (i != null) {
            return i;
        }
        try {
            return XmlUtils.convertValueToInt(color2, -1);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    static {
        sColorNameMap.put("black", -16777216);
        sColorNameMap.put("darkgray", -12303292);
        sColorNameMap.put("gray", -7829368);
        sColorNameMap.put("lightgray", -3355444);
        sColorNameMap.put("white", -1);
        sColorNameMap.put("red", -65536);
        sColorNameMap.put("green", -16711936);
        sColorNameMap.put("blue", -16776961);
        sColorNameMap.put("yellow", -256);
        sColorNameMap.put("cyan", -16711681);
        sColorNameMap.put("magenta", -65281);
        sColorNameMap.put("aqua", -16711681);
        sColorNameMap.put("fuchsia", -65281);
        sColorNameMap.put("darkgrey", -12303292);
        sColorNameMap.put("grey", -7829368);
        sColorNameMap.put("lightgrey", -3355444);
        sColorNameMap.put("lime", -16711936);
        sColorNameMap.put("maroon", -8388608);
        sColorNameMap.put("navy", -16777088);
        sColorNameMap.put("olive", -8355840);
        sColorNameMap.put("purple", -8388480);
        sColorNameMap.put("silver", -4144960);
        sColorNameMap.put("teal", -16744320);
    }
}

