/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.AssetManager;
import android.graphics.FontListParser;
import android.util.Log;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;

public class FontFamily {
    private static String TAG = "FontFamily";
    public long mNativePtr;

    public FontFamily() {
        this.mNativePtr = FontFamily.nCreateFamily(null, 0);
        if (this.mNativePtr == 0L) {
            throw new IllegalStateException("error creating native FontFamily");
        }
    }

    public FontFamily(String lang, String variant) {
        int varEnum = 0;
        if ("compact".equals(variant)) {
            varEnum = 1;
        } else if ("elegant".equals(variant)) {
            varEnum = 2;
        }
        this.mNativePtr = FontFamily.nCreateFamily(lang, varEnum);
        if (this.mNativePtr == 0L) {
            throw new IllegalStateException("error creating native FontFamily");
        }
    }

    protected void finalize() throws Throwable {
        try {
            FontFamily.nUnrefFamily(this.mNativePtr);
        }
        finally {
            super.finalize();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addFont(String path, int ttcIndex) {
        try (FileInputStream file = new FileInputStream(path);){
            FileChannel fileChannel = file.getChannel();
            long fontSize = fileChannel.size();
            MappedByteBuffer fontBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fontSize);
            boolean bl = FontFamily.nAddFont(this.mNativePtr, fontBuffer, ttcIndex);
            return bl;
        }
        catch (IOException e) {
            Log.e(TAG, "Error mapping font file " + path);
            return false;
        }
    }

    public boolean addFontWeightStyle(ByteBuffer font, int ttcIndex, List<FontListParser.Axis> axes, int weight, boolean style2) {
        return FontFamily.nAddFontWeightStyle(this.mNativePtr, font, ttcIndex, axes, weight, style2);
    }

    public boolean addFontFromAsset(AssetManager mgr, String path) {
        return FontFamily.nAddFontFromAsset(this.mNativePtr, mgr, path);
    }

    private static native long nCreateFamily(String var0, int var1);

    private static native void nUnrefFamily(long var0);

    private static native boolean nAddFont(long var0, ByteBuffer var2, int var3);

    private static native boolean nAddFontWeightStyle(long var0, ByteBuffer var2, int var3, List<FontListParser.Axis> var4, int var5, boolean var6);

    private static native boolean nAddFontFromAsset(long var0, AssetManager var2, String var3);
}

