/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Path;
import android.graphics.Rect;

public final class Outline {
    private static final float RADIUS_UNDEFINED = Float.NEGATIVE_INFINITY;
    public static final int MODE_EMPTY = 0;
    public static final int MODE_ROUND_RECT = 1;
    public static final int MODE_CONVEX_PATH = 2;
    public int mMode = 0;
    public final Path mPath = new Path();
    public final Rect mRect = new Rect();
    public float mRadius = Float.NEGATIVE_INFINITY;
    public float mAlpha;

    public Outline() {
    }

    public Outline(Outline src) {
        this.set(src);
    }

    public void setEmpty() {
        this.mMode = 0;
        this.mPath.rewind();
        this.mRect.setEmpty();
        this.mRadius = Float.NEGATIVE_INFINITY;
    }

    public boolean isEmpty() {
        return this.mMode == 0;
    }

    public boolean canClip() {
        return this.mMode != 2;
    }

    public void setAlpha(float alpha) {
        this.mAlpha = alpha;
    }

    public float getAlpha() {
        return this.mAlpha;
    }

    public void set(Outline src) {
        this.mMode = src.mMode;
        this.mPath.set(src.mPath);
        this.mRect.set(src.mRect);
        this.mRadius = src.mRadius;
        this.mAlpha = src.mAlpha;
    }

    public void setRect(int left, int top, int right, int bottom) {
        this.setRoundRect(left, top, right, bottom, 0.0f);
    }

    public void setRect(Rect rect) {
        this.setRect(rect.left, rect.top, rect.right, rect.bottom);
    }

    public void setRoundRect(int left, int top, int right, int bottom, float radius) {
        if (left >= right || top >= bottom) {
            this.setEmpty();
            return;
        }
        this.mMode = 1;
        this.mRect.set(left, top, right, bottom);
        this.mRadius = radius;
        this.mPath.rewind();
    }

    public void setRoundRect(Rect rect, float radius) {
        this.setRoundRect(rect.left, rect.top, rect.right, rect.bottom, radius);
    }

    public boolean getRect(Rect outRect) {
        if (this.mMode != 1) {
            return false;
        }
        outRect.set(this.mRect);
        return true;
    }

    public float getRadius() {
        return this.mRadius;
    }

    public void setOval(int left, int top, int right, int bottom) {
        if (left >= right || top >= bottom) {
            this.setEmpty();
            return;
        }
        if (bottom - top == right - left) {
            this.setRoundRect(left, top, right, bottom, (float)(bottom - top) / 2.0f);
            return;
        }
        this.mMode = 2;
        this.mPath.rewind();
        this.mPath.addOval(left, top, right, bottom, Path.Direction.CW);
        this.mRect.setEmpty();
        this.mRadius = Float.NEGATIVE_INFINITY;
    }

    public void setOval(Rect rect) {
        this.setOval(rect.left, rect.top, rect.right, rect.bottom);
    }

    public void setConvexPath(Path convexPath) {
        if (convexPath.isEmpty()) {
            this.setEmpty();
            return;
        }
        if (!convexPath.isConvex()) {
            throw new IllegalArgumentException("path must be convex");
        }
        this.mMode = 2;
        this.mPath.set(convexPath);
        this.mRect.setEmpty();
        this.mRadius = Float.NEGATIVE_INFINITY;
    }

    public void offset(int dx, int dy) {
        if (this.mMode == 1) {
            this.mRect.offset(dx, dy);
        } else if (this.mMode == 2) {
            this.mPath.offset(dx, dy);
        }
    }
}

