/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.ColorFilter;
import android.graphics.MaskFilter;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rasterizer;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.TemporaryBuffer;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.os.LocaleList;
import android.text.GraphicsOperations;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextUtils;
import com.android.internal.annotations.GuardedBy;
import java.util.HashMap;
import java.util.Locale;
import libcore.util.NativeAllocationRegistry;

public class Paint {
    private long mNativePaint;
    private long mNativeShader = 0L;
    private static final long NATIVE_PAINT_SIZE = 98L;
    public long mNativeTypeface;
    private ColorFilter mColorFilter;
    private MaskFilter mMaskFilter;
    private PathEffect mPathEffect;
    private Rasterizer mRasterizer;
    private Shader mShader;
    private Typeface mTypeface;
    private Xfermode mXfermode;
    private boolean mHasCompatScaling;
    private float mCompatScaling;
    private float mInvCompatScaling;
    private LocaleList mLocales;
    private String mFontFeatureSettings;
    private static final Object sCacheLock = new Object();
    @GuardedBy(value="sCacheLock")
    private static final HashMap<String, Integer> sMinikinLangListIdCache = new HashMap();
    public int mBidiFlags = 2;
    static final Style[] sStyleArray = new Style[]{Style.FILL, Style.STROKE, Style.FILL_AND_STROKE};
    static final Cap[] sCapArray = new Cap[]{Cap.BUTT, Cap.ROUND, Cap.SQUARE};
    static final Join[] sJoinArray = new Join[]{Join.MITER, Join.ROUND, Join.BEVEL};
    static final Align[] sAlignArray = new Align[]{Align.LEFT, Align.CENTER, Align.RIGHT};
    public static final int ANTI_ALIAS_FLAG = 1;
    public static final int FILTER_BITMAP_FLAG = 2;
    public static final int DITHER_FLAG = 4;
    public static final int UNDERLINE_TEXT_FLAG = 8;
    public static final int STRIKE_THRU_TEXT_FLAG = 16;
    public static final int FAKE_BOLD_TEXT_FLAG = 32;
    public static final int LINEAR_TEXT_FLAG = 64;
    public static final int SUBPIXEL_TEXT_FLAG = 128;
    public static final int DEV_KERN_TEXT_FLAG = 256;
    public static final int LCD_RENDER_TEXT_FLAG = 512;
    public static final int EMBEDDED_BITMAP_TEXT_FLAG = 1024;
    public static final int AUTO_HINTING_TEXT_FLAG = 2048;
    public static final int VERTICAL_TEXT_FLAG = 4096;
    static final int HIDDEN_DEFAULT_PAINT_FLAGS = 1280;
    public static final int HINTING_OFF = 0;
    public static final int HINTING_ON = 1;
    public static final int BIDI_LTR = 0;
    public static final int BIDI_RTL = 1;
    public static final int BIDI_DEFAULT_LTR = 2;
    public static final int BIDI_DEFAULT_RTL = 3;
    public static final int BIDI_FORCE_LTR = 4;
    public static final int BIDI_FORCE_RTL = 5;
    private static final int BIDI_MAX_FLAG_VALUE = 5;
    private static final int BIDI_FLAG_MASK = 7;
    public static final int DIRECTION_LTR = 0;
    public static final int DIRECTION_RTL = 1;
    public static final int CURSOR_AFTER = 0;
    public static final int CURSOR_AT_OR_AFTER = 1;
    public static final int CURSOR_BEFORE = 2;
    public static final int CURSOR_AT_OR_BEFORE = 3;
    public static final int CURSOR_AT = 4;
    private static final int CURSOR_OPT_MAX_VALUE = 4;

    public Paint() {
        this(0);
    }

    public Paint(int flags) {
        this.mNativePaint = Paint.nInit();
        NoImagePreloadHolder.sRegistry.registerNativeAllocation((Object)this, this.mNativePaint);
        this.setFlags(flags | 0x500);
        this.mInvCompatScaling = 1.0f;
        this.mCompatScaling = 1.0f;
        this.setTextLocales(LocaleList.getAdjustedDefault());
    }

    public Paint(Paint paint) {
        this.mNativePaint = Paint.nInitWithPaint(paint.getNativeInstance());
        NoImagePreloadHolder.sRegistry.registerNativeAllocation((Object)this, this.mNativePaint);
        this.setClassVariablesFrom(paint);
    }

    public void reset() {
        Paint.nReset(this.mNativePaint);
        this.setFlags(1280);
        this.mColorFilter = null;
        this.mMaskFilter = null;
        this.mPathEffect = null;
        this.mRasterizer = null;
        this.mShader = null;
        this.mNativeShader = 0L;
        this.mTypeface = null;
        this.mNativeTypeface = 0L;
        this.mXfermode = null;
        this.mHasCompatScaling = false;
        this.mCompatScaling = 1.0f;
        this.mInvCompatScaling = 1.0f;
        this.mBidiFlags = 2;
        this.setTextLocales(LocaleList.getAdjustedDefault());
        this.setElegantTextHeight(false);
        this.mFontFeatureSettings = null;
    }

    public void set(Paint src) {
        if (this != src) {
            Paint.nSet(this.mNativePaint, src.mNativePaint);
            this.setClassVariablesFrom(src);
        }
    }

    private void setClassVariablesFrom(Paint paint) {
        this.mColorFilter = paint.mColorFilter;
        this.mMaskFilter = paint.mMaskFilter;
        this.mPathEffect = paint.mPathEffect;
        this.mRasterizer = paint.mRasterizer;
        this.mShader = paint.mShader;
        this.mNativeShader = paint.mNativeShader;
        this.mTypeface = paint.mTypeface;
        this.mNativeTypeface = paint.mNativeTypeface;
        this.mXfermode = paint.mXfermode;
        this.mHasCompatScaling = paint.mHasCompatScaling;
        this.mCompatScaling = paint.mCompatScaling;
        this.mInvCompatScaling = paint.mInvCompatScaling;
        this.mBidiFlags = paint.mBidiFlags;
        this.mLocales = paint.mLocales;
        this.mFontFeatureSettings = paint.mFontFeatureSettings;
    }

    public void setCompatibilityScaling(float factor) {
        if ((double)factor == 1.0) {
            this.mHasCompatScaling = false;
            this.mInvCompatScaling = 1.0f;
            this.mCompatScaling = 1.0f;
        } else {
            this.mHasCompatScaling = true;
            this.mCompatScaling = factor;
            this.mInvCompatScaling = 1.0f / factor;
        }
    }

    public long getNativeInstance() {
        long newNativeShader;
        long l = newNativeShader = this.mShader == null ? 0L : this.mShader.getNativeInstance();
        if (newNativeShader != this.mNativeShader) {
            this.mNativeShader = newNativeShader;
            Paint.nSetShader(this.mNativePaint, this.mNativeShader);
        }
        return this.mNativePaint;
    }

    public int getBidiFlags() {
        return this.mBidiFlags;
    }

    public void setBidiFlags(int flags) {
        if ((flags &= 7) > 5) {
            throw new IllegalArgumentException("unknown bidi flag: " + flags);
        }
        this.mBidiFlags = flags;
    }

    public int getFlags() {
        return this.nGetFlags(this.mNativePaint);
    }

    private native int nGetFlags(long var1);

    public void setFlags(int flags) {
        this.nSetFlags(this.mNativePaint, flags);
    }

    private native void nSetFlags(long var1, int var3);

    public int getHinting() {
        return this.nGetHinting(this.mNativePaint);
    }

    private native int nGetHinting(long var1);

    public void setHinting(int mode) {
        this.nSetHinting(this.mNativePaint, mode);
    }

    private native void nSetHinting(long var1, int var3);

    public final boolean isAntiAlias() {
        return (this.getFlags() & 1) != 0;
    }

    public void setAntiAlias(boolean aa) {
        this.nSetAntiAlias(this.mNativePaint, aa);
    }

    private native void nSetAntiAlias(long var1, boolean var3);

    public final boolean isDither() {
        return (this.getFlags() & 4) != 0;
    }

    public void setDither(boolean dither) {
        this.nSetDither(this.mNativePaint, dither);
    }

    private native void nSetDither(long var1, boolean var3);

    public final boolean isLinearText() {
        return (this.getFlags() & 0x40) != 0;
    }

    public void setLinearText(boolean linearText) {
        this.nSetLinearText(this.mNativePaint, linearText);
    }

    private native void nSetLinearText(long var1, boolean var3);

    public final boolean isSubpixelText() {
        return (this.getFlags() & 0x80) != 0;
    }

    public void setSubpixelText(boolean subpixelText) {
        this.nSetSubpixelText(this.mNativePaint, subpixelText);
    }

    private native void nSetSubpixelText(long var1, boolean var3);

    public final boolean isUnderlineText() {
        return (this.getFlags() & 8) != 0;
    }

    public void setUnderlineText(boolean underlineText) {
        this.nSetUnderlineText(this.mNativePaint, underlineText);
    }

    private native void nSetUnderlineText(long var1, boolean var3);

    public final boolean isStrikeThruText() {
        return (this.getFlags() & 0x10) != 0;
    }

    public void setStrikeThruText(boolean strikeThruText) {
        this.nSetStrikeThruText(this.mNativePaint, strikeThruText);
    }

    private native void nSetStrikeThruText(long var1, boolean var3);

    public final boolean isFakeBoldText() {
        return (this.getFlags() & 0x20) != 0;
    }

    public void setFakeBoldText(boolean fakeBoldText) {
        this.nSetFakeBoldText(this.mNativePaint, fakeBoldText);
    }

    private native void nSetFakeBoldText(long var1, boolean var3);

    public final boolean isFilterBitmap() {
        return (this.getFlags() & 2) != 0;
    }

    public void setFilterBitmap(boolean filter) {
        this.nSetFilterBitmap(this.mNativePaint, filter);
    }

    private native void nSetFilterBitmap(long var1, boolean var3);

    public Style getStyle() {
        return sStyleArray[Paint.nGetStyle(this.mNativePaint)];
    }

    public void setStyle(Style style2) {
        Paint.nSetStyle(this.mNativePaint, style2.nativeInt);
    }

    public int getColor() {
        return this.nGetColor(this.mNativePaint);
    }

    private native int nGetColor(long var1);

    public void setColor(int color2) {
        this.nSetColor(this.mNativePaint, color2);
    }

    private native void nSetColor(long var1, int var3);

    public int getAlpha() {
        return this.nGetAlpha(this.mNativePaint);
    }

    private native int nGetAlpha(long var1);

    public void setAlpha(int a) {
        this.nSetAlpha(this.mNativePaint, a);
    }

    private native void nSetAlpha(long var1, int var3);

    public void setARGB(int a, int r, int g, int b) {
        this.setColor(a << 24 | r << 16 | g << 8 | b);
    }

    public float getStrokeWidth() {
        return this.nGetStrokeWidth(this.mNativePaint);
    }

    private native float nGetStrokeWidth(long var1);

    public void setStrokeWidth(float width) {
        this.nSetStrokeWidth(this.mNativePaint, width);
    }

    private native void nSetStrokeWidth(long var1, float var3);

    public float getStrokeMiter() {
        return this.nGetStrokeMiter(this.mNativePaint);
    }

    private native float nGetStrokeMiter(long var1);

    public void setStrokeMiter(float miter) {
        this.nSetStrokeMiter(this.mNativePaint, miter);
    }

    private native void nSetStrokeMiter(long var1, float var3);

    public Cap getStrokeCap() {
        return sCapArray[Paint.nGetStrokeCap(this.mNativePaint)];
    }

    public void setStrokeCap(Cap cap) {
        Paint.nSetStrokeCap(this.mNativePaint, cap.nativeInt);
    }

    public Join getStrokeJoin() {
        return sJoinArray[Paint.nGetStrokeJoin(this.mNativePaint)];
    }

    public void setStrokeJoin(Join join) {
        Paint.nSetStrokeJoin(this.mNativePaint, join.nativeInt);
    }

    public boolean getFillPath(Path src, Path dst) {
        return Paint.nGetFillPath(this.mNativePaint, src.readOnlyNI(), dst.mutateNI());
    }

    public Shader getShader() {
        return this.mShader;
    }

    public Shader setShader(Shader shader) {
        if (this.mShader != shader) {
            this.mNativeShader = -1L;
        }
        this.mShader = shader;
        return shader;
    }

    public ColorFilter getColorFilter() {
        return this.mColorFilter;
    }

    public ColorFilter setColorFilter(ColorFilter filter) {
        long filterNative = 0L;
        if (filter != null) {
            filterNative = filter.native_instance;
        }
        Paint.nSetColorFilter(this.mNativePaint, filterNative);
        this.mColorFilter = filter;
        return filter;
    }

    public Xfermode getXfermode() {
        return this.mXfermode;
    }

    public Xfermode setXfermode(Xfermode xfermode) {
        long xfermodeNative = 0L;
        if (xfermode != null) {
            xfermodeNative = xfermode.native_instance;
        }
        Paint.nSetXfermode(this.mNativePaint, xfermodeNative);
        this.mXfermode = xfermode;
        return xfermode;
    }

    public PathEffect getPathEffect() {
        return this.mPathEffect;
    }

    public PathEffect setPathEffect(PathEffect effect) {
        long effectNative = 0L;
        if (effect != null) {
            effectNative = effect.native_instance;
        }
        Paint.nSetPathEffect(this.mNativePaint, effectNative);
        this.mPathEffect = effect;
        return effect;
    }

    public MaskFilter getMaskFilter() {
        return this.mMaskFilter;
    }

    public MaskFilter setMaskFilter(MaskFilter maskfilter) {
        long maskfilterNative = 0L;
        if (maskfilter != null) {
            maskfilterNative = maskfilter.native_instance;
        }
        Paint.nSetMaskFilter(this.mNativePaint, maskfilterNative);
        this.mMaskFilter = maskfilter;
        return maskfilter;
    }

    public Typeface getTypeface() {
        return this.mTypeface;
    }

    public Typeface setTypeface(Typeface typeface) {
        long typefaceNative = 0L;
        if (typeface != null) {
            typefaceNative = typeface.native_instance;
        }
        Paint.nSetTypeface(this.mNativePaint, typefaceNative);
        this.mTypeface = typeface;
        this.mNativeTypeface = typefaceNative;
        return typeface;
    }

    @Deprecated
    public Rasterizer getRasterizer() {
        return this.mRasterizer;
    }

    @Deprecated
    public Rasterizer setRasterizer(Rasterizer rasterizer) {
        long rasterizerNative = 0L;
        if (rasterizer != null) {
            rasterizerNative = rasterizer.native_instance;
        }
        Paint.nSetRasterizer(this.mNativePaint, rasterizerNative);
        this.mRasterizer = rasterizer;
        return rasterizer;
    }

    public void setShadowLayer(float radius, float dx, float dy, int shadowColor) {
        Paint.nSetShadowLayer(this.mNativePaint, radius, dx, dy, shadowColor);
    }

    public void clearShadowLayer() {
        this.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
    }

    public boolean hasShadowLayer() {
        return Paint.nHasShadowLayer(this.mNativePaint);
    }

    public Align getTextAlign() {
        return sAlignArray[Paint.nGetTextAlign(this.mNativePaint)];
    }

    public void setTextAlign(Align align) {
        Paint.nSetTextAlign(this.mNativePaint, align.nativeInt);
    }

    public Locale getTextLocale() {
        return this.mLocales.get(0);
    }

    public LocaleList getTextLocales() {
        return this.mLocales;
    }

    public void setTextLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale cannot be null");
        }
        if (this.mLocales != null && this.mLocales.size() == 1 && locale.equals(this.mLocales.get(0))) {
            return;
        }
        this.mLocales = new LocaleList(locale);
        this.syncTextLocalesWithMinikin();
    }

    public void setTextLocales(LocaleList locales) {
        if (locales == null || locales.isEmpty()) {
            throw new IllegalArgumentException("locales cannot be null or empty");
        }
        if (locales.equals(this.mLocales)) {
            return;
        }
        this.mLocales = locales;
        this.syncTextLocalesWithMinikin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncTextLocalesWithMinikin() {
        Integer minikinLangListId;
        String languageTags = this.mLocales.toLanguageTags();
        Object object = sCacheLock;
        synchronized (object) {
            minikinLangListId = sMinikinLangListIdCache.get(languageTags);
            if (minikinLangListId == null) {
                int newID = Paint.nSetTextLocales(this.mNativePaint, languageTags);
                sMinikinLangListIdCache.put(languageTags, newID);
                return;
            }
        }
        Paint.nSetTextLocalesByMinikinLangListId(this.mNativePaint, minikinLangListId);
    }

    public boolean isElegantTextHeight() {
        return this.nIsElegantTextHeight(this.mNativePaint);
    }

    private native boolean nIsElegantTextHeight(long var1);

    public void setElegantTextHeight(boolean elegant) {
        this.nSetElegantTextHeight(this.mNativePaint, elegant);
    }

    private native void nSetElegantTextHeight(long var1, boolean var3);

    public float getTextSize() {
        return this.nGetTextSize(this.mNativePaint);
    }

    private native float nGetTextSize(long var1);

    public void setTextSize(float textSize) {
        this.nSetTextSize(this.mNativePaint, textSize);
    }

    private native void nSetTextSize(long var1, float var3);

    public float getTextScaleX() {
        return this.nGetTextScaleX(this.mNativePaint);
    }

    private native float nGetTextScaleX(long var1);

    public void setTextScaleX(float scaleX) {
        this.nSetTextScaleX(this.mNativePaint, scaleX);
    }

    private native void nSetTextScaleX(long var1, float var3);

    public float getTextSkewX() {
        return this.nGetTextSkewX(this.mNativePaint);
    }

    private native float nGetTextSkewX(long var1);

    public void setTextSkewX(float skewX) {
        this.nSetTextSkewX(this.mNativePaint, skewX);
    }

    private native void nSetTextSkewX(long var1, float var3);

    public float getLetterSpacing() {
        return Paint.nGetLetterSpacing(this.mNativePaint);
    }

    public void setLetterSpacing(float letterSpacing) {
        Paint.nSetLetterSpacing(this.mNativePaint, letterSpacing);
    }

    public String getFontFeatureSettings() {
        return this.mFontFeatureSettings;
    }

    public void setFontFeatureSettings(String settings) {
        if (settings != null && settings.equals("")) {
            settings = null;
        }
        if (settings == null && this.mFontFeatureSettings == null || settings != null && settings.equals(this.mFontFeatureSettings)) {
            return;
        }
        this.mFontFeatureSettings = settings;
        Paint.nSetFontFeatureSettings(this.mNativePaint, settings);
    }

    public int getHyphenEdit() {
        return Paint.nGetHyphenEdit(this.mNativePaint);
    }

    public void setHyphenEdit(int hyphen) {
        Paint.nSetHyphenEdit(this.mNativePaint, hyphen);
    }

    public float ascent() {
        return this.nAscent(this.mNativePaint, this.mNativeTypeface);
    }

    private native float nAscent(long var1, long var3);

    public float descent() {
        return this.nDescent(this.mNativePaint, this.mNativeTypeface);
    }

    private native float nDescent(long var1, long var3);

    public float getFontMetrics(FontMetrics metrics) {
        return this.nGetFontMetrics(this.mNativePaint, this.mNativeTypeface, metrics);
    }

    private native float nGetFontMetrics(long var1, long var3, FontMetrics var5);

    public FontMetrics getFontMetrics() {
        FontMetrics fm = new FontMetrics();
        this.getFontMetrics(fm);
        return fm;
    }

    public int getFontMetricsInt(FontMetricsInt fmi) {
        return this.nGetFontMetricsInt(this.mNativePaint, this.mNativeTypeface, fmi);
    }

    private native int nGetFontMetricsInt(long var1, long var3, FontMetricsInt var5);

    public FontMetricsInt getFontMetricsInt() {
        FontMetricsInt fm = new FontMetricsInt();
        this.getFontMetricsInt(fm);
        return fm;
    }

    public float getFontSpacing() {
        return this.getFontMetrics(null);
    }

    public float measureText(char[] text, int index, int count) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((index | count) < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (text.length == 0 || count == 0) {
            return 0.0f;
        }
        if (!this.mHasCompatScaling) {
            return (float)Math.ceil(Paint.nGetTextAdvances(this.mNativePaint, this.mNativeTypeface, text, index, count, index, count, this.mBidiFlags, null, 0));
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        float w = Paint.nGetTextAdvances(this.mNativePaint, this.mNativeTypeface, text, index, count, index, count, this.mBidiFlags, null, 0);
        this.setTextSize(oldSize);
        return (float)Math.ceil(w * this.mInvCompatScaling);
    }

    public float measureText(String text, int start, int end) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (text.length() == 0 || start == end) {
            return 0.0f;
        }
        if (!this.mHasCompatScaling) {
            return (float)Math.ceil(Paint.nGetTextAdvances(this.mNativePaint, this.mNativeTypeface, text, start, end, start, end, this.mBidiFlags, null, 0));
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        float w = Paint.nGetTextAdvances(this.mNativePaint, this.mNativeTypeface, text, start, end, start, end, this.mBidiFlags, null, 0);
        this.setTextSize(oldSize);
        return (float)Math.ceil(w * this.mInvCompatScaling);
    }

    public float measureText(String text) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        return this.measureText(text, 0, text.length());
    }

    public float measureText(CharSequence text, int start, int end) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (text.length() == 0 || start == end) {
            return 0.0f;
        }
        if (text instanceof String) {
            return this.measureText((String)text, start, end);
        }
        if (text instanceof SpannedString || text instanceof SpannableString) {
            return this.measureText(text.toString(), start, end);
        }
        if (text instanceof GraphicsOperations) {
            return ((GraphicsOperations)text).measureText(start, end, this);
        }
        char[] buf = TemporaryBuffer.obtain(end - start);
        TextUtils.getChars(text, start, end, buf, 0);
        float result = this.measureText(buf, 0, end - start);
        TemporaryBuffer.recycle(buf);
        return result;
    }

    public int breakText(char[] text, int index, int count, float maxWidth, float[] measuredWidth) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if (index < 0 || text.length - index < Math.abs(count)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (text.length == 0 || count == 0) {
            return 0;
        }
        if (!this.mHasCompatScaling) {
            return Paint.nBreakText(this.mNativePaint, this.mNativeTypeface, text, index, count, maxWidth, this.mBidiFlags, measuredWidth);
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        int res = Paint.nBreakText(this.mNativePaint, this.mNativeTypeface, text, index, count, maxWidth * this.mCompatScaling, this.mBidiFlags, measuredWidth);
        this.setTextSize(oldSize);
        if (measuredWidth != null) {
            measuredWidth[0] = measuredWidth[0] * this.mInvCompatScaling;
        }
        return res;
    }

    private static native int nBreakText(long var0, long var2, char[] var4, int var5, int var6, float var7, int var8, float[] var9);

    public int breakText(CharSequence text, int start, int end, boolean measureForwards, float maxWidth, float[] measuredWidth) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (text.length() == 0 || start == end) {
            return 0;
        }
        if (start == 0 && text instanceof String && end == text.length()) {
            return this.breakText((String)text, measureForwards, maxWidth, measuredWidth);
        }
        char[] buf = TemporaryBuffer.obtain(end - start);
        TextUtils.getChars(text, start, end, buf, 0);
        int result = measureForwards ? this.breakText(buf, 0, end - start, maxWidth, measuredWidth) : this.breakText(buf, 0, -(end - start), maxWidth, measuredWidth);
        TemporaryBuffer.recycle(buf);
        return result;
    }

    public int breakText(String text, boolean measureForwards, float maxWidth, float[] measuredWidth) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if (text.length() == 0) {
            return 0;
        }
        if (!this.mHasCompatScaling) {
            return Paint.nBreakText(this.mNativePaint, this.mNativeTypeface, text, measureForwards, maxWidth, this.mBidiFlags, measuredWidth);
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        int res = Paint.nBreakText(this.mNativePaint, this.mNativeTypeface, text, measureForwards, maxWidth * this.mCompatScaling, this.mBidiFlags, measuredWidth);
        this.setTextSize(oldSize);
        if (measuredWidth != null) {
            measuredWidth[0] = measuredWidth[0] * this.mInvCompatScaling;
        }
        return res;
    }

    private static native int nBreakText(long var0, long var2, String var4, boolean var5, float var6, int var7, float[] var8);

    public int getTextWidths(char[] text, int index, int count, float[] widths) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((index | count) < 0 || index + count > text.length || count > widths.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (text.length == 0 || count == 0) {
            return 0;
        }
        if (!this.mHasCompatScaling) {
            Paint.nGetTextAdvances(this.mNativePaint, this.mNativeTypeface, text, index, count, index, count, this.mBidiFlags, widths, 0);
            return count;
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        Paint.nGetTextAdvances(this.mNativePaint, this.mNativeTypeface, text, index, count, index, count, this.mBidiFlags, widths, 0);
        this.setTextSize(oldSize);
        int i = 0;
        while (i < count) {
            int n = i++;
            widths[n] = widths[n] * this.mInvCompatScaling;
        }
        return count;
    }

    public int getTextWidths(CharSequence text, int start, int end, float[] widths) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (end - start > widths.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (text.length() == 0 || start == end) {
            return 0;
        }
        if (text instanceof String) {
            return this.getTextWidths((String)text, start, end, widths);
        }
        if (text instanceof SpannedString || text instanceof SpannableString) {
            return this.getTextWidths(text.toString(), start, end, widths);
        }
        if (text instanceof GraphicsOperations) {
            return ((GraphicsOperations)text).getTextWidths(start, end, widths, this);
        }
        char[] buf = TemporaryBuffer.obtain(end - start);
        TextUtils.getChars(text, start, end, buf, 0);
        int result = this.getTextWidths(buf, 0, end - start, widths);
        TemporaryBuffer.recycle(buf);
        return result;
    }

    public int getTextWidths(String text, int start, int end, float[] widths) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (end - start > widths.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (text.length() == 0 || start == end) {
            return 0;
        }
        if (!this.mHasCompatScaling) {
            Paint.nGetTextAdvances(this.mNativePaint, this.mNativeTypeface, text, start, end, start, end, this.mBidiFlags, widths, 0);
            return end - start;
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        Paint.nGetTextAdvances(this.mNativePaint, this.mNativeTypeface, text, start, end, start, end, this.mBidiFlags, widths, 0);
        this.setTextSize(oldSize);
        int i = 0;
        while (i < end - start) {
            int n = i++;
            widths[n] = widths[n] * this.mInvCompatScaling;
        }
        return end - start;
    }

    public int getTextWidths(String text, float[] widths) {
        return this.getTextWidths(text, 0, text.length(), widths);
    }

    public float getTextRunAdvances(char[] chars, int index, int count, int contextIndex, int contextCount, boolean isRtl, float[] advances, int advancesIndex) {
        if (chars == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((index | count | contextIndex | contextCount | advancesIndex | index - contextIndex | contextCount - count | contextIndex + contextCount - (index + count) | chars.length - (contextIndex + contextCount) | (advances == null ? 0 : advances.length - (advancesIndex + count))) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (chars.length == 0 || count == 0) {
            return 0.0f;
        }
        if (!this.mHasCompatScaling) {
            return Paint.nGetTextAdvances(this.mNativePaint, this.mNativeTypeface, chars, index, count, contextIndex, contextCount, isRtl ? 5 : 4, advances, advancesIndex);
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        float res = Paint.nGetTextAdvances(this.mNativePaint, this.mNativeTypeface, chars, index, count, contextIndex, contextCount, isRtl ? 5 : 4, advances, advancesIndex);
        this.setTextSize(oldSize);
        if (advances != null) {
            int i = advancesIndex;
            int e = i + count;
            while (i < e) {
                int n = i++;
                advances[n] = advances[n] * this.mInvCompatScaling;
            }
        }
        return res * this.mInvCompatScaling;
    }

    public float getTextRunAdvances(CharSequence text, int start, int end, int contextStart, int contextEnd, boolean isRtl, float[] advances, int advancesIndex) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((start | end | contextStart | contextEnd | advancesIndex | end - start | start - contextStart | contextEnd - end | text.length() - contextEnd | (advances == null ? 0 : advances.length - advancesIndex - (end - start))) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (text instanceof String) {
            return this.getTextRunAdvances((String)text, start, end, contextStart, contextEnd, isRtl, advances, advancesIndex);
        }
        if (text instanceof SpannedString || text instanceof SpannableString) {
            return this.getTextRunAdvances(text.toString(), start, end, contextStart, contextEnd, isRtl, advances, advancesIndex);
        }
        if (text instanceof GraphicsOperations) {
            return ((GraphicsOperations)text).getTextRunAdvances(start, end, contextStart, contextEnd, isRtl, advances, advancesIndex, this);
        }
        if (text.length() == 0 || end == start) {
            return 0.0f;
        }
        int contextLen = contextEnd - contextStart;
        int len = end - start;
        char[] buf = TemporaryBuffer.obtain(contextLen);
        TextUtils.getChars(text, contextStart, contextEnd, buf, 0);
        float result = this.getTextRunAdvances(buf, start - contextStart, len, 0, contextLen, isRtl, advances, advancesIndex);
        TemporaryBuffer.recycle(buf);
        return result;
    }

    public float getTextRunAdvances(String text, int start, int end, int contextStart, int contextEnd, boolean isRtl, float[] advances, int advancesIndex) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((start | end | contextStart | contextEnd | advancesIndex | end - start | start - contextStart | contextEnd - end | text.length() - contextEnd | (advances == null ? 0 : advances.length - advancesIndex - (end - start))) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (text.length() == 0 || start == end) {
            return 0.0f;
        }
        if (!this.mHasCompatScaling) {
            return Paint.nGetTextAdvances(this.mNativePaint, this.mNativeTypeface, text, start, end, contextStart, contextEnd, isRtl ? 5 : 4, advances, advancesIndex);
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        float totalAdvance = Paint.nGetTextAdvances(this.mNativePaint, this.mNativeTypeface, text, start, end, contextStart, contextEnd, isRtl ? 5 : 4, advances, advancesIndex);
        this.setTextSize(oldSize);
        if (advances != null) {
            int i = advancesIndex;
            int e = i + (end - start);
            while (i < e) {
                int n = i++;
                advances[n] = advances[n] * this.mInvCompatScaling;
            }
        }
        return totalAdvance * this.mInvCompatScaling;
    }

    public int getTextRunCursor(char[] text, int contextStart, int contextLength, int dir, int offset, int cursorOpt) {
        int contextEnd = contextStart + contextLength;
        if ((contextStart | contextEnd | offset | contextEnd - contextStart | offset - contextStart | contextEnd - offset | text.length - contextEnd | cursorOpt) < 0 || cursorOpt > 4) {
            throw new IndexOutOfBoundsException();
        }
        return this.nGetTextRunCursor(this.mNativePaint, text, contextStart, contextLength, dir, offset, cursorOpt);
    }

    public int getTextRunCursor(CharSequence text, int contextStart, int contextEnd, int dir, int offset, int cursorOpt) {
        if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
            return this.getTextRunCursor(text.toString(), contextStart, contextEnd, dir, offset, cursorOpt);
        }
        if (text instanceof GraphicsOperations) {
            return ((GraphicsOperations)text).getTextRunCursor(contextStart, contextEnd, dir, offset, cursorOpt, this);
        }
        int contextLen = contextEnd - contextStart;
        char[] buf = TemporaryBuffer.obtain(contextLen);
        TextUtils.getChars(text, contextStart, contextEnd, buf, 0);
        int relPos = this.getTextRunCursor(buf, 0, contextLen, dir, offset - contextStart, cursorOpt);
        TemporaryBuffer.recycle(buf);
        return relPos == -1 ? -1 : relPos + contextStart;
    }

    public int getTextRunCursor(String text, int contextStart, int contextEnd, int dir, int offset, int cursorOpt) {
        if ((contextStart | contextEnd | offset | contextEnd - contextStart | offset - contextStart | contextEnd - offset | text.length() - contextEnd | cursorOpt) < 0 || cursorOpt > 4) {
            throw new IndexOutOfBoundsException();
        }
        return this.nGetTextRunCursor(this.mNativePaint, text, contextStart, contextEnd, dir, offset, cursorOpt);
    }

    public void getTextPath(char[] text, int index, int count, float x, float y, Path path) {
        if ((index | count) < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Paint.nGetTextPath(this.mNativePaint, this.mNativeTypeface, this.mBidiFlags, text, index, count, x, y, path.mutateNI());
    }

    public void getTextPath(String text, int start, int end, float x, float y, Path path) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        Paint.nGetTextPath(this.mNativePaint, this.mNativeTypeface, this.mBidiFlags, text, start, end, x, y, path.mutateNI());
    }

    public void getTextBounds(String text, int start, int end, Rect bounds) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (bounds == null) {
            throw new NullPointerException("need bounds Rect");
        }
        Paint.nGetStringBounds(this.mNativePaint, this.mNativeTypeface, text, start, end, this.mBidiFlags, bounds);
    }

    public void getTextBounds(char[] text, int index, int count, Rect bounds) {
        if ((index | count) < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (bounds == null) {
            throw new NullPointerException("need bounds Rect");
        }
        Paint.nGetCharArrayBounds(this.mNativePaint, this.mNativeTypeface, text, index, count, this.mBidiFlags, bounds);
    }

    public boolean hasGlyph(String string2) {
        return Paint.nHasGlyph(this.mNativePaint, this.mNativeTypeface, this.mBidiFlags, string2);
    }

    public float getRunAdvance(char[] text, int start, int end, int contextStart, int contextEnd, boolean isRtl, int offset) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((contextStart | start | offset | end | contextEnd | start - contextStart | offset - start | end - offset | contextEnd - end | text.length - contextEnd) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (end == start) {
            return 0.0f;
        }
        return Paint.nGetRunAdvance(this.mNativePaint, this.mNativeTypeface, text, start, end, contextStart, contextEnd, isRtl, offset);
    }

    public float getRunAdvance(CharSequence text, int start, int end, int contextStart, int contextEnd, boolean isRtl, int offset) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((contextStart | start | offset | end | contextEnd | start - contextStart | offset - start | end - offset | contextEnd - end | text.length() - contextEnd) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (end == start) {
            return 0.0f;
        }
        char[] buf = TemporaryBuffer.obtain(contextEnd - contextStart);
        TextUtils.getChars(text, contextStart, contextEnd, buf, 0);
        float result = this.getRunAdvance(buf, start - contextStart, end - contextStart, 0, contextEnd - contextStart, isRtl, offset - contextStart);
        TemporaryBuffer.recycle(buf);
        return result;
    }

    public int getOffsetForAdvance(char[] text, int start, int end, int contextStart, int contextEnd, boolean isRtl, float advance) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((contextStart | start | end | contextEnd | start - contextStart | end - start | contextEnd - end | text.length - contextEnd) < 0) {
            throw new IndexOutOfBoundsException();
        }
        return Paint.nGetOffsetForAdvance(this.mNativePaint, this.mNativeTypeface, text, start, end, contextStart, contextEnd, isRtl, advance);
    }

    public int getOffsetForAdvance(CharSequence text, int start, int end, int contextStart, int contextEnd, boolean isRtl, float advance) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((contextStart | start | end | contextEnd | start - contextStart | end - start | contextEnd - end | text.length() - contextEnd) < 0) {
            throw new IndexOutOfBoundsException();
        }
        char[] buf = TemporaryBuffer.obtain(contextEnd - contextStart);
        TextUtils.getChars(text, contextStart, contextEnd, buf, 0);
        int result = this.getOffsetForAdvance(buf, start - contextStart, end - contextStart, 0, contextEnd - contextStart, isRtl, advance) + contextStart;
        TemporaryBuffer.recycle(buf);
        return result;
    }

    private static native long nInit();

    private static native long nInitWithPaint(long var0);

    private static native void nReset(long var0);

    private static native void nSet(long var0, long var2);

    private static native int nGetStyle(long var0);

    private static native void nSetStyle(long var0, int var2);

    private static native int nGetStrokeCap(long var0);

    private static native void nSetStrokeCap(long var0, int var2);

    private static native int nGetStrokeJoin(long var0);

    private static native void nSetStrokeJoin(long var0, int var2);

    private static native boolean nGetFillPath(long var0, long var2, long var4);

    private static native long nSetShader(long var0, long var2);

    private static native long nSetColorFilter(long var0, long var2);

    private static native long nSetXfermode(long var0, long var2);

    private static native long nSetPathEffect(long var0, long var2);

    private static native long nSetMaskFilter(long var0, long var2);

    private static native long nSetTypeface(long var0, long var2);

    private static native long nSetRasterizer(long var0, long var2);

    private static native int nGetTextAlign(long var0);

    private static native void nSetTextAlign(long var0, int var2);

    private static native int nSetTextLocales(long var0, String var2);

    private static native void nSetTextLocalesByMinikinLangListId(long var0, int var2);

    private static native float nGetTextAdvances(long var0, long var2, char[] var4, int var5, int var6, int var7, int var8, int var9, float[] var10, int var11);

    private static native float nGetTextAdvances(long var0, long var2, String var4, int var5, int var6, int var7, int var8, int var9, float[] var10, int var11);

    private native int nGetTextRunCursor(long var1, char[] var3, int var4, int var5, int var6, int var7, int var8);

    private native int nGetTextRunCursor(long var1, String var3, int var4, int var5, int var6, int var7, int var8);

    private static native void nGetTextPath(long var0, long var2, int var4, char[] var5, int var6, int var7, float var8, float var9, long var10);

    private static native void nGetTextPath(long var0, long var2, int var4, String var5, int var6, int var7, float var8, float var9, long var10);

    private static native void nGetStringBounds(long var0, long var2, String var4, int var5, int var6, int var7, Rect var8);

    private static native void nGetCharArrayBounds(long var0, long var2, char[] var4, int var5, int var6, int var7, Rect var8);

    private static native long nGetNativeFinalizer();

    private static native void nSetShadowLayer(long var0, float var2, float var3, float var4, int var5);

    private static native boolean nHasShadowLayer(long var0);

    private static native float nGetLetterSpacing(long var0);

    private static native void nSetLetterSpacing(long var0, float var2);

    private static native void nSetFontFeatureSettings(long var0, String var2);

    private static native int nGetHyphenEdit(long var0);

    private static native void nSetHyphenEdit(long var0, int var2);

    private static native boolean nHasGlyph(long var0, long var2, int var4, String var5);

    private static native float nGetRunAdvance(long var0, long var2, char[] var4, int var5, int var6, int var7, int var8, boolean var9, int var10);

    private static native int nGetOffsetForAdvance(long var0, long var2, char[] var4, int var5, int var6, int var7, int var8, boolean var9, float var10);

    static /* synthetic */ long access$000() {
        return Paint.nGetNativeFinalizer();
    }

    public static class FontMetricsInt {
        public int top;
        public int ascent;
        public int descent;
        public int bottom;
        public int leading;

        public String toString() {
            return "FontMetricsInt: top=" + this.top + " ascent=" + this.ascent + " descent=" + this.descent + " bottom=" + this.bottom + " leading=" + this.leading;
        }
    }

    public static class FontMetrics {
        public float top;
        public float ascent;
        public float descent;
        public float bottom;
        public float leading;
    }

    public static enum Align {
        LEFT(0),
        CENTER(1),
        RIGHT(2);

        final int nativeInt;

        private Align(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    public static enum Join {
        MITER(0),
        ROUND(1),
        BEVEL(2);

        final int nativeInt;

        private Join(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    public static enum Cap {
        BUTT(0),
        ROUND(1),
        SQUARE(2);

        final int nativeInt;

        private Cap(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    public static enum Style {
        FILL(0),
        STROKE(1),
        FILL_AND_STROKE(2);

        final int nativeInt;

        private Style(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    private static class NoImagePreloadHolder {
        public static final NativeAllocationRegistry sRegistry = new NativeAllocationRegistry(Paint.class.getClassLoader(), Paint.access$000(), 98L);

        private NoImagePreloadHolder() {
        }
    }
}

