/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.AssetManager;
import android.graphics.FontFamily;
import android.graphics.FontListParser;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.LruCache;
import android.util.SparseArray;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.xmlpull.v1.XmlPullParserException;

public class Typeface {
    private static String TAG = "Typeface";
    public static final Typeface DEFAULT;
    public static final Typeface DEFAULT_BOLD;
    public static final Typeface SANS_SERIF;
    public static final Typeface SERIF;
    public static final Typeface MONOSPACE;
    static Typeface[] sDefaults;
    private static final LongSparseArray<SparseArray<Typeface>> sTypefaceCache;
    private static final LruCache<String, Typeface> sDynamicTypefaceCache;
    static Typeface sDefaultTypeface;
    static Map<String, Typeface> sSystemFontMap;
    static FontFamily[] sFallbackFonts;
    static final String FONTS_CONFIG = "fonts.xml";
    public long native_instance;
    public static final int NORMAL = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int BOLD_ITALIC = 3;
    private int mStyle = 0;

    private static void setDefault(Typeface t) {
        sDefaultTypeface = t;
        Typeface.nativeSetDefault(t.native_instance);
    }

    public int getStyle() {
        return this.mStyle;
    }

    public final boolean isBold() {
        return (this.mStyle & 1) != 0;
    }

    public final boolean isItalic() {
        return (this.mStyle & 2) != 0;
    }

    public static Typeface create(String familyName, int style2) {
        if (sSystemFontMap != null) {
            return Typeface.create(sSystemFontMap.get(familyName), style2);
        }
        return null;
    }

    public static Typeface create(Typeface family, int style2) {
        Typeface typeface;
        SparseArray<Typeface> styles;
        if (style2 < 0 || style2 > 3) {
            style2 = 0;
        }
        long ni = 0L;
        if (family != null) {
            if (family.mStyle == style2) {
                return family;
            }
            ni = family.native_instance;
        }
        if ((styles = sTypefaceCache.get(ni)) != null && (typeface = styles.get(style2)) != null) {
            return typeface;
        }
        typeface = new Typeface(Typeface.nativeCreateFromTypeface(ni, style2));
        if (styles == null) {
            styles = new SparseArray(4);
            sTypefaceCache.put(ni, styles);
        }
        styles.put(style2, typeface);
        return typeface;
    }

    public static Typeface defaultFromStyle(int style2) {
        return sDefaults[style2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Typeface createFromAsset(AssetManager mgr, String path) {
        if (sFallbackFonts != null) {
            LruCache<String, Typeface> lruCache = sDynamicTypefaceCache;
            synchronized (lruCache) {
                String key = Typeface.createAssetUid(mgr, path);
                Typeface typeface = sDynamicTypefaceCache.get(key);
                if (typeface != null) {
                    return typeface;
                }
                FontFamily fontFamily = new FontFamily();
                if (fontFamily.addFontFromAsset(mgr, path)) {
                    FontFamily[] families = new FontFamily[]{fontFamily};
                    typeface = Typeface.createFromFamiliesWithDefault(families);
                    sDynamicTypefaceCache.put(key, typeface);
                    return typeface;
                }
            }
        }
        throw new RuntimeException("Font asset not found " + path);
    }

    private static String createAssetUid(AssetManager mgr, String path) {
        SparseArray<String> pkgs = mgr.getAssignedPackageIdentifiers();
        StringBuilder builder = new StringBuilder();
        int size = pkgs.size();
        for (int i = 0; i < size; ++i) {
            builder.append(pkgs.valueAt(i));
            builder.append("-");
        }
        builder.append(path);
        return builder.toString();
    }

    public static Typeface createFromFile(File path) {
        return Typeface.createFromFile(path.getAbsolutePath());
    }

    public static Typeface createFromFile(String path) {
        FontFamily fontFamily;
        if (sFallbackFonts != null && (fontFamily = new FontFamily()).addFont(path, 0)) {
            FontFamily[] families = new FontFamily[]{fontFamily};
            return Typeface.createFromFamiliesWithDefault(families);
        }
        throw new RuntimeException("Font not found " + path);
    }

    public static Typeface createFromFamilies(FontFamily[] families) {
        long[] ptrArray = new long[families.length];
        for (int i = 0; i < families.length; ++i) {
            ptrArray[i] = families[i].mNativePtr;
        }
        return new Typeface(Typeface.nativeCreateFromArray(ptrArray));
    }

    public static Typeface createFromFamiliesWithDefault(FontFamily[] families) {
        int i;
        long[] ptrArray = new long[families.length + sFallbackFonts.length];
        for (i = 0; i < families.length; ++i) {
            ptrArray[i] = families[i].mNativePtr;
        }
        for (i = 0; i < sFallbackFonts.length; ++i) {
            ptrArray[i + families.length] = Typeface.sFallbackFonts[i].mNativePtr;
        }
        return new Typeface(Typeface.nativeCreateFromArray(ptrArray));
    }

    private Typeface(long ni) {
        if (ni == 0L) {
            throw new RuntimeException("native typeface cannot be made");
        }
        this.native_instance = ni;
        this.mStyle = Typeface.nativeGetStyle(ni);
    }

    private static FontFamily makeFamilyFromParsed(FontListParser.Family family, Map<String, ByteBuffer> bufferForPath) {
        FontFamily fontFamily = new FontFamily(family.lang, family.variant);
        for (FontListParser.Font font : family.fonts) {
            ByteBuffer fontBuffer = bufferForPath.get(font.fontName);
            if (fontBuffer == null) {
                try (FileInputStream file = new FileInputStream(font.fontName);){
                    FileChannel fileChannel = file.getChannel();
                    long fontSize = fileChannel.size();
                    fontBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fontSize);
                    bufferForPath.put(font.fontName, fontBuffer);
                }
                catch (IOException e) {
                    Log.e(TAG, "Error mapping font file " + font.fontName);
                    continue;
                }
            }
            if (fontFamily.addFontWeightStyle(fontBuffer, font.ttcIndex, font.axes, font.weight, font.isItalic)) continue;
            Log.e(TAG, "Error creating font " + font.fontName + "#" + font.ttcIndex);
        }
        return fontFamily;
    }

    private static void init() {
        File systemFontConfigLocation = Typeface.getSystemFontConfigLocation();
        File configFilename = new File(systemFontConfigLocation, FONTS_CONFIG);
        try {
            FileInputStream fontsIn = new FileInputStream(configFilename);
            FontListParser.Config fontConfig = FontListParser.parse(fontsIn);
            HashMap<String, ByteBuffer> bufferForPath = new HashMap<String, ByteBuffer>();
            ArrayList<FontFamily> familyList = new ArrayList<FontFamily>();
            for (int i = 0; i < fontConfig.families.size(); ++i) {
                FontListParser.Family f = fontConfig.families.get(i);
                if (i != 0 && f.name != null) continue;
                familyList.add(Typeface.makeFamilyFromParsed(f, bufferForPath));
            }
            sFallbackFonts = familyList.toArray(new FontFamily[familyList.size()]);
            Typeface.setDefault(Typeface.createFromFamilies(sFallbackFonts));
            HashMap<String, Typeface> systemFonts = new HashMap<String, Typeface>();
            for (int i = 0; i < fontConfig.families.size(); ++i) {
                Typeface typeface;
                FontListParser.Family f = fontConfig.families.get(i);
                if (f.name == null) continue;
                if (i == 0) {
                    typeface = sDefaultTypeface;
                } else {
                    FontFamily fontFamily = Typeface.makeFamilyFromParsed(f, bufferForPath);
                    FontFamily[] families = new FontFamily[]{fontFamily};
                    typeface = Typeface.createFromFamiliesWithDefault(families);
                }
                systemFonts.put(f.name, typeface);
            }
            for (FontListParser.Alias alias : fontConfig.aliases) {
                Typeface base;
                Typeface newFace = base = (Typeface)systemFonts.get(alias.toName);
                int weight = alias.weight;
                if (weight != 400) {
                    newFace = new Typeface(Typeface.nativeCreateWeightAlias(base.native_instance, weight));
                }
                systemFonts.put(alias.name, newFace);
            }
            sSystemFontMap = systemFonts;
        }
        catch (RuntimeException e) {
            Log.w(TAG, "Didn't create default family (most likely, non-Minikin build)", e);
        }
        catch (FileNotFoundException e) {
            Log.e(TAG, "Error opening " + configFilename, e);
        }
        catch (IOException e) {
            Log.e(TAG, "Error reading " + configFilename, e);
        }
        catch (XmlPullParserException e) {
            Log.e(TAG, "XML parse exception for " + configFilename, e);
        }
    }

    private static File getSystemFontConfigLocation() {
        return new File("/system/etc/");
    }

    protected void finalize() throws Throwable {
        try {
            Typeface.nativeUnref(this.native_instance);
            this.native_instance = 0L;
        }
        finally {
            super.finalize();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Typeface typeface = (Typeface)o;
        return this.mStyle == typeface.mStyle && this.native_instance == typeface.native_instance;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (int)(this.native_instance ^ this.native_instance >>> 32);
        result = 31 * result + this.mStyle;
        return result;
    }

    private static native long nativeCreateFromTypeface(long var0, int var2);

    private static native long nativeCreateWeightAlias(long var0, int var2);

    private static native void nativeUnref(long var0);

    private static native int nativeGetStyle(long var0);

    private static native long nativeCreateFromArray(long[] var0);

    private static native void nativeSetDefault(long var0);

    static {
        sTypefaceCache = new LongSparseArray(3);
        sDynamicTypefaceCache = new LruCache(16);
        Typeface.init();
        DEFAULT = Typeface.create((String)null, 0);
        DEFAULT_BOLD = Typeface.create((String)null, 1);
        SANS_SERIF = Typeface.create("sans-serif", 0);
        SERIF = Typeface.create("serif", 0);
        MONOSPACE = Typeface.create("monospace", 0);
        sDefaults = new Typeface[]{DEFAULT, DEFAULT_BOLD, Typeface.create((String)null, 2), Typeface.create((String)null, 3)};
    }
}

