/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.pdf;

import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.ParcelFileDescriptor;
import android.system.ErrnoException;
import android.system.OsConstants;
import dalvik.system.CloseGuard;
import java.io.FileDescriptor;
import java.io.IOException;
import libcore.io.IoUtils;
import libcore.io.Libcore;

public final class PdfEditor {
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private final long mNativeDocument;
    private int mPageCount;
    private ParcelFileDescriptor mInput;

    public PdfEditor(ParcelFileDescriptor input) throws IOException {
        long size;
        if (input == null) {
            throw new NullPointerException("input cannot be null");
        }
        try {
            Libcore.os.lseek(input.getFileDescriptor(), 0L, OsConstants.SEEK_SET);
            size = Libcore.os.fstat((FileDescriptor)input.getFileDescriptor()).st_size;
        }
        catch (ErrnoException ee) {
            throw new IllegalArgumentException("file descriptor not seekable");
        }
        this.mInput = input;
        this.mNativeDocument = PdfEditor.nativeOpen(this.mInput.getFd(), size);
        this.mPageCount = PdfEditor.nativeGetPageCount(this.mNativeDocument);
        this.mCloseGuard.open("close");
    }

    public int getPageCount() {
        this.throwIfClosed();
        return this.mPageCount;
    }

    public void removePage(int pageIndex) {
        this.throwIfClosed();
        this.throwIfPageNotInDocument(pageIndex);
        this.mPageCount = PdfEditor.nativeRemovePage(this.mNativeDocument, pageIndex);
    }

    public void setTransformAndClip(int pageIndex, Matrix transform, Rect clip) {
        this.throwIfClosed();
        this.throwIfPageNotInDocument(pageIndex);
        this.throwIfNotNullAndNotAfine(transform);
        if (transform == null) {
            transform = Matrix.IDENTITY_MATRIX;
        }
        if (clip == null) {
            Point size = new Point();
            this.getPageSize(pageIndex, size);
            PdfEditor.nativeSetTransformAndClip(this.mNativeDocument, pageIndex, transform.native_instance, 0, 0, size.x, size.y);
        } else {
            PdfEditor.nativeSetTransformAndClip(this.mNativeDocument, pageIndex, transform.native_instance, clip.left, clip.top, clip.right, clip.bottom);
        }
    }

    public void getPageSize(int pageIndex, Point outSize) {
        this.throwIfClosed();
        this.throwIfOutSizeNull(outSize);
        this.throwIfPageNotInDocument(pageIndex);
        PdfEditor.nativeGetPageSize(this.mNativeDocument, pageIndex, outSize);
    }

    public boolean getPageMediaBox(int pageIndex, Rect outMediaBox) {
        this.throwIfClosed();
        this.throwIfOutMediaBoxNull(outMediaBox);
        this.throwIfPageNotInDocument(pageIndex);
        return PdfEditor.nativeGetPageMediaBox(this.mNativeDocument, pageIndex, outMediaBox);
    }

    public void setPageMediaBox(int pageIndex, Rect mediaBox) {
        this.throwIfClosed();
        this.throwIfMediaBoxNull(mediaBox);
        this.throwIfPageNotInDocument(pageIndex);
        PdfEditor.nativeSetPageMediaBox(this.mNativeDocument, pageIndex, mediaBox);
    }

    public boolean getPageCropBox(int pageIndex, Rect outCropBox) {
        this.throwIfClosed();
        this.throwIfOutCropBoxNull(outCropBox);
        this.throwIfPageNotInDocument(pageIndex);
        return PdfEditor.nativeGetPageCropBox(this.mNativeDocument, pageIndex, outCropBox);
    }

    public void setPageCropBox(int pageIndex, Rect cropBox) {
        this.throwIfClosed();
        this.throwIfCropBoxNull(cropBox);
        this.throwIfPageNotInDocument(pageIndex);
        PdfEditor.nativeSetPageCropBox(this.mNativeDocument, pageIndex, cropBox);
    }

    public boolean shouldScaleForPrinting() {
        this.throwIfClosed();
        return PdfEditor.nativeScaleForPrinting(this.mNativeDocument);
    }

    public void write(ParcelFileDescriptor output) throws IOException {
        try {
            this.throwIfClosed();
            PdfEditor.nativeWrite(this.mNativeDocument, output.getFd());
        }
        finally {
            IoUtils.closeQuietly(output);
        }
    }

    public void close() {
        this.throwIfClosed();
        this.doClose();
    }

    protected void finalize() throws Throwable {
        try {
            this.mCloseGuard.warnIfOpen();
            if (this.mInput != null) {
                this.doClose();
            }
        }
        finally {
            super.finalize();
        }
    }

    private void doClose() {
        PdfEditor.nativeClose(this.mNativeDocument);
        IoUtils.closeQuietly(this.mInput);
        this.mInput = null;
        this.mCloseGuard.close();
    }

    private void throwIfClosed() {
        if (this.mInput == null) {
            throw new IllegalStateException("Already closed");
        }
    }

    private void throwIfPageNotInDocument(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.mPageCount) {
            throw new IllegalArgumentException("Invalid page index");
        }
    }

    private void throwIfNotNullAndNotAfine(Matrix matrix) {
        if (matrix != null && !matrix.isAffine()) {
            throw new IllegalStateException("Matrix must be afine");
        }
    }

    private void throwIfOutSizeNull(Point outSize) {
        if (outSize == null) {
            throw new NullPointerException("outSize cannot be null");
        }
    }

    private void throwIfOutMediaBoxNull(Rect outMediaBox) {
        if (outMediaBox == null) {
            throw new NullPointerException("outMediaBox cannot be null");
        }
    }

    private void throwIfMediaBoxNull(Rect mediaBox) {
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox cannot be null");
        }
    }

    private void throwIfOutCropBoxNull(Rect outCropBox) {
        if (outCropBox == null) {
            throw new NullPointerException("outCropBox cannot be null");
        }
    }

    private void throwIfCropBoxNull(Rect cropBox) {
        if (cropBox == null) {
            throw new NullPointerException("cropBox cannot be null");
        }
    }

    private static native long nativeOpen(int var0, long var1);

    private static native void nativeClose(long var0);

    private static native int nativeGetPageCount(long var0);

    private static native int nativeRemovePage(long var0, int var2);

    private static native void nativeWrite(long var0, int var2);

    private static native void nativeSetTransformAndClip(long var0, int var2, long var3, int var5, int var6, int var7, int var8);

    private static native void nativeGetPageSize(long var0, int var2, Point var3);

    private static native boolean nativeGetPageMediaBox(long var0, int var2, Rect var3);

    private static native void nativeSetPageMediaBox(long var0, int var2, Rect var3);

    private static native boolean nativeGetPageCropBox(long var0, int var2, Rect var3);

    private static native void nativeSetPageCropBox(long var0, int var2, Rect var3);

    private static native boolean nativeScaleForPrinting(long var0);
}

