/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.Sensor;
import android.hardware.SensorAdditionalInfo;
import android.hardware.SensorEvent;
import android.hardware.SensorEventCallback;
import android.hardware.SensorEventListener;
import android.hardware.SensorEventListener2;
import android.hardware.SensorManager;
import android.hardware.TriggerEvent;
import android.hardware.TriggerEventListener;
import android.os.Handler;
import android.os.Looper;
import android.os.MessageQueue;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import com.android.internal.annotations.GuardedBy;
import dalvik.system.CloseGuard;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SystemSensorManager
extends SensorManager {
    private static boolean DEBUG_DYNAMIC_SENSOR = true;
    private static final Object sLock = new Object();
    @GuardedBy(value="sLock")
    private static boolean sNativeClassInited = false;
    @GuardedBy(value="sLock")
    private static InjectEventQueue sInjectEventQueue = null;
    private final ArrayList<Sensor> mFullSensorsList = new ArrayList();
    private List<Sensor> mFullDynamicSensorsList = new ArrayList<Sensor>();
    private boolean mDynamicSensorListDirty = true;
    private final HashMap<Integer, Sensor> mHandleToSensor = new HashMap();
    private final HashMap<SensorEventListener, SensorEventQueue> mSensorListeners = new HashMap();
    private final HashMap<TriggerEventListener, TriggerEventQueue> mTriggerListeners = new HashMap();
    private HashMap<SensorManager.DynamicSensorCallback, Handler> mDynamicSensorCallbacks = new HashMap();
    private BroadcastReceiver mDynamicSensorBroadcastReceiver;
    private final Looper mMainLooper;
    private final int mTargetSdkLevel;
    private final Context mContext;
    private final long mNativeInstance;

    private static native void nativeClassInit();

    private static native long nativeCreate(String var0);

    private static native boolean nativeGetSensorAtIndex(long var0, Sensor var2, int var3);

    private static native void nativeGetDynamicSensors(long var0, List<Sensor> var2);

    private static native boolean nativeIsDataInjectionEnabled(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SystemSensorManager(Context context, Looper mainLooper) {
        Sensor sensor;
        Object object = sLock;
        synchronized (object) {
            if (!sNativeClassInited) {
                sNativeClassInited = true;
                SystemSensorManager.nativeClassInit();
            }
        }
        this.mMainLooper = mainLooper;
        this.mTargetSdkLevel = context.getApplicationInfo().targetSdkVersion;
        this.mContext = context;
        this.mNativeInstance = SystemSensorManager.nativeCreate(context.getOpPackageName());
        int index = 0;
        while (SystemSensorManager.nativeGetSensorAtIndex(this.mNativeInstance, sensor = new Sensor(), index)) {
            this.mFullSensorsList.add(sensor);
            this.mHandleToSensor.put(sensor.getHandle(), sensor);
            ++index;
        }
    }

    @Override
    protected List<Sensor> getFullSensorList() {
        return this.mFullSensorsList;
    }

    @Override
    protected List<Sensor> getFullDynamicSensorList() {
        this.setupDynamicSensorBroadcastReceiver();
        this.updateDynamicSensorList();
        return this.mFullDynamicSensorsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean registerListenerImpl(SensorEventListener listener, Sensor sensor, int delayUs, Handler handler, int maxBatchReportLatencyUs, int reservedFlags) {
        if (listener == null || sensor == null) {
            Log.e("SensorManager", "sensor or listener is null");
            return false;
        }
        if (sensor.getReportingMode() == 2) {
            Log.e("SensorManager", "Trigger Sensors should use the requestTriggerSensor.");
            return false;
        }
        if (maxBatchReportLatencyUs < 0 || delayUs < 0) {
            Log.e("SensorManager", "maxBatchReportLatencyUs and delayUs should be non-negative");
            return false;
        }
        HashMap<SensorEventListener, SensorEventQueue> hashMap = this.mSensorListeners;
        synchronized (hashMap) {
            SensorEventQueue queue = this.mSensorListeners.get(listener);
            if (queue == null) {
                String fullClassName;
                Looper looper = handler != null ? handler.getLooper() : this.mMainLooper;
                queue = new SensorEventQueue(listener, looper, this, fullClassName = listener.getClass().getEnclosingClass() != null ? listener.getClass().getEnclosingClass().getName() : listener.getClass().getName());
                if (!queue.addSensor(sensor, delayUs, maxBatchReportLatencyUs)) {
                    queue.dispose();
                    return false;
                }
                this.mSensorListeners.put(listener, queue);
                return true;
            }
            return queue.addSensor(sensor, delayUs, maxBatchReportLatencyUs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void unregisterListenerImpl(SensorEventListener listener, Sensor sensor) {
        if (sensor != null && sensor.getReportingMode() == 2) {
            return;
        }
        HashMap<SensorEventListener, SensorEventQueue> hashMap = this.mSensorListeners;
        synchronized (hashMap) {
            boolean result;
            SensorEventQueue queue = this.mSensorListeners.get(listener);
            if (queue != null && (result = sensor == null ? queue.removeAllSensors() : queue.removeSensor(sensor, true)) && !queue.hasSensors()) {
                this.mSensorListeners.remove(listener);
                queue.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean requestTriggerSensorImpl(TriggerEventListener listener, Sensor sensor) {
        if (sensor == null) {
            throw new IllegalArgumentException("sensor cannot be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        if (sensor.getReportingMode() != 2) {
            return false;
        }
        HashMap<TriggerEventListener, TriggerEventQueue> hashMap = this.mTriggerListeners;
        synchronized (hashMap) {
            TriggerEventQueue queue = this.mTriggerListeners.get(listener);
            if (queue == null) {
                String fullClassName = listener.getClass().getEnclosingClass() != null ? listener.getClass().getEnclosingClass().getName() : listener.getClass().getName();
                queue = new TriggerEventQueue(listener, this.mMainLooper, this, fullClassName);
                if (!queue.addSensor(sensor, 0, 0)) {
                    queue.dispose();
                    return false;
                }
                this.mTriggerListeners.put(listener, queue);
                return true;
            }
            return queue.addSensor(sensor, 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean cancelTriggerSensorImpl(TriggerEventListener listener, Sensor sensor, boolean disable) {
        if (sensor != null && sensor.getReportingMode() != 2) {
            return false;
        }
        HashMap<TriggerEventListener, TriggerEventQueue> hashMap = this.mTriggerListeners;
        synchronized (hashMap) {
            TriggerEventQueue queue = this.mTriggerListeners.get(listener);
            if (queue != null) {
                boolean result = sensor == null ? queue.removeAllSensors() : queue.removeSensor(sensor, disable);
                if (result && !queue.hasSensors()) {
                    this.mTriggerListeners.remove(listener);
                    queue.dispose();
                }
                return result;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean flushImpl(SensorEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        HashMap<SensorEventListener, SensorEventQueue> hashMap = this.mSensorListeners;
        synchronized (hashMap) {
            SensorEventQueue queue = this.mSensorListeners.get(listener);
            if (queue == null) {
                return false;
            }
            return queue.flush() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean initDataInjectionImpl(boolean enable) {
        Object object = sLock;
        synchronized (object) {
            if (enable) {
                boolean isDataInjectionModeEnabled = SystemSensorManager.nativeIsDataInjectionEnabled(this.mNativeInstance);
                if (!isDataInjectionModeEnabled) {
                    Log.e("SensorManager", "Data Injection mode not enabled");
                    return false;
                }
                if (sInjectEventQueue == null) {
                    sInjectEventQueue = new InjectEventQueue(this.mMainLooper, this, this.mContext.getPackageName());
                }
            } else if (sInjectEventQueue != null) {
                sInjectEventQueue.dispose();
                sInjectEventQueue = null;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean injectSensorDataImpl(Sensor sensor, float[] values, int accuracy, long timestamp) {
        Object object = sLock;
        synchronized (object) {
            if (sInjectEventQueue == null) {
                Log.e("SensorManager", "Data injection mode not activated before calling injectSensorData");
                return false;
            }
            int ret = sInjectEventQueue.injectSensorData(sensor.getHandle(), values, accuracy, timestamp);
            if (ret != 0) {
                sInjectEventQueue.dispose();
                sInjectEventQueue = null;
            }
            return ret == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupSensorConnection(Sensor sensor) {
        this.mHandleToSensor.remove(sensor.getHandle());
        if (sensor.getReportingMode() == 2) {
            HashMap<TriggerEventListener, TriggerEventQueue> hashMap = this.mTriggerListeners;
            synchronized (hashMap) {
                for (TriggerEventListener l : this.mTriggerListeners.keySet()) {
                    if (DEBUG_DYNAMIC_SENSOR) {
                        Log.i("SensorManager", "removed trigger listener" + l.toString() + " due to sensor disconnection");
                    }
                    this.cancelTriggerSensorImpl(l, sensor, true);
                }
            }
        }
        HashMap<SensorEventListener, SensorEventQueue> hashMap = this.mSensorListeners;
        synchronized (hashMap) {
            for (SensorEventListener l : this.mSensorListeners.keySet()) {
                if (DEBUG_DYNAMIC_SENSOR) {
                    Log.i("SensorManager", "removed event listener" + l.toString() + " due to sensor disconnection");
                }
                this.unregisterListenerImpl(l, sensor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDynamicSensorList() {
        List<Sensor> list = this.mFullDynamicSensorsList;
        synchronized (list) {
            if (this.mDynamicSensorListDirty) {
                ArrayList<Sensor> list2 = new ArrayList<Sensor>();
                SystemSensorManager.nativeGetDynamicSensors(this.mNativeInstance, list2);
                ArrayList<Sensor> updatedList = new ArrayList<Sensor>();
                final ArrayList<Sensor> addedList = new ArrayList<Sensor>();
                final ArrayList<Sensor> removedList = new ArrayList<Sensor>();
                boolean changed = SystemSensorManager.diffSortedSensorList(this.mFullDynamicSensorsList, list2, updatedList, addedList, removedList);
                if (changed) {
                    if (DEBUG_DYNAMIC_SENSOR) {
                        Log.i("SensorManager", "DYNS dynamic sensor list cached should be updated");
                    }
                    this.mFullDynamicSensorsList = updatedList;
                    for (Sensor s : addedList) {
                        this.mHandleToSensor.put(s.getHandle(), s);
                    }
                    Handler mainHandler = new Handler(this.mContext.getMainLooper());
                    for (Map.Entry<SensorManager.DynamicSensorCallback, Handler> entry : this.mDynamicSensorCallbacks.entrySet()) {
                        final SensorManager.DynamicSensorCallback callback = entry.getKey();
                        Handler handler = entry.getValue() == null ? mainHandler : entry.getValue();
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                for (Sensor s : addedList) {
                                    callback.onDynamicSensorConnected(s);
                                }
                                for (Sensor s : removedList) {
                                    callback.onDynamicSensorDisconnected(s);
                                }
                            }
                        });
                    }
                    for (Sensor s : removedList) {
                        this.cleanupSensorConnection(s);
                    }
                }
                this.mDynamicSensorListDirty = false;
            }
        }
    }

    private void setupDynamicSensorBroadcastReceiver() {
        if (this.mDynamicSensorBroadcastReceiver == null) {
            this.mDynamicSensorBroadcastReceiver = new BroadcastReceiver(){

                @Override
                public void onReceive(Context context, Intent intent) {
                    if (intent.getAction() == "android.intent.action.DYNAMIC_SENSOR_CHANGED") {
                        if (DEBUG_DYNAMIC_SENSOR) {
                            Log.i("SensorManager", "DYNS received DYNAMIC_SENSOR_CHANED broadcast");
                        }
                        SystemSensorManager.this.mDynamicSensorListDirty = true;
                        SystemSensorManager.this.updateDynamicSensorList();
                    }
                }
            };
            IntentFilter filter = new IntentFilter("dynamic_sensor_change");
            filter.addAction("android.intent.action.DYNAMIC_SENSOR_CHANGED");
            this.mContext.registerReceiver(this.mDynamicSensorBroadcastReceiver, filter);
        }
    }

    private void teardownDynamicSensorBroadcastReceiver() {
        this.mDynamicSensorCallbacks.clear();
        this.mContext.unregisterReceiver(this.mDynamicSensorBroadcastReceiver);
        this.mDynamicSensorBroadcastReceiver = null;
    }

    @Override
    protected void registerDynamicSensorCallbackImpl(SensorManager.DynamicSensorCallback callback, Handler handler) {
        if (DEBUG_DYNAMIC_SENSOR) {
            Log.i("SensorManager", "DYNS Register dynamic sensor callback");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        if (this.mDynamicSensorCallbacks.containsKey(callback)) {
            return;
        }
        this.setupDynamicSensorBroadcastReceiver();
        this.mDynamicSensorCallbacks.put(callback, handler);
    }

    @Override
    protected void unregisterDynamicSensorCallbackImpl(SensorManager.DynamicSensorCallback callback) {
        if (DEBUG_DYNAMIC_SENSOR) {
            Log.i("SensorManager", "Removing dynamic sensor listerner");
        }
        this.mDynamicSensorCallbacks.remove(callback);
    }

    private static boolean diffSortedSensorList(List<Sensor> oldList, List<Sensor> newList, List<Sensor> updated, List<Sensor> added, List<Sensor> removed) {
        boolean changed = false;
        int i = 0;
        int j = 0;
        while (true) {
            if (j < oldList.size() && (i >= newList.size() || newList.get(i).getHandle() > oldList.get(j).getHandle())) {
                changed = true;
                if (removed != null) {
                    removed.add(oldList.get(j));
                }
                ++j;
                continue;
            }
            if (i < newList.size() && (j >= oldList.size() || newList.get(i).getHandle() < oldList.get(j).getHandle())) {
                changed = true;
                if (added != null) {
                    added.add(newList.get(i));
                }
                if (updated != null) {
                    updated.add(newList.get(i));
                }
                ++i;
                continue;
            }
            if (i >= newList.size() || j >= oldList.size() || newList.get(i).getHandle() != oldList.get(j).getHandle()) break;
            if (updated != null) {
                updated.add(oldList.get(j));
            }
            ++i;
            ++j;
        }
        return changed;
    }

    final class InjectEventQueue
    extends BaseEventQueue {
        public InjectEventQueue(Looper looper, SystemSensorManager manager, String packageName) {
            super(looper, manager, 1, packageName);
        }

        int injectSensorData(int handle, float[] values, int accuracy, long timestamp) {
            return this.injectSensorDataBase(handle, values, accuracy, timestamp);
        }

        @Override
        protected void dispatchSensorEvent(int handle, float[] values, int accuracy, long timestamp) {
        }

        @Override
        protected void dispatchFlushCompleteEvent(int handle) {
        }

        @Override
        protected void addSensorEvent(Sensor sensor) {
        }

        @Override
        protected void removeSensorEvent(Sensor sensor) {
        }
    }

    static final class TriggerEventQueue
    extends BaseEventQueue {
        private final TriggerEventListener mListener;
        private final SparseArray<TriggerEvent> mTriggerEvents = new SparseArray();

        public TriggerEventQueue(TriggerEventListener listener, Looper looper, SystemSensorManager manager, String packageName) {
            super(looper, manager, 0, packageName);
            this.mListener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addSensorEvent(Sensor sensor) {
            TriggerEvent t = new TriggerEvent(Sensor.getMaxLengthValuesArray(sensor, this.mManager.mTargetSdkLevel));
            SparseArray<TriggerEvent> sparseArray = this.mTriggerEvents;
            synchronized (sparseArray) {
                this.mTriggerEvents.put(sensor.getHandle(), t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeSensorEvent(Sensor sensor) {
            SparseArray<TriggerEvent> sparseArray = this.mTriggerEvents;
            synchronized (sparseArray) {
                this.mTriggerEvents.delete(sensor.getHandle());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void dispatchSensorEvent(int handle, float[] values, int accuracy, long timestamp) {
            Sensor sensor = (Sensor)this.mManager.mHandleToSensor.get(handle);
            if (sensor == null) {
                return;
            }
            TriggerEvent t = null;
            SparseArray<TriggerEvent> sparseArray = this.mTriggerEvents;
            synchronized (sparseArray) {
                t = this.mTriggerEvents.get(handle);
            }
            if (t == null) {
                Log.e("SensorManager", "Error: Trigger Event is null for Sensor: " + sensor);
                return;
            }
            System.arraycopy((float[])values, (int)0, (float[])t.values, (int)0, (int)t.values.length);
            t.timestamp = timestamp;
            t.sensor = sensor;
            this.mManager.cancelTriggerSensorImpl(this.mListener, sensor, false);
            this.mListener.onTrigger(t);
        }

        @Override
        protected void dispatchFlushCompleteEvent(int handle) {
        }
    }

    static final class SensorEventQueue
    extends BaseEventQueue {
        private final SensorEventListener mListener;
        private final SparseArray<SensorEvent> mSensorsEvents = new SparseArray();

        public SensorEventQueue(SensorEventListener listener, Looper looper, SystemSensorManager manager, String packageName) {
            super(looper, manager, 0, packageName);
            this.mListener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addSensorEvent(Sensor sensor) {
            SensorEvent t = new SensorEvent(Sensor.getMaxLengthValuesArray(sensor, this.mManager.mTargetSdkLevel));
            SparseArray<SensorEvent> sparseArray = this.mSensorsEvents;
            synchronized (sparseArray) {
                this.mSensorsEvents.put(sensor.getHandle(), t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeSensorEvent(Sensor sensor) {
            SparseArray<SensorEvent> sparseArray = this.mSensorsEvents;
            synchronized (sparseArray) {
                this.mSensorsEvents.delete(sensor.getHandle());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void dispatchSensorEvent(int handle, float[] values, int inAccuracy, long timestamp) {
            Sensor sensor = (Sensor)this.mManager.mHandleToSensor.get(handle);
            if (sensor == null) {
                return;
            }
            SensorEvent t = null;
            SparseArray<SensorEvent> sparseArray = this.mSensorsEvents;
            synchronized (sparseArray) {
                t = this.mSensorsEvents.get(handle);
            }
            if (t == null) {
                return;
            }
            System.arraycopy((float[])values, (int)0, (float[])t.values, (int)0, (int)t.values.length);
            t.timestamp = timestamp;
            t.accuracy = inAccuracy;
            t.sensor = sensor;
            int accuracy = this.mSensorAccuracies.get(handle);
            if (t.accuracy >= 0 && accuracy != t.accuracy) {
                this.mSensorAccuracies.put(handle, t.accuracy);
                this.mListener.onAccuracyChanged(t.sensor, t.accuracy);
            }
            this.mListener.onSensorChanged(t);
        }

        @Override
        protected void dispatchFlushCompleteEvent(int handle) {
            if (this.mListener instanceof SensorEventListener2) {
                Sensor sensor = (Sensor)this.mManager.mHandleToSensor.get(handle);
                if (sensor == null) {
                    return;
                }
                ((SensorEventListener2)this.mListener).onFlushCompleted(sensor);
            }
        }

        @Override
        protected void dispatchAdditionalInfoEvent(int handle, int type, int serial, float[] floatValues, int[] intValues) {
            if (this.mListener instanceof SensorEventCallback) {
                Sensor sensor = (Sensor)this.mManager.mHandleToSensor.get(handle);
                if (sensor == null) {
                    return;
                }
                SensorAdditionalInfo info = new SensorAdditionalInfo(sensor, type, serial, intValues, floatValues);
                ((SensorEventCallback)this.mListener).onSensorAdditionalInfo(info);
            }
        }
    }

    private static abstract class BaseEventQueue {
        private long nSensorEventQueue;
        private final SparseBooleanArray mActiveSensors = new SparseBooleanArray();
        protected final SparseIntArray mSensorAccuracies = new SparseIntArray();
        private final CloseGuard mCloseGuard = CloseGuard.get();
        protected final SystemSensorManager mManager;
        protected static final int OPERATING_MODE_NORMAL = 0;
        protected static final int OPERATING_MODE_DATA_INJECTION = 1;

        private static native long nativeInitBaseEventQueue(long var0, WeakReference<BaseEventQueue> var2, MessageQueue var3, String var4, int var5, String var6);

        private static native int nativeEnableSensor(long var0, int var2, int var3, int var4);

        private static native int nativeDisableSensor(long var0, int var2);

        private static native void nativeDestroySensorEventQueue(long var0);

        private static native int nativeFlushSensor(long var0);

        private static native int nativeInjectSensorData(long var0, int var2, float[] var3, int var4, long var5);

        BaseEventQueue(Looper looper, SystemSensorManager manager, int mode, String packageName) {
            if (packageName == null) {
                packageName = "";
            }
            this.nSensorEventQueue = BaseEventQueue.nativeInitBaseEventQueue(manager.mNativeInstance, new WeakReference<BaseEventQueue>(this), looper.getQueue(), packageName, mode, manager.mContext.getOpPackageName());
            this.mCloseGuard.open("dispose");
            this.mManager = manager;
        }

        public void dispose() {
            this.dispose(false);
        }

        public boolean addSensor(Sensor sensor, int delayUs, int maxBatchReportLatencyUs) {
            int handle = sensor.getHandle();
            if (this.mActiveSensors.get(handle)) {
                return false;
            }
            this.mActiveSensors.put(handle, true);
            this.addSensorEvent(sensor);
            if (this.enableSensor(sensor, delayUs, maxBatchReportLatencyUs) != 0 && (maxBatchReportLatencyUs == 0 || maxBatchReportLatencyUs > 0 && this.enableSensor(sensor, delayUs, 0) != 0)) {
                this.removeSensor(sensor, false);
                return false;
            }
            return true;
        }

        public boolean removeAllSensors() {
            for (int i = 0; i < this.mActiveSensors.size(); ++i) {
                if (!this.mActiveSensors.valueAt(i)) continue;
                int handle = this.mActiveSensors.keyAt(i);
                Sensor sensor = (Sensor)this.mManager.mHandleToSensor.get(handle);
                if (sensor == null) continue;
                this.disableSensor(sensor);
                this.mActiveSensors.put(handle, false);
                this.removeSensorEvent(sensor);
            }
            return true;
        }

        public boolean removeSensor(Sensor sensor, boolean disable) {
            int handle = sensor.getHandle();
            if (this.mActiveSensors.get(handle)) {
                if (disable) {
                    this.disableSensor(sensor);
                }
                this.mActiveSensors.put(sensor.getHandle(), false);
                this.removeSensorEvent(sensor);
                return true;
            }
            return false;
        }

        public int flush() {
            if (this.nSensorEventQueue == 0L) {
                throw new NullPointerException();
            }
            return BaseEventQueue.nativeFlushSensor(this.nSensorEventQueue);
        }

        public boolean hasSensors() {
            return this.mActiveSensors.indexOfValue(true) >= 0;
        }

        protected void finalize() throws Throwable {
            try {
                this.dispose(true);
            }
            finally {
                super.finalize();
            }
        }

        private void dispose(boolean finalized) {
            if (this.mCloseGuard != null) {
                if (finalized) {
                    this.mCloseGuard.warnIfOpen();
                }
                this.mCloseGuard.close();
            }
            if (this.nSensorEventQueue != 0L) {
                BaseEventQueue.nativeDestroySensorEventQueue(this.nSensorEventQueue);
                this.nSensorEventQueue = 0L;
            }
        }

        private int enableSensor(Sensor sensor, int rateUs, int maxBatchReportLatencyUs) {
            if (this.nSensorEventQueue == 0L) {
                throw new NullPointerException();
            }
            if (sensor == null) {
                throw new NullPointerException();
            }
            return BaseEventQueue.nativeEnableSensor(this.nSensorEventQueue, sensor.getHandle(), rateUs, maxBatchReportLatencyUs);
        }

        protected int injectSensorDataBase(int handle, float[] values, int accuracy, long timestamp) {
            return BaseEventQueue.nativeInjectSensorData(this.nSensorEventQueue, handle, values, accuracy, timestamp);
        }

        private int disableSensor(Sensor sensor) {
            if (this.nSensorEventQueue == 0L) {
                throw new NullPointerException();
            }
            if (sensor == null) {
                throw new NullPointerException();
            }
            return BaseEventQueue.nativeDisableSensor(this.nSensorEventQueue, sensor.getHandle());
        }

        protected abstract void dispatchSensorEvent(int var1, float[] var2, int var3, long var4);

        protected abstract void dispatchFlushCompleteEvent(int var1);

        protected void dispatchAdditionalInfoEvent(int handle, int type, int serial, float[] floatValues, int[] intValues) {
        }

        protected abstract void addSensorEvent(Sensor var1);

        protected abstract void removeSensorEvent(Sensor var1);
    }
}

