/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.graphics.SurfaceTexture;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.hardware.camera2.utils.HashCodeHelpers;
import android.hardware.camera2.utils.SurfaceUtils;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import android.util.Size;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.android.internal.util.Preconditions;

public final class OutputConfiguration
implements Parcelable {
    public static final int ROTATION_0 = 0;
    public static final int ROTATION_90 = 1;
    public static final int ROTATION_180 = 2;
    public static final int ROTATION_270 = 3;
    public static final int SURFACE_GROUP_ID_NONE = -1;
    private final int SURFACE_TYPE_UNKNOWN = -1;
    private final int SURFACE_TYPE_SURFACE_VIEW = 0;
    private final int SURFACE_TYPE_SURFACE_TEXTURE = 1;
    public static final Parcelable.Creator<OutputConfiguration> CREATOR = new Parcelable.Creator<OutputConfiguration>(){

        @Override
        public OutputConfiguration createFromParcel(Parcel source) {
            try {
                OutputConfiguration outputConfiguration = new OutputConfiguration(source);
                return outputConfiguration;
            }
            catch (Exception e) {
                Log.e(OutputConfiguration.TAG, "Exception creating OutputConfiguration from parcel", e);
                return null;
            }
        }

        public OutputConfiguration[] newArray(int size) {
            return new OutputConfiguration[size];
        }
    };
    private static final String TAG = "OutputConfiguration";
    private Surface mSurface;
    private final int mRotation;
    private final int mSurfaceGroupId;
    private final int mSurfaceType;
    private final Size mConfiguredSize;
    private final int mConfiguredFormat;
    private final int mConfiguredDataspace;
    private final int mConfiguredGenerationId;
    private final boolean mIsDeferredConfig;

    public OutputConfiguration(Surface surface) {
        this(-1, surface, 0);
    }

    public OutputConfiguration(int surfaceGroupId, Surface surface) {
        this(surfaceGroupId, surface, 0);
    }

    public OutputConfiguration(Surface surface, int rotation) {
        this(-1, surface, rotation);
    }

    public OutputConfiguration(int surfaceGroupId, Surface surface, int rotation) {
        Preconditions.checkNotNull(surface, "Surface must not be null");
        Preconditions.checkArgumentInRange(rotation, 0, 3, "Rotation constant");
        this.mSurfaceGroupId = surfaceGroupId;
        this.mSurfaceType = -1;
        this.mSurface = surface;
        this.mRotation = rotation;
        this.mConfiguredSize = SurfaceUtils.getSurfaceSize(surface);
        this.mConfiguredFormat = SurfaceUtils.getSurfaceFormat(surface);
        this.mConfiguredDataspace = SurfaceUtils.getSurfaceDataspace(surface);
        this.mConfiguredGenerationId = surface.getGenerationId();
        this.mIsDeferredConfig = false;
    }

    public <T> OutputConfiguration(Size surfaceSize, Class<T> klass) {
        Preconditions.checkNotNull(klass, "surfaceSize must not be null");
        Preconditions.checkNotNull(klass, "klass must not be null");
        if (klass == SurfaceHolder.class) {
            this.mSurfaceType = 0;
        } else if (klass == SurfaceTexture.class) {
            this.mSurfaceType = 1;
        } else {
            this.mSurfaceType = -1;
            throw new IllegalArgumentException("Unknow surface source class type");
        }
        this.mSurfaceGroupId = -1;
        this.mSurface = null;
        this.mRotation = 0;
        this.mConfiguredSize = surfaceSize;
        this.mConfiguredFormat = StreamConfigurationMap.imageFormatToInternal(34);
        this.mConfiguredDataspace = StreamConfigurationMap.imageFormatToDataspace(34);
        this.mConfiguredGenerationId = 0;
        this.mIsDeferredConfig = true;
    }

    public boolean isDeferredConfiguration() {
        return this.mIsDeferredConfig;
    }

    public void setDeferredSurface(Surface surface) {
        Preconditions.checkNotNull(surface, "Surface must not be null");
        if (this.mSurface != null) {
            throw new IllegalStateException("Deferred surface is already set!");
        }
        Size surfaceSize = SurfaceUtils.getSurfaceSize(surface);
        if (!surfaceSize.equals(this.mConfiguredSize)) {
            Log.w(TAG, "Deferred surface size " + surfaceSize + " is different with pre-configured size " + this.mConfiguredSize + ", the pre-configured size will be used.");
        }
        this.mSurface = surface;
    }

    public OutputConfiguration(OutputConfiguration other) {
        if (other == null) {
            throw new IllegalArgumentException("OutputConfiguration shouldn't be null");
        }
        this.mSurface = other.mSurface;
        this.mRotation = other.mRotation;
        this.mSurfaceGroupId = other.mSurfaceGroupId;
        this.mSurfaceType = other.mSurfaceType;
        this.mConfiguredDataspace = other.mConfiguredDataspace;
        this.mConfiguredFormat = other.mConfiguredFormat;
        this.mConfiguredSize = other.mConfiguredSize;
        this.mConfiguredGenerationId = other.mConfiguredGenerationId;
        this.mIsDeferredConfig = other.mIsDeferredConfig;
    }

    private OutputConfiguration(Parcel source) {
        int rotation = source.readInt();
        int surfaceSetId = source.readInt();
        int surfaceType = source.readInt();
        int width = source.readInt();
        int height = source.readInt();
        Surface surface = Surface.CREATOR.createFromParcel(source);
        Preconditions.checkArgumentInRange(rotation, 0, 3, "Rotation constant");
        this.mSurfaceGroupId = surfaceSetId;
        this.mSurface = surface;
        this.mRotation = rotation;
        if (surface != null) {
            this.mSurfaceType = -1;
            this.mConfiguredSize = SurfaceUtils.getSurfaceSize(this.mSurface);
            this.mConfiguredFormat = SurfaceUtils.getSurfaceFormat(this.mSurface);
            this.mConfiguredDataspace = SurfaceUtils.getSurfaceDataspace(this.mSurface);
            this.mConfiguredGenerationId = this.mSurface.getGenerationId();
            this.mIsDeferredConfig = true;
        } else {
            this.mSurfaceType = surfaceType;
            this.mConfiguredSize = new Size(width, height);
            this.mConfiguredFormat = StreamConfigurationMap.imageFormatToInternal(34);
            this.mConfiguredGenerationId = 0;
            this.mConfiguredDataspace = StreamConfigurationMap.imageFormatToDataspace(34);
            this.mIsDeferredConfig = false;
        }
    }

    public Surface getSurface() {
        return this.mSurface;
    }

    public int getRotation() {
        return this.mRotation;
    }

    public int getSurfaceGroupId() {
        return this.mSurfaceGroupId;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (dest == null) {
            throw new IllegalArgumentException("dest must not be null");
        }
        dest.writeInt(this.mRotation);
        dest.writeInt(this.mSurfaceGroupId);
        dest.writeInt(this.mSurfaceType);
        dest.writeInt(this.mConfiguredSize.getWidth());
        dest.writeInt(this.mConfiguredSize.getHeight());
        if (this.mSurface != null) {
            this.mSurface.writeToParcel(dest, flags);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof OutputConfiguration) {
            boolean iSSurfaceEqual;
            OutputConfiguration other = (OutputConfiguration)obj;
            boolean bl = iSSurfaceEqual = this.mSurface == other.mSurface && this.mConfiguredGenerationId == other.mConfiguredGenerationId;
            if (this.mIsDeferredConfig) {
                Log.i(TAG, "deferred config has the same surface");
                iSSurfaceEqual = true;
            }
            return this.mRotation == other.mRotation && iSSurfaceEqual && this.mConfiguredSize.equals(other.mConfiguredSize) && this.mConfiguredFormat == other.mConfiguredFormat && this.mConfiguredDataspace == other.mConfiguredDataspace && this.mSurfaceGroupId == other.mSurfaceGroupId && this.mSurfaceType == other.mSurfaceType && this.mIsDeferredConfig == other.mIsDeferredConfig;
        }
        return false;
    }

    public int hashCode() {
        if (this.mIsDeferredConfig) {
            return HashCodeHelpers.hashCode(this.mRotation, this.mConfiguredSize.hashCode(), this.mConfiguredFormat, this.mConfiguredDataspace, this.mSurfaceGroupId, this.mSurfaceType);
        }
        return HashCodeHelpers.hashCode(this.mRotation, this.mSurface.hashCode(), this.mConfiguredGenerationId, this.mConfiguredSize.hashCode(), this.mConfiguredFormat, this.mConfiguredDataspace, this.mSurfaceGroupId);
    }
}

