/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.utils;

import android.util.Log;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class CloseableLock
implements AutoCloseable {
    private static final boolean VERBOSE = false;
    private final String TAG = "CloseableLock";
    private final String mName;
    private volatile boolean mClosed = false;
    private boolean mExclusive = false;
    private int mSharedLocks = 0;
    private final ReentrantLock mLock = new ReentrantLock();
    private final Condition mCondition = this.mLock.newCondition();
    private final ThreadLocal<Integer> mLockCount = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };

    public CloseableLock() {
        this.mName = "";
    }

    public CloseableLock(String name) {
        this.mName = name;
    }

    @Override
    public void close() {
        if (this.mClosed) {
            return;
        }
        ScopedLock scoper = this.acquireExclusiveLock();
        if (scoper == null) {
            return;
        }
        if (this.mLockCount.get() != 1) {
            throw new IllegalStateException("Cannot close while one or more acquired locks are being held by this thread; release all other locks first");
        }
        try {
            this.mLock.lock();
            this.mClosed = true;
            this.mExclusive = false;
            this.mSharedLocks = 0;
            this.mLockCount.remove();
            this.mCondition.signalAll();
        }
        finally {
            this.mLock.unlock();
        }
    }

    public ScopedLock acquireLock() {
        try {
            this.mLock.lock();
            if (this.mClosed) {
                ScopedLock scopedLock = null;
                return scopedLock;
            }
            int ownedLocks = this.mLockCount.get();
            if (this.mExclusive && ownedLocks > 0) {
                throw new IllegalStateException("Cannot acquire shared lock while holding exclusive lock");
            }
            while (this.mExclusive) {
                this.mCondition.awaitUninterruptibly();
                if (!this.mClosed) continue;
                ScopedLock scopedLock = null;
                return scopedLock;
            }
            ++this.mSharedLocks;
            ownedLocks = this.mLockCount.get() + 1;
            this.mLockCount.set(ownedLocks);
        }
        finally {
            this.mLock.unlock();
        }
        return new ScopedLock();
    }

    public ScopedLock acquireExclusiveLock() {
        try {
            this.mLock.lock();
            if (this.mClosed) {
                ScopedLock scopedLock = null;
                return scopedLock;
            }
            int ownedLocks = this.mLockCount.get();
            if (!this.mExclusive && ownedLocks > 0) {
                throw new IllegalStateException("Cannot acquire exclusive lock while holding shared lock");
            }
            while (ownedLocks == 0 && (this.mExclusive || this.mSharedLocks > 0)) {
                this.mCondition.awaitUninterruptibly();
                if (!this.mClosed) continue;
                ScopedLock scopedLock = null;
                return scopedLock;
            }
            this.mExclusive = true;
            ownedLocks = this.mLockCount.get() + 1;
            this.mLockCount.set(ownedLocks);
        }
        finally {
            this.mLock.unlock();
        }
        return new ScopedLock();
    }

    public void releaseLock() {
        if (this.mLockCount.get() <= 0) {
            throw new IllegalStateException("Cannot release lock that was not acquired by this thread");
        }
        try {
            this.mLock.lock();
            if (this.mClosed) {
                throw new IllegalStateException("Do not release after the lock has been closed");
            }
            if (!this.mExclusive) {
                --this.mSharedLocks;
            } else if (this.mSharedLocks != 0) {
                throw new AssertionError((Object)("Too many shared locks " + this.mSharedLocks));
            }
            int ownedLocks = this.mLockCount.get() - 1;
            this.mLockCount.set(ownedLocks);
            if (ownedLocks == 0 && this.mExclusive) {
                this.mExclusive = false;
                this.mCondition.signalAll();
            } else if (ownedLocks == 0 && this.mSharedLocks == 0) {
                this.mCondition.signalAll();
            }
        }
        finally {
            this.mLock.unlock();
        }
    }

    private void log(String what) {
        Log.v("CloseableLock[" + this.mName + "]", what);
    }

    public class ScopedLock
    implements AutoCloseable {
        private ScopedLock() {
        }

        @Override
        public void close() {
            CloseableLock.this.releaseLock();
        }
    }
}

