/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.location;

import android.content.Context;
import android.hardware.location.ContextHubInfo;
import android.hardware.location.ContextHubMessage;
import android.hardware.location.IContextHubCallback;
import android.hardware.location.IContextHubService;
import android.hardware.location.NanoApp;
import android.hardware.location.NanoAppFilter;
import android.hardware.location.NanoAppInstanceInfo;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;

public final class ContextHubManager {
    private static final String TAG = "ContextHubManager";
    private final Looper mMainLooper;
    private IContextHubService mContextHubService;
    private Callback mCallback;
    private Handler mCallbackHandler;
    @Deprecated
    private ICallback mLocalCallback;
    private IContextHubCallback.Stub mClientCallback = new IContextHubCallback.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMessageReceipt(final int hubId, final int nanoAppId, final ContextHubMessage message) {
            if (ContextHubManager.this.mCallback != null) {
                1 var4_4 = this;
                synchronized (var4_4) {
                    final Callback callback = ContextHubManager.this.mCallback;
                    Handler handler = ContextHubManager.this.mCallbackHandler == null ? new Handler(ContextHubManager.this.mMainLooper) : ContextHubManager.this.mCallbackHandler;
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onMessageReceipt(hubId, nanoAppId, message);
                        }
                    });
                }
            } else if (ContextHubManager.this.mLocalCallback != null) {
                1 var4_5 = this;
                synchronized (var4_5) {
                    ContextHubManager.this.mLocalCallback.onMessageReceipt(hubId, nanoAppId, message);
                }
            } else {
                Log.d(ContextHubManager.TAG, "Context hub manager client callback is NULL");
            }
        }
    };

    public int[] getContextHubHandles() {
        int[] retVal = null;
        try {
            retVal = this.getBinder().getContextHubHandles();
        }
        catch (RemoteException e) {
            Log.w(TAG, "Could not fetch context hub handles : " + e);
        }
        return retVal;
    }

    public ContextHubInfo getContextHubInfo(int hubHandle) {
        ContextHubInfo retVal = null;
        try {
            retVal = this.getBinder().getContextHubInfo(hubHandle);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Could not fetch context hub info :" + e);
        }
        return retVal;
    }

    public int loadNanoApp(int hubHandle, NanoApp app) {
        int retVal = -1;
        if (app == null) {
            return retVal;
        }
        try {
            retVal = this.getBinder().loadNanoApp(hubHandle, app);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Could not load nanoApp :" + e);
        }
        return retVal;
    }

    public int unloadNanoApp(int nanoAppHandle) {
        int retVal = -1;
        try {
            retVal = this.getBinder().unloadNanoApp(nanoAppHandle);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Could not fetch unload nanoApp :" + e);
        }
        return retVal;
    }

    public NanoAppInstanceInfo getNanoAppInstanceInfo(int nanoAppHandle) {
        NanoAppInstanceInfo retVal = null;
        try {
            retVal = this.getBinder().getNanoAppInstanceInfo(nanoAppHandle);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Could not fetch nanoApp info :" + e);
        }
        return retVal;
    }

    public int[] findNanoAppOnHub(int hubHandle, NanoAppFilter filter) {
        int[] retVal = null;
        try {
            retVal = this.getBinder().findNanoAppOnHub(hubHandle, filter);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Could not query nanoApp instance :" + e);
        }
        return retVal;
    }

    public int sendMessage(int hubHandle, int nanoAppHandle, ContextHubMessage message) {
        int retVal = -1;
        if (message == null || message.getData() == null) {
            Log.w(TAG, "null ptr");
            return retVal;
        }
        try {
            retVal = this.getBinder().sendMessage(hubHandle, nanoAppHandle, message);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Could not send message :" + e.toString());
        }
        return retVal;
    }

    public int registerCallback(Callback callback) {
        return this.registerCallback(callback, null);
    }

    @Deprecated
    public int registerCallback(ICallback callback) {
        if (this.mLocalCallback != null) {
            Log.w(TAG, "Max number of local callbacks reached!");
            return -1;
        }
        this.mLocalCallback = callback;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerCallback(Callback callback, Handler handler) {
        ContextHubManager contextHubManager = this;
        synchronized (contextHubManager) {
            if (this.mCallback != null) {
                Log.w(TAG, "Max number of callbacks reached!");
                return -1;
            }
            this.mCallback = callback;
            this.mCallbackHandler = handler;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unregisterCallback(Callback callback) {
        ContextHubManager contextHubManager = this;
        synchronized (contextHubManager) {
            if (callback != this.mCallback) {
                Log.w(TAG, "Cannot recognize callback!");
                return -1;
            }
            this.mCallback = null;
            this.mCallbackHandler = null;
        }
        return 0;
    }

    public synchronized int unregisterCallback(ICallback callback) {
        if (callback != this.mLocalCallback) {
            Log.w(TAG, "Cannot recognize local callback!");
            return -1;
        }
        this.mLocalCallback = null;
        return 0;
    }

    public ContextHubManager(Context context, Looper mainLooper) {
        this.mMainLooper = mainLooper;
        IBinder b = ServiceManager.getService("contexthub_service");
        if (b != null) {
            this.mContextHubService = IContextHubService.Stub.asInterface(b);
            try {
                this.getBinder().registerCallback(this.mClientCallback);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Could not register callback:" + e);
            }
        } else {
            Log.w(TAG, "failed to getService");
        }
    }

    private IContextHubService getBinder() throws RemoteException {
        if (this.mContextHubService == null) {
            throw new RemoteException("Service not connected.");
        }
        return this.mContextHubService;
    }

    @Deprecated
    public static interface ICallback {
        public void onMessageReceipt(int var1, int var2, ContextHubMessage var3);
    }

    public static abstract class Callback {
        protected Callback() {
        }

        public abstract void onMessageReceipt(int var1, int var2, ContextHubMessage var3);
    }
}

