/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.location;

import android.content.Context;
import android.hardware.location.ContextHubInfo;
import android.hardware.location.ContextHubMessage;
import android.hardware.location.IContextHubCallback;
import android.hardware.location.IContextHubService;
import android.hardware.location.NanoApp;
import android.hardware.location.NanoAppFilter;
import android.hardware.location.NanoAppInstanceInfo;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.service.vr.IVrManager;
import android.service.vr.IVrStateCallbacks;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;

public class ContextHubService
extends IContextHubService.Stub {
    public static final String CONTEXTHUB_SERVICE = "contexthub_service";
    private static final String TAG = "ContextHubService";
    private static final String HARDWARE_PERMISSION = "android.permission.LOCATION_HARDWARE";
    private static final String ENFORCE_HW_PERMISSION_MESSAGE = "Permission 'android.permission.LOCATION_HARDWARE' not granted to access ContextHub Hardware";
    public static final int ANY_HUB = -1;
    public static final int MSG_LOAD_NANO_APP = 3;
    public static final int MSG_UNLOAD_NANO_APP = 4;
    private static final String PRE_LOADED_GENERIC_UNKNOWN = "Preloaded app, unknown";
    private static final String PRE_LOADED_APP_NAME = "Preloaded app, unknown";
    private static final String PRE_LOADED_APP_PUBLISHER = "Preloaded app, unknown";
    private static final int PRE_LOADED_APP_MEM_REQ = 0;
    private static final int MSG_HEADER_SIZE = 4;
    private static final int HEADER_FIELD_MSG_TYPE = 0;
    private static final int HEADER_FIELD_MSG_VERSION = 1;
    private static final int HEADER_FIELD_HUB_HANDLE = 2;
    private static final int HEADER_FIELD_APP_INSTANCE = 3;
    private static final int HEADER_FIELD_LOAD_APP_ID_LO = 4;
    private static final int HEADER_FIELD_LOAD_APP_ID_HI = 5;
    private static final int MSG_LOAD_APP_HEADER_SIZE = 6;
    private static final int OS_APP_INSTANCE = -1;
    private static final long APP_ID_ACTIVITY_RECOGNITION = 5147455389092024320L;
    private final Context mContext;
    private final ConcurrentHashMap<Integer, NanoAppInstanceInfo> mNanoAppHash = new ConcurrentHashMap();
    private final ContextHubInfo[] mContextHubInfo;
    private final RemoteCallbackList<IContextHubCallback> mCallbacksList = new RemoteCallbackList();
    private final IVrStateCallbacks mVrStateCallbacks = new IVrStateCallbacks.Stub(){

        @Override
        public void onVrStateChanged(boolean enabled) {
            for (NanoAppInstanceInfo app : ContextHubService.this.mNanoAppHash.values()) {
                if (app.getAppId() != 5147455389092024320L) continue;
                ContextHubService.this.sendVrStateChangeMessageToApp(app, enabled);
                break;
            }
        }
    };

    private native int nativeSendMessage(int[] var1, byte[] var2);

    private native ContextHubInfo[] nativeInitialize();

    public ContextHubService(Context context) {
        IVrManager vrManager;
        this.mContext = context;
        this.mContextHubInfo = this.nativeInitialize();
        for (int i = 0; i < this.mContextHubInfo.length; ++i) {
            Log.d(TAG, "ContextHub[" + i + "] id: " + this.mContextHubInfo[i].getId() + ", name:  " + this.mContextHubInfo[i].getName());
        }
        if (context.getPackageManager().hasSystemFeature("android.software.vr.mode") && (vrManager = IVrManager.Stub.asInterface(ServiceManager.getService("vrmanager"))) != null) {
            try {
                vrManager.registerListener(this.mVrStateCallbacks);
            }
            catch (RemoteException e) {
                Log.e(TAG, "VR state listener registration failed", e);
            }
        }
    }

    @Override
    public int registerCallback(IContextHubCallback callback) throws RemoteException {
        this.checkPermissions();
        this.mCallbacksList.register(callback);
        return 0;
    }

    @Override
    public int[] getContextHubHandles() throws RemoteException {
        this.checkPermissions();
        int[] returnArray = new int[this.mContextHubInfo.length];
        for (int i = 0; i < returnArray.length; ++i) {
            returnArray[i] = i;
            Log.d(TAG, String.format("Hub %s is mapped to %d", this.mContextHubInfo[i].getName(), returnArray[i]));
        }
        return returnArray;
    }

    @Override
    public ContextHubInfo getContextHubInfo(int contextHubHandle) throws RemoteException {
        this.checkPermissions();
        if (contextHubHandle < 0 || contextHubHandle >= this.mContextHubInfo.length) {
            return null;
        }
        return this.mContextHubInfo[contextHubHandle];
    }

    @Override
    public int loadNanoApp(int contextHubHandle, NanoApp app) throws RemoteException {
        this.checkPermissions();
        if (contextHubHandle < 0 || contextHubHandle >= this.mContextHubInfo.length) {
            Log.e(TAG, "Invalid contextHubhandle " + contextHubHandle);
            return -1;
        }
        int[] msgHeader = new int[6];
        msgHeader[2] = contextHubHandle;
        msgHeader[3] = -1;
        msgHeader[1] = 0;
        msgHeader[0] = 3;
        long appId = app.getAppId();
        msgHeader[4] = (int)(appId & 0xFFFFFFFFFFFFFFFFL);
        msgHeader[5] = (int)(appId >> 32 & 0xFFFFFFFFFFFFFFFFL);
        int errVal = this.nativeSendMessage(msgHeader, app.getAppBinary());
        if (errVal != 0) {
            Log.e(TAG, "Send Message returns error" + contextHubHandle);
            return -1;
        }
        return 0;
    }

    @Override
    public int unloadNanoApp(int nanoAppInstanceHandle) throws RemoteException {
        this.checkPermissions();
        NanoAppInstanceInfo info = this.mNanoAppHash.get(nanoAppInstanceHandle);
        if (info == null) {
            return -1;
        }
        int[] msgHeader = new int[4];
        msgHeader[2] = -1;
        msgHeader[3] = nanoAppInstanceHandle;
        msgHeader[1] = 0;
        msgHeader[0] = 4;
        byte[] msg = new byte[0];
        if (this.nativeSendMessage(msgHeader, msg) != 0) {
            return -1;
        }
        return 0;
    }

    @Override
    public NanoAppInstanceInfo getNanoAppInstanceInfo(int nanoAppInstanceHandle) throws RemoteException {
        this.checkPermissions();
        if (this.mNanoAppHash.containsKey(nanoAppInstanceHandle)) {
            return this.mNanoAppHash.get(nanoAppInstanceHandle);
        }
        return null;
    }

    @Override
    public int[] findNanoAppOnHub(int hubHandle, NanoAppFilter filter) throws RemoteException {
        this.checkPermissions();
        ArrayList<Integer> foundInstances = new ArrayList<Integer>();
        for (Integer nanoAppInstance : this.mNanoAppHash.keySet()) {
            NanoAppInstanceInfo info = this.mNanoAppHash.get(nanoAppInstance);
            if (!filter.testMatch(info)) continue;
            foundInstances.add(nanoAppInstance);
        }
        int[] retArray = new int[foundInstances.size()];
        for (int i = 0; i < foundInstances.size(); ++i) {
            retArray[i] = (Integer)foundInstances.get(i);
        }
        return retArray;
    }

    @Override
    public int sendMessage(int hubHandle, int nanoAppHandle, ContextHubMessage msg) throws RemoteException {
        this.checkPermissions();
        int[] msgHeader = new int[4];
        msgHeader[2] = hubHandle;
        msgHeader[3] = nanoAppHandle;
        msgHeader[1] = msg.getVersion();
        msgHeader[0] = msg.getMsgType();
        return this.nativeSendMessage(msgHeader, msg.getData());
    }

    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump contexthub_service");
            return;
        }
        pw.println("Dumping ContextHub Service");
        pw.println("");
        pw.println("=================== CONTEXT HUBS ====================");
        for (int i = 0; i < this.mContextHubInfo.length; ++i) {
            pw.println("Handle " + i + " : " + this.mContextHubInfo[i].toString());
        }
        pw.println("");
        pw.println("=================== NANOAPPS ====================");
        for (Integer nanoAppInstance : this.mNanoAppHash.keySet()) {
            pw.println(nanoAppInstance + " : " + this.mNanoAppHash.get(nanoAppInstance).toString());
        }
    }

    private void checkPermissions() {
        this.mContext.enforceCallingPermission(HARDWARE_PERMISSION, ENFORCE_HW_PERMISSION_MESSAGE);
    }

    private int onMessageReceipt(int[] header, byte[] data) {
        if (header == null || data == null || header.length < 4) {
            return -1;
        }
        int callbacksCount = this.mCallbacksList.beginBroadcast();
        if (callbacksCount < 1) {
            Log.v(TAG, "No message callbacks registered.");
            return 0;
        }
        ContextHubMessage msg = new ContextHubMessage(header[0], header[1], data);
        for (int i = 0; i < callbacksCount; ++i) {
            IContextHubCallback callback = this.mCallbacksList.getBroadcastItem(i);
            try {
                callback.onMessageReceipt(header[2], header[3], msg);
                continue;
            }
            catch (RemoteException e) {
                Log.i(TAG, "Exception (" + e + ") calling remote callback (" + callback + ").");
            }
        }
        this.mCallbacksList.finishBroadcast();
        return 0;
    }

    private int addAppInstance(int hubHandle, int appInstanceHandle, long appId, int appVersion) {
        NanoAppInstanceInfo appInfo = new NanoAppInstanceInfo();
        appInfo.setAppId(appId);
        appInfo.setAppVersion(appVersion);
        appInfo.setName("Preloaded app, unknown");
        appInfo.setContexthubId(hubHandle);
        appInfo.setHandle(appInstanceHandle);
        appInfo.setPublisher("Preloaded app, unknown");
        appInfo.setNeededExecMemBytes(0);
        appInfo.setNeededReadMemBytes(0);
        appInfo.setNeededWriteMemBytes(0);
        this.mNanoAppHash.put(appInstanceHandle, appInfo);
        Log.d(TAG, "Added app instance " + appInstanceHandle + " with id " + appId + " version " + appVersion);
        return 0;
    }

    private int deleteAppInstance(int appInstanceHandle) {
        if (this.mNanoAppHash.remove(appInstanceHandle) == null) {
            return -1;
        }
        return 0;
    }

    private void sendVrStateChangeMessageToApp(NanoAppInstanceInfo app, boolean vrModeEnabled) {
        int[] msgHeader = new int[]{0, 0, -1, app.getHandle()};
        byte[] data = new byte[]{(byte)(vrModeEnabled ? 1 : 0)};
        int ret = this.nativeSendMessage(msgHeader, data);
        if (ret != 0) {
            Log.e(TAG, "Couldn't send VR state change notification (" + ret + ")!");
        }
    }
}

