/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

public final class SimplePatternFormatter {
    private static final int ARG_NUM_LIMIT = 256;
    private static final char SEGMENT_LENGTH_PLACEHOLDER_CHAR = '\uffff';
    private static final int MAX_SEGMENT_LENGTH = 65279;
    private final String compiledPattern;

    private SimplePatternFormatter(String compiledPattern) {
        this.compiledPattern = compiledPattern;
    }

    public static SimplePatternFormatter compile(CharSequence pattern) {
        return SimplePatternFormatter.compileMinMaxPlaceholders(pattern, 0, Integer.MAX_VALUE);
    }

    public static SimplePatternFormatter compileMinMaxPlaceholders(CharSequence pattern, int min, int max) {
        StringBuilder sb = new StringBuilder();
        String compiledPattern = SimplePatternFormatter.compileToStringMinMaxPlaceholders(pattern, sb, min, max);
        return new SimplePatternFormatter(compiledPattern);
    }

    public static String compileToStringMinMaxPlaceholders(CharSequence pattern, StringBuilder sb, int min, int max) {
        int argCount;
        int patternLength = pattern.length();
        sb.ensureCapacity(patternLength);
        sb.setLength(1);
        int textLength = 0;
        int maxArg = -1;
        boolean inQuote = false;
        int i = 0;
        while (i < patternLength) {
            int c;
            if ((c = pattern.charAt(i++)) == 39) {
                if (i < patternLength && (c = pattern.charAt(i)) == 39) {
                    ++i;
                } else {
                    if (inQuote) {
                        inQuote = false;
                        continue;
                    }
                    if (c == 123 || c == 125) {
                        ++i;
                        inQuote = true;
                    } else {
                        c = 39;
                    }
                }
            } else if (!inQuote && c == 123) {
                int argNumber;
                if (textLength > 0) {
                    sb.setCharAt(sb.length() - textLength - 1, (char)(256 + textLength));
                    textLength = 0;
                }
                if (i + 1 < patternLength && 0 <= (argNumber = pattern.charAt(i) - 48) && argNumber <= 9 && pattern.charAt(i + 1) == '}') {
                    i += 2;
                } else {
                    int argStart = i - 1;
                    argNumber = -1;
                    if (i < patternLength) {
                        char c2 = pattern.charAt(i++);
                        c = c2;
                        if ('1' <= c2 && c <= 57) {
                            argNumber = c - 48;
                            while (i < patternLength) {
                                char c3 = pattern.charAt(i++);
                                c = c3;
                                if ('0' <= c3 && c <= 57 && (argNumber = argNumber * 10 + (c - 48)) < 256) continue;
                            }
                        }
                    }
                    if (argNumber < 0 || c != 125) {
                        throw new IllegalArgumentException("Argument syntax error in pattern \"" + pattern + "\" at index " + argStart + ": " + pattern.subSequence(argStart, i));
                    }
                }
                if (argNumber > maxArg) {
                    maxArg = argNumber;
                }
                sb.append((char)argNumber);
                continue;
            }
            if (textLength == 0) {
                sb.append('\uffff');
            }
            sb.append((char)c);
            if (++textLength != 65279) continue;
            textLength = 0;
        }
        if (textLength > 0) {
            sb.setCharAt(sb.length() - textLength - 1, (char)(256 + textLength));
        }
        if ((argCount = maxArg + 1) < min) {
            throw new IllegalArgumentException("Fewer than minimum " + min + " placeholders in pattern \"" + pattern + "\"");
        }
        if (argCount > max) {
            throw new IllegalArgumentException("More than maximum " + max + " placeholders in pattern \"" + pattern + "\"");
        }
        sb.setCharAt(0, (char)argCount);
        return sb.toString();
    }

    public int getPlaceholderCount() {
        return SimplePatternFormatter.getPlaceholderCount(this.compiledPattern);
    }

    public static int getPlaceholderCount(String compiledPattern) {
        return compiledPattern.charAt(0);
    }

    public String format(CharSequence ... values) {
        return SimplePatternFormatter.formatCompiledPattern(this.compiledPattern, values);
    }

    public static String formatCompiledPattern(String compiledPattern, CharSequence ... values) {
        return SimplePatternFormatter.formatAndAppend(compiledPattern, new StringBuilder(), null, values).toString();
    }

    public StringBuilder formatAndAppend(StringBuilder appendTo, int[] offsets, CharSequence ... values) {
        return SimplePatternFormatter.formatAndAppend(this.compiledPattern, appendTo, offsets, values);
    }

    public static StringBuilder formatAndAppend(String compiledPattern, StringBuilder appendTo, int[] offsets, CharSequence ... values) {
        int valuesLength;
        int n = valuesLength = values != null ? values.length : 0;
        if (valuesLength < SimplePatternFormatter.getPlaceholderCount(compiledPattern)) {
            throw new IllegalArgumentException("Too few values.");
        }
        return SimplePatternFormatter.format(compiledPattern, values, appendTo, null, true, offsets);
    }

    public StringBuilder formatAndReplace(StringBuilder result, int[] offsets, CharSequence ... values) {
        return SimplePatternFormatter.formatAndReplace(this.compiledPattern, result, offsets, values);
    }

    public static StringBuilder formatAndReplace(String compiledPattern, StringBuilder result, int[] offsets, CharSequence ... values) {
        int valuesLength;
        int n = valuesLength = values != null ? values.length : 0;
        if (valuesLength < SimplePatternFormatter.getPlaceholderCount(compiledPattern)) {
            throw new IllegalArgumentException("Too few values.");
        }
        int firstArg = -1;
        String resultCopy = null;
        if (SimplePatternFormatter.getPlaceholderCount(compiledPattern) > 0) {
            int i = 1;
            while (i < compiledPattern.length()) {
                char n2;
                if ((n2 = compiledPattern.charAt(i++)) < '\u0100') {
                    if (values[n2] != result) continue;
                    if (i == 2) {
                        firstArg = n2;
                        continue;
                    }
                    if (resultCopy != null) continue;
                    resultCopy = result.toString();
                    continue;
                }
                i += n2 - 256;
            }
        }
        if (firstArg < 0) {
            result.setLength(0);
        }
        return SimplePatternFormatter.format(compiledPattern, values, result, resultCopy, false, offsets);
    }

    public String toString() {
        CharSequence[] values = new String[this.getPlaceholderCount()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = String.format("{%d}", i);
        }
        return this.formatAndAppend(new StringBuilder(), null, values).toString();
    }

    public String getTextWithNoPlaceholders() {
        return SimplePatternFormatter.getTextWithNoPlaceholders(this.compiledPattern);
    }

    public static String getTextWithNoPlaceholders(String compiledPattern) {
        int capacity = compiledPattern.length() - 1 - SimplePatternFormatter.getPlaceholderCount(compiledPattern);
        StringBuilder sb = new StringBuilder(capacity);
        int i = 1;
        while (i < compiledPattern.length()) {
            int segmentLength;
            if ((segmentLength = compiledPattern.charAt(i++) - 256) <= 0) continue;
            int limit = i + segmentLength;
            sb.append(compiledPattern, i, limit);
            i = limit;
        }
        return sb.toString();
    }

    private static StringBuilder format(String compiledPattern, CharSequence[] values, StringBuilder result, String resultCopy, boolean forbidResultAsValue, int[] offsets) {
        int i;
        int offsetsLength;
        if (offsets == null) {
            offsetsLength = 0;
        } else {
            offsetsLength = offsets.length;
            for (i = 0; i < offsetsLength; ++i) {
                offsets[i] = -1;
            }
        }
        i = 1;
        while (i < compiledPattern.length()) {
            char n;
            if ((n = compiledPattern.charAt(i++)) < '\u0100') {
                CharSequence value = values[n];
                if (value == result) {
                    if (forbidResultAsValue) {
                        throw new IllegalArgumentException("Value must not be same object as result");
                    }
                    if (i == 2) {
                        if (n >= offsetsLength) continue;
                        offsets[n] = 0;
                        continue;
                    }
                    if (n < offsetsLength) {
                        offsets[n] = result.length();
                    }
                    result.append(resultCopy);
                    continue;
                }
                if (n < offsetsLength) {
                    offsets[n] = result.length();
                }
                result.append(value);
                continue;
            }
            int limit = i + (n - 256);
            result.append(compiledPattern, i, limit);
            i = limit;
        }
        return result;
    }
}

