/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import java.io.IOException;
import java.io.InputStream;

public final class AmrInputStream
extends InputStream {
    private static final String TAG = "AmrInputStream";
    private static final int SAMPLES_PER_FRAME = 160;
    private InputStream mInputStream;
    private long mGae;
    private final byte[] mBuf = new byte[320];
    private int mBufIn = 0;
    private int mBufOut = 0;
    private byte[] mOneByte = new byte[1];

    public AmrInputStream(InputStream inputStream) {
        this.mInputStream = inputStream;
        this.mGae = AmrInputStream.GsmAmrEncoderNew();
        AmrInputStream.GsmAmrEncoderInitialize(this.mGae);
    }

    @Override
    public int read() throws IOException {
        int rtn = this.read(this.mOneByte, 0, 1);
        return rtn == 1 ? 0xFF & this.mOneByte[0] : -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        if (this.mGae == 0L) {
            throw new IllegalStateException("not open");
        }
        if (this.mBufOut >= this.mBufIn) {
            int n;
            this.mBufOut = 0;
            this.mBufIn = 0;
            for (int i = 0; i < 320; i += n) {
                n = this.mInputStream.read(this.mBuf, i, 320 - i);
                if (n != -1) continue;
                return -1;
            }
            this.mBufIn = AmrInputStream.GsmAmrEncoderEncode(this.mGae, this.mBuf, 0, this.mBuf, 0);
        }
        if (length > this.mBufIn - this.mBufOut) {
            length = this.mBufIn - this.mBufOut;
        }
        System.arraycopy((byte[])this.mBuf, (int)this.mBufOut, (byte[])b, (int)offset, (int)length);
        this.mBufOut += length;
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            if (this.mInputStream != null) {
                this.mInputStream.close();
            }
        }
        finally {
            this.mInputStream = null;
            try {
                if (this.mGae != 0L) {
                    AmrInputStream.GsmAmrEncoderCleanup(this.mGae);
                }
            }
            finally {
                try {
                    if (this.mGae != 0L) {
                        AmrInputStream.GsmAmrEncoderDelete(this.mGae);
                    }
                }
                finally {
                    this.mGae = 0L;
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.mGae != 0L) {
            this.close();
            throw new IllegalStateException("someone forgot to close AmrInputStream");
        }
    }

    private static native long GsmAmrEncoderNew();

    private static native void GsmAmrEncoderInitialize(long var0);

    private static native int GsmAmrEncoderEncode(long var0, byte[] var2, int var3, byte[] var4, int var5) throws IOException;

    private static native void GsmAmrEncoderCleanup(long var0);

    private static native void GsmAmrEncoderDelete(long var0);

    static {
        System.loadLibrary("media_jni");
    }
}

