/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.res.AssetManager;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Log;
import android.util.Pair;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import libcore.io.IoUtils;
import libcore.io.Streams;

public class ExifInterface {
    private static final String TAG = "ExifInterface";
    private static final boolean DEBUG = false;
    public static final String TAG_ARTIST = "Artist";
    public static final String TAG_BITS_PER_SAMPLE = "BitsPerSample";
    public static final String TAG_COMPRESSION = "Compression";
    public static final String TAG_COPYRIGHT = "Copyright";
    public static final String TAG_DATETIME = "DateTime";
    public static final String TAG_IMAGE_DESCRIPTION = "ImageDescription";
    public static final String TAG_IMAGE_LENGTH = "ImageLength";
    public static final String TAG_IMAGE_WIDTH = "ImageWidth";
    public static final String TAG_JPEG_INTERCHANGE_FORMAT = "JPEGInterchangeFormat";
    public static final String TAG_JPEG_INTERCHANGE_FORMAT_LENGTH = "JPEGInterchangeFormatLength";
    public static final String TAG_MAKE = "Make";
    public static final String TAG_MODEL = "Model";
    public static final String TAG_ORIENTATION = "Orientation";
    public static final String TAG_PHOTOMETRIC_INTERPRETATION = "PhotometricInterpretation";
    public static final String TAG_PLANAR_CONFIGURATION = "PlanarConfiguration";
    public static final String TAG_PRIMARY_CHROMATICITIES = "PrimaryChromaticities";
    public static final String TAG_REFERENCE_BLACK_WHITE = "ReferenceBlackWhite";
    public static final String TAG_RESOLUTION_UNIT = "ResolutionUnit";
    public static final String TAG_ROWS_PER_STRIP = "RowsPerStrip";
    public static final String TAG_SAMPLES_PER_PIXEL = "SamplesPerPixel";
    public static final String TAG_SOFTWARE = "Software";
    public static final String TAG_STRIP_BYTE_COUNTS = "StripByteCounts";
    public static final String TAG_STRIP_OFFSETS = "StripOffsets";
    public static final String TAG_TRANSFER_FUNCTION = "TransferFunction";
    public static final String TAG_WHITE_POINT = "WhitePoint";
    public static final String TAG_X_RESOLUTION = "XResolution";
    public static final String TAG_Y_CB_CR_COEFFICIENTS = "YCbCrCoefficients";
    public static final String TAG_Y_CB_CR_POSITIONING = "YCbCrPositioning";
    public static final String TAG_Y_CB_CR_SUB_SAMPLING = "YCbCrSubSampling";
    public static final String TAG_Y_RESOLUTION = "YResolution";
    public static final String TAG_APERTURE_VALUE = "ApertureValue";
    public static final String TAG_BRIGHTNESS_VALUE = "BrightnessValue";
    public static final String TAG_CFA_PATTERN = "CFAPattern";
    public static final String TAG_COLOR_SPACE = "ColorSpace";
    public static final String TAG_COMPONENTS_CONFIGURATION = "ComponentsConfiguration";
    public static final String TAG_COMPRESSED_BITS_PER_PIXEL = "CompressedBitsPerPixel";
    public static final String TAG_CONTRAST = "Contrast";
    public static final String TAG_CUSTOM_RENDERED = "CustomRendered";
    public static final String TAG_DATETIME_DIGITIZED = "DateTimeDigitized";
    public static final String TAG_DATETIME_ORIGINAL = "DateTimeOriginal";
    public static final String TAG_DEVICE_SETTING_DESCRIPTION = "DeviceSettingDescription";
    public static final String TAG_DIGITAL_ZOOM_RATIO = "DigitalZoomRatio";
    public static final String TAG_EXIF_VERSION = "ExifVersion";
    public static final String TAG_EXPOSURE_BIAS_VALUE = "ExposureBiasValue";
    public static final String TAG_EXPOSURE_INDEX = "ExposureIndex";
    public static final String TAG_EXPOSURE_MODE = "ExposureMode";
    public static final String TAG_EXPOSURE_PROGRAM = "ExposureProgram";
    public static final String TAG_EXPOSURE_TIME = "ExposureTime";
    public static final String TAG_F_NUMBER = "FNumber";
    @Deprecated
    public static final String TAG_APERTURE = "FNumber";
    public static final String TAG_FILE_SOURCE = "FileSource";
    public static final String TAG_FLASH = "Flash";
    public static final String TAG_FLASH_ENERGY = "FlashEnergy";
    public static final String TAG_FLASHPIX_VERSION = "FlashpixVersion";
    public static final String TAG_FOCAL_LENGTH = "FocalLength";
    public static final String TAG_FOCAL_LENGTH_IN_35MM_FILM = "FocalLengthIn35mmFilm";
    public static final String TAG_FOCAL_PLANE_RESOLUTION_UNIT = "FocalPlaneResolutionUnit";
    public static final String TAG_FOCAL_PLANE_X_RESOLUTION = "FocalPlaneXResolution";
    public static final String TAG_FOCAL_PLANE_Y_RESOLUTION = "FocalPlaneYResolution";
    public static final String TAG_GAIN_CONTROL = "GainControl";
    public static final String TAG_ISO_SPEED_RATINGS = "ISOSpeedRatings";
    @Deprecated
    public static final String TAG_ISO = "ISOSpeedRatings";
    public static final String TAG_IMAGE_UNIQUE_ID = "ImageUniqueID";
    public static final String TAG_LIGHT_SOURCE = "LightSource";
    public static final String TAG_MAKER_NOTE = "MakerNote";
    public static final String TAG_MAX_APERTURE_VALUE = "MaxApertureValue";
    public static final String TAG_METERING_MODE = "MeteringMode";
    public static final String TAG_OECF = "OECF";
    public static final String TAG_PIXEL_X_DIMENSION = "PixelXDimension";
    public static final String TAG_PIXEL_Y_DIMENSION = "PixelYDimension";
    public static final String TAG_RELATED_SOUND_FILE = "RelatedSoundFile";
    public static final String TAG_SATURATION = "Saturation";
    public static final String TAG_SCENE_CAPTURE_TYPE = "SceneCaptureType";
    public static final String TAG_SCENE_TYPE = "SceneType";
    public static final String TAG_SENSING_METHOD = "SensingMethod";
    public static final String TAG_SHARPNESS = "Sharpness";
    public static final String TAG_SHUTTER_SPEED_VALUE = "ShutterSpeedValue";
    public static final String TAG_SPATIAL_FREQUENCY_RESPONSE = "SpatialFrequencyResponse";
    public static final String TAG_SPECTRAL_SENSITIVITY = "SpectralSensitivity";
    public static final String TAG_SUBSEC_TIME = "SubSecTime";
    public static final String TAG_SUBSEC_TIME_DIG = "SubSecTimeDigitized";
    public static final String TAG_SUBSEC_TIME_DIGITIZED = "SubSecTimeDigitized";
    public static final String TAG_SUBSEC_TIME_ORIG = "SubSecTimeOriginal";
    public static final String TAG_SUBSEC_TIME_ORIGINAL = "SubSecTimeOriginal";
    public static final String TAG_SUBJECT_AREA = "SubjectArea";
    public static final String TAG_SUBJECT_DISTANCE = "SubjectDistance";
    public static final String TAG_SUBJECT_DISTANCE_RANGE = "SubjectDistanceRange";
    public static final String TAG_SUBJECT_LOCATION = "SubjectLocation";
    public static final String TAG_USER_COMMENT = "UserComment";
    public static final String TAG_WHITE_BALANCE = "WhiteBalance";
    public static final String TAG_GPS_ALTITUDE = "GPSAltitude";
    public static final String TAG_GPS_ALTITUDE_REF = "GPSAltitudeRef";
    public static final String TAG_GPS_AREA_INFORMATION = "GPSAreaInformation";
    public static final String TAG_GPS_DOP = "GPSDOP";
    public static final String TAG_GPS_DATESTAMP = "GPSDateStamp";
    public static final String TAG_GPS_DEST_BEARING = "GPSDestBearing";
    public static final String TAG_GPS_DEST_BEARING_REF = "GPSDestBearingRef";
    public static final String TAG_GPS_DEST_DISTANCE = "GPSDestDistance";
    public static final String TAG_GPS_DEST_DISTANCE_REF = "GPSDestDistanceRef";
    public static final String TAG_GPS_DEST_LATITUDE = "GPSDestLatitude";
    public static final String TAG_GPS_DEST_LATITUDE_REF = "GPSDestLatitudeRef";
    public static final String TAG_GPS_DEST_LONGITUDE = "GPSDestLongitude";
    public static final String TAG_GPS_DEST_LONGITUDE_REF = "GPSDestLongitudeRef";
    public static final String TAG_GPS_DIFFERENTIAL = "GPSDifferential";
    public static final String TAG_GPS_IMG_DIRECTION = "GPSImgDirection";
    public static final String TAG_GPS_IMG_DIRECTION_REF = "GPSImgDirectionRef";
    public static final String TAG_GPS_LATITUDE = "GPSLatitude";
    public static final String TAG_GPS_LATITUDE_REF = "GPSLatitudeRef";
    public static final String TAG_GPS_LONGITUDE = "GPSLongitude";
    public static final String TAG_GPS_LONGITUDE_REF = "GPSLongitudeRef";
    public static final String TAG_GPS_MAP_DATUM = "GPSMapDatum";
    public static final String TAG_GPS_MEASURE_MODE = "GPSMeasureMode";
    public static final String TAG_GPS_PROCESSING_METHOD = "GPSProcessingMethod";
    public static final String TAG_GPS_SATELLITES = "GPSSatellites";
    public static final String TAG_GPS_SPEED = "GPSSpeed";
    public static final String TAG_GPS_SPEED_REF = "GPSSpeedRef";
    public static final String TAG_GPS_STATUS = "GPSStatus";
    public static final String TAG_GPS_TIMESTAMP = "GPSTimeStamp";
    public static final String TAG_GPS_TRACK = "GPSTrack";
    public static final String TAG_GPS_TRACK_REF = "GPSTrackRef";
    public static final String TAG_GPS_VERSION_ID = "GPSVersionID";
    public static final String TAG_INTEROPERABILITY_INDEX = "InteroperabilityIndex";
    public static final String TAG_THUMBNAIL_IMAGE_LENGTH = "ThumbnailImageLength";
    public static final String TAG_THUMBNAIL_IMAGE_WIDTH = "ThumbnailImageWidth";
    private static final String TAG_EXIF_IFD_POINTER = "ExifIFDPointer";
    private static final String TAG_GPS_INFO_IFD_POINTER = "GPSInfoIFDPointer";
    private static final String TAG_INTEROPERABILITY_IFD_POINTER = "InteroperabilityIFDPointer";
    private static final String TAG_HAS_THUMBNAIL = "HasThumbnail";
    private static final String TAG_THUMBNAIL_OFFSET = "ThumbnailOffset";
    private static final String TAG_THUMBNAIL_LENGTH = "ThumbnailLength";
    private static final String TAG_THUMBNAIL_DATA = "ThumbnailData";
    public static final int ORIENTATION_UNDEFINED = 0;
    public static final int ORIENTATION_NORMAL = 1;
    public static final int ORIENTATION_FLIP_HORIZONTAL = 2;
    public static final int ORIENTATION_ROTATE_180 = 3;
    public static final int ORIENTATION_FLIP_VERTICAL = 4;
    public static final int ORIENTATION_TRANSPOSE = 5;
    public static final int ORIENTATION_ROTATE_90 = 6;
    public static final int ORIENTATION_TRANSVERSE = 7;
    public static final int ORIENTATION_ROTATE_270 = 8;
    public static final int WHITEBALANCE_AUTO = 0;
    public static final int WHITEBALANCE_MANUAL = 1;
    private static final byte[] JPEG_SIGNATURE = new byte[]{-1, -40, -1};
    private static final int JPEG_SIGNATURE_SIZE = 3;
    private static SimpleDateFormat sFormatter;
    private static final short BYTE_ALIGN_II = 18761;
    private static final short BYTE_ALIGN_MM = 19789;
    private static final int IFD_FORMAT_BYTE = 1;
    private static final int IFD_FORMAT_STRING = 2;
    private static final int IFD_FORMAT_USHORT = 3;
    private static final int IFD_FORMAT_ULONG = 4;
    private static final int IFD_FORMAT_URATIONAL = 5;
    private static final int IFD_FORMAT_SBYTE = 6;
    private static final int IFD_FORMAT_UNDEFINED = 7;
    private static final int IFD_FORMAT_SSHORT = 8;
    private static final int IFD_FORMAT_SLONG = 9;
    private static final int IFD_FORMAT_SRATIONAL = 10;
    private static final int IFD_FORMAT_SINGLE = 11;
    private static final int IFD_FORMAT_DOUBLE = 12;
    private static final String[] IFD_FORMAT_NAMES;
    private static final int[] IFD_FORMAT_BYTES_PER_FORMAT;
    private static final byte[] EXIF_ASCII_PREFIX;
    private static final ExifTag[] IFD_TIFF_TAGS;
    private static final ExifTag[] IFD_EXIF_TAGS;
    private static final ExifTag[] IFD_GPS_TAGS;
    private static final ExifTag[] IFD_INTEROPERABILITY_TAGS;
    private static final ExifTag[] IFD_THUMBNAIL_TAGS;
    private static final int IFD_TIFF_HINT = 0;
    private static final int IFD_EXIF_HINT = 1;
    private static final int IFD_GPS_HINT = 2;
    private static final int IFD_INTEROPERABILITY_HINT = 3;
    private static final int IFD_THUMBNAIL_HINT = 4;
    private static final ExifTag[][] EXIF_TAGS;
    private static final ExifTag[] IFD_POINTER_TAGS;
    private static final int[] IFD_POINTER_TAG_HINTS;
    private static final ExifTag JPEG_INTERCHANGE_FORMAT_TAG;
    private static final ExifTag JPEG_INTERCHANGE_FORMAT_LENGTH_TAG;
    private static final HashMap[] sExifTagMapsForReading;
    private static final HashMap[] sExifTagMapsForWriting;
    private static final HashSet<String> sTagSetForCompatibility;
    private static final Charset ASCII;
    private static final byte[] IDENTIFIER_EXIF_APP1;
    private static final byte MARKER = -1;
    private static final byte MARKER_SOI = -40;
    private static final byte MARKER_SOF0 = -64;
    private static final byte MARKER_SOF1 = -63;
    private static final byte MARKER_SOF2 = -62;
    private static final byte MARKER_SOF3 = -61;
    private static final byte MARKER_SOF5 = -59;
    private static final byte MARKER_SOF6 = -58;
    private static final byte MARKER_SOF7 = -57;
    private static final byte MARKER_SOF9 = -55;
    private static final byte MARKER_SOF10 = -54;
    private static final byte MARKER_SOF11 = -53;
    private static final byte MARKER_SOF13 = -51;
    private static final byte MARKER_SOF14 = -50;
    private static final byte MARKER_SOF15 = -49;
    private static final byte MARKER_SOS = -38;
    private static final byte MARKER_APP1 = -31;
    private static final byte MARKER_COM = -2;
    private static final byte MARKER_EOI = -39;
    private final String mFilename;
    private final FileDescriptor mSeekableFileDescriptor;
    private final AssetManager.AssetInputStream mAssetInputStream;
    private final boolean mIsInputStream;
    private boolean mIsRaw;
    private final HashMap[] mAttributes = new HashMap[EXIF_TAGS.length];
    private ByteOrder mExifByteOrder = ByteOrder.BIG_ENDIAN;
    private boolean mHasThumbnail;
    private int mThumbnailOffset;
    private int mThumbnailLength;
    private byte[] mThumbnailBytes;
    private boolean mIsSupportedFile;
    private static final Pattern sNonZeroTimePattern;
    private static final Pattern sGpsTimestampPattern;

    public ExifInterface(String filename) throws IOException {
        if (filename == null) {
            throw new IllegalArgumentException("filename cannot be null");
        }
        FileInputStream in = null;
        this.mAssetInputStream = null;
        this.mFilename = filename;
        this.mIsInputStream = false;
        try {
            in = new FileInputStream(filename);
            this.mSeekableFileDescriptor = ExifInterface.isSeekableFD(in.getFD()) ? in.getFD() : null;
            this.loadAttributes(in);
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(in);
            throw throwable;
        }
        IoUtils.closeQuietly(in);
    }

    public ExifInterface(FileDescriptor fileDescriptor) throws IOException {
        if (fileDescriptor == null) {
            throw new IllegalArgumentException("fileDescriptor cannot be null");
        }
        this.mAssetInputStream = null;
        this.mFilename = null;
        if (ExifInterface.isSeekableFD(fileDescriptor)) {
            this.mSeekableFileDescriptor = fileDescriptor;
            try {
                fileDescriptor = Os.dup(fileDescriptor);
            }
            catch (ErrnoException e) {
                throw e.rethrowAsIOException();
            }
        } else {
            this.mSeekableFileDescriptor = null;
        }
        this.mIsInputStream = false;
        FileInputStream in = null;
        try {
            in = new FileInputStream(fileDescriptor);
            this.loadAttributes(in);
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(in);
            throw throwable;
        }
        IoUtils.closeQuietly(in);
    }

    public ExifInterface(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream cannot be null");
        }
        this.mFilename = null;
        if (inputStream instanceof AssetManager.AssetInputStream) {
            this.mAssetInputStream = (AssetManager.AssetInputStream)inputStream;
            this.mSeekableFileDescriptor = null;
        } else if (inputStream instanceof FileInputStream && ExifInterface.isSeekableFD(((FileInputStream)inputStream).getFD())) {
            this.mAssetInputStream = null;
            this.mSeekableFileDescriptor = ((FileInputStream)inputStream).getFD();
        } else {
            this.mAssetInputStream = null;
            this.mSeekableFileDescriptor = null;
        }
        this.mIsInputStream = true;
        this.loadAttributes(inputStream);
    }

    private ExifAttribute getExifAttribute(String tag) {
        for (int i = 0; i < EXIF_TAGS.length; ++i) {
            Object value = this.mAttributes[i].get(tag);
            if (value == null) continue;
            return (ExifAttribute)value;
        }
        return null;
    }

    public String getAttribute(String tag) {
        ExifAttribute attribute = this.getExifAttribute(tag);
        if (attribute != null) {
            if (!sTagSetForCompatibility.contains(tag)) {
                return attribute.getStringValue(this.mExifByteOrder);
            }
            if (tag.equals(TAG_GPS_TIMESTAMP)) {
                if (attribute.format != 5 && attribute.format != 10) {
                    return null;
                }
                Rational[] array2 = (Rational[])attribute.getValue(this.mExifByteOrder);
                if (array2.length != 3) {
                    return null;
                }
                return String.format("%02d:%02d:%02d", (int)((float)array2[0].numerator / (float)array2[0].denominator), (int)((float)array2[1].numerator / (float)array2[1].denominator), (int)((float)array2[2].numerator / (float)array2[2].denominator));
            }
            try {
                return Double.toString(attribute.getDoubleValue(this.mExifByteOrder));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public int getAttributeInt(String tag, int defaultValue) {
        ExifAttribute exifAttribute = this.getExifAttribute(tag);
        if (exifAttribute == null) {
            return defaultValue;
        }
        try {
            return exifAttribute.getIntValue(this.mExifByteOrder);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public double getAttributeDouble(String tag, double defaultValue) {
        ExifAttribute exifAttribute = this.getExifAttribute(tag);
        if (exifAttribute == null) {
            return defaultValue;
        }
        try {
            return exifAttribute.getDoubleValue(this.mExifByteOrder);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public void setAttribute(String tag, String value) {
        if (value != null && sTagSetForCompatibility.contains(tag)) {
            if (tag.equals(TAG_GPS_TIMESTAMP)) {
                Matcher m = sGpsTimestampPattern.matcher(value);
                if (!m.find()) {
                    Log.w(TAG, "Invalid value for " + tag + " : " + value);
                    return;
                }
                value = Integer.parseInt(m.group(1)) + "/1," + Integer.parseInt(m.group(2)) + "/1," + Integer.parseInt(m.group(3)) + "/1";
            } else {
                try {
                    double doubleValue = Double.parseDouble(value);
                    value = (long)(doubleValue * 10000.0) + "/10000";
                }
                catch (NumberFormatException e) {
                    Log.w(TAG, "Invalid value for " + tag + " : " + value);
                    return;
                }
            }
        }
        block12: for (int i = 0; i < EXIF_TAGS.length; ++i) {
            int dataFormat;
            Object obj;
            if (i == 4 && !this.mHasThumbnail || (obj = sExifTagMapsForWriting[i].get(tag)) == null) continue;
            if (value == null) {
                this.mAttributes[i].remove(tag);
                continue;
            }
            ExifTag exifTag = (ExifTag)obj;
            Pair<Integer, Integer> guess = ExifInterface.guessDataFormat(value);
            if (exifTag.primaryFormat == (Integer)guess.first || exifTag.primaryFormat == (Integer)guess.second) {
                dataFormat = exifTag.primaryFormat;
            } else if (exifTag.secondaryFormat != -1 && (exifTag.secondaryFormat == (Integer)guess.first || exifTag.secondaryFormat == (Integer)guess.second)) {
                dataFormat = exifTag.secondaryFormat;
            } else if (exifTag.primaryFormat == 1 || exifTag.primaryFormat == 7 || exifTag.primaryFormat == 2) {
                dataFormat = exifTag.primaryFormat;
            } else {
                Log.w(TAG, "Given tag (" + tag + ") value didn't match with one of expected " + "formats: " + IFD_FORMAT_NAMES[exifTag.primaryFormat] + (exifTag.secondaryFormat == -1 ? "" : ", " + IFD_FORMAT_NAMES[exifTag.secondaryFormat]) + " (guess: " + IFD_FORMAT_NAMES[(Integer)guess.first] + ((Integer)guess.second == -1 ? "" : ", " + IFD_FORMAT_NAMES[(Integer)guess.second]) + ")");
                continue;
            }
            switch (dataFormat) {
                case 1: {
                    this.mAttributes[i].put(tag, ExifAttribute.createByte(value));
                    continue block12;
                }
                case 2: 
                case 7: {
                    this.mAttributes[i].put(tag, ExifAttribute.createString(value));
                    continue block12;
                }
                case 3: {
                    int j;
                    String[] values = value.split(",");
                    int[] intArray = new int[values.length];
                    for (j = 0; j < values.length; ++j) {
                        intArray[j] = Integer.parseInt(values[j]);
                    }
                    this.mAttributes[i].put(tag, ExifAttribute.createUShort(intArray, this.mExifByteOrder));
                    continue block12;
                }
                case 9: {
                    int j;
                    String[] values = value.split(",");
                    int[] intArray = new int[values.length];
                    for (j = 0; j < values.length; ++j) {
                        intArray[j] = Integer.parseInt(values[j]);
                    }
                    this.mAttributes[i].put(tag, ExifAttribute.createSLong(intArray, this.mExifByteOrder));
                    continue block12;
                }
                case 4: {
                    int j;
                    String[] values = value.split(",");
                    long[] longArray = new long[values.length];
                    for (j = 0; j < values.length; ++j) {
                        longArray[j] = Long.parseLong(values[j]);
                    }
                    this.mAttributes[i].put(tag, ExifAttribute.createULong(longArray, this.mExifByteOrder));
                    continue block12;
                }
                case 5: {
                    String[] numbers;
                    int j;
                    String[] values = value.split(",");
                    Rational[] rationalArray = new Rational[values.length];
                    for (j = 0; j < values.length; ++j) {
                        numbers = values[j].split("/");
                        rationalArray[j] = new Rational(Long.parseLong(numbers[0]), Long.parseLong(numbers[1]));
                    }
                    this.mAttributes[i].put(tag, ExifAttribute.createURational(rationalArray, this.mExifByteOrder));
                    continue block12;
                }
                case 10: {
                    String[] numbers;
                    int j;
                    String[] values = value.split(",");
                    Rational[] rationalArray = new Rational[values.length];
                    for (j = 0; j < values.length; ++j) {
                        numbers = values[j].split("/");
                        rationalArray[j] = new Rational(Long.parseLong(numbers[0]), Long.parseLong(numbers[1]));
                    }
                    this.mAttributes[i].put(tag, ExifAttribute.createSRational(rationalArray, this.mExifByteOrder));
                    continue block12;
                }
                case 12: {
                    int j;
                    String[] values = value.split(",");
                    double[] doubleArray = new double[values.length];
                    for (j = 0; j < values.length; ++j) {
                        doubleArray[j] = Double.parseDouble(values[j]);
                    }
                    this.mAttributes[i].put(tag, ExifAttribute.createDouble(doubleArray, this.mExifByteOrder));
                    continue block12;
                }
                default: {
                    Log.w(TAG, "Data format isn't one of expected formats: " + dataFormat);
                    continue block12;
                }
            }
        }
    }

    private boolean updateAttribute(String tag, ExifAttribute value) {
        boolean updated = false;
        for (int i = 0; i < EXIF_TAGS.length; ++i) {
            if (!this.mAttributes[i].containsKey(tag)) continue;
            this.mAttributes[i].put(tag, value);
            updated = true;
        }
        return updated;
    }

    private void removeAttribute(String tag) {
        for (int i = 0; i < EXIF_TAGS.length; ++i) {
            this.mAttributes[i].remove(tag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAttributes(InputStream in) throws IOException {
        try {
            for (int i = 0; i < EXIF_TAGS.length; ++i) {
                this.mAttributes[i] = new HashMap();
            }
            if (this.mAssetInputStream != null) {
                long asset = this.mAssetInputStream.getNativeAsset();
                if (this.handleRawResult(ExifInterface.nativeGetRawAttributesFromAsset(asset))) {
                    return;
                }
            } else if (this.mSeekableFileDescriptor != null ? this.handleRawResult(ExifInterface.nativeGetRawAttributesFromFileDescriptor(this.mSeekableFileDescriptor)) : !ExifInterface.isJpegInputStream((BufferedInputStream)(in = new BufferedInputStream(in, 3))) && this.handleRawResult(ExifInterface.nativeGetRawAttributesFromInputStream(in))) {
                return;
            }
            this.getJpegAttributes(in);
            this.mIsSupportedFile = true;
        }
        catch (IOException e) {
            this.mIsSupportedFile = false;
            Log.w(TAG, "Invalid image: ExifInterface got an unsupported image format file(ExifInterface supports JPEG and some RAW image formats only) or a corrupted JPEG file to ExifInterface.", e);
        }
        finally {
            this.addDefaultValuesForCompatibility();
        }
    }

    private static boolean isJpegInputStream(BufferedInputStream in) throws IOException {
        in.mark(3);
        byte[] signatureBytes = new byte[3];
        if (in.read(signatureBytes) != 3) {
            throw new EOFException();
        }
        boolean isJpeg = Arrays.equals(JPEG_SIGNATURE, signatureBytes);
        in.reset();
        return isJpeg;
    }

    private boolean handleRawResult(HashMap map) {
        if (map == null) {
            return false;
        }
        this.mIsRaw = true;
        String value = (String)map.remove(TAG_HAS_THUMBNAIL);
        this.mHasThumbnail = value != null && value.equalsIgnoreCase("true");
        value = (String)map.remove(TAG_THUMBNAIL_OFFSET);
        if (value != null) {
            this.mThumbnailOffset = Integer.parseInt(value);
        }
        if ((value = (String)map.remove(TAG_THUMBNAIL_LENGTH)) != null) {
            this.mThumbnailLength = Integer.parseInt(value);
        }
        this.mThumbnailBytes = (byte[])map.remove(TAG_THUMBNAIL_DATA);
        for (Map.Entry entry : map.entrySet()) {
            this.setAttribute((String)entry.getKey(), (String)entry.getValue());
        }
        return true;
    }

    private static boolean isSeekableFD(FileDescriptor fd) throws IOException {
        try {
            Os.lseek(fd, 0L, OsConstants.SEEK_CUR);
            return true;
        }
        catch (ErrnoException e) {
            return false;
        }
    }

    private void printAttributes() {
        for (int i = 0; i < this.mAttributes.length; ++i) {
            Log.d(TAG, "The size of tag group[" + i + "]: " + this.mAttributes[i].size());
            for (Map.Entry entry : this.mAttributes[i].entrySet()) {
                ExifAttribute tagValue = (ExifAttribute)entry.getValue();
                Log.d(TAG, "tagName: " + entry.getKey() + ", tagType: " + tagValue.toString() + ", tagValue: '" + tagValue.getStringValue(this.mExifByteOrder) + "'");
            }
        }
    }

    public void saveAttributes() throws IOException {
        if (!this.mIsSupportedFile || this.mIsRaw) {
            throw new UnsupportedOperationException("ExifInterface only supports saving attributes on JPEG formats.");
        }
        if (this.mIsInputStream || this.mSeekableFileDescriptor == null && this.mFilename == null) {
            throw new UnsupportedOperationException("ExifInterface does not support saving attributes for the current input.");
        }
        this.mThumbnailBytes = this.getThumbnail();
        FileInputStream in = null;
        FileOutputStream out = null;
        File tempFile = null;
        try {
            if (this.mFilename != null) {
                File originalFile = new File(this.mFilename);
                tempFile = new File(this.mFilename + ".tmp");
                if (!originalFile.renameTo(tempFile)) {
                    throw new IOException("Could'nt rename to " + tempFile.getAbsolutePath());
                }
            } else if (this.mSeekableFileDescriptor != null) {
                tempFile = File.createTempFile("temp", "jpg");
                Os.lseek(this.mSeekableFileDescriptor, 0L, OsConstants.SEEK_SET);
                in = new FileInputStream(this.mSeekableFileDescriptor);
                out = new FileOutputStream(tempFile);
                Streams.copy(in, out);
            }
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
        finally {
            IoUtils.closeQuietly(in);
            IoUtils.closeQuietly(out);
        }
        in = null;
        out = null;
        try {
            in = new FileInputStream(tempFile);
            if (this.mFilename != null) {
                out = new FileOutputStream(this.mFilename);
            } else if (this.mSeekableFileDescriptor != null) {
                Os.lseek(this.mSeekableFileDescriptor, 0L, OsConstants.SEEK_SET);
                out = new FileOutputStream(this.mSeekableFileDescriptor);
            }
            this.saveJpegAttributes(in, out);
        }
        catch (ErrnoException e) {
            try {
                throw e.rethrowAsIOException();
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(in);
                IoUtils.closeQuietly(out);
                tempFile.delete();
                throw throwable;
            }
        }
        IoUtils.closeQuietly(in);
        IoUtils.closeQuietly(out);
        tempFile.delete();
        this.mThumbnailBytes = null;
    }

    public boolean hasThumbnail() {
        return this.mHasThumbnail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getThumbnail() {
        block13: {
            byte[] byArray;
            FileInputStream in;
            block12: {
                if (!this.mHasThumbnail) {
                    return null;
                }
                if (this.mThumbnailBytes != null) {
                    return this.mThumbnailBytes;
                }
                in = null;
                if (this.mAssetInputStream == null) break block12;
                byte[] byArray2 = ExifInterface.nativeGetThumbnailFromAsset(this.mAssetInputStream.getNativeAsset(), this.mThumbnailOffset, this.mThumbnailLength);
                IoUtils.closeQuietly(in);
                return byArray2;
            }
            try {
                if (this.mFilename != null) {
                    in = new FileInputStream(this.mFilename);
                } else if (this.mSeekableFileDescriptor != null) {
                    FileDescriptor fileDescriptor = Os.dup(this.mSeekableFileDescriptor);
                    Os.lseek(fileDescriptor, 0L, OsConstants.SEEK_SET);
                    in = new FileInputStream(fileDescriptor);
                }
                if (in == null) {
                    throw new FileNotFoundException();
                }
                if (in.skip(this.mThumbnailOffset) != (long)this.mThumbnailOffset) {
                    throw new IOException("Corrupted image");
                }
                byte[] buffer = new byte[this.mThumbnailLength];
                if (in.read(buffer) != this.mThumbnailLength) {
                    throw new IOException("Corrupted image");
                }
                byArray = buffer;
            }
            catch (ErrnoException | IOException exception) {
                IoUtils.closeQuietly(in);
                break block13;
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(in);
                throw throwable;
            }
            IoUtils.closeQuietly(in);
            return byArray;
        }
        return null;
    }

    public long[] getThumbnailRange() {
        if (!this.mHasThumbnail) {
            return null;
        }
        long[] range = new long[]{this.mThumbnailOffset, this.mThumbnailLength};
        return range;
    }

    public boolean getLatLong(float[] output) {
        String latValue = this.getAttribute(TAG_GPS_LATITUDE);
        String latRef = this.getAttribute(TAG_GPS_LATITUDE_REF);
        String lngValue = this.getAttribute(TAG_GPS_LONGITUDE);
        String lngRef = this.getAttribute(TAG_GPS_LONGITUDE_REF);
        if (latValue != null && latRef != null && lngValue != null && lngRef != null) {
            try {
                output[0] = ExifInterface.convertRationalLatLonToFloat(latValue, latRef);
                output[1] = ExifInterface.convertRationalLatLonToFloat(lngValue, lngRef);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    public double getAltitude(double defaultValue) {
        double altitude = this.getAttributeDouble(TAG_GPS_ALTITUDE, -1.0);
        int ref = this.getAttributeInt(TAG_GPS_ALTITUDE_REF, -1);
        if (altitude >= 0.0 && ref >= 0) {
            return altitude * (double)(ref == 1 ? -1 : 1);
        }
        return defaultValue;
    }

    public long getDateTime() {
        String dateTimeString = this.getAttribute(TAG_DATETIME);
        if (dateTimeString == null || !sNonZeroTimePattern.matcher(dateTimeString).matches()) {
            return -1L;
        }
        ParsePosition pos = new ParsePosition(0);
        try {
            Date datetime = sFormatter.parse(dateTimeString, pos);
            if (datetime == null) {
                return -1L;
            }
            long msecs = datetime.getTime();
            String subSecs = this.getAttribute(TAG_SUBSEC_TIME);
            if (subSecs != null) {
                try {
                    long sub;
                    for (sub = Long.valueOf(subSecs).longValue(); sub > 1000L; sub /= 10L) {
                    }
                    msecs += sub;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return msecs;
        }
        catch (IllegalArgumentException e) {
            return -1L;
        }
    }

    public long getGpsDateTime() {
        String date = this.getAttribute(TAG_GPS_DATESTAMP);
        String time = this.getAttribute(TAG_GPS_TIMESTAMP);
        if (date == null || time == null || !sNonZeroTimePattern.matcher(date).matches() && !sNonZeroTimePattern.matcher(time).matches()) {
            return -1L;
        }
        String dateTimeString = date + ' ' + time;
        ParsePosition pos = new ParsePosition(0);
        try {
            Date datetime = sFormatter.parse(dateTimeString, pos);
            if (datetime == null) {
                return -1L;
            }
            return datetime.getTime();
        }
        catch (IllegalArgumentException e) {
            return -1L;
        }
    }

    private static float convertRationalLatLonToFloat(String rationalString, String ref) {
        try {
            String[] parts = rationalString.split(",");
            String[] pair = parts[0].split("/");
            double degrees = Double.parseDouble(pair[0].trim()) / Double.parseDouble(pair[1].trim());
            pair = parts[1].split("/");
            double minutes = Double.parseDouble(pair[0].trim()) / Double.parseDouble(pair[1].trim());
            pair = parts[2].split("/");
            double seconds = Double.parseDouble(pair[0].trim()) / Double.parseDouble(pair[1].trim());
            double result = degrees + minutes / 60.0 + seconds / 3600.0;
            if (ref.equals("S") || ref.equals("W")) {
                return (float)(-result);
            }
            return (float)result;
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            throw new IllegalArgumentException();
        }
    }

    private void getJpegAttributes(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int bytesRead = 0;
        byte marker = dataInputStream.readByte();
        if (marker != -1) {
            throw new IOException("Invalid marker: " + Integer.toHexString(marker & 0xFF));
        }
        ++bytesRead;
        if (dataInputStream.readByte() != -40) {
            throw new IOException("Invalid marker: " + Integer.toHexString(marker & 0xFF));
        }
        ++bytesRead;
        while (true) {
            if ((marker = dataInputStream.readByte()) != -1) {
                throw new IOException("Invalid marker:" + Integer.toHexString(marker & 0xFF));
            }
            ++bytesRead;
            marker = dataInputStream.readByte();
            ++bytesRead;
            if (marker == -39 || marker == -38) break;
            int length = dataInputStream.readUnsignedShort() - 2;
            bytesRead += 2;
            if (length < 0) {
                throw new IOException("Invalid length");
            }
            switch (marker) {
                case -31: {
                    if (length < 6) break;
                    byte[] identifier = new byte[6];
                    if (inputStream.read(identifier) != 6) {
                        throw new IOException("Invalid exif");
                    }
                    bytesRead += 6;
                    length -= 6;
                    if (!Arrays.equals(identifier, IDENTIFIER_EXIF_APP1)) break;
                    if (length <= 0) {
                        throw new IOException("Invalid exif");
                    }
                    byte[] bytes = new byte[length];
                    if (dataInputStream.read(bytes) != length) {
                        throw new IOException("Invalid exif");
                    }
                    this.readExifSegment(bytes, bytesRead);
                    bytesRead += length;
                    length = 0;
                    break;
                }
                case -2: {
                    byte[] bytes = new byte[length];
                    if (dataInputStream.read(bytes) != length) {
                        throw new IOException("Invalid exif");
                    }
                    length = 0;
                    if (this.getAttribute(TAG_USER_COMMENT) != null) break;
                    this.mAttributes[1].put(TAG_USER_COMMENT, ExifAttribute.createString(new String(bytes, ASCII)));
                    break;
                }
                case -64: 
                case -63: 
                case -62: 
                case -61: 
                case -59: 
                case -58: 
                case -57: 
                case -55: 
                case -54: 
                case -53: 
                case -51: 
                case -50: 
                case -49: {
                    if (dataInputStream.skipBytes(1) != 1) {
                        throw new IOException("Invalid SOFx");
                    }
                    this.mAttributes[0].put(TAG_IMAGE_LENGTH, ExifAttribute.createULong(dataInputStream.readUnsignedShort(), this.mExifByteOrder));
                    this.mAttributes[0].put(TAG_IMAGE_WIDTH, ExifAttribute.createULong(dataInputStream.readUnsignedShort(), this.mExifByteOrder));
                    length -= 5;
                    break;
                }
            }
            if (length < 0) {
                throw new IOException("Invalid length");
            }
            if (dataInputStream.skipBytes(length) != length) {
                throw new IOException("Invalid JPEG segment");
            }
            bytesRead += length;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void saveJpegAttributes(InputStream inputStream, OutputStream outputStream) throws IOException {
        dataInputStream = new DataInputStream(inputStream);
        dataOutputStream = new ByteOrderAwarenessDataOutputStream(outputStream, ByteOrder.BIG_ENDIAN);
        if (dataInputStream.readByte() != -1) {
            throw new IOException("Invalid marker");
        }
        dataOutputStream.writeByte(-1);
        if (dataInputStream.readByte() != -40) {
            throw new IOException("Invalid marker");
        }
        dataOutputStream.writeByte(-40);
        dataOutputStream.writeByte(-1);
        dataOutputStream.writeByte(-31);
        this.writeExifSegment(dataOutputStream, 6);
        bytes = new byte[4096];
        block4: while (true) {
            if ((marker = dataInputStream.readByte()) != -1) {
                throw new IOException("Invalid marker");
            }
            marker = dataInputStream.readByte();
            switch (marker) {
                case -31: {
                    length = dataInputStream.readUnsignedShort() - 2;
                    if (length < 0) {
                        throw new IOException("Invalid length");
                    }
                    identifier = new byte[6];
                    if (length >= 6) {
                        if (dataInputStream.read(identifier) != 6) {
                            throw new IOException("Invalid exif");
                        }
                        if (Arrays.equals(identifier, ExifInterface.IDENTIFIER_EXIF_APP1)) {
                            if (dataInputStream.skip(length - 6) == (long)(length - 6)) continue block4;
                            throw new IOException("Invalid length");
                        }
                    }
                    dataOutputStream.writeByte(-1);
                    dataOutputStream.writeByte(marker);
                    dataOutputStream.writeUnsignedShort(length + 2);
                    if (length >= 6) {
                        length -= 6;
                        dataOutputStream.write(identifier);
                    }
                    while (true) {
                        if (length <= 0 || (read = dataInputStream.read(bytes, 0, Math.min(length, bytes.length))) < 0) continue block4;
                        dataOutputStream.write(bytes, 0, read);
                        length -= read;
                    }
                }
                case -39: 
                case -38: {
                    dataOutputStream.writeByte(-1);
                    dataOutputStream.writeByte(marker);
                    Streams.copy(dataInputStream, dataOutputStream);
                    return;
                }
            }
            dataOutputStream.writeByte(-1);
            dataOutputStream.writeByte(marker);
            length = dataInputStream.readUnsignedShort();
            dataOutputStream.writeUnsignedShort(length);
            if ((length -= 2) < 0) {
                throw new IOException("Invalid length");
            }
            while (true) {
                if (length > 0 && (read = dataInputStream.read(bytes, 0, Math.min(length, bytes.length))) >= 0) ** break;
                continue block4;
                dataOutputStream.write(bytes, 0, read);
                length -= read;
            }
            break;
        }
    }

    private void readExifSegment(byte[] exifBytes, int exifOffsetFromBeginning) throws IOException {
        ByteOrderAwarenessDataInputStream dataInputStream = new ByteOrderAwarenessDataInputStream(exifBytes);
        short byteOrder = dataInputStream.readShort();
        switch (byteOrder) {
            case 18761: {
                this.mExifByteOrder = ByteOrder.LITTLE_ENDIAN;
                break;
            }
            case 19789: {
                this.mExifByteOrder = ByteOrder.BIG_ENDIAN;
                break;
            }
            default: {
                throw new IOException("Invalid byte order: " + Integer.toHexString(byteOrder));
            }
        }
        dataInputStream.setByteOrder(this.mExifByteOrder);
        int startCode = dataInputStream.readUnsignedShort();
        if (startCode != 42) {
            throw new IOException("Invalid exif start: " + Integer.toHexString(startCode));
        }
        long firstIfdOffset = dataInputStream.readUnsignedInt();
        if (firstIfdOffset < 8L || firstIfdOffset >= (long)exifBytes.length) {
            throw new IOException("Invalid first Ifd offset: " + firstIfdOffset);
        }
        if ((firstIfdOffset -= 8L) > 0L && dataInputStream.skip(firstIfdOffset) != firstIfdOffset) {
            throw new IOException("Couldn't jump to first Ifd: " + firstIfdOffset);
        }
        this.readImageFileDirectory(dataInputStream, 0);
        String jpegInterchangeFormatString = this.getAttribute(ExifInterface.JPEG_INTERCHANGE_FORMAT_TAG.name);
        String jpegInterchangeFormatLengthString = this.getAttribute(ExifInterface.JPEG_INTERCHANGE_FORMAT_LENGTH_TAG.name);
        if (jpegInterchangeFormatString != null && jpegInterchangeFormatLengthString != null) {
            try {
                int jpegInterchangeFormat = Integer.parseInt(jpegInterchangeFormatString);
                int jpegInterchangeFormatLength = Integer.parseInt(jpegInterchangeFormatLengthString);
                jpegInterchangeFormatLength = Math.min(jpegInterchangeFormat + jpegInterchangeFormatLength, exifBytes.length) - jpegInterchangeFormat;
                if (jpegInterchangeFormat > 0 && jpegInterchangeFormatLength > 0) {
                    this.mHasThumbnail = true;
                    this.mThumbnailOffset = exifOffsetFromBeginning + jpegInterchangeFormat;
                    this.mThumbnailLength = jpegInterchangeFormatLength;
                    if (this.mFilename == null && this.mAssetInputStream == null && this.mSeekableFileDescriptor == null) {
                        byte[] thumbnailBytes = new byte[jpegInterchangeFormatLength];
                        dataInputStream.seek(jpegInterchangeFormat);
                        dataInputStream.readFully(thumbnailBytes);
                        this.mThumbnailBytes = thumbnailBytes;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void addDefaultValuesForCompatibility() {
        String valueOfDateTimeOriginal = this.getAttribute(TAG_DATETIME_ORIGINAL);
        if (valueOfDateTimeOriginal != null) {
            this.mAttributes[0].put(TAG_DATETIME, ExifAttribute.createString(valueOfDateTimeOriginal));
        }
        if (this.getAttribute(TAG_IMAGE_WIDTH) == null) {
            this.mAttributes[0].put(TAG_IMAGE_WIDTH, ExifAttribute.createULong(0L, this.mExifByteOrder));
        }
        if (this.getAttribute(TAG_IMAGE_LENGTH) == null) {
            this.mAttributes[0].put(TAG_IMAGE_LENGTH, ExifAttribute.createULong(0L, this.mExifByteOrder));
        }
        if (this.getAttribute(TAG_ORIENTATION) == null) {
            this.mAttributes[0].put(TAG_ORIENTATION, ExifAttribute.createULong(0L, this.mExifByteOrder));
        }
        if (this.getAttribute(TAG_LIGHT_SOURCE) == null) {
            this.mAttributes[1].put(TAG_LIGHT_SOURCE, ExifAttribute.createULong(0L, this.mExifByteOrder));
        }
    }

    private void readImageFileDirectory(ByteOrderAwarenessDataInputStream dataInputStream, int hint) throws IOException {
        long nextIfdOffset;
        if (dataInputStream.peek() + 2L > dataInputStream.mLength) {
            return;
        }
        short numberOfDirectoryEntry = dataInputStream.readShort();
        if (dataInputStream.peek() + (long)(12 * numberOfDirectoryEntry) > dataInputStream.mLength) {
            return;
        }
        for (short i = 0; i < numberOfDirectoryEntry; i = (short)(i + 1)) {
            int innerIfdHint;
            int tagNumber = dataInputStream.readUnsignedShort();
            int dataFormat = dataInputStream.readUnsignedShort();
            int numberOfComponents = dataInputStream.readInt();
            long nextEntryOffset = dataInputStream.peek() + 4L;
            ExifTag tag = (ExifTag)sExifTagMapsForReading[hint].get(tagNumber);
            if (tag == null || dataFormat <= 0 || dataFormat >= IFD_FORMAT_BYTES_PER_FORMAT.length) {
                if (tag == null) {
                    Log.w(TAG, "Skip the tag entry since tag number is not defined: " + tagNumber);
                } else {
                    Log.w(TAG, "Skip the tag entry since data format is invalid: " + dataFormat);
                }
                dataInputStream.seek(nextEntryOffset);
                continue;
            }
            int byteCount = numberOfComponents * IFD_FORMAT_BYTES_PER_FORMAT[dataFormat];
            if (byteCount > 4) {
                long offset = dataInputStream.readUnsignedInt();
                if (offset + (long)byteCount <= dataInputStream.mLength) {
                    dataInputStream.seek(offset);
                } else {
                    Log.w(TAG, "Skip the tag entry since data offset is invalid: " + offset);
                    dataInputStream.seek(nextEntryOffset);
                    continue;
                }
            }
            if ((innerIfdHint = ExifInterface.getIfdHintFromTagNumber(tagNumber)) >= 0) {
                long offset = -1L;
                switch (dataFormat) {
                    case 3: {
                        offset = dataInputStream.readUnsignedShort();
                        break;
                    }
                    case 8: {
                        offset = dataInputStream.readShort();
                        break;
                    }
                    case 4: {
                        offset = dataInputStream.readUnsignedInt();
                        break;
                    }
                    case 9: {
                        offset = dataInputStream.readInt();
                        break;
                    }
                }
                if (offset > 0L && offset < dataInputStream.mLength) {
                    dataInputStream.seek(offset);
                    this.readImageFileDirectory(dataInputStream, innerIfdHint);
                } else {
                    Log.w(TAG, "Skip jump into the IFD since its offset is invalid: " + offset);
                }
                dataInputStream.seek(nextEntryOffset);
                continue;
            }
            byte[] bytes = new byte[numberOfComponents * IFD_FORMAT_BYTES_PER_FORMAT[dataFormat]];
            dataInputStream.readFully(bytes);
            this.mAttributes[hint].put(tag.name, new ExifAttribute(dataFormat, numberOfComponents, bytes));
            if (dataInputStream.peek() == nextEntryOffset) continue;
            dataInputStream.seek(nextEntryOffset);
        }
        if (dataInputStream.peek() + 4L <= dataInputStream.mLength && (nextIfdOffset = dataInputStream.readUnsignedInt()) > 8L && nextIfdOffset < dataInputStream.mLength) {
            dataInputStream.seek(nextIfdOffset);
            this.readImageFileDirectory(dataInputStream, 4);
        }
    }

    private static int getIfdHintFromTagNumber(int tagNumber) {
        for (int i = 0; i < IFD_POINTER_TAG_HINTS.length; ++i) {
            if (ExifInterface.IFD_POINTER_TAGS[i].number != tagNumber) continue;
            return IFD_POINTER_TAG_HINTS[i];
        }
        return -1;
    }

    private int writeExifSegment(ByteOrderAwarenessDataOutputStream dataOutputStream, int exifOffsetFromBeginning) throws IOException {
        int[] ifdOffsets = new int[EXIF_TAGS.length];
        int[] ifdDataSizes = new int[EXIF_TAGS.length];
        for (ExifTag tag : IFD_POINTER_TAGS) {
            this.removeAttribute(tag.name);
        }
        this.removeAttribute(ExifInterface.JPEG_INTERCHANGE_FORMAT_TAG.name);
        this.removeAttribute(ExifInterface.JPEG_INTERCHANGE_FORMAT_LENGTH_TAG.name);
        for (int hint = 0; hint < EXIF_TAGS.length; ++hint) {
            for (Object obj : this.mAttributes[hint].entrySet().toArray()) {
                Map.Entry entry = (Map.Entry)obj;
                if (entry.getValue() != null) continue;
                this.mAttributes[hint].remove(entry.getKey());
            }
        }
        if (!this.mAttributes[3].isEmpty()) {
            this.mAttributes[1].put(ExifInterface.IFD_POINTER_TAGS[2].name, ExifAttribute.createULong(0L, this.mExifByteOrder));
        }
        if (!this.mAttributes[1].isEmpty()) {
            this.mAttributes[0].put(ExifInterface.IFD_POINTER_TAGS[0].name, ExifAttribute.createULong(0L, this.mExifByteOrder));
        }
        if (!this.mAttributes[2].isEmpty()) {
            this.mAttributes[0].put(ExifInterface.IFD_POINTER_TAGS[1].name, ExifAttribute.createULong(0L, this.mExifByteOrder));
        }
        if (this.mHasThumbnail) {
            this.mAttributes[0].put(ExifInterface.JPEG_INTERCHANGE_FORMAT_TAG.name, ExifAttribute.createULong(0L, this.mExifByteOrder));
            this.mAttributes[0].put(ExifInterface.JPEG_INTERCHANGE_FORMAT_LENGTH_TAG.name, ExifAttribute.createULong(this.mThumbnailLength, this.mExifByteOrder));
        }
        int i = 0;
        while (i < EXIF_TAGS.length) {
            int sum = 0;
            for (Map.Entry entry : this.mAttributes[i].entrySet()) {
                ExifAttribute exifAttribute = (ExifAttribute)entry.getValue();
                int size = exifAttribute.size();
                if (size <= 4) continue;
                sum += size;
            }
            int n = i++;
            ifdDataSizes[n] = ifdDataSizes[n] + sum;
        }
        int position = 8;
        for (int hint = 0; hint < EXIF_TAGS.length; ++hint) {
            if (this.mAttributes[hint].isEmpty()) continue;
            ifdOffsets[hint] = position;
            position += 2 + this.mAttributes[hint].size() * 12 + 4 + ifdDataSizes[hint];
        }
        if (this.mHasThumbnail) {
            int thumbnailOffset = position;
            this.mAttributes[0].put(ExifInterface.JPEG_INTERCHANGE_FORMAT_TAG.name, ExifAttribute.createULong(thumbnailOffset, this.mExifByteOrder));
            this.mThumbnailOffset = exifOffsetFromBeginning + thumbnailOffset;
            position += this.mThumbnailLength;
        }
        int totalSize = position + 8;
        if (!this.mAttributes[1].isEmpty()) {
            this.mAttributes[0].put(ExifInterface.IFD_POINTER_TAGS[0].name, ExifAttribute.createULong(ifdOffsets[1], this.mExifByteOrder));
        }
        if (!this.mAttributes[2].isEmpty()) {
            this.mAttributes[0].put(ExifInterface.IFD_POINTER_TAGS[1].name, ExifAttribute.createULong(ifdOffsets[2], this.mExifByteOrder));
        }
        if (!this.mAttributes[3].isEmpty()) {
            this.mAttributes[1].put(ExifInterface.IFD_POINTER_TAGS[2].name, ExifAttribute.createULong(ifdOffsets[3], this.mExifByteOrder));
        }
        dataOutputStream.writeUnsignedShort(totalSize);
        dataOutputStream.write(IDENTIFIER_EXIF_APP1);
        dataOutputStream.writeShort(this.mExifByteOrder == ByteOrder.BIG_ENDIAN ? (short)19789 : 18761);
        dataOutputStream.setByteOrder(this.mExifByteOrder);
        dataOutputStream.writeUnsignedShort(42);
        dataOutputStream.writeUnsignedInt(8L);
        for (int hint = 0; hint < EXIF_TAGS.length; ++hint) {
            if (this.mAttributes[hint].isEmpty()) continue;
            dataOutputStream.writeUnsignedShort(this.mAttributes[hint].size());
            int dataOffset = ifdOffsets[hint] + 2 + this.mAttributes[hint].size() * 12 + 4;
            for (Map.Entry entry : this.mAttributes[hint].entrySet()) {
                ExifTag tag = (ExifTag)sExifTagMapsForWriting[hint].get(entry.getKey());
                int tagNumber = tag.number;
                ExifAttribute attribute = (ExifAttribute)entry.getValue();
                int size = attribute.size();
                dataOutputStream.writeUnsignedShort(tagNumber);
                dataOutputStream.writeUnsignedShort(attribute.format);
                dataOutputStream.writeInt(attribute.numberOfComponents);
                if (size > 4) {
                    dataOutputStream.writeUnsignedInt(dataOffset);
                    dataOffset += size;
                    continue;
                }
                dataOutputStream.write(attribute.bytes);
                if (size >= 4) continue;
                for (int i2 = size; i2 < 4; ++i2) {
                    dataOutputStream.writeByte(0);
                }
            }
            if (hint == 0 && !this.mAttributes[4].isEmpty()) {
                dataOutputStream.writeUnsignedInt(ifdOffsets[4]);
            } else {
                dataOutputStream.writeUnsignedInt(0L);
            }
            for (Map.Entry entry : this.mAttributes[hint].entrySet()) {
                ExifAttribute attribute = (ExifAttribute)entry.getValue();
                if (attribute.bytes.length <= 4) continue;
                dataOutputStream.write(attribute.bytes, 0, attribute.bytes.length);
            }
        }
        if (this.mHasThumbnail) {
            dataOutputStream.write(this.getThumbnail());
        }
        dataOutputStream.setByteOrder(ByteOrder.BIG_ENDIAN);
        return totalSize;
    }

    private static Pair<Integer, Integer> guessDataFormat(String entryValue) {
        if (entryValue.contains(",")) {
            String[] entryValues = entryValue.split(",");
            Pair<Integer, Integer> dataFormat = ExifInterface.guessDataFormat(entryValues[0]);
            if ((Integer)dataFormat.first == 2) {
                return dataFormat;
            }
            for (int i = 1; i < entryValues.length; ++i) {
                Pair<Integer, Integer> guessDataFormat = ExifInterface.guessDataFormat(entryValues[i]);
                int first = -1;
                int second = -1;
                if (guessDataFormat.first == dataFormat.first || guessDataFormat.second == dataFormat.first) {
                    first = (Integer)dataFormat.first;
                }
                if ((Integer)dataFormat.second != -1 && (guessDataFormat.first == dataFormat.second || guessDataFormat.second == dataFormat.second)) {
                    second = (Integer)dataFormat.second;
                }
                if (first == -1 && second == -1) {
                    return new Pair<Integer, Integer>(2, -1);
                }
                if (first == -1) {
                    dataFormat = new Pair<Integer, Integer>(second, -1);
                    continue;
                }
                if (second != -1) continue;
                dataFormat = new Pair<Integer, Integer>(first, -1);
            }
            return dataFormat;
        }
        if (entryValue.contains("/")) {
            String[] rationalNumber = entryValue.split("/");
            if (rationalNumber.length == 2) {
                try {
                    long numerator = Long.parseLong(rationalNumber[0]);
                    long denominator = Long.parseLong(rationalNumber[1]);
                    if (numerator < 0L || denominator < 0L) {
                        return new Pair<Integer, Integer>(10, -1);
                    }
                    if (numerator > Integer.MAX_VALUE || denominator > Integer.MAX_VALUE) {
                        return new Pair<Integer, Integer>(5, -1);
                    }
                    return new Pair<Integer, Integer>(10, 5);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return new Pair<Integer, Integer>(2, -1);
        }
        try {
            Long longValue = Long.parseLong(entryValue);
            if (longValue >= 0L && longValue <= 65535L) {
                return new Pair<Integer, Integer>(3, 4);
            }
            if (longValue < 0L) {
                return new Pair<Integer, Integer>(9, -1);
            }
            return new Pair<Integer, Integer>(4, -1);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Double.parseDouble(entryValue);
                return new Pair<Integer, Integer>(12, -1);
            }
            catch (NumberFormatException numberFormatException2) {
                return new Pair<Integer, Integer>(2, -1);
            }
        }
    }

    private static native void nativeInitRaw();

    private static native byte[] nativeGetThumbnailFromAsset(long var0, int var2, int var3);

    private static native HashMap nativeGetRawAttributesFromAsset(long var0);

    private static native HashMap nativeGetRawAttributesFromFileDescriptor(FileDescriptor var0);

    private static native HashMap nativeGetRawAttributesFromInputStream(InputStream var0);

    static {
        IFD_FORMAT_NAMES = new String[]{"", "BYTE", "STRING", "USHORT", "ULONG", "URATIONAL", "SBYTE", "UNDEFINED", "SSHORT", "SLONG", "SRATIONAL", "SINGLE", "DOUBLE"};
        IFD_FORMAT_BYTES_PER_FORMAT = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};
        EXIF_ASCII_PREFIX = new byte[]{65, 83, 67, 73, 73, 0, 0, 0};
        IFD_TIFF_TAGS = new ExifTag[]{new ExifTag(TAG_IMAGE_WIDTH, 256, 3, 4), new ExifTag(TAG_IMAGE_LENGTH, 257, 3, 4), new ExifTag(TAG_BITS_PER_SAMPLE, 258, 3), new ExifTag(TAG_COMPRESSION, 259, 3), new ExifTag(TAG_PHOTOMETRIC_INTERPRETATION, 262, 3), new ExifTag(TAG_IMAGE_DESCRIPTION, 270, 2), new ExifTag(TAG_MAKE, 271, 2), new ExifTag(TAG_MODEL, 272, 2), new ExifTag(TAG_STRIP_OFFSETS, 273, 3, 4), new ExifTag(TAG_ORIENTATION, 274, 3), new ExifTag(TAG_SAMPLES_PER_PIXEL, 277, 3), new ExifTag(TAG_ROWS_PER_STRIP, 278, 3, 4), new ExifTag(TAG_STRIP_BYTE_COUNTS, 279, 3, 4), new ExifTag(TAG_X_RESOLUTION, 282, 5), new ExifTag(TAG_Y_RESOLUTION, 283, 5), new ExifTag(TAG_PLANAR_CONFIGURATION, 284, 3), new ExifTag(TAG_RESOLUTION_UNIT, 296, 3), new ExifTag(TAG_TRANSFER_FUNCTION, 301, 3), new ExifTag(TAG_SOFTWARE, 305, 2), new ExifTag(TAG_DATETIME, 306, 2), new ExifTag(TAG_ARTIST, 315, 2), new ExifTag(TAG_WHITE_POINT, 318, 5), new ExifTag(TAG_PRIMARY_CHROMATICITIES, 319, 5), new ExifTag(TAG_JPEG_INTERCHANGE_FORMAT, 513, 4), new ExifTag(TAG_JPEG_INTERCHANGE_FORMAT_LENGTH, 514, 4), new ExifTag(TAG_Y_CB_CR_COEFFICIENTS, 529, 5), new ExifTag(TAG_Y_CB_CR_SUB_SAMPLING, 530, 3), new ExifTag(TAG_Y_CB_CR_POSITIONING, 531, 3), new ExifTag(TAG_REFERENCE_BLACK_WHITE, 532, 5), new ExifTag(TAG_COPYRIGHT, 33432, 2), new ExifTag(TAG_EXIF_IFD_POINTER, 34665, 4), new ExifTag(TAG_GPS_INFO_IFD_POINTER, 34853, 4)};
        IFD_EXIF_TAGS = new ExifTag[]{new ExifTag(TAG_EXPOSURE_TIME, 33434, 5), new ExifTag("FNumber", 33437, 5), new ExifTag(TAG_EXPOSURE_PROGRAM, 34850, 3), new ExifTag(TAG_SPECTRAL_SENSITIVITY, 34852, 2), new ExifTag("ISOSpeedRatings", 34855, 3), new ExifTag(TAG_OECF, 34856, 7), new ExifTag(TAG_EXIF_VERSION, 36864, 2), new ExifTag(TAG_DATETIME_ORIGINAL, 36867, 2), new ExifTag(TAG_DATETIME_DIGITIZED, 36868, 2), new ExifTag(TAG_COMPONENTS_CONFIGURATION, 37121, 7), new ExifTag(TAG_COMPRESSED_BITS_PER_PIXEL, 37122, 5), new ExifTag(TAG_SHUTTER_SPEED_VALUE, 37377, 10), new ExifTag(TAG_APERTURE_VALUE, 37378, 5), new ExifTag(TAG_BRIGHTNESS_VALUE, 37379, 10), new ExifTag(TAG_EXPOSURE_BIAS_VALUE, 37380, 10), new ExifTag(TAG_MAX_APERTURE_VALUE, 37381, 5), new ExifTag(TAG_SUBJECT_DISTANCE, 37382, 5), new ExifTag(TAG_METERING_MODE, 37383, 3), new ExifTag(TAG_LIGHT_SOURCE, 37384, 3), new ExifTag(TAG_FLASH, 37385, 3), new ExifTag(TAG_FOCAL_LENGTH, 37386, 5), new ExifTag(TAG_SUBJECT_AREA, 37396, 3), new ExifTag(TAG_MAKER_NOTE, 37500, 7), new ExifTag(TAG_USER_COMMENT, 37510, 7), new ExifTag(TAG_SUBSEC_TIME, 37520, 2), new ExifTag("SubSecTimeOriginal", 37521, 2), new ExifTag("SubSecTimeDigitized", 37522, 2), new ExifTag(TAG_FLASHPIX_VERSION, 40960, 7), new ExifTag(TAG_COLOR_SPACE, 40961, 3), new ExifTag(TAG_PIXEL_X_DIMENSION, 40962, 3, 4), new ExifTag(TAG_PIXEL_Y_DIMENSION, 40963, 3, 4), new ExifTag(TAG_RELATED_SOUND_FILE, 40964, 2), new ExifTag(TAG_INTEROPERABILITY_IFD_POINTER, 40965, 4), new ExifTag(TAG_FLASH_ENERGY, 41483, 5), new ExifTag(TAG_SPATIAL_FREQUENCY_RESPONSE, 41484, 7), new ExifTag(TAG_FOCAL_PLANE_X_RESOLUTION, 41486, 5), new ExifTag(TAG_FOCAL_PLANE_Y_RESOLUTION, 41487, 5), new ExifTag(TAG_FOCAL_PLANE_RESOLUTION_UNIT, 41488, 3), new ExifTag(TAG_SUBJECT_LOCATION, 41492, 3), new ExifTag(TAG_EXPOSURE_INDEX, 41493, 5), new ExifTag(TAG_SENSING_METHOD, 41495, 3), new ExifTag(TAG_FILE_SOURCE, 41728, 7), new ExifTag(TAG_SCENE_TYPE, 41729, 7), new ExifTag(TAG_CFA_PATTERN, 41730, 7), new ExifTag(TAG_CUSTOM_RENDERED, 41985, 3), new ExifTag(TAG_EXPOSURE_MODE, 41986, 3), new ExifTag(TAG_WHITE_BALANCE, 41987, 3), new ExifTag(TAG_DIGITAL_ZOOM_RATIO, 41988, 5), new ExifTag(TAG_FOCAL_LENGTH_IN_35MM_FILM, 41989, 3), new ExifTag(TAG_SCENE_CAPTURE_TYPE, 41990, 3), new ExifTag(TAG_GAIN_CONTROL, 41991, 3), new ExifTag(TAG_CONTRAST, 41992, 3), new ExifTag(TAG_SATURATION, 41993, 3), new ExifTag(TAG_SHARPNESS, 41994, 3), new ExifTag(TAG_DEVICE_SETTING_DESCRIPTION, 41995, 7), new ExifTag(TAG_SUBJECT_DISTANCE_RANGE, 41996, 3), new ExifTag(TAG_IMAGE_UNIQUE_ID, 42016, 2)};
        IFD_GPS_TAGS = new ExifTag[]{new ExifTag(TAG_GPS_VERSION_ID, 0, 1), new ExifTag(TAG_GPS_LATITUDE_REF, 1, 2), new ExifTag(TAG_GPS_LATITUDE, 2, 5), new ExifTag(TAG_GPS_LONGITUDE_REF, 3, 2), new ExifTag(TAG_GPS_LONGITUDE, 4, 5), new ExifTag(TAG_GPS_ALTITUDE_REF, 5, 1), new ExifTag(TAG_GPS_ALTITUDE, 6, 5), new ExifTag(TAG_GPS_TIMESTAMP, 7, 5), new ExifTag(TAG_GPS_SATELLITES, 8, 2), new ExifTag(TAG_GPS_STATUS, 9, 2), new ExifTag(TAG_GPS_MEASURE_MODE, 10, 2), new ExifTag(TAG_GPS_DOP, 11, 5), new ExifTag(TAG_GPS_SPEED_REF, 12, 2), new ExifTag(TAG_GPS_SPEED, 13, 5), new ExifTag(TAG_GPS_TRACK_REF, 14, 2), new ExifTag(TAG_GPS_TRACK, 15, 5), new ExifTag(TAG_GPS_IMG_DIRECTION_REF, 16, 2), new ExifTag(TAG_GPS_IMG_DIRECTION, 17, 5), new ExifTag(TAG_GPS_MAP_DATUM, 18, 2), new ExifTag(TAG_GPS_DEST_LATITUDE_REF, 19, 2), new ExifTag(TAG_GPS_DEST_LATITUDE, 20, 5), new ExifTag(TAG_GPS_DEST_LONGITUDE_REF, 21, 2), new ExifTag(TAG_GPS_DEST_LONGITUDE, 22, 5), new ExifTag(TAG_GPS_DEST_BEARING_REF, 23, 2), new ExifTag(TAG_GPS_DEST_BEARING, 24, 5), new ExifTag(TAG_GPS_DEST_DISTANCE_REF, 25, 2), new ExifTag(TAG_GPS_DEST_DISTANCE, 26, 5), new ExifTag(TAG_GPS_PROCESSING_METHOD, 27, 7), new ExifTag(TAG_GPS_AREA_INFORMATION, 28, 7), new ExifTag(TAG_GPS_DATESTAMP, 29, 2), new ExifTag(TAG_GPS_DIFFERENTIAL, 30, 3)};
        IFD_INTEROPERABILITY_TAGS = new ExifTag[]{new ExifTag(TAG_INTEROPERABILITY_INDEX, 1, 2)};
        IFD_THUMBNAIL_TAGS = new ExifTag[]{new ExifTag(TAG_THUMBNAIL_IMAGE_WIDTH, 256, 3, 4), new ExifTag(TAG_THUMBNAIL_IMAGE_LENGTH, 257, 3, 4), new ExifTag(TAG_BITS_PER_SAMPLE, 258, 3), new ExifTag(TAG_COMPRESSION, 259, 3), new ExifTag(TAG_PHOTOMETRIC_INTERPRETATION, 262, 3), new ExifTag(TAG_IMAGE_DESCRIPTION, 270, 2), new ExifTag(TAG_MAKE, 271, 2), new ExifTag(TAG_MODEL, 272, 2), new ExifTag(TAG_STRIP_OFFSETS, 3, 4), new ExifTag(TAG_ORIENTATION, 274, 3), new ExifTag(TAG_SAMPLES_PER_PIXEL, 277, 3), new ExifTag(TAG_ROWS_PER_STRIP, 278, 3, 4), new ExifTag(TAG_STRIP_BYTE_COUNTS, 279, 3, 4), new ExifTag(TAG_X_RESOLUTION, 282, 5), new ExifTag(TAG_Y_RESOLUTION, 283, 5), new ExifTag(TAG_PLANAR_CONFIGURATION, 284, 3), new ExifTag(TAG_RESOLUTION_UNIT, 296, 3), new ExifTag(TAG_TRANSFER_FUNCTION, 301, 3), new ExifTag(TAG_SOFTWARE, 305, 2), new ExifTag(TAG_DATETIME, 306, 2), new ExifTag(TAG_ARTIST, 315, 2), new ExifTag(TAG_WHITE_POINT, 318, 5), new ExifTag(TAG_PRIMARY_CHROMATICITIES, 319, 5), new ExifTag(TAG_JPEG_INTERCHANGE_FORMAT, 513, 4), new ExifTag(TAG_JPEG_INTERCHANGE_FORMAT_LENGTH, 514, 4), new ExifTag(TAG_Y_CB_CR_COEFFICIENTS, 529, 5), new ExifTag(TAG_Y_CB_CR_SUB_SAMPLING, 530, 3), new ExifTag(TAG_Y_CB_CR_POSITIONING, 531, 3), new ExifTag(TAG_REFERENCE_BLACK_WHITE, 532, 5), new ExifTag(TAG_COPYRIGHT, 33432, 2), new ExifTag(TAG_EXIF_IFD_POINTER, 34665, 4), new ExifTag(TAG_GPS_INFO_IFD_POINTER, 34853, 4)};
        EXIF_TAGS = new ExifTag[][]{IFD_TIFF_TAGS, IFD_EXIF_TAGS, IFD_GPS_TAGS, IFD_INTEROPERABILITY_TAGS, IFD_THUMBNAIL_TAGS};
        IFD_POINTER_TAGS = new ExifTag[]{new ExifTag(TAG_EXIF_IFD_POINTER, 34665, 4), new ExifTag(TAG_GPS_INFO_IFD_POINTER, 34853, 4), new ExifTag(TAG_INTEROPERABILITY_IFD_POINTER, 40965, 4)};
        IFD_POINTER_TAG_HINTS = new int[]{1, 2, 3};
        JPEG_INTERCHANGE_FORMAT_TAG = new ExifTag(TAG_JPEG_INTERCHANGE_FORMAT, 513, 4);
        JPEG_INTERCHANGE_FORMAT_LENGTH_TAG = new ExifTag(TAG_JPEG_INTERCHANGE_FORMAT_LENGTH, 514, 4);
        sExifTagMapsForReading = new HashMap[EXIF_TAGS.length];
        sExifTagMapsForWriting = new HashMap[EXIF_TAGS.length];
        sTagSetForCompatibility = new HashSet<String>(Arrays.asList("FNumber", TAG_DIGITAL_ZOOM_RATIO, TAG_EXPOSURE_TIME, TAG_SUBJECT_DISTANCE, TAG_GPS_TIMESTAMP));
        ASCII = Charset.forName("US-ASCII");
        IDENTIFIER_EXIF_APP1 = "Exif\u0000\u0000".getBytes(ASCII);
        System.loadLibrary("media_jni");
        ExifInterface.nativeInitRaw();
        sFormatter = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
        sFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        for (int hint = 0; hint < EXIF_TAGS.length; ++hint) {
            ExifInterface.sExifTagMapsForReading[hint] = new HashMap();
            ExifInterface.sExifTagMapsForWriting[hint] = new HashMap();
            for (ExifTag tag : EXIF_TAGS[hint]) {
                sExifTagMapsForReading[hint].put(tag.number, tag);
                sExifTagMapsForWriting[hint].put(tag.name, tag);
            }
        }
        sNonZeroTimePattern = Pattern.compile(".*[1-9].*");
        sGpsTimestampPattern = Pattern.compile("^([0-9][0-9]):([0-9][0-9]):([0-9][0-9])$");
    }

    private static class ByteOrderAwarenessDataOutputStream
    extends FilterOutputStream {
        private final OutputStream mOutputStream;
        private ByteOrder mByteOrder;

        public ByteOrderAwarenessDataOutputStream(OutputStream out, ByteOrder byteOrder) {
            super(out);
            this.mOutputStream = out;
            this.mByteOrder = byteOrder;
        }

        public void setByteOrder(ByteOrder byteOrder) {
            this.mByteOrder = byteOrder;
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this.mOutputStream.write(bytes);
        }

        @Override
        public void write(byte[] bytes, int offset, int length) throws IOException {
            this.mOutputStream.write(bytes, offset, length);
        }

        public void writeByte(int val) throws IOException {
            this.mOutputStream.write(val);
        }

        public void writeShort(short val) throws IOException {
            if (this.mByteOrder == ByteOrder.LITTLE_ENDIAN) {
                this.mOutputStream.write(val >>> 0 & 0xFF);
                this.mOutputStream.write(val >>> 8 & 0xFF);
            } else if (this.mByteOrder == ByteOrder.BIG_ENDIAN) {
                this.mOutputStream.write(val >>> 8 & 0xFF);
                this.mOutputStream.write(val >>> 0 & 0xFF);
            }
        }

        public void writeInt(int val) throws IOException {
            if (this.mByteOrder == ByteOrder.LITTLE_ENDIAN) {
                this.mOutputStream.write(val >>> 0 & 0xFF);
                this.mOutputStream.write(val >>> 8 & 0xFF);
                this.mOutputStream.write(val >>> 16 & 0xFF);
                this.mOutputStream.write(val >>> 24 & 0xFF);
            } else if (this.mByteOrder == ByteOrder.BIG_ENDIAN) {
                this.mOutputStream.write(val >>> 24 & 0xFF);
                this.mOutputStream.write(val >>> 16 & 0xFF);
                this.mOutputStream.write(val >>> 8 & 0xFF);
                this.mOutputStream.write(val >>> 0 & 0xFF);
            }
        }

        public void writeUnsignedShort(int val) throws IOException {
            this.writeShort((short)val);
        }

        public void writeUnsignedInt(long val) throws IOException {
            this.writeInt((int)val);
        }
    }

    private static class ByteOrderAwarenessDataInputStream
    extends ByteArrayInputStream {
        private static final ByteOrder LITTLE_ENDIAN = ByteOrder.LITTLE_ENDIAN;
        private static final ByteOrder BIG_ENDIAN = ByteOrder.BIG_ENDIAN;
        private ByteOrder mByteOrder = ByteOrder.BIG_ENDIAN;
        private final long mLength;
        private long mPosition;

        public ByteOrderAwarenessDataInputStream(byte[] bytes) {
            super(bytes);
            this.mLength = bytes.length;
            this.mPosition = 0L;
        }

        public void setByteOrder(ByteOrder byteOrder) {
            this.mByteOrder = byteOrder;
        }

        public void seek(long byteCount) throws IOException {
            this.mPosition = 0L;
            this.reset();
            if (this.skip(byteCount) != byteCount) {
                throw new IOException("Couldn't seek up to the byteCount");
            }
        }

        public long peek() {
            return this.mPosition;
        }

        public void readFully(byte[] buffer) throws IOException {
            this.mPosition += (long)buffer.length;
            if (this.mPosition > this.mLength) {
                throw new EOFException();
            }
            if (super.read(buffer, 0, buffer.length) != buffer.length) {
                throw new IOException("Couldn't read up to the length of buffer");
            }
        }

        public byte readByte() throws IOException {
            ++this.mPosition;
            if (this.mPosition > this.mLength) {
                throw new EOFException();
            }
            int ch = super.read();
            if (ch < 0) {
                throw new EOFException();
            }
            return (byte)ch;
        }

        public short readShort() throws IOException {
            int ch2;
            this.mPosition += 2L;
            if (this.mPosition > this.mLength) {
                throw new EOFException();
            }
            int ch1 = super.read();
            if ((ch1 | (ch2 = super.read())) < 0) {
                throw new EOFException();
            }
            if (this.mByteOrder == LITTLE_ENDIAN) {
                return (short)((ch2 << 8) + ch1);
            }
            if (this.mByteOrder == BIG_ENDIAN) {
                return (short)((ch1 << 8) + ch2);
            }
            throw new IOException("Invalid byte order: " + this.mByteOrder);
        }

        public int readInt() throws IOException {
            int ch4;
            int ch3;
            int ch2;
            this.mPosition += 4L;
            if (this.mPosition > this.mLength) {
                throw new EOFException();
            }
            int ch1 = super.read();
            if ((ch1 | (ch2 = super.read()) | (ch3 = super.read()) | (ch4 = super.read())) < 0) {
                throw new EOFException();
            }
            if (this.mByteOrder == LITTLE_ENDIAN) {
                return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + ch1;
            }
            if (this.mByteOrder == BIG_ENDIAN) {
                return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
            }
            throw new IOException("Invalid byte order: " + this.mByteOrder);
        }

        @Override
        public long skip(long byteCount) {
            long skipped = super.skip(Math.min(byteCount, this.mLength - this.mPosition));
            this.mPosition += skipped;
            return skipped;
        }

        public int readUnsignedShort() throws IOException {
            int ch2;
            this.mPosition += 2L;
            if (this.mPosition > this.mLength) {
                throw new EOFException();
            }
            int ch1 = super.read();
            if ((ch1 | (ch2 = super.read())) < 0) {
                throw new EOFException();
            }
            if (this.mByteOrder == LITTLE_ENDIAN) {
                return (ch2 << 8) + ch1;
            }
            if (this.mByteOrder == BIG_ENDIAN) {
                return (ch1 << 8) + ch2;
            }
            throw new IOException("Invalid byte order: " + this.mByteOrder);
        }

        public long readUnsignedInt() throws IOException {
            return (long)this.readInt() & 0xFFFFFFFFL;
        }

        public long readLong() throws IOException {
            int ch8;
            int ch7;
            int ch6;
            int ch5;
            int ch4;
            int ch3;
            int ch2;
            this.mPosition += 8L;
            if (this.mPosition > this.mLength) {
                throw new EOFException();
            }
            int ch1 = super.read();
            if ((ch1 | (ch2 = super.read()) | (ch3 = super.read()) | (ch4 = super.read()) | (ch5 = super.read()) | (ch6 = super.read()) | (ch7 = super.read()) | (ch8 = super.read())) < 0) {
                throw new EOFException();
            }
            if (this.mByteOrder == LITTLE_ENDIAN) {
                return ((long)ch8 << 56) + ((long)ch7 << 48) + ((long)ch6 << 40) + ((long)ch5 << 32) + ((long)ch4 << 24) + ((long)ch3 << 16) + ((long)ch2 << 8) + (long)ch1;
            }
            if (this.mByteOrder == BIG_ENDIAN) {
                return ((long)ch1 << 56) + ((long)ch2 << 48) + ((long)ch3 << 40) + ((long)ch4 << 32) + ((long)ch5 << 24) + ((long)ch6 << 16) + ((long)ch7 << 8) + (long)ch8;
            }
            throw new IOException("Invalid byte order: " + this.mByteOrder);
        }

        public float readFloat() throws IOException {
            return Float.intBitsToFloat(this.readInt());
        }

        public double readDouble() throws IOException {
            return Double.longBitsToDouble(this.readLong());
        }
    }

    private static class ExifTag {
        public final int number;
        public final String name;
        public final int primaryFormat;
        public final int secondaryFormat;

        private ExifTag(String name, int number, int format) {
            this.name = name;
            this.number = number;
            this.primaryFormat = format;
            this.secondaryFormat = -1;
        }

        private ExifTag(String name, int number, int primaryFormat, int secondaryFormat) {
            this.name = name;
            this.number = number;
            this.primaryFormat = primaryFormat;
            this.secondaryFormat = secondaryFormat;
        }
    }

    private static class ExifAttribute {
        public final int format;
        public final int numberOfComponents;
        public final byte[] bytes;

        private ExifAttribute(int format, int numberOfComponents, byte[] bytes) {
            this.format = format;
            this.numberOfComponents = numberOfComponents;
            this.bytes = bytes;
        }

        public static ExifAttribute createUShort(int[] values, ByteOrder byteOrder) {
            ByteBuffer buffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[3] * values.length]);
            buffer.order(byteOrder);
            for (int value : values) {
                buffer.putShort((short)value);
            }
            return new ExifAttribute(3, values.length, buffer.array());
        }

        public static ExifAttribute createUShort(int value, ByteOrder byteOrder) {
            return ExifAttribute.createUShort(new int[]{value}, byteOrder);
        }

        public static ExifAttribute createULong(long[] values, ByteOrder byteOrder) {
            ByteBuffer buffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[4] * values.length]);
            buffer.order(byteOrder);
            for (long value : values) {
                buffer.putInt((int)value);
            }
            return new ExifAttribute(4, values.length, buffer.array());
        }

        public static ExifAttribute createULong(long value, ByteOrder byteOrder) {
            return ExifAttribute.createULong(new long[]{value}, byteOrder);
        }

        public static ExifAttribute createSLong(int[] values, ByteOrder byteOrder) {
            ByteBuffer buffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[9] * values.length]);
            buffer.order(byteOrder);
            for (int value : values) {
                buffer.putInt(value);
            }
            return new ExifAttribute(9, values.length, buffer.array());
        }

        public static ExifAttribute createSLong(int value, ByteOrder byteOrder) {
            return ExifAttribute.createSLong(new int[]{value}, byteOrder);
        }

        public static ExifAttribute createByte(String value) {
            if (value.length() == 1 && value.charAt(0) >= '0' && value.charAt(0) <= '1') {
                byte[] bytes = new byte[]{(byte)(value.charAt(0) - 48)};
                return new ExifAttribute(1, bytes.length, bytes);
            }
            byte[] ascii = value.getBytes(ASCII);
            return new ExifAttribute(1, ascii.length, ascii);
        }

        public static ExifAttribute createString(String value) {
            byte[] ascii = (value + '\u0000').getBytes(ASCII);
            return new ExifAttribute(2, ascii.length, ascii);
        }

        public static ExifAttribute createURational(Rational[] values, ByteOrder byteOrder) {
            ByteBuffer buffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[5] * values.length]);
            buffer.order(byteOrder);
            for (Rational value : values) {
                buffer.putInt((int)value.numerator);
                buffer.putInt((int)value.denominator);
            }
            return new ExifAttribute(5, values.length, buffer.array());
        }

        public static ExifAttribute createURational(Rational value, ByteOrder byteOrder) {
            return ExifAttribute.createURational(new Rational[]{value}, byteOrder);
        }

        public static ExifAttribute createSRational(Rational[] values, ByteOrder byteOrder) {
            ByteBuffer buffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[10] * values.length]);
            buffer.order(byteOrder);
            for (Rational value : values) {
                buffer.putInt((int)value.numerator);
                buffer.putInt((int)value.denominator);
            }
            return new ExifAttribute(10, values.length, buffer.array());
        }

        public static ExifAttribute createSRational(Rational value, ByteOrder byteOrder) {
            return ExifAttribute.createSRational(new Rational[]{value}, byteOrder);
        }

        public static ExifAttribute createDouble(double[] values, ByteOrder byteOrder) {
            ByteBuffer buffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[12] * values.length]);
            buffer.order(byteOrder);
            for (double value : values) {
                buffer.putDouble(value);
            }
            return new ExifAttribute(12, values.length, buffer.array());
        }

        public static ExifAttribute createDouble(double value, ByteOrder byteOrder) {
            return ExifAttribute.createDouble(new double[]{value}, byteOrder);
        }

        public String toString() {
            return "(" + IFD_FORMAT_NAMES[this.format] + ", data length:" + this.bytes.length + ")";
        }

        private Object getValue(ByteOrder byteOrder) {
            try {
                ByteOrderAwarenessDataInputStream inputStream = new ByteOrderAwarenessDataInputStream(this.bytes);
                inputStream.setByteOrder(byteOrder);
                switch (this.format) {
                    case 1: 
                    case 6: {
                        if (this.bytes.length == 1 && this.bytes[0] >= 0 && this.bytes[0] <= 1) {
                            return new String(new char[]{(char)(this.bytes[0] + 48)});
                        }
                        return new String(this.bytes, ASCII);
                    }
                    case 2: 
                    case 7: {
                        byte ch;
                        int index = 0;
                        if (this.numberOfComponents >= EXIF_ASCII_PREFIX.length) {
                            boolean same = true;
                            for (int i = 0; i < EXIF_ASCII_PREFIX.length; ++i) {
                                if (this.bytes[i] == EXIF_ASCII_PREFIX[i]) continue;
                                same = false;
                                break;
                            }
                            if (same) {
                                index = EXIF_ASCII_PREFIX.length;
                            }
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        while (index < this.numberOfComponents && (ch = this.bytes[index]) != 0) {
                            if (ch >= 32) {
                                stringBuilder.append((char)ch);
                            } else {
                                stringBuilder.append('?');
                            }
                            ++index;
                        }
                        return stringBuilder.toString();
                    }
                    case 3: {
                        int[] values = new int[this.numberOfComponents];
                        for (int i = 0; i < this.numberOfComponents; ++i) {
                            values[i] = inputStream.readUnsignedShort();
                        }
                        return values;
                    }
                    case 4: {
                        long[] values = new long[this.numberOfComponents];
                        for (int i = 0; i < this.numberOfComponents; ++i) {
                            values[i] = inputStream.readUnsignedInt();
                        }
                        return values;
                    }
                    case 5: {
                        Rational[] values = new Rational[this.numberOfComponents];
                        for (int i = 0; i < this.numberOfComponents; ++i) {
                            long numerator = inputStream.readUnsignedInt();
                            long denominator = inputStream.readUnsignedInt();
                            values[i] = new Rational(numerator, denominator);
                        }
                        return values;
                    }
                    case 8: {
                        int[] values = new int[this.numberOfComponents];
                        for (int i = 0; i < this.numberOfComponents; ++i) {
                            values[i] = inputStream.readShort();
                        }
                        return values;
                    }
                    case 9: {
                        int[] values = new int[this.numberOfComponents];
                        for (int i = 0; i < this.numberOfComponents; ++i) {
                            values[i] = inputStream.readInt();
                        }
                        return values;
                    }
                    case 10: {
                        Rational[] values = new Rational[this.numberOfComponents];
                        for (int i = 0; i < this.numberOfComponents; ++i) {
                            long numerator = inputStream.readInt();
                            long denominator = inputStream.readInt();
                            values[i] = new Rational(numerator, denominator);
                        }
                        return values;
                    }
                    case 11: {
                        double[] values = new double[this.numberOfComponents];
                        for (int i = 0; i < this.numberOfComponents; ++i) {
                            values[i] = inputStream.readFloat();
                        }
                        return values;
                    }
                    case 12: {
                        double[] values = new double[this.numberOfComponents];
                        for (int i = 0; i < this.numberOfComponents; ++i) {
                            values[i] = inputStream.readDouble();
                        }
                        return values;
                    }
                }
                return null;
            }
            catch (IOException e) {
                Log.w(ExifInterface.TAG, "IOException occurred during reading a value", e);
                return null;
            }
        }

        public double getDoubleValue(ByteOrder byteOrder) {
            Object value = this.getValue(byteOrder);
            if (value == null) {
                throw new NumberFormatException("NULL can't be converted to a double value");
            }
            if (value instanceof String) {
                return Double.parseDouble((String)value);
            }
            if (value instanceof long[]) {
                long[] array2 = (long[])value;
                if (array2.length == 1) {
                    return array2[0];
                }
                throw new NumberFormatException("There are more than one component");
            }
            if (value instanceof int[]) {
                int[] array3 = (int[])value;
                if (array3.length == 1) {
                    return array3[0];
                }
                throw new NumberFormatException("There are more than one component");
            }
            if (value instanceof double[]) {
                double[] array4 = (double[])value;
                if (array4.length == 1) {
                    return array4[0];
                }
                throw new NumberFormatException("There are more than one component");
            }
            if (value instanceof Rational[]) {
                Rational[] array5 = (Rational[])value;
                if (array5.length == 1) {
                    return array5[0].calculate();
                }
                throw new NumberFormatException("There are more than one component");
            }
            throw new NumberFormatException("Couldn't find a double value");
        }

        public int getIntValue(ByteOrder byteOrder) {
            Object value = this.getValue(byteOrder);
            if (value == null) {
                throw new NumberFormatException("NULL can't be converted to a integer value");
            }
            if (value instanceof String) {
                return Integer.parseInt((String)value);
            }
            if (value instanceof long[]) {
                long[] array2 = (long[])value;
                if (array2.length == 1) {
                    return (int)array2[0];
                }
                throw new NumberFormatException("There are more than one component");
            }
            if (value instanceof int[]) {
                int[] array3 = (int[])value;
                if (array3.length == 1) {
                    return array3[0];
                }
                throw new NumberFormatException("There are more than one component");
            }
            throw new NumberFormatException("Couldn't find a integer value");
        }

        public String getStringValue(ByteOrder byteOrder) {
            Object value = this.getValue(byteOrder);
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                return (String)value;
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (value instanceof long[]) {
                long[] array2 = (long[])value;
                for (int i = 0; i < array2.length; ++i) {
                    stringBuilder.append(array2[i]);
                    if (i + 1 == array2.length) continue;
                    stringBuilder.append(",");
                }
                return stringBuilder.toString();
            }
            if (value instanceof int[]) {
                int[] array3 = (int[])value;
                for (int i = 0; i < array3.length; ++i) {
                    stringBuilder.append(array3[i]);
                    if (i + 1 == array3.length) continue;
                    stringBuilder.append(",");
                }
                return stringBuilder.toString();
            }
            if (value instanceof double[]) {
                double[] array4 = (double[])value;
                for (int i = 0; i < array4.length; ++i) {
                    stringBuilder.append(array4[i]);
                    if (i + 1 == array4.length) continue;
                    stringBuilder.append(",");
                }
                return stringBuilder.toString();
            }
            if (value instanceof Rational[]) {
                Rational[] array5 = (Rational[])value;
                for (int i = 0; i < array5.length; ++i) {
                    stringBuilder.append(array5[i].numerator);
                    stringBuilder.append('/');
                    stringBuilder.append(array5[i].denominator);
                    if (i + 1 == array5.length) continue;
                    stringBuilder.append(",");
                }
                return stringBuilder.toString();
            }
            return null;
        }

        public int size() {
            return IFD_FORMAT_BYTES_PER_FORMAT[this.format] * this.numberOfComponents;
        }
    }

    private static class Rational {
        public final long numerator;
        public final long denominator;

        private Rational(long numerator, long denominator) {
            if (denominator == 0L) {
                this.numerator = 0L;
                this.denominator = 1L;
                return;
            }
            this.numerator = numerator;
            this.denominator = denominator;
        }

        public String toString() {
            return this.numerator + "/" + this.denominator;
        }

        public double calculate() {
            return (double)this.numerator / (double)this.denominator;
        }
    }
}

