/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.media.MediaDataSource;
import android.media.MediaHTTPService;
import android.net.Uri;
import android.os.IBinder;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;

public class MediaMetadataRetriever {
    private long mNativeContext;
    private static final int EMBEDDED_PICTURE_TYPE_ANY = 65535;
    public static final int OPTION_PREVIOUS_SYNC = 0;
    public static final int OPTION_NEXT_SYNC = 1;
    public static final int OPTION_CLOSEST_SYNC = 2;
    public static final int OPTION_CLOSEST = 3;
    public static final int METADATA_KEY_CD_TRACK_NUMBER = 0;
    public static final int METADATA_KEY_ALBUM = 1;
    public static final int METADATA_KEY_ARTIST = 2;
    public static final int METADATA_KEY_AUTHOR = 3;
    public static final int METADATA_KEY_COMPOSER = 4;
    public static final int METADATA_KEY_DATE = 5;
    public static final int METADATA_KEY_GENRE = 6;
    public static final int METADATA_KEY_TITLE = 7;
    public static final int METADATA_KEY_YEAR = 8;
    public static final int METADATA_KEY_DURATION = 9;
    public static final int METADATA_KEY_NUM_TRACKS = 10;
    public static final int METADATA_KEY_WRITER = 11;
    public static final int METADATA_KEY_MIMETYPE = 12;
    public static final int METADATA_KEY_ALBUMARTIST = 13;
    public static final int METADATA_KEY_DISC_NUMBER = 14;
    public static final int METADATA_KEY_COMPILATION = 15;
    public static final int METADATA_KEY_HAS_AUDIO = 16;
    public static final int METADATA_KEY_HAS_VIDEO = 17;
    public static final int METADATA_KEY_VIDEO_WIDTH = 18;
    public static final int METADATA_KEY_VIDEO_HEIGHT = 19;
    public static final int METADATA_KEY_BITRATE = 20;
    public static final int METADATA_KEY_TIMED_TEXT_LANGUAGES = 21;
    public static final int METADATA_KEY_IS_DRM = 22;
    public static final int METADATA_KEY_LOCATION = 23;
    public static final int METADATA_KEY_VIDEO_ROTATION = 24;
    public static final int METADATA_KEY_CAPTURE_FRAMERATE = 25;

    public MediaMetadataRetriever() {
        this.native_setup();
    }

    public void setDataSource(String path) throws IllegalArgumentException {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        try (FileInputStream is = new FileInputStream(path);){
            FileDescriptor fd = is.getFD();
            this.setDataSource(fd, 0L, 0x7FFFFFFFFFFFFFFL);
        }
        catch (FileNotFoundException fileEx) {
            throw new IllegalArgumentException();
        }
        catch (IOException ioEx) {
            throw new IllegalArgumentException();
        }
    }

    public void setDataSource(String uri, Map<String, String> headers) throws IllegalArgumentException {
        int i = 0;
        String[] keys = new String[headers.size()];
        String[] values = new String[headers.size()];
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            keys[i] = entry.getKey();
            values[i] = entry.getValue();
            ++i;
        }
        this._setDataSource(MediaHTTPService.createHttpServiceBinderIfNecessary(uri), uri, keys, values);
    }

    private native void _setDataSource(IBinder var1, String var2, String[] var3, String[] var4) throws IllegalArgumentException;

    public native void setDataSource(FileDescriptor var1, long var2, long var4) throws IllegalArgumentException;

    public void setDataSource(FileDescriptor fd) throws IllegalArgumentException {
        this.setDataSource(fd, 0L, 0x7FFFFFFFFFFFFFFL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataSource(Context context, Uri uri) throws IllegalArgumentException, SecurityException {
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        String scheme = uri.getScheme();
        if (scheme == null || scheme.equals("file")) {
            this.setDataSource(uri.getPath());
            return;
        }
        AssetFileDescriptor fd = null;
        try {
            ContentResolver resolver = context.getContentResolver();
            try {
                fd = resolver.openAssetFileDescriptor(uri, "r");
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException();
            }
            if (fd == null) {
                throw new IllegalArgumentException();
            }
            FileDescriptor descriptor = fd.getFileDescriptor();
            if (!descriptor.valid()) {
                throw new IllegalArgumentException();
            }
            if (fd.getDeclaredLength() < 0L) {
                this.setDataSource(descriptor);
            } else {
                this.setDataSource(descriptor, fd.getStartOffset(), fd.getDeclaredLength());
            }
            return;
        }
        catch (SecurityException securityException) {
        }
        finally {
            try {
                if (fd != null) {
                    fd.close();
                }
            }
            catch (IOException iOException) {}
        }
        this.setDataSource(uri.toString());
    }

    public void setDataSource(MediaDataSource dataSource) throws IllegalArgumentException {
        this._setDataSource(dataSource);
    }

    private native void _setDataSource(MediaDataSource var1) throws IllegalArgumentException;

    public native String extractMetadata(int var1);

    public Bitmap getFrameAtTime(long timeUs, int option) {
        if (option < 0 || option > 3) {
            throw new IllegalArgumentException("Unsupported option: " + option);
        }
        return this._getFrameAtTime(timeUs, option);
    }

    public Bitmap getFrameAtTime(long timeUs) {
        return this.getFrameAtTime(timeUs, 2);
    }

    public Bitmap getFrameAtTime() {
        return this.getFrameAtTime(-1L, 2);
    }

    private native Bitmap _getFrameAtTime(long var1, int var3);

    public byte[] getEmbeddedPicture() {
        return this.getEmbeddedPicture(65535);
    }

    private native byte[] getEmbeddedPicture(int var1);

    public native void release();

    private native void native_setup();

    private static native void native_init();

    private final native void native_finalize();

    protected void finalize() throws Throwable {
        try {
            this.native_finalize();
        }
        finally {
            super.finalize();
        }
    }

    static {
        System.loadLibrary("media_jni");
        MediaMetadataRetriever.native_init();
    }
}

