/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityThread;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.AudioAttributes;
import android.media.IAudioService;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.AndroidRuntimeException;
import android.util.Log;
import com.android.internal.app.IAppOpsCallback;
import com.android.internal.app.IAppOpsService;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.ref.WeakReference;

public class SoundPool {
    private static final int SAMPLE_LOADED = 1;
    private static final String TAG = "SoundPool";
    private static final boolean DEBUG;
    private long mNativeContext;
    private EventHandler mEventHandler;
    private OnLoadCompleteListener mOnLoadCompleteListener;
    private boolean mHasAppOpsPlayAudio;
    private final Object mLock;
    private final AudioAttributes mAttributes;
    private final IAppOpsService mAppOps;
    private final IAppOpsCallback mAppOpsCallback;
    private static IAudioService sService;

    public SoundPool(int maxStreams, int streamType, int srcQuality) {
        this(maxStreams, new AudioAttributes.Builder().setInternalLegacyStreamType(streamType).build());
    }

    private SoundPool(int maxStreams, AudioAttributes attributes) {
        if (this.native_setup(new WeakReference<SoundPool>(this), maxStreams, attributes) != 0) {
            throw new RuntimeException("Native setup failed");
        }
        this.mLock = new Object();
        this.mAttributes = attributes;
        IBinder b = ServiceManager.getService("appops");
        this.mAppOps = IAppOpsService.Stub.asInterface(b);
        this.updateAppOpsPlayAudio();
        this.mAppOpsCallback = new IAppOpsCallback.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void opChanged(int op, int uid, String packageName) {
                Object object = SoundPool.this.mLock;
                synchronized (object) {
                    if (op == 28) {
                        SoundPool.this.updateAppOpsPlayAudio();
                    }
                }
            }
        };
        try {
            this.mAppOps.startWatchingMode(28, ActivityThread.currentPackageName(), this.mAppOpsCallback);
        }
        catch (RemoteException e) {
            this.mHasAppOpsPlayAudio = false;
        }
    }

    public final void release() {
        try {
            this.mAppOps.stopWatchingMode(this.mAppOpsCallback);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.native_release();
    }

    private final native void native_release();

    protected void finalize() {
        this.release();
    }

    public int load(String path, int priority) {
        int id2 = 0;
        try {
            File f = new File(path);
            ParcelFileDescriptor fd = ParcelFileDescriptor.open(f, 0x10000000);
            if (fd != null) {
                id2 = this._load(fd.getFileDescriptor(), 0L, f.length(), priority);
                fd.close();
            }
        }
        catch (IOException e) {
            Log.e(TAG, "error loading " + path);
        }
        return id2;
    }

    public int load(Context context, int resId, int priority) {
        AssetFileDescriptor afd = context.getResources().openRawResourceFd(resId);
        int id2 = 0;
        if (afd != null) {
            id2 = this._load(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength(), priority);
            try {
                afd.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return id2;
    }

    public int load(AssetFileDescriptor afd, int priority) {
        if (afd != null) {
            long len = afd.getLength();
            if (len < 0L) {
                throw new AndroidRuntimeException("no length for fd");
            }
            return this._load(afd.getFileDescriptor(), afd.getStartOffset(), len, priority);
        }
        return 0;
    }

    public int load(FileDescriptor fd, long offset, long length, int priority) {
        return this._load(fd, offset, length, priority);
    }

    public final native boolean unload(int var1);

    public final int play(int soundID, float leftVolume, float rightVolume, int priority, int loop, float rate) {
        if (this.isRestricted()) {
            rightVolume = 0.0f;
            leftVolume = 0.0f;
        }
        return this._play(soundID, leftVolume, rightVolume, priority, loop, rate);
    }

    public final native void pause(int var1);

    public final native void resume(int var1);

    public final native void autoPause();

    public final native void autoResume();

    public final native void stop(int var1);

    public final void setVolume(int streamID, float leftVolume, float rightVolume) {
        if (this.isRestricted()) {
            return;
        }
        this._setVolume(streamID, leftVolume, rightVolume);
    }

    public void setVolume(int streamID, float volume) {
        this.setVolume(streamID, volume, volume);
    }

    public final native void setPriority(int var1, int var2);

    public final native void setLoop(int var1, int var2);

    public final native void setRate(int var1, float var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnLoadCompleteListener(OnLoadCompleteListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            Looper looper;
            this.mEventHandler = listener != null ? ((looper = Looper.myLooper()) != null ? new EventHandler(looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(looper) : null)) : null;
            this.mOnLoadCompleteListener = listener;
        }
    }

    private static IAudioService getService() {
        if (sService != null) {
            return sService;
        }
        IBinder b = ServiceManager.getService("audio");
        sService = IAudioService.Stub.asInterface(b);
        return sService;
    }

    private boolean isRestricted() {
        if (this.mHasAppOpsPlayAudio) {
            return false;
        }
        if ((this.mAttributes.getAllFlags() & 0x40) != 0) {
            return false;
        }
        if ((this.mAttributes.getAllFlags() & 1) != 0) {
            boolean cameraSoundForced = false;
            try {
                cameraSoundForced = SoundPool.getService().isCameraSoundForced();
            }
            catch (RemoteException e) {
                Log.e(TAG, "Cannot access AudioService in isRestricted()");
            }
            catch (NullPointerException e) {
                Log.e(TAG, "Null AudioService in isRestricted()");
            }
            if (cameraSoundForced) {
                return false;
            }
        }
        return true;
    }

    private void updateAppOpsPlayAudio() {
        try {
            int mode = this.mAppOps.checkAudioOperation(28, this.mAttributes.getUsage(), Process.myUid(), ActivityThread.currentPackageName());
            this.mHasAppOpsPlayAudio = mode == 0;
        }
        catch (RemoteException e) {
            this.mHasAppOpsPlayAudio = false;
        }
    }

    private final native int _load(FileDescriptor var1, long var2, long var4, int var6);

    private final native int native_setup(Object var1, int var2, Object var3);

    private final native int _play(int var1, float var2, float var3, int var4, int var5, float var6);

    private final native void _setVolume(int var1, float var2, float var3);

    private static void postEventFromNative(Object ref, int msg, int arg1, int arg2, Object obj) {
        SoundPool soundPool = (SoundPool)((WeakReference)ref).get();
        if (soundPool == null) {
            return;
        }
        if (soundPool.mEventHandler != null) {
            Message m = soundPool.mEventHandler.obtainMessage(msg, arg1, arg2, obj);
            soundPool.mEventHandler.sendMessage(m);
        }
    }

    static {
        System.loadLibrary("soundpool");
        DEBUG = Log.isLoggable(TAG, 3);
    }

    public static class Builder {
        private int mMaxStreams = 1;
        private AudioAttributes mAudioAttributes;

        public Builder setMaxStreams(int maxStreams) throws IllegalArgumentException {
            if (maxStreams <= 0) {
                throw new IllegalArgumentException("Strictly positive value required for the maximum number of streams");
            }
            this.mMaxStreams = maxStreams;
            return this;
        }

        public Builder setAudioAttributes(AudioAttributes attributes) throws IllegalArgumentException {
            if (attributes == null) {
                throw new IllegalArgumentException("Invalid null AudioAttributes");
            }
            this.mAudioAttributes = attributes;
            return this;
        }

        public SoundPool build() {
            if (this.mAudioAttributes == null) {
                this.mAudioAttributes = new AudioAttributes.Builder().setUsage(1).build();
            }
            return new SoundPool(this.mMaxStreams, this.mAudioAttributes);
        }
    }

    private final class EventHandler
    extends Handler {
        public EventHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    if (DEBUG) {
                        Log.d(SoundPool.TAG, "Sample " + msg.arg1 + " loaded");
                    }
                    Object object = SoundPool.this.mLock;
                    synchronized (object) {
                        if (SoundPool.this.mOnLoadCompleteListener != null) {
                            SoundPool.this.mOnLoadCompleteListener.onLoadComplete(SoundPool.this, msg.arg1, msg.arg2);
                        }
                        break;
                    }
                }
                default: {
                    Log.e(SoundPool.TAG, "Unknown message type " + msg.what);
                    return;
                }
            }
        }
    }

    public static interface OnLoadCompleteListener {
        public void onLoadComplete(SoundPool var1, int var2, int var3);
    }
}

