/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiofx;

import android.app.ActivityThread;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import java.lang.ref.WeakReference;

public class Visualizer {
    private static final String TAG = "Visualizer-JAVA";
    public static final int STATE_UNINITIALIZED = 0;
    public static final int STATE_INITIALIZED = 1;
    public static final int STATE_ENABLED = 2;
    public static final int SCALING_MODE_NORMALIZED = 0;
    public static final int SCALING_MODE_AS_PLAYED = 1;
    public static final int MEASUREMENT_MODE_NONE = 0;
    public static final int MEASUREMENT_MODE_PEAK_RMS = 1;
    private static final int NATIVE_EVENT_PCM_CAPTURE = 0;
    private static final int NATIVE_EVENT_FFT_CAPTURE = 1;
    private static final int NATIVE_EVENT_SERVER_DIED = 2;
    public static final int SUCCESS = 0;
    public static final int ERROR = -1;
    public static final int ALREADY_EXISTS = -2;
    public static final int ERROR_NO_INIT = -3;
    public static final int ERROR_BAD_VALUE = -4;
    public static final int ERROR_INVALID_OPERATION = -5;
    public static final int ERROR_NO_MEMORY = -6;
    public static final int ERROR_DEAD_OBJECT = -7;
    private int mState = 0;
    private final Object mStateLock = new Object();
    private int mId;
    private final Object mListenerLock = new Object();
    private NativeEventHandler mNativeEventHandler = null;
    private OnDataCaptureListener mCaptureListener = null;
    private OnServerDiedListener mServerDiedListener = null;
    private long mNativeVisualizer;
    private long mJniData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Visualizer(int audioSession) throws UnsupportedOperationException, RuntimeException {
        int[] id2 = new int[1];
        Object object = this.mStateLock;
        synchronized (object) {
            this.mState = 0;
            int result = this.native_setup(new WeakReference<Visualizer>(this), audioSession, id2, ActivityThread.currentOpPackageName());
            if (result != 0 && result != -2) {
                Log.e(TAG, "Error code " + result + " when initializing Visualizer.");
                switch (result) {
                    case -5: {
                        throw new UnsupportedOperationException("Effect library not loaded");
                    }
                }
                throw new RuntimeException("Cannot initialize Visualizer engine, error: " + result);
            }
            this.mId = id2[0];
            this.mState = this.native_getEnabled() ? 2 : 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.mStateLock;
        synchronized (object) {
            this.native_release();
            this.mState = 0;
        }
    }

    protected void finalize() {
        this.native_finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setEnabled(boolean enabled) throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState == 0) {
                throw new IllegalStateException("setEnabled() called in wrong state: " + this.mState);
            }
            int status = 0;
            if ((enabled && this.mState == 1 || !enabled && this.mState == 2) && (status = this.native_setEnabled(enabled)) == 0) {
                this.mState = enabled ? 2 : 1;
            }
            return status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getEnabled() {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState == 0) {
                throw new IllegalStateException("getEnabled() called in wrong state: " + this.mState);
            }
            return this.native_getEnabled();
        }
    }

    public static native int[] getCaptureSizeRange();

    public static native int getMaxCaptureRate();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setCaptureSize(int size) throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState != 1) {
                throw new IllegalStateException("setCaptureSize() called in wrong state: " + this.mState);
            }
            return this.native_setCaptureSize(size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCaptureSize() throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState == 0) {
                throw new IllegalStateException("getCaptureSize() called in wrong state: " + this.mState);
            }
            return this.native_getCaptureSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setScalingMode(int mode) throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState == 0) {
                throw new IllegalStateException("setScalingMode() called in wrong state: " + this.mState);
            }
            return this.native_setScalingMode(mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getScalingMode() throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState == 0) {
                throw new IllegalStateException("getScalingMode() called in wrong state: " + this.mState);
            }
            return this.native_getScalingMode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setMeasurementMode(int mode) throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState == 0) {
                throw new IllegalStateException("setMeasurementMode() called in wrong state: " + this.mState);
            }
            return this.native_setMeasurementMode(mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMeasurementMode() throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState == 0) {
                throw new IllegalStateException("getMeasurementMode() called in wrong state: " + this.mState);
            }
            return this.native_getMeasurementMode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSamplingRate() throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState == 0) {
                throw new IllegalStateException("getSamplingRate() called in wrong state: " + this.mState);
            }
            return this.native_getSamplingRate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWaveForm(byte[] waveform) throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState != 2) {
                throw new IllegalStateException("getWaveForm() called in wrong state: " + this.mState);
            }
            return this.native_getWaveForm(waveform);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFft(byte[] fft) throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState != 2) {
                throw new IllegalStateException("getFft() called in wrong state: " + this.mState);
            }
            return this.native_getFft(fft);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMeasurementPeakRms(MeasurementPeakRms measurement) {
        if (measurement == null) {
            Log.e(TAG, "Cannot store measurements in a null object");
            return -4;
        }
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState != 2) {
                throw new IllegalStateException("getMeasurementPeakRms() called in wrong state: " + this.mState);
            }
            return this.native_getPeakRms(measurement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setDataCaptureListener(OnDataCaptureListener listener, int rate, boolean waveform, boolean fft) {
        int status;
        Object object = this.mListenerLock;
        synchronized (object) {
            this.mCaptureListener = listener;
        }
        if (listener == null) {
            waveform = false;
            fft = false;
        }
        if ((status = this.native_setPeriodicCapture(rate, waveform, fft)) == 0 && listener != null && this.mNativeEventHandler == null) {
            Looper looper = Looper.myLooper();
            if (looper != null) {
                this.mNativeEventHandler = new NativeEventHandler(this, looper);
            } else {
                looper = Looper.getMainLooper();
                if (looper != null) {
                    this.mNativeEventHandler = new NativeEventHandler(this, looper);
                } else {
                    this.mNativeEventHandler = null;
                    status = -3;
                }
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setServerDiedListener(OnServerDiedListener listener) {
        Object object = this.mListenerLock;
        synchronized (object) {
            this.mServerDiedListener = listener;
        }
        return 0;
    }

    private static final native void native_init();

    private final native int native_setup(Object var1, int var2, int[] var3, String var4);

    private final native void native_finalize();

    private final native void native_release();

    private final native int native_setEnabled(boolean var1);

    private final native boolean native_getEnabled();

    private final native int native_setCaptureSize(int var1);

    private final native int native_getCaptureSize();

    private final native int native_setScalingMode(int var1);

    private final native int native_getScalingMode();

    private final native int native_setMeasurementMode(int var1);

    private final native int native_getMeasurementMode();

    private final native int native_getSamplingRate();

    private final native int native_getWaveForm(byte[] var1);

    private final native int native_getFft(byte[] var1);

    private final native int native_getPeakRms(MeasurementPeakRms var1);

    private final native int native_setPeriodicCapture(int var1, boolean var2, boolean var3);

    private static void postEventFromNative(Object effect_ref, int what, int arg1, int arg2, Object obj) {
        Visualizer visu = (Visualizer)((WeakReference)effect_ref).get();
        if (visu == null) {
            return;
        }
        if (visu.mNativeEventHandler != null) {
            Message m = visu.mNativeEventHandler.obtainMessage(what, arg1, arg2, obj);
            visu.mNativeEventHandler.sendMessage(m);
        }
    }

    static {
        System.loadLibrary("audioeffect_jni");
        Visualizer.native_init();
    }

    private class NativeEventHandler
    extends Handler {
        private Visualizer mVisualizer;

        public NativeEventHandler(Visualizer v, Looper looper) {
            super(looper);
            this.mVisualizer = v;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleCaptureMessage(Message msg) {
            OnDataCaptureListener l = null;
            Object object = Visualizer.this.mListenerLock;
            synchronized (object) {
                l = this.mVisualizer.mCaptureListener;
            }
            if (l != null) {
                byte[] data = (byte[])msg.obj;
                int samplingRate = msg.arg1;
                switch (msg.what) {
                    case 0: {
                        l.onWaveFormDataCapture(this.mVisualizer, data, samplingRate);
                        break;
                    }
                    case 1: {
                        l.onFftDataCapture(this.mVisualizer, data, samplingRate);
                        break;
                    }
                    default: {
                        Log.e(Visualizer.TAG, "Unknown native event in handleCaptureMessge: " + msg.what);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleServerDiedMessage(Message msg) {
            OnServerDiedListener l = null;
            Object object = Visualizer.this.mListenerLock;
            synchronized (object) {
                l = this.mVisualizer.mServerDiedListener;
            }
            if (l != null) {
                l.onServerDied();
            }
        }

        @Override
        public void handleMessage(Message msg) {
            if (this.mVisualizer == null) {
                return;
            }
            switch (msg.what) {
                case 0: 
                case 1: {
                    this.handleCaptureMessage(msg);
                    break;
                }
                case 2: {
                    this.handleServerDiedMessage(msg);
                    break;
                }
                default: {
                    Log.e(Visualizer.TAG, "Unknown native event: " + msg.what);
                }
            }
        }
    }

    public static interface OnServerDiedListener {
        public void onServerDied();
    }

    public static interface OnDataCaptureListener {
        public void onWaveFormDataCapture(Visualizer var1, byte[] var2, int var3);

        public void onFftDataCapture(Visualizer var1, byte[] var2, int var3);
    }

    public static final class MeasurementPeakRms {
        public int mPeak;
        public int mRms;
    }
}

