/*
 * Decompiled with CFR 0.152.
 */
package android.media.midi;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;

public final class MidiDeviceInfo
implements Parcelable {
    private static final String TAG = "MidiDeviceInfo";
    public static final int TYPE_USB = 1;
    public static final int TYPE_VIRTUAL = 2;
    public static final int TYPE_BLUETOOTH = 3;
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_MANUFACTURER = "manufacturer";
    public static final String PROPERTY_PRODUCT = "product";
    public static final String PROPERTY_VERSION = "version";
    public static final String PROPERTY_SERIAL_NUMBER = "serial_number";
    public static final String PROPERTY_USB_DEVICE = "usb_device";
    public static final String PROPERTY_BLUETOOTH_DEVICE = "bluetooth_device";
    public static final String PROPERTY_ALSA_CARD = "alsa_card";
    public static final String PROPERTY_ALSA_DEVICE = "alsa_device";
    public static final String PROPERTY_SERVICE_INFO = "service_info";
    private final int mType;
    private final int mId;
    private final int mInputPortCount;
    private final int mOutputPortCount;
    private final String[] mInputPortNames;
    private final String[] mOutputPortNames;
    private final Bundle mProperties;
    private final boolean mIsPrivate;
    public static final Parcelable.Creator<MidiDeviceInfo> CREATOR = new Parcelable.Creator<MidiDeviceInfo>(){

        @Override
        public MidiDeviceInfo createFromParcel(Parcel in) {
            int type = in.readInt();
            int id2 = in.readInt();
            int inputPorts = in.readInt();
            int outputPorts = in.readInt();
            String[] inputPortNames = in.createStringArray();
            String[] outputPortNames = in.createStringArray();
            Bundle properties = in.readBundle();
            boolean isPrivate = in.readInt() == 1;
            return new MidiDeviceInfo(type, id2, inputPorts, outputPorts, inputPortNames, outputPortNames, properties, isPrivate);
        }

        public MidiDeviceInfo[] newArray(int size) {
            return new MidiDeviceInfo[size];
        }
    };

    public MidiDeviceInfo(int type, int id2, int numInputPorts, int numOutputPorts, String[] inputPortNames, String[] outputPortNames, Bundle properties, boolean isPrivate) {
        this.mType = type;
        this.mId = id2;
        this.mInputPortCount = numInputPorts;
        this.mOutputPortCount = numOutputPorts;
        this.mInputPortNames = inputPortNames == null ? new String[numInputPorts] : inputPortNames;
        this.mOutputPortNames = outputPortNames == null ? new String[numOutputPorts] : outputPortNames;
        this.mProperties = properties;
        this.mIsPrivate = isPrivate;
    }

    public int getType() {
        return this.mType;
    }

    public int getId() {
        return this.mId;
    }

    public int getInputPortCount() {
        return this.mInputPortCount;
    }

    public int getOutputPortCount() {
        return this.mOutputPortCount;
    }

    public PortInfo[] getPorts() {
        int i;
        PortInfo[] ports = new PortInfo[this.mInputPortCount + this.mOutputPortCount];
        int index = 0;
        for (i = 0; i < this.mInputPortCount; ++i) {
            ports[index++] = new PortInfo(1, i, this.mInputPortNames[i]);
        }
        for (i = 0; i < this.mOutputPortCount; ++i) {
            ports[index++] = new PortInfo(2, i, this.mOutputPortNames[i]);
        }
        return ports;
    }

    public Bundle getProperties() {
        return this.mProperties;
    }

    public boolean isPrivate() {
        return this.mIsPrivate;
    }

    public boolean equals(Object o) {
        if (o instanceof MidiDeviceInfo) {
            return ((MidiDeviceInfo)o).mId == this.mId;
        }
        return false;
    }

    public int hashCode() {
        return this.mId;
    }

    public String toString() {
        this.mProperties.getString(PROPERTY_NAME);
        return "MidiDeviceInfo[mType=" + this.mType + ",mInputPortCount=" + this.mInputPortCount + ",mOutputPortCount=" + this.mOutputPortCount + ",mProperties=" + this.mProperties + ",mIsPrivate=" + this.mIsPrivate;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mType);
        parcel.writeInt(this.mId);
        parcel.writeInt(this.mInputPortCount);
        parcel.writeInt(this.mOutputPortCount);
        parcel.writeStringArray(this.mInputPortNames);
        parcel.writeStringArray(this.mOutputPortNames);
        parcel.writeBundle(this.mProperties);
        parcel.writeInt(this.mIsPrivate ? 1 : 0);
    }

    public static final class PortInfo {
        public static final int TYPE_INPUT = 1;
        public static final int TYPE_OUTPUT = 2;
        private final int mPortType;
        private final int mPortNumber;
        private final String mName;

        PortInfo(int type, int portNumber, String name) {
            this.mPortType = type;
            this.mPortNumber = portNumber;
            this.mName = name == null ? "" : name;
        }

        public int getType() {
            return this.mPortType;
        }

        public int getPortNumber() {
            return this.mPortNumber;
        }

        public String getName() {
            return this.mName;
        }
    }
}

