/*
 * Decompiled with CFR 0.152.
 */
package android.media.midi;

import android.media.midi.IMidiDeviceServer;
import android.media.midi.IMidiManager;
import android.media.midi.MidiDeviceInfo;
import android.media.midi.MidiDeviceStatus;
import android.media.midi.MidiInputPort;
import android.media.midi.MidiOutputPort;
import android.media.midi.MidiReceiver;
import android.os.Binder;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.system.OsConstants;
import android.util.Log;
import com.android.internal.midi.MidiDispatcher;
import dalvik.system.CloseGuard;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import libcore.io.IoUtils;

public final class MidiDeviceServer
implements Closeable {
    private static final String TAG = "MidiDeviceServer";
    private final IMidiManager mMidiManager;
    private MidiDeviceInfo mDeviceInfo;
    private final int mInputPortCount;
    private final int mOutputPortCount;
    private final MidiReceiver[] mInputPortReceivers;
    private MidiDispatcher[] mOutputPortDispatchers;
    private final MidiOutputPort[] mInputPortOutputPorts;
    private final CopyOnWriteArrayList<MidiInputPort> mInputPorts = new CopyOnWriteArrayList();
    private final boolean[] mInputPortOpen;
    private final int[] mOutputPortOpenCount;
    private final CloseGuard mGuard = CloseGuard.get();
    private boolean mIsClosed;
    private final Callback mCallback;
    private final HashMap<IBinder, PortClient> mPortClients = new HashMap();
    private final IMidiDeviceServer mServer = new IMidiDeviceServer.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ParcelFileDescriptor openInputPort(IBinder token, int portNumber) {
            if (MidiDeviceServer.this.mDeviceInfo.isPrivate() && Binder.getCallingUid() != Process.myUid()) {
                throw new SecurityException("Can't access private device from different UID");
            }
            if (portNumber < 0 || portNumber >= MidiDeviceServer.this.mInputPortCount) {
                Log.e(MidiDeviceServer.TAG, "portNumber out of range in openInputPort: " + portNumber);
                return null;
            }
            MidiOutputPort[] midiOutputPortArray = MidiDeviceServer.this.mInputPortOutputPorts;
            synchronized (midiOutputPortArray) {
                if (MidiDeviceServer.this.mInputPortOutputPorts[portNumber] != null) {
                    Log.d(MidiDeviceServer.TAG, "port " + portNumber + " already open");
                    return null;
                }
                try {
                    MidiOutputPort outputPort;
                    ParcelFileDescriptor[] pair = ParcelFileDescriptor.createSocketPair(OsConstants.SOCK_SEQPACKET);
                    ((MidiDeviceServer)MidiDeviceServer.this).mInputPortOutputPorts[portNumber] = outputPort = new MidiOutputPort(pair[0], portNumber);
                    outputPort.connect(MidiDeviceServer.this.mInputPortReceivers[portNumber]);
                    InputPortClient client = new InputPortClient(token, outputPort);
                    HashMap hashMap = MidiDeviceServer.this.mPortClients;
                    synchronized (hashMap) {
                        MidiDeviceServer.this.mPortClients.put(token, client);
                    }
                    ((MidiDeviceServer)MidiDeviceServer.this).mInputPortOpen[portNumber] = true;
                    MidiDeviceServer.this.updateDeviceStatus();
                    return pair[1];
                }
                catch (IOException e) {
                    Log.e(MidiDeviceServer.TAG, "unable to create ParcelFileDescriptors in openInputPort");
                    return null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ParcelFileDescriptor openOutputPort(IBinder token, int portNumber) {
            if (MidiDeviceServer.this.mDeviceInfo.isPrivate() && Binder.getCallingUid() != Process.myUid()) {
                throw new SecurityException("Can't access private device from different UID");
            }
            if (portNumber < 0 || portNumber >= MidiDeviceServer.this.mOutputPortCount) {
                Log.e(MidiDeviceServer.TAG, "portNumber out of range in openOutputPort: " + portNumber);
                return null;
            }
            try {
                MidiDispatcher dispatcher;
                ParcelFileDescriptor[] pair = ParcelFileDescriptor.createSocketPair(OsConstants.SOCK_SEQPACKET);
                MidiInputPort inputPort = new MidiInputPort(pair[0], portNumber);
                MidiDispatcher midiDispatcher = dispatcher = MidiDeviceServer.this.mOutputPortDispatchers[portNumber];
                synchronized (midiDispatcher) {
                    int openCount;
                    dispatcher.getSender().connect(inputPort);
                    ((MidiDeviceServer)MidiDeviceServer.this).mOutputPortOpenCount[portNumber] = openCount = dispatcher.getReceiverCount();
                    MidiDeviceServer.this.updateDeviceStatus();
                }
                MidiDeviceServer.this.mInputPorts.add(inputPort);
                OutputPortClient client = new OutputPortClient(token, inputPort);
                HashMap hashMap = MidiDeviceServer.this.mPortClients;
                synchronized (hashMap) {
                    MidiDeviceServer.this.mPortClients.put(token, client);
                }
                return pair[1];
            }
            catch (IOException e) {
                Log.e(MidiDeviceServer.TAG, "unable to create ParcelFileDescriptors in openOutputPort");
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void closePort(IBinder token) {
            HashMap hashMap = MidiDeviceServer.this.mPortClients;
            synchronized (hashMap) {
                PortClient client = (PortClient)MidiDeviceServer.this.mPortClients.remove(token);
                if (client != null) {
                    client.close();
                }
            }
        }

        @Override
        public void closeDevice() {
            if (MidiDeviceServer.this.mCallback != null) {
                MidiDeviceServer.this.mCallback.onClose();
            }
            IoUtils.closeQuietly(MidiDeviceServer.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int connectPorts(IBinder token, ParcelFileDescriptor pfd, int outputPortNumber) {
            MidiDispatcher dispatcher;
            MidiInputPort inputPort = new MidiInputPort(pfd, outputPortNumber);
            MidiDispatcher midiDispatcher = dispatcher = MidiDeviceServer.this.mOutputPortDispatchers[outputPortNumber];
            synchronized (midiDispatcher) {
                int openCount;
                dispatcher.getSender().connect(inputPort);
                ((MidiDeviceServer)MidiDeviceServer.this).mOutputPortOpenCount[outputPortNumber] = openCount = dispatcher.getReceiverCount();
                MidiDeviceServer.this.updateDeviceStatus();
            }
            MidiDeviceServer.this.mInputPorts.add(inputPort);
            OutputPortClient client = new OutputPortClient(token, inputPort);
            HashMap hashMap = MidiDeviceServer.this.mPortClients;
            synchronized (hashMap) {
                MidiDeviceServer.this.mPortClients.put(token, client);
            }
            return Process.myPid();
        }

        @Override
        public MidiDeviceInfo getDeviceInfo() {
            return MidiDeviceServer.this.mDeviceInfo;
        }

        @Override
        public void setDeviceInfo(MidiDeviceInfo deviceInfo) {
            if (Binder.getCallingUid() != 1000) {
                throw new SecurityException("setDeviceInfo should only be called by MidiService");
            }
            if (MidiDeviceServer.this.mDeviceInfo != null) {
                throw new IllegalStateException("setDeviceInfo should only be called once");
            }
            MidiDeviceServer.this.mDeviceInfo = deviceInfo;
        }
    };

    MidiDeviceServer(IMidiManager midiManager, MidiReceiver[] inputPortReceivers, int numOutputPorts, Callback callback) {
        this.mMidiManager = midiManager;
        this.mInputPortReceivers = inputPortReceivers;
        this.mInputPortCount = inputPortReceivers.length;
        this.mOutputPortCount = numOutputPorts;
        this.mCallback = callback;
        this.mInputPortOutputPorts = new MidiOutputPort[this.mInputPortCount];
        this.mOutputPortDispatchers = new MidiDispatcher[numOutputPorts];
        for (int i = 0; i < numOutputPorts; ++i) {
            this.mOutputPortDispatchers[i] = new MidiDispatcher();
        }
        this.mInputPortOpen = new boolean[this.mInputPortCount];
        this.mOutputPortOpenCount = new int[numOutputPorts];
        this.mGuard.open("close");
    }

    MidiDeviceServer(IMidiManager midiManager, MidiReceiver[] inputPortReceivers, MidiDeviceInfo deviceInfo, Callback callback) {
        this(midiManager, inputPortReceivers, deviceInfo.getOutputPortCount(), callback);
        this.mDeviceInfo = deviceInfo;
    }

    IMidiDeviceServer getBinderInterface() {
        return this.mServer;
    }

    public IBinder asBinder() {
        return this.mServer.asBinder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDeviceStatus() {
        long identityToken = Binder.clearCallingIdentity();
        MidiDeviceStatus status = new MidiDeviceStatus(this.mDeviceInfo, this.mInputPortOpen, this.mOutputPortOpenCount);
        if (this.mCallback != null) {
            this.mCallback.onDeviceStatusChanged(this, status);
        }
        try {
            this.mMidiManager.setDeviceStatus(this.mServer, status);
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in updateDeviceStatus");
        }
        finally {
            Binder.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        CloseGuard closeGuard = this.mGuard;
        synchronized (closeGuard) {
            if (this.mIsClosed) {
                return;
            }
            this.mGuard.close();
            for (int i = 0; i < this.mInputPortCount; ++i) {
                MidiOutputPort outputPort = this.mInputPortOutputPorts[i];
                if (outputPort == null) continue;
                IoUtils.closeQuietly(outputPort);
                this.mInputPortOutputPorts[i] = null;
            }
            for (MidiInputPort inputPort : this.mInputPorts) {
                IoUtils.closeQuietly(inputPort);
            }
            this.mInputPorts.clear();
            try {
                this.mMidiManager.unregisterDeviceServer(this.mServer);
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException in unregisterDeviceServer");
            }
            this.mIsClosed = true;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.mGuard.warnIfOpen();
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public MidiReceiver[] getOutputPortReceivers() {
        MidiReceiver[] receivers = new MidiReceiver[this.mOutputPortCount];
        System.arraycopy(this.mOutputPortDispatchers, 0, receivers, 0, this.mOutputPortCount);
        return receivers;
    }

    private class OutputPortClient
    extends PortClient {
        private final MidiInputPort mInputPort;

        OutputPortClient(IBinder token, MidiInputPort inputPort) {
            super(token);
            this.mInputPort = inputPort;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void close() {
            MidiDispatcher dispatcher;
            this.mToken.unlinkToDeath(this, 0);
            int portNumber = this.mInputPort.getPortNumber();
            MidiDispatcher midiDispatcher = dispatcher = MidiDeviceServer.this.mOutputPortDispatchers[portNumber];
            synchronized (midiDispatcher) {
                int openCount;
                dispatcher.getSender().disconnect(this.mInputPort);
                ((MidiDeviceServer)MidiDeviceServer.this).mOutputPortOpenCount[portNumber] = openCount = dispatcher.getReceiverCount();
                MidiDeviceServer.this.updateDeviceStatus();
            }
            MidiDeviceServer.this.mInputPorts.remove(this.mInputPort);
            IoUtils.closeQuietly(this.mInputPort);
        }
    }

    private class InputPortClient
    extends PortClient {
        private final MidiOutputPort mOutputPort;

        InputPortClient(IBinder token, MidiOutputPort outputPort) {
            super(token);
            this.mOutputPort = outputPort;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void close() {
            this.mToken.unlinkToDeath(this, 0);
            MidiOutputPort[] midiOutputPortArray = MidiDeviceServer.this.mInputPortOutputPorts;
            synchronized (midiOutputPortArray) {
                int portNumber = this.mOutputPort.getPortNumber();
                ((MidiDeviceServer)MidiDeviceServer.this).mInputPortOutputPorts[portNumber] = null;
                ((MidiDeviceServer)MidiDeviceServer.this).mInputPortOpen[portNumber] = false;
                MidiDeviceServer.this.updateDeviceStatus();
            }
            IoUtils.closeQuietly(this.mOutputPort);
        }
    }

    private abstract class PortClient
    implements IBinder.DeathRecipient {
        final IBinder mToken;

        PortClient(IBinder token) {
            this.mToken = token;
            try {
                token.linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                this.close();
            }
        }

        abstract void close();

        @Override
        public void binderDied() {
            this.close();
        }
    }

    public static interface Callback {
        public void onDeviceStatusChanged(MidiDeviceServer var1, MidiDeviceStatus var2);

        public void onClose();
    }
}

