/*
 * Decompiled with CFR 0.152.
 */
package android.media.session;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ParceledListSlice;
import android.media.AudioAttributes;
import android.media.MediaDescription;
import android.media.MediaMetadata;
import android.media.Rating;
import android.media.VolumeProvider;
import android.media.session.ISession;
import android.media.session.ISessionCallback;
import android.media.session.ISessionController;
import android.media.session.MediaController;
import android.media.session.MediaSessionManager;
import android.media.session.PlaybackState;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import java.lang.ref.WeakReference;
import java.util.List;

public final class MediaSession {
    private static final String TAG = "MediaSession";
    public static final int FLAG_HANDLES_MEDIA_BUTTONS = 1;
    public static final int FLAG_HANDLES_TRANSPORT_CONTROLS = 2;
    public static final int FLAG_EXCLUSIVE_GLOBAL_PRIORITY = 65536;
    private final Object mLock = new Object();
    private final int mMaxBitmapSize;
    private final Token mSessionToken;
    private final MediaController mController;
    private final ISession mBinder;
    private final CallbackStub mCbStub;
    private CallbackMessageHandler mCallback;
    private VolumeProvider mVolumeProvider;
    private PlaybackState mPlaybackState;
    private boolean mActive = false;

    public MediaSession(Context context, String tag) {
        this(context, tag, UserHandle.myUserId());
    }

    public MediaSession(Context context, String tag, int userId) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null.");
        }
        if (TextUtils.isEmpty(tag)) {
            throw new IllegalArgumentException("tag cannot be null or empty");
        }
        this.mMaxBitmapSize = context.getResources().getDimensionPixelSize(17104916);
        this.mCbStub = new CallbackStub(this);
        MediaSessionManager manager = (MediaSessionManager)context.getSystemService("media_session");
        try {
            this.mBinder = manager.createSession(this.mCbStub, tag, userId);
            this.mSessionToken = new Token(this.mBinder.getController());
            this.mController = new MediaController(context, this.mSessionToken);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Remote error creating session.", e);
        }
    }

    public void setCallback(Callback callback) {
        this.setCallback(callback, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCallback(Callback callback, Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            CallbackMessageHandler msgHandler;
            if (callback == null) {
                if (this.mCallback != null) {
                    this.mCallback.mCallback.mSession = null;
                }
                this.mCallback = null;
                return;
            }
            if (this.mCallback != null) {
                this.mCallback.mCallback.mSession = null;
            }
            if (handler == null) {
                handler = new Handler();
            }
            callback.mSession = this;
            this.mCallback = msgHandler = new CallbackMessageHandler(handler.getLooper(), callback);
        }
    }

    public void setSessionActivity(PendingIntent pi) {
        try {
            this.mBinder.setLaunchPendingIntent(pi);
        }
        catch (RemoteException e) {
            Log.wtf(TAG, "Failure in setLaunchPendingIntent.", e);
        }
    }

    public void setMediaButtonReceiver(PendingIntent mbr) {
        try {
            this.mBinder.setMediaButtonReceiver(mbr);
        }
        catch (RemoteException e) {
            Log.wtf(TAG, "Failure in setMediaButtonReceiver.", e);
        }
    }

    public void setFlags(int flags) {
        try {
            this.mBinder.setFlags(flags);
        }
        catch (RemoteException e) {
            Log.wtf(TAG, "Failure in setFlags.", e);
        }
    }

    public void setPlaybackToLocal(AudioAttributes attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("Attributes cannot be null for local playback.");
        }
        try {
            this.mBinder.setPlaybackToLocal(attributes);
        }
        catch (RemoteException e) {
            Log.wtf(TAG, "Failure in setPlaybackToLocal.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlaybackToRemote(VolumeProvider volumeProvider) {
        if (volumeProvider == null) {
            throw new IllegalArgumentException("volumeProvider may not be null!");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mVolumeProvider = volumeProvider;
        }
        volumeProvider.setCallback(new VolumeProvider.Callback(){

            @Override
            public void onVolumeChanged(VolumeProvider volumeProvider) {
                MediaSession.this.notifyRemoteVolumeChanged(volumeProvider);
            }
        });
        try {
            this.mBinder.setPlaybackToRemote(volumeProvider.getVolumeControl(), volumeProvider.getMaxVolume());
            this.mBinder.setCurrentVolume(volumeProvider.getCurrentVolume());
        }
        catch (RemoteException e) {
            Log.wtf(TAG, "Failure in setPlaybackToRemote.", e);
        }
    }

    public void setActive(boolean active) {
        if (this.mActive == active) {
            return;
        }
        try {
            this.mBinder.setActive(active);
            this.mActive = active;
        }
        catch (RemoteException e) {
            Log.wtf(TAG, "Failure in setActive.", e);
        }
    }

    public boolean isActive() {
        return this.mActive;
    }

    public void sendSessionEvent(String event, Bundle extras) {
        if (TextUtils.isEmpty(event)) {
            throw new IllegalArgumentException("event cannot be null or empty");
        }
        try {
            this.mBinder.sendEvent(event, extras);
        }
        catch (RemoteException e) {
            Log.wtf(TAG, "Error sending event", e);
        }
    }

    public void release() {
        try {
            this.mBinder.destroy();
        }
        catch (RemoteException e) {
            Log.wtf(TAG, "Error releasing session: ", e);
        }
    }

    public Token getSessionToken() {
        return this.mSessionToken;
    }

    public MediaController getController() {
        return this.mController;
    }

    public void setPlaybackState(PlaybackState state) {
        this.mPlaybackState = state;
        try {
            this.mBinder.setPlaybackState(state);
        }
        catch (RemoteException e) {
            Log.wtf(TAG, "Dead object in setPlaybackState.", e);
        }
    }

    public void setMetadata(MediaMetadata metadata) {
        if (metadata != null) {
            metadata = new MediaMetadata.Builder(metadata, this.mMaxBitmapSize).build();
        }
        try {
            this.mBinder.setMetadata(metadata);
        }
        catch (RemoteException e) {
            Log.wtf(TAG, "Dead object in setPlaybackState.", e);
        }
    }

    public void setQueue(List<QueueItem> queue) {
        try {
            this.mBinder.setQueue(queue == null ? null : new ParceledListSlice<QueueItem>(queue));
        }
        catch (RemoteException e) {
            Log.wtf("Dead object in setQueue.", e);
        }
    }

    public void setQueueTitle(CharSequence title) {
        try {
            this.mBinder.setQueueTitle(title);
        }
        catch (RemoteException e) {
            Log.wtf("Dead object in setQueueTitle.", e);
        }
    }

    public void setRatingType(int type) {
        try {
            this.mBinder.setRatingType(type);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error in setRatingType.", e);
        }
    }

    public void setExtras(Bundle extras) {
        try {
            this.mBinder.setExtras(extras);
        }
        catch (RemoteException e) {
            Log.wtf("Dead object in setExtras.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRemoteVolumeChanged(VolumeProvider provider) {
        Object object = this.mLock;
        synchronized (object) {
            if (provider == null || provider != this.mVolumeProvider) {
                Log.w(TAG, "Received update from stale volume provider");
                return;
            }
        }
        try {
            this.mBinder.setCurrentVolume(provider.getCurrentVolume());
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error in notifyVolumeChanged", e);
        }
    }

    public String getCallingPackage() {
        try {
            return this.mBinder.getCallingPackage();
        }
        catch (RemoteException e) {
            Log.wtf(TAG, "Dead object in getCallingPackage.", e);
            return null;
        }
    }

    private void dispatchPrepare() {
        this.postToCallback(3);
    }

    private void dispatchPrepareFromMediaId(String mediaId, Bundle extras) {
        this.postToCallback(4, mediaId, extras);
    }

    private void dispatchPrepareFromSearch(String query, Bundle extras) {
        this.postToCallback(5, query, extras);
    }

    private void dispatchPrepareFromUri(Uri uri, Bundle extras) {
        this.postToCallback(6, uri, extras);
    }

    private void dispatchPlay() {
        this.postToCallback(7);
    }

    private void dispatchPlayFromMediaId(String mediaId, Bundle extras) {
        this.postToCallback(8, mediaId, extras);
    }

    private void dispatchPlayFromSearch(String query, Bundle extras) {
        this.postToCallback(9, query, extras);
    }

    private void dispatchPlayFromUri(Uri uri, Bundle extras) {
        this.postToCallback(10, uri, extras);
    }

    private void dispatchSkipToItem(long id2) {
        this.postToCallback(11, id2);
    }

    private void dispatchPause() {
        this.postToCallback(12);
    }

    private void dispatchStop() {
        this.postToCallback(13);
    }

    private void dispatchNext() {
        this.postToCallback(14);
    }

    private void dispatchPrevious() {
        this.postToCallback(15);
    }

    private void dispatchFastForward() {
        this.postToCallback(16);
    }

    private void dispatchRewind() {
        this.postToCallback(17);
    }

    private void dispatchSeekTo(long pos) {
        this.postToCallback(18, pos);
    }

    private void dispatchRate(Rating rating) {
        this.postToCallback(19, rating);
    }

    private void dispatchCustomAction(String action, Bundle args) {
        this.postToCallback(20, action, args);
    }

    private void dispatchMediaButton(Intent mediaButtonIntent) {
        this.postToCallback(2, mediaButtonIntent);
    }

    private void dispatchAdjustVolume(int direction) {
        this.postToCallback(21, direction);
    }

    private void dispatchSetVolumeTo(int volume) {
        this.postToCallback(22, volume);
    }

    private void postToCallback(int what) {
        this.postToCallback(what, null);
    }

    private void postCommand(String command, Bundle args, ResultReceiver resultCb) {
        Command cmd = new Command(command, args, resultCb);
        this.postToCallback(1, cmd);
    }

    private void postToCallback(int what, Object obj) {
        this.postToCallback(what, obj, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postToCallback(int what, Object obj, Bundle extras) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCallback != null) {
                this.mCallback.post(what, obj, extras);
            }
        }
    }

    public static boolean isActiveState(int state) {
        switch (state) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    private class CallbackMessageHandler
    extends Handler {
        private static final int MSG_COMMAND = 1;
        private static final int MSG_MEDIA_BUTTON = 2;
        private static final int MSG_PREPARE = 3;
        private static final int MSG_PREPARE_MEDIA_ID = 4;
        private static final int MSG_PREPARE_SEARCH = 5;
        private static final int MSG_PREPARE_URI = 6;
        private static final int MSG_PLAY = 7;
        private static final int MSG_PLAY_MEDIA_ID = 8;
        private static final int MSG_PLAY_SEARCH = 9;
        private static final int MSG_PLAY_URI = 10;
        private static final int MSG_SKIP_TO_ITEM = 11;
        private static final int MSG_PAUSE = 12;
        private static final int MSG_STOP = 13;
        private static final int MSG_NEXT = 14;
        private static final int MSG_PREVIOUS = 15;
        private static final int MSG_FAST_FORWARD = 16;
        private static final int MSG_REWIND = 17;
        private static final int MSG_SEEK_TO = 18;
        private static final int MSG_RATE = 19;
        private static final int MSG_CUSTOM_ACTION = 20;
        private static final int MSG_ADJUST_VOLUME = 21;
        private static final int MSG_SET_VOLUME = 22;
        private Callback mCallback;

        public CallbackMessageHandler(Looper looper, Callback callback) {
            super(looper, null, true);
            this.mCallback = callback;
        }

        public void post(int what, Object obj, Bundle bundle) {
            Message msg = this.obtainMessage(what, obj);
            msg.setData(bundle);
            msg.sendToTarget();
        }

        public void post(int what, Object obj) {
            this.obtainMessage(what, obj).sendToTarget();
        }

        public void post(int what) {
            this.post(what, null);
        }

        public void post(int what, Object obj, int arg1) {
            this.obtainMessage(what, arg1, 0, obj).sendToTarget();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Command cmd = (Command)msg.obj;
                    this.mCallback.onCommand(cmd.command, cmd.extras, cmd.stub);
                    break;
                }
                case 2: {
                    this.mCallback.onMediaButtonEvent((Intent)msg.obj);
                    break;
                }
                case 3: {
                    this.mCallback.onPrepare();
                    break;
                }
                case 4: {
                    this.mCallback.onPrepareFromMediaId((String)msg.obj, msg.getData());
                    break;
                }
                case 5: {
                    this.mCallback.onPrepareFromSearch((String)msg.obj, msg.getData());
                    break;
                }
                case 6: {
                    this.mCallback.onPrepareFromUri((Uri)msg.obj, msg.getData());
                    break;
                }
                case 7: {
                    this.mCallback.onPlay();
                    break;
                }
                case 8: {
                    this.mCallback.onPlayFromMediaId((String)msg.obj, msg.getData());
                    break;
                }
                case 9: {
                    this.mCallback.onPlayFromSearch((String)msg.obj, msg.getData());
                    break;
                }
                case 10: {
                    this.mCallback.onPlayFromUri((Uri)msg.obj, msg.getData());
                    break;
                }
                case 11: {
                    this.mCallback.onSkipToQueueItem((Long)msg.obj);
                    break;
                }
                case 12: {
                    this.mCallback.onPause();
                    break;
                }
                case 13: {
                    this.mCallback.onStop();
                    break;
                }
                case 14: {
                    this.mCallback.onSkipToNext();
                    break;
                }
                case 15: {
                    this.mCallback.onSkipToPrevious();
                    break;
                }
                case 16: {
                    this.mCallback.onFastForward();
                    break;
                }
                case 17: {
                    this.mCallback.onRewind();
                    break;
                }
                case 18: {
                    this.mCallback.onSeekTo((Long)msg.obj);
                    break;
                }
                case 19: {
                    this.mCallback.onSetRating((Rating)msg.obj);
                    break;
                }
                case 20: {
                    this.mCallback.onCustomAction((String)msg.obj, msg.getData());
                    break;
                }
                case 21: {
                    VolumeProvider vp;
                    Object object = MediaSession.this.mLock;
                    synchronized (object) {
                        vp = MediaSession.this.mVolumeProvider;
                    }
                    if (vp == null) break;
                    vp.onAdjustVolume((Integer)msg.obj);
                    break;
                }
                case 22: {
                    VolumeProvider vp;
                    Object object = MediaSession.this.mLock;
                    synchronized (object) {
                        vp = MediaSession.this.mVolumeProvider;
                    }
                    if (vp == null) break;
                    vp.onSetVolumeTo((Integer)msg.obj);
                }
            }
        }
    }

    private static final class Command {
        public final String command;
        public final Bundle extras;
        public final ResultReceiver stub;

        public Command(String command, Bundle extras, ResultReceiver stub) {
            this.command = command;
            this.extras = extras;
            this.stub = stub;
        }
    }

    public static final class QueueItem
    implements Parcelable {
        public static final int UNKNOWN_ID = -1;
        private final MediaDescription mDescription;
        private final long mId;
        public static final Parcelable.Creator<QueueItem> CREATOR = new Parcelable.Creator<QueueItem>(){

            @Override
            public QueueItem createFromParcel(Parcel p) {
                return new QueueItem(p);
            }

            public QueueItem[] newArray(int size) {
                return new QueueItem[size];
            }
        };

        public QueueItem(MediaDescription description, long id2) {
            if (description == null) {
                throw new IllegalArgumentException("Description cannot be null.");
            }
            if (id2 == -1L) {
                throw new IllegalArgumentException("Id cannot be QueueItem.UNKNOWN_ID");
            }
            this.mDescription = description;
            this.mId = id2;
        }

        private QueueItem(Parcel in) {
            this.mDescription = MediaDescription.CREATOR.createFromParcel(in);
            this.mId = in.readLong();
        }

        public MediaDescription getDescription() {
            return this.mDescription;
        }

        public long getQueueId() {
            return this.mId;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            this.mDescription.writeToParcel(dest, flags);
            dest.writeLong(this.mId);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public String toString() {
            return "MediaSession.QueueItem {Description=" + this.mDescription + ", Id=" + this.mId + " }";
        }
    }

    public static class CallbackStub
    extends ISessionCallback.Stub {
        private WeakReference<MediaSession> mMediaSession;

        public CallbackStub(MediaSession session) {
            this.mMediaSession = new WeakReference<MediaSession>(session);
        }

        @Override
        public void onCommand(String command, Bundle args, ResultReceiver cb) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.postCommand(command, args, cb);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMediaButton(Intent mediaButtonIntent, int sequenceNumber, ResultReceiver cb) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            try {
                if (session != null) {
                    session.dispatchMediaButton(mediaButtonIntent);
                }
            }
            finally {
                if (cb != null) {
                    cb.send(sequenceNumber, null);
                }
            }
        }

        @Override
        public void onPrepare() {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPrepare();
            }
        }

        @Override
        public void onPrepareFromMediaId(String mediaId, Bundle extras) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPrepareFromMediaId(mediaId, extras);
            }
        }

        @Override
        public void onPrepareFromSearch(String query, Bundle extras) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPrepareFromSearch(query, extras);
            }
        }

        @Override
        public void onPrepareFromUri(Uri uri, Bundle extras) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPrepareFromUri(uri, extras);
            }
        }

        @Override
        public void onPlay() {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPlay();
            }
        }

        @Override
        public void onPlayFromMediaId(String mediaId, Bundle extras) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPlayFromMediaId(mediaId, extras);
            }
        }

        @Override
        public void onPlayFromSearch(String query, Bundle extras) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPlayFromSearch(query, extras);
            }
        }

        @Override
        public void onPlayFromUri(Uri uri, Bundle extras) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPlayFromUri(uri, extras);
            }
        }

        @Override
        public void onSkipToTrack(long id2) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchSkipToItem(id2);
            }
        }

        @Override
        public void onPause() {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPause();
            }
        }

        @Override
        public void onStop() {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchStop();
            }
        }

        @Override
        public void onNext() {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchNext();
            }
        }

        @Override
        public void onPrevious() {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPrevious();
            }
        }

        @Override
        public void onFastForward() {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchFastForward();
            }
        }

        @Override
        public void onRewind() {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchRewind();
            }
        }

        @Override
        public void onSeekTo(long pos) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchSeekTo(pos);
            }
        }

        @Override
        public void onRate(Rating rating) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchRate(rating);
            }
        }

        @Override
        public void onCustomAction(String action, Bundle args) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchCustomAction(action, args);
            }
        }

        @Override
        public void onAdjustVolume(int direction) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchAdjustVolume(direction);
            }
        }

        @Override
        public void onSetVolumeTo(int value) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchSetVolumeTo(value);
            }
        }
    }

    public static abstract class Callback {
        private MediaSession mSession;

        public void onCommand(String command, Bundle args, ResultReceiver cb) {
        }

        public boolean onMediaButtonEvent(Intent mediaButtonIntent) {
            KeyEvent ke;
            if (this.mSession != null && "android.intent.action.MEDIA_BUTTON".equals(mediaButtonIntent.getAction()) && (ke = (KeyEvent)mediaButtonIntent.getParcelableExtra("android.intent.extra.KEY_EVENT")) != null && ke.getAction() == 0) {
                PlaybackState state = this.mSession.mPlaybackState;
                long validActions = state == null ? 0L : state.getActions();
                switch (ke.getKeyCode()) {
                    case 126: {
                        if ((validActions & 4L) == 0L) break;
                        this.onPlay();
                        return true;
                    }
                    case 127: {
                        if ((validActions & 2L) == 0L) break;
                        this.onPause();
                        return true;
                    }
                    case 87: {
                        if ((validActions & 0x20L) == 0L) break;
                        this.onSkipToNext();
                        return true;
                    }
                    case 88: {
                        if ((validActions & 0x10L) == 0L) break;
                        this.onSkipToPrevious();
                        return true;
                    }
                    case 86: {
                        if ((validActions & 1L) == 0L) break;
                        this.onStop();
                        return true;
                    }
                    case 90: {
                        if ((validActions & 0x40L) == 0L) break;
                        this.onFastForward();
                        return true;
                    }
                    case 89: {
                        if ((validActions & 8L) == 0L) break;
                        this.onRewind();
                        return true;
                    }
                    case 79: 
                    case 85: {
                        boolean canPause;
                        boolean isPlaying = state == null ? false : state.getState() == 3;
                        boolean canPlay = (validActions & 0x204L) != 0L;
                        boolean bl = canPause = (validActions & 0x202L) != 0L;
                        if (isPlaying && canPause) {
                            this.onPause();
                            return true;
                        }
                        if (isPlaying || !canPlay) break;
                        this.onPlay();
                        return true;
                    }
                }
            }
            return false;
        }

        public void onPrepare() {
        }

        public void onPrepareFromMediaId(String mediaId, Bundle extras) {
        }

        public void onPrepareFromSearch(String query, Bundle extras) {
        }

        public void onPrepareFromUri(Uri uri, Bundle extras) {
        }

        public void onPlay() {
        }

        public void onPlayFromSearch(String query, Bundle extras) {
        }

        public void onPlayFromMediaId(String mediaId, Bundle extras) {
        }

        public void onPlayFromUri(Uri uri, Bundle extras) {
        }

        public void onSkipToQueueItem(long id2) {
        }

        public void onPause() {
        }

        public void onSkipToNext() {
        }

        public void onSkipToPrevious() {
        }

        public void onFastForward() {
        }

        public void onRewind() {
        }

        public void onStop() {
        }

        public void onSeekTo(long pos) {
        }

        public void onSetRating(Rating rating) {
        }

        public void onCustomAction(String action, Bundle extras) {
        }
    }

    public static final class Token
    implements Parcelable {
        private ISessionController mBinder;
        public static final Parcelable.Creator<Token> CREATOR = new Parcelable.Creator<Token>(){

            @Override
            public Token createFromParcel(Parcel in) {
                return new Token(ISessionController.Stub.asInterface(in.readStrongBinder()));
            }

            public Token[] newArray(int size) {
                return new Token[size];
            }
        };

        public Token(ISessionController binder) {
            this.mBinder = binder;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeStrongBinder(this.mBinder.asBinder());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.mBinder == null ? 0 : this.mBinder.asBinder().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Token other = (Token)obj;
            return !(this.mBinder == null ? other.mBinder != null : !this.mBinder.asBinder().equals(other.mBinder.asBinder()));
        }

        ISessionController getBinder() {
            return this.mBinder;
        }
    }
}

